/*
 * Decompiled with CFR 0.152.
 */
package com.miui.theme.tool.gui.main;

import com.miui.theme.tool.gui.NinePPanel;
import com.miui.theme.tool.gui.main.MainTabPanel;
import com.miui.theme.tool.gui.main.MenuDialog;
import com.miui.theme.tool.gui.main.NewMainFrame;
import com.miui.theme.tool.gui.main.ResizeLabel;
import com.miui.theme.tool.icon.IconManager;
import com.miui.theme.tool.icon.MockLauncher;
import com.miui.theme.tool.resource.ResourceFactory;
import com.miui.theme.tool.util.GUIUtil;
import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class MainPanel
extends NinePPanel {
    public MainTabPanel mMainTabPanel;
    private String mLaunchResourceType = null;
    private JLabel[] mResizeLables;
    protected Point mLastPoint;
    private final MouseAdapter mResizeListener = new MouseAdapter(){

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            MainPanel.this.mLastPoint = mouseEvent.getLocationOnScreen();
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            MainPanel.this.handleDrag(mouseEvent);
        }
    };
    public MenuDialog mMenuDialog;
    public ImageIcon mMenuIcon = ResourceFactory.getInstance().getImageIcon("main/logo_n.png");
    public JButton mMenu = GUIUtil.createTransparentButton(this.mMenuIcon, this.mMenuIcon, this.mMenuIcon, null);
    private final ActionListener mMenuListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            MainPanel.this.mMenuDialog.setVisible(true);
        }
    };
    private static final int[][] MOVE_DIRECTION = new int[][]{{-1, -1, 1, 1}, {0, -1, 0, 1}, {1, -1, 0, 1}, {1, 0, 0, 0}, {1, 1, 0, 0}, {0, 1, 0, 0}, {-1, 1, 1, 0}, {-1, 0, 1, 0}};
    private final HashMap<JLabel, int[]> mMoveDirection = new HashMap();
    private static final String[] MOVE_LAYOUT = new String[]{"1, 1", "2, 1", "3, 1", "3, 2", "3, 3", "2, 3", "1, 3", "1, 2"};
    private static final int[] MOVE_CURSOR_TYPE = new int[]{6, 8, 7, 11, 5, 9, 4, 10};

    protected void handleDrag(MouseEvent mouseEvent) {
        Point point = mouseEvent.getLocationOnScreen();
        if (point != null && this.mLastPoint != null) {
            int n = point.x - this.mLastPoint.x;
            int n2 = point.y - this.mLastPoint.y;
            NewMainFrame newMainFrame = NewMainFrame.getInstance();
            if (newMainFrame.getExtendedState() != 6) {
                int[] nArray = this.mMoveDirection.get(mouseEvent.getSource());
                int n3 = newMainFrame.getWidth();
                int n4 = newMainFrame.getHeight();
                int n5 = newMainFrame.getLocation().x;
                int n6 = newMainFrame.getLocation().y;
                n5 += nArray[2] * n;
                n6 += nArray[3] * n2;
                if ((n3 += nArray[0] * n) >= 1132 + this.getLeftPadding() + this.getRightPadding() && (n4 += nArray[1] * n2) >= 686 + this.getTopPadding() + this.getBottomPadding()) {
                    newMainFrame.setBounds(n5, n6, n3, n4);
                }
            }
        }
        this.mLastPoint = point;
    }

    public void setFullBackground(boolean bl) {
        if (GUIUtil.supportTransparent()) {
            if (bl) {
                this.setNinePBackground("main/fullscreen_shadow.9.png");
            } else {
                this.setNinePBackground("main/frame_bg.9.png");
            }
        }
    }

    public MainPanel() {
        if (GUIUtil.supportTransparent()) {
            this.setNinePBackground("main/frame_bg.9.png");
        }
        this.mMainTabPanel = new MainTabPanel();
        this.initMenuDialog();
        this.initEditPanel();
        this.adjustPadding();
    }

    private void initMenuDialog() {
        this.mMenuDialog = new MenuDialog();
    }

    public void initEditPanel() {
        this.getContentPanel().removeAll();
        this.mMenu.addActionListener(this.mMenuListener);
        this.mMenu.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                keyEvent.consume();
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                keyEvent.consume();
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                keyEvent.consume();
            }
        });
        double[][] dArrayArray = new double[][]{{67.0, -1.0}, {67.0, -1.0}};
        TableLayout tableLayout = new TableLayout(dArrayArray);
        this.getContentPanel().setLayout(tableLayout);
        this.getContentPanel().add((Component)this.mMenu, "0, 0");
        this.getContentPanel().add((Component)this.mMainTabPanel, "0, 0, 1, 1");
        this.revalidate();
        this.repaint();
    }

    public void setResizeEnable(boolean bl) {
        if (bl) {
            for (int i = 0; i < MOVE_CURSOR_TYPE.length; ++i) {
                this.mResizeLables[i].setCursor(Cursor.getPredefinedCursor(MOVE_CURSOR_TYPE[i]));
            }
        } else {
            for (int i = 0; i < MOVE_CURSOR_TYPE.length; ++i) {
                this.mResizeLables[i].setCursor(Cursor.getDefaultCursor());
            }
        }
    }

    @Override
    public void adjustPadding() {
        int n;
        int n2 = 5;
        double[][] dArrayArray = new double[][]{{this.getLeftPadding(), n2, -1.0, n2, this.getRightPadding()}, {this.getTopPadding(), n2, -1.0, n2, this.getBottomPadding()}};
        TableLayout tableLayout = new TableLayout(dArrayArray);
        this.setLayout(tableLayout);
        if (this.mResizeLables == null) {
            this.mResizeLables = new ResizeLabel[MOVE_CURSOR_TYPE.length];
            for (n = 0; n < MOVE_CURSOR_TYPE.length; ++n) {
                this.mResizeLables[n] = new ResizeLabel();
                this.mResizeLables[n].setCursor(Cursor.getPredefinedCursor(MOVE_CURSOR_TYPE[n]));
                this.mMoveDirection.put(this.mResizeLables[n], MOVE_DIRECTION[n]);
                this.mResizeLables[n].addMouseMotionListener(this.mResizeListener);
                this.mResizeLables[n].addMouseListener(this.mResizeListener);
            }
        }
        for (n = 0; n < MOVE_CURSOR_TYPE.length; ++n) {
            this.add((Component)this.mResizeLables[n], MOVE_LAYOUT[n]);
        }
        this.add((Component)this.getContentPanel(), "1, 1, 3, 3");
    }

    public void switchTab(String string) {
        this.switchTab(string, null);
    }

    public void switchTab(String string, String string2) {
        this.mLaunchResourceType = string2;
        this.mMainTabPanel.switchTab(string);
    }

    public void switchTab(JPanel jPanel) {
        this.mMainTabPanel.switchTab(jPanel);
    }

    public String getAndClearLaunchResourceType() {
        String string = this.mLaunchResourceType;
        this.mLaunchResourceType = null;
        return string;
    }

    public void afterOpenTheme() {
        IconManager.fillData();
        MockLauncher.clearIconMapCache();
        this.mMainTabPanel.afterOpenTheme();
    }
}

