/*
 * Decompiled with CFR 0.152.
 */
package com.miui.theme.tool.gui.main;

import com.miui.theme.tool.gui.PopupDialog;
import com.miui.theme.tool.gui.TransparentPanel;
import com.miui.theme.tool.gui.main.ComboBoxUI;
import com.miui.theme.tool.gui.main.TextFieldUI;
import com.miui.theme.tool.gui.main.ThemeInfoData;
import com.miui.theme.tool.gui.main.ThemeManager;
import com.miui.theme.tool.gui.skin.ThemeLookAndFeel;
import com.miui.theme.tool.resource.ResourceFactory;
import com.miui.theme.tool.util.ConfigUtil;
import com.miui.theme.tool.util.ThemeHelper;
import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class EditInfoDialog
extends PopupDialog {
    private JLabel mThemeTitleLabel;
    private JLabel mThemeAuthorLabel;
    private JLabel mThemeDesignerLabel;
    private JLabel mThemeVersionLabel;
    private JLabel mThemeUIVersionLabel;
    private TransparentPanel mInfoPanel;
    protected TextField mThemeVersionTextField;
    protected TextField mThemeAuthorTextField;
    protected TextField mThemeDesignerTextField;
    protected TextField mThemeTitleTextField;
    protected ComboBox mThemeUIVersionComboBox;
    protected ActionListener mEditInfoListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            EditInfoDialog.this.saveInfo();
            ThemeManager.getInstance();
            ThemeManager.openTheme(new File(ConfigUtil.getThemePath()));
            EditInfoDialog.this.closeDialog();
        }
    };

    private void saveInfo() {
        ThemeInfoData themeInfoData = ThemeManager.getInstance().getThemeInfoData();
        themeInfoData.mTitle = this.mThemeTitleTextField.getText();
        themeInfoData.mDesigner = this.mThemeDesignerTextField.getText();
        themeInfoData.mAuthor = this.mThemeAuthorTextField.getText();
        themeInfoData.mVersion = this.mThemeVersionTextField.getText();
        themeInfoData.mUIVersion = ThemeHelper.UI_VERSION_VALUE[this.mThemeUIVersionComboBox.getSelectedIndex()];
        themeInfoData.save();
    }

    public EditInfoDialog() {
        this.initLayout();
        this.initInfoPanel();
        this.mContentPanel.getContentPanel().add((Component)this.mInfoPanel, "0, 2, 3, 2");
    }

    protected void initLayout() {
        double[][] dArrayArray = new double[][]{{26.0, -1.0, 23.0, 48.0}, {46.0, 1.0, -1.0, 1.0, 46.0}};
        TableLayout tableLayout = new TableLayout(dArrayArray);
        this.mMainPanel = this.mContentPanel.getContentPanel();
        this.mMainPanel.setLayout(tableLayout);
        this.mMainPanel.add((Component)this.getSepPanel(), "0, 1, 3, 1");
        this.mMainPanel.add((Component)this.getSepPanel(), "0, 3, 3, 3");
        this.initTitleLabel();
        this.initConfirmPanel();
    }

    public void initTitleLabel() {
        this.mDialogTitleLabel = new JLabel(ResourceFactory.getString("EditThemeInfo"));
        this.mDialogTitleLabel.setHorizontalTextPosition(2);
        this.adjustLabel(this.mDialogTitleLabel);
        this.mMainPanel.add((Component)this.mDialogTitleLabel, "1, 0");
        this.mCloseButton.addActionListener(this.mCloseActionListener);
        this.mCloseButton.setCursor(Cursor.getPredefinedCursor(12));
        this.mMainPanel.add((Component)this.mCloseButton, "3, 0");
    }

    public void initConfirmPanel() {
        this.mMainPanel.add((Component)this.mConfirmButton, "2, 4, 3, 4");
        this.mConfirmButton.addActionListener(this.mEditInfoListener);
    }

    private void initInfoPanel() {
        double[][] dArrayArray = new double[][]{{176.0, 8.0, 164.0, 122.0}, {40.0, 27.0, 20.0, 27.0, 20.0, 27.0, 20.0, 27.0, 20.0, 27.0, 20.0}};
        TableLayout tableLayout = new TableLayout(dArrayArray);
        this.mInfoPanel = new TransparentPanel();
        this.mInfoPanel.setBackground(sBackground);
        this.mInfoPanel.setLayout(tableLayout);
        this.mThemeTitleLabel = new Label(ResourceFactory.getString("Editinfo.ThemeTitle"));
        this.mThemeTitleTextField = new TextField();
        this.mThemeDesignerLabel = new Label(ResourceFactory.getString("Editinfo.ThemeDesigner"));
        this.mThemeDesignerTextField = new TextField();
        this.mThemeAuthorLabel = new Label(ResourceFactory.getString("Editinfo.ThemeAuthor"));
        this.mThemeAuthorTextField = new TextField();
        this.mThemeVersionLabel = new Label(ResourceFactory.getString("Editinfo.ThemeVersion"));
        this.mThemeVersionTextField = new TextField();
        this.mThemeUIVersionLabel = new Label(ResourceFactory.getString("Editinfo.ThemeUIVersion"));
        this.mThemeUIVersionComboBox = new ComboBox<String>(ThemeHelper.UI_VERSION_LABEL);
        this.mThemeUIVersionComboBox.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                EditInfoDialog.this.mContentPanel.repaint();
            }
        });
        this.mThemeUIVersionComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EditInfoDialog.this.mContentPanel.repaint();
            }
        });
        this.mThemeUIVersionComboBox.setSelectedItem("V5");
        ThemeInfoData themeInfoData = ThemeManager.getInstance().getThemeInfoData();
        if (themeInfoData != null) {
            this.mThemeTitleTextField.setText(themeInfoData.mTitle);
            this.mThemeDesignerTextField.setText(themeInfoData.mDesigner);
            this.mThemeAuthorTextField.setText(themeInfoData.mAuthor);
            this.mThemeVersionTextField.setText(themeInfoData.mVersion);
            this.mThemeUIVersionComboBox.setSelectedItem(ThemeHelper.sUiVersionMap.get(themeInfoData.mUIVersion));
        }
        this.mInfoPanel.add((Component)this.mThemeTitleLabel, "0, 1");
        this.mInfoPanel.add((Component)this.mThemeTitleTextField, "2, 1");
        this.mInfoPanel.add((Component)this.mThemeDesignerLabel, "0, 3");
        this.mInfoPanel.add((Component)this.mThemeDesignerTextField, "2, 3");
        this.mInfoPanel.add((Component)this.mThemeAuthorLabel, "0, 5");
        this.mInfoPanel.add((Component)this.mThemeAuthorTextField, "2, 5");
        this.mInfoPanel.add((Component)this.mThemeVersionLabel, "0, 7");
        this.mInfoPanel.add((Component)this.mThemeVersionTextField, "2, 7");
        this.mInfoPanel.add((Component)this.mThemeUIVersionLabel, "0, 9");
        this.mInfoPanel.add((Component)this.mThemeUIVersionComboBox, "2, 9");
    }

    class ComboBox<E>
    extends JComboBox {
        public ComboBox(E[] EArray) {
            super(EArray);
            this.setUI(ComboBoxUI.createUI(this));
            this.setAlignmentX(0.5f);
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
        }
    }

    class TextField
    extends JTextField {
        public TextField() {
            this.setUI(TextFieldUI.createUI(this));
            this.setHorizontalAlignment(0);
        }
    }

    class Label
    extends JLabel {
        public Label(String string) {
            super(string);
            this.setHorizontalAlignment(4);
            this.setForeground(PopupDialog.sLabelColor);
            this.setFont(ThemeLookAndFeel.getBoldFont(12));
        }
    }
}

