/*
 * Decompiled with CFR 0.152.
 */
package com.miui.theme.tool.gui;

import com.miui.theme.tool.gui.CommonRightPanel;
import com.miui.theme.tool.os.CmdUtils;
import com.miui.theme.tool.resource.ResourceFactory;
import com.miui.theme.tool.util.FileDrop;
import com.miui.theme.tool.util.GUIUtil;
import com.miui.theme.tool.util.ImagePreview;
import com.miui.theme.tool.util.ThemeHelper;
import java.awt.Color;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;

public class ResourceReplacePanel
extends CommonRightPanel {
    protected static File mLastDir;
    protected String mName;
    protected File mCatalogFile;
    protected File mReplaceFile;
    protected ReplaceActionListener mReplaceActionListener;
    protected static Color sBorderColor;
    protected static Border mBorder;
    protected static ImageIcon sUnreplaceNormal;
    protected static ImageIcon sUnreplaceHover;
    protected static ImageIcon sUnreplacePressed;
    protected JButton mUnreplaceButton = GUIUtil.createTransparentButton(sUnreplaceNormal, sUnreplaceHover, sUnreplacePressed, null);
    protected JLabel mCatalogIconLabel;
    protected JLabel mReplaceIconLabel;
    protected static ImageIcon sCopyNormal;
    protected static ImageIcon sCopyHover;
    protected static ImageIcon sCopyPressed;
    protected JButton mCopyButton = GUIUtil.createTransparentButton(sCopyNormal, sCopyHover, sCopyPressed, null);
    protected JPanel mEditPanel;
    protected static ImageIcon sSelectNormal;
    protected static ImageIcon sSelectHover;
    protected static ImageIcon sSelectPressed;
    protected JButton mSelectButton = GUIUtil.createTransparentButton(sSelectNormal, sSelectHover, sSelectPressed, null);
    protected static ImageIcon sDeleteNormal;
    protected static ImageIcon sDeleteHover;
    protected static ImageIcon sDeletePressed;
    protected JButton mDeleteButton = GUIUtil.createTransparentButton(sDeleteNormal, sDeleteHover, sDeletePressed, null);
    protected static ImageIcon sEditNormal;
    protected static ImageIcon sEditHover;
    protected static ImageIcon sEditPressed;
    protected JButton mEditButton = GUIUtil.createTransparentButton(sEditNormal, sEditHover, sEditPressed, null);
    public static final String[] NORMAL_SUFFIX;
    public static final String[] PRESSED_SUFFIX;
    public static final String[] DISABLED_SUFFIX;
    public static ArrayList<String> sResourceSuffixList;
    protected ReplaceIconActionListener rial = new ReplaceIconActionListener();
    AdaptXhdpi2Hdpi ax2all = new AdaptXhdpi2Hdpi();
    protected EditNinePatchActionListener enpal = new EditNinePatchActionListener();
    protected DeleteFileActionListener dfal = new DeleteFileActionListener();
    protected DragHintActionListener dhal = new DragHintActionListener();

    public ResourceReplacePanel(String string, File file, File file2, ReplaceActionListener replaceActionListener) {
        this.mName = string;
        this.mCatalogFile = file;
        this.mReplaceFile = file2;
        this.mReplaceActionListener = replaceActionListener;
    }

    protected void checkAndReplace(File file, File file2) {
        if (file.exists() && !file2.exists()) {
            try {
                ThemeHelper.copyFile(file, file2);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    protected void replaceResource(File file, File file2) {
        if (!this.isRightSuffix(file2.getName())) {
            GUIUtil.alert(ResourceFactory.getString("wrong_resource_type"));
            return;
        }
        File file3 = file.getParentFile();
        if (!file3.exists()) {
            file3.mkdirs();
        }
        CmdUtils.copyFile(file2.getAbsolutePath(), file.getAbsolutePath());
        for (int i = 0; i < PRESSED_SUFFIX.length; ++i) {
            if (!this.mCatalogFile.getAbsolutePath().endsWith(PRESSED_SUFFIX[i] + ".png")) continue;
            File file4 = new File(this.mCatalogFile.getAbsolutePath().replace(PRESSED_SUFFIX[i], NORMAL_SUFFIX[i]));
            File file5 = new File(file.getAbsolutePath().replace(PRESSED_SUFFIX[i], NORMAL_SUFFIX[i]));
            this.checkAndReplace(file4, file5);
            File file6 = new File(this.mCatalogFile.getAbsolutePath().replace(PRESSED_SUFFIX[i], DISABLED_SUFFIX[i]));
            File file7 = new File(file.getAbsolutePath().replace(PRESSED_SUFFIX[i], DISABLED_SUFFIX[i]));
            this.checkAndReplace(file6, file7);
        }
        this.mReplaceActionListener.onRefresh();
    }

    protected void deleteFile(File file) {
        file.delete();
    }

    protected boolean isRightSuffix(String string) {
        for (int i = 0; i < sResourceSuffixList.size(); ++i) {
            if (!string.endsWith(sResourceSuffixList.get(i))) continue;
            return true;
        }
        return false;
    }

    static {
        sBorderColor = GUIUtil.hex2color("#b8b8b9");
        mBorder = BorderFactory.createLineBorder(sBorderColor);
        sUnreplaceNormal = ResourceFactory.getInstance().getImageIcon("icon/unreplace_n.png");
        sUnreplaceHover = ResourceFactory.getInstance().getImageIcon("icon/unreplace_h.png");
        sUnreplacePressed = ResourceFactory.getInstance().getImageIcon("icon/unreplace_p.png");
        sCopyNormal = ResourceFactory.getInstance().getImageIcon("icon/copy_btn_n.png");
        sCopyHover = ResourceFactory.getInstance().getImageIcon("icon/copy_btn_h.png");
        sCopyPressed = ResourceFactory.getInstance().getImageIcon("icon/copy_btn_p.png");
        sSelectNormal = ResourceFactory.getInstance().getImageIcon("icon/imgpicker_icon_n.png");
        sSelectHover = ResourceFactory.getInstance().getImageIcon("icon/imgpicker_icon_h.png");
        sSelectPressed = ResourceFactory.getInstance().getImageIcon("icon/imgpicker_icon_p.png");
        sDeleteNormal = ResourceFactory.getInstance().getImageIcon("icon/crash_icon_n.png");
        sDeleteHover = ResourceFactory.getInstance().getImageIcon("icon/crash_icon_h.png");
        sDeletePressed = ResourceFactory.getInstance().getImageIcon("icon/crash_icon_p.png");
        sEditNormal = ResourceFactory.getInstance().getImageIcon("icon/edit_icon_n.png");
        sEditHover = ResourceFactory.getInstance().getImageIcon("icon/edit_icon_h.png");
        sEditPressed = ResourceFactory.getInstance().getImageIcon("icon/edit_icon_p.png");
        NORMAL_SUFFIX = new String[]{"_n", "_normal"};
        PRESSED_SUFFIX = new String[]{"_p", "_pressed"};
        DISABLED_SUFFIX = new String[]{"_d", "_disabled"};
        sResourceSuffixList = new ArrayList();
        sResourceSuffixList.add(".png");
        sResourceSuffixList.add(".jpg");
    }

    public static interface ReplaceActionListener {
        public void onRefresh();

        public void onWait();
    }

    protected class DragHintActionListener
    implements ActionListener {
        protected DragHintActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            GUIUtil.alert(ResourceFactory.getString("DragHint"));
        }
    }

    protected class PasteActionListener
    implements ActionListener {
        private final String mReplaceResourcePath;

        public PasteActionListener(String string) {
            this.mReplaceResourcePath = string;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            Transferable transferable = clipboard.getContents(null);
            if (transferable == null || !transferable.isDataFlavorSupported(DataFlavor.imageFlavor)) {
                GUIUtil.alert(ResourceFactory.getString("no_image_in_clipboard"));
                return;
            }
            try {
                BufferedImage bufferedImage = (BufferedImage)clipboard.getData(DataFlavor.imageFlavor);
                GUIUtil.saveImage(bufferedImage, new File(this.mReplaceResourcePath));
                ResourceReplacePanel.this.mReplaceActionListener.onRefresh();
                return;
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
                unsupportedFlavorException.printStackTrace();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            GUIUtil.alert(ResourceFactory.getString("paste_wrong"));
        }
    }

    protected class CopyResourceActionListener
    implements ActionListener {
        private final String mCatalogResourcePath;
        private final String mReplaceResourcePath;

        public CopyResourceActionListener(String string, String string2) {
            this.mCatalogResourcePath = string;
            this.mReplaceResourcePath = string2;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            File file = new File(this.mReplaceResourcePath);
            ResourceReplacePanel.this.replaceResource(file, new File(this.mCatalogResourcePath));
        }
    }

    protected class OpenThemeResourceFolderActionListener
    implements ActionListener {
        private final String mReplaceResourcePath;

        public OpenThemeResourceFolderActionListener(String string) {
            this.mReplaceResourcePath = string;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ThemeHelper.openInExplorer(new File(this.mReplaceResourcePath));
            ResourceReplacePanel.this.mReplaceActionListener.onRefresh();
        }
    }

    protected class OpenInExplorerMouseAdapter
    extends MouseAdapter {
        private final File mFile;

        public OpenInExplorerMouseAdapter(File file) {
            this.mFile = file;
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getButton() != 1) {
                return;
            }
            File file = this.mFile;
            if (!file.exists()) {
                return;
            }
            ThemeHelper.openInExplorer(file);
            ResourceReplacePanel.this.mReplaceActionListener.onRefresh();
            ResourceReplacePanel.this.mReplaceActionListener.onWait();
        }
    }

    protected class DeleteFileActionListener
    implements ActionListener {
        protected DeleteFileActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ResourceReplacePanel.this.deleteFile(ResourceReplacePanel.this.mReplaceFile);
            ResourceReplacePanel.this.mReplaceActionListener.onRefresh();
        }
    }

    protected class EditNinePatchActionListener
    implements ActionListener {
        protected EditNinePatchActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            GUIUtil.openNinePatch(ResourceReplacePanel.this.mReplaceFile.getAbsolutePath());
            ResourceReplacePanel.this.mReplaceActionListener.onWait();
        }
    }

    protected class AdaptXhdpi2Hdpi
    implements ActionListener {
        protected AdaptXhdpi2Hdpi() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ResourceReplacePanel.this.mReplaceActionListener.onRefresh();
        }
    }

    protected class FileDropListener
    implements FileDrop.Listener {
        private final File mReplaceFile;

        public FileDropListener(File file) {
            this.mReplaceFile = file;
        }

        @Override
        public void filesDropped(File[] fileArray) {
            File file = fileArray[0];
            if (file.isDirectory()) {
                return;
            }
            ResourceReplacePanel.this.replaceResource(this.mReplaceFile, file);
        }
    }

    protected class ReplaceIconActionListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setVisible(true);
            jFileChooser.setDialogTitle(ResourceFactory.getString("select_a_resource"));
            if (mLastDir != null) {
                jFileChooser.setCurrentDirectory(mLastDir);
            }
            jFileChooser.setFileSelectionMode(0);
            jFileChooser.setMultiSelectionEnabled(false);
            ImagePreview imagePreview = new ImagePreview(jFileChooser);
            jFileChooser.addPropertyChangeListener(imagePreview);
            jFileChooser.setAccessory(imagePreview);
            int n = jFileChooser.showOpenDialog(null);
            if (n == 0) {
                File file = jFileChooser.getSelectedFile();
                mLastDir = file.getParentFile();
                if (file.isDirectory()) {
                    return;
                }
                ResourceReplacePanel.this.replaceResource(ResourceReplacePanel.this.mReplaceFile, file);
                ((JLabel)actionEvent.getSource()).setIcon(GUIUtil.getIcon(ResourceReplacePanel.this.mReplaceFile));
            }
        }
    }
}

