/*
 * Decompiled with CFR 0.152.
 */
package com.miui.theme.tool.compressor;

import com.miui.theme.tool.ninepatch.NinePatchUtils;
import com.miui.theme.tool.util.ConfigUtil;
import com.miui.theme.tool.util.Log;
import com.miui.theme.tool.util.ThemeHelper;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.zip.CRC32;
import java.util.zip.CheckedOutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipOutputStream;

public class ZipCompressor {
    static final int BUFFER = 8192;
    private File mZipFile;
    private boolean mIsEncode9Patch = true;
    private HashSet<String> mNinePatchWrongs = new HashSet();

    public ZipCompressor(String string) {
        this.mZipFile = new File(string);
    }

    public ZipCompressor(String string, boolean bl) {
        this.mZipFile = new File(string);
        this.mIsEncode9Patch = bl;
    }

    public HashSet<String> compressContent(String string) {
        File file = new File(string);
        if (!file.exists()) {
            throw new RuntimeException(string + " not exists");
        }
        ZipOutputStream zipOutputStream = null;
        FileOutputStream fileOutputStream = null;
        FilterOutputStream filterOutputStream = null;
        try {
            this.mZipFile.getParentFile().mkdirs();
            fileOutputStream = new FileOutputStream(this.mZipFile);
            filterOutputStream = new CheckedOutputStream(fileOutputStream, new CRC32());
            zipOutputStream = new ZipOutputStream((OutputStream)filterOutputStream);
            if (string.endsWith("bootanimation")) {
                zipOutputStream.setMethod(0);
            }
            String string2 = "";
            for (File file2 : file.listFiles()) {
                this.compress(file2, zipOutputStream, string2);
            }
            HashSet<String> hashSet = this.mNinePatchWrongs;
            return hashSet;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        finally {
            try {
                if (zipOutputStream != null) {
                    zipOutputStream.close();
                }
                if (filterOutputStream != null) {
                    filterOutputStream.close();
                }
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    private void compress(File file, ZipOutputStream zipOutputStream, String string) {
        if (file.isDirectory()) {
            if (file.getAbsolutePath().endsWith(".unzip")) {
                return;
            }
            this.compressDirectory(file, zipOutputStream, string);
        } else {
            this.compressFile(file, zipOutputStream, string);
        }
    }

    private void compressDirectory(File file, ZipOutputStream zipOutputStream, String string) {
        if (!file.exists()) {
            return;
        }
        for (File file2 : file.listFiles()) {
            this.compress(file2, zipOutputStream, string + file.getName() + "/");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compressFile(File file, ZipOutputStream zipOutputStream, String string) {
        if (!file.exists()) {
            return;
        }
        BufferedInputStream bufferedInputStream = null;
        FileInputStream fileInputStream = null;
        try {
            int n;
            Object object;
            ByteArrayInputStream byteArrayInputStream;
            if (this.mIsEncode9Patch && ThemeHelper.isNinePatchName(file.getName())) {
                byteArrayInputStream = null;
                byteArrayInputStream = NinePatchUtils.compileSinglePng(new FileInputStream(file));
                if (byteArrayInputStream != null) {
                    bufferedInputStream = new BufferedInputStream(byteArrayInputStream);
                    byteArrayInputStream.close();
                } else {
                    bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
                }
                if (byteArrayInputStream == null) {
                    Log.l(file.getAbsolutePath() + " not valid .9.png ");
                }
            } else {
                bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
            }
            byteArrayInputStream = new ZipEntry(string + file.getName());
            if (string.indexOf("bootanimation") != -1 || file.getAbsolutePath().indexOf("bootanimation") != -1) {
                byteArrayInputStream.setMethod(0);
                byteArrayInputStream.setSize(file.length());
                byteArrayInputStream.setCompressedSize(file.length());
                object = new CRC32();
                fileInputStream = new FileInputStream(file);
                object.update(IOUtils.toByteArray((InputStream)fileInputStream));
                byteArrayInputStream.setCrc(((CRC32)object).getValue());
            }
            byteArrayInputStream.setTime(file.lastModified());
            byteArrayInputStream.setUnixMode(644);
            zipOutputStream.putNextEntry((ZipEntry)byteArrayInputStream);
            zipOutputStream.setEncoding("UTF-8");
            object = new byte[8192];
            while ((n = bufferedInputStream.read((byte[])object, 0, 8192)) != -1) {
                zipOutputStream.write((byte[])object, 0, n);
            }
        }
        catch (Exception exception) {
            String string2 = file.getAbsolutePath();
            exception.printStackTrace();
            this.mNinePatchWrongs.add(exception.getMessage() + string2.substring(new File(ConfigUtil.getThemePath()).getParent().length() + 1));
        }
        finally {
            try {
                if (bufferedInputStream != null) {
                    bufferedInputStream.close();
                }
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }
}

