/*
 * Decompiled with CFR 0.152.
 */
package com.miui.theme.tool.compressor;

import com.miui.theme.tool.compressor.ZipCompressor;
import com.miui.theme.tool.gui.CopyableDialog;
import com.miui.theme.tool.gui.main.NewMainFrame;
import com.miui.theme.tool.ninepatch.NinePatchDecoder;
import com.miui.theme.tool.ninepatch.NinePatchUtils;
import com.miui.theme.tool.os.CmdUtils;
import com.miui.theme.tool.os.OS;
import com.miui.theme.tool.util.ConfigUtil;
import com.miui.theme.tool.util.MD5Util;
import com.miui.theme.tool.util.ThemeHelper;
import java.awt.Cursor;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipFile;

public class MtzCompressor {
    public static final String[] sNoCompressDirs = new String[]{"wallpaper", "fonts", "boots", "ringtones", "audioeffect", "preview"};
    public static final String FONT = "fonts";
    public static final String BOOTS = "boots";
    public static final String ICONS = "icons";
    public static final String BOOTANIMATION = "bootanimation";
    public static final String BOOTANIMATION_DOT_ZIP = "bootanimation.zip";
    public static final String WIN_RABBISH = "Thumbs.db";
    private String mSrcPath;
    private File mSrcFile;
    private String mCacheDirPath;
    private String mTmpDirPath;
    private String mDestPath;
    private boolean mEncode9PatchFlag = true;
    private boolean mCompressFontFlag = false;
    private boolean mFullCompressFlag = false;
    private long mStartTime;
    private long mLastTime;
    private HashSet<String> mRepackagedSet;
    private HashSet<String> mNinePatchWrongs = new HashSet();
    public static ExecutorService sThreadPool;

    public static boolean isNoCompressDir(String string) {
        for (int i = 0; i < sNoCompressDirs.length; ++i) {
            if (!string.equals(sNoCompressDirs[i])) continue;
            return true;
        }
        return false;
    }

    public void setSrcPath(String string) {
        this.mSrcPath = string;
        this.mSrcFile = new File(this.mSrcPath);
        this.mCacheDirPath = ThemeHelper.getTmpFolder() + File.separator + "compress_cache" + File.separator + this.mSrcFile.getName() + "_" + MD5Util.md5(this.mSrcFile.getAbsolutePath());
        File file = new File(this.mCacheDirPath);
        file.mkdirs();
        this.mTmpDirPath = ThemeHelper.getTmpFolder() + File.separator + "compress_temp" + File.separator + this.mSrcFile.getName() + "_" + MD5Util.md5(this.mSrcFile.getAbsolutePath());
    }

    public void setDestPath(String string) {
        this.mDestPath = string;
    }

    public void setEncodeNinePatch(boolean bl) {
        this.mEncode9PatchFlag = bl;
    }

    public void setCompressFont(boolean bl) {
        this.mCompressFontFlag = bl;
    }

    public void setFullCompress(boolean bl) {
        this.mFullCompressFlag = bl;
    }

    public void generate() {
        ThemeHelper.searchAndDelete(WIN_RABBISH, this.mSrcFile);
        this.generateCache();
        if (this.mNinePatchWrongs.size() > 0) {
            StringBuilder stringBuilder = new StringBuilder();
            for (String string : this.mNinePatchWrongs) {
                stringBuilder.append(string + "\n");
            }
            new CopyableDialog(stringBuilder.toString()).setVisible(true);
            throw new RuntimeException("generate cache error");
        }
        this.generateMtz();
    }

    /*
     * WARNING - void declaration
     */
    public void generateCache() {
        if (!this.mSrcFile.exists() && !this.mSrcFile.isDirectory()) {
            return;
        }
        new File(this.mCacheDirPath).mkdirs();
        this.mStartTime = System.currentTimeMillis();
        this.mLastTime = System.currentTimeMillis();
        this.mRepackagedSet = new HashSet();
        for (File file : this.mSrcFile.listFiles()) {
            boolean bl = false;
            File file2 = new File(this.mCacheDirPath + File.separator + file.getName());
            sThreadPool = Executors.newFixedThreadPool(10);
            this.optimizePacakge(file, file2);
            sThreadPool.shutdown();
            try {
                sThreadPool.awaitTermination(Long.MAX_VALUE, TimeUnit.NANOSECONDS);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            if (!bl && !file2.exists()) {
                bl = true;
            }
            if (!bl && file.getName().equals("description.xml")) {
                bl = true;
            }
            HashMap<String, Long> hashMap = new HashMap<String, Long>();
            String string = "";
            if (!bl) {
                if (file2.isDirectory()) {
                    this.getFileMapRecursive(file2, "", hashMap);
                } else {
                    this.getFileMapFromZip(file2, hashMap);
                }
                string = file.getName() + "count before:" + hashMap.size();
                bl = this.checkFileByMapRecursive(file, "", hashMap);
            }
            if (!bl && hashMap.keySet().size() > 0) {
                System.out.println(string + " count after:" + hashMap.size());
                bl = true;
            }
            if (!bl) continue;
            this.mRepackagedSet.add(file.getName());
            this.removePackage(file2);
            if (file.isFile()) {
                this.copyFile(this.mSrcPath + File.separator + file.getName(), this.mCacheDirPath + File.separator + file.getName(), this.mEncode9PatchFlag);
            } else {
                Object object;
                Serializable serializable;
                File[] fileArray;
                if (file.listFiles().length == 0) continue;
                String string2 = file.getName();
                if (MtzCompressor.isNoCompressDir(string2)) {
                    new File(this.mCacheDirPath + File.separator + string2).mkdir();
                    if (string2.equals(BOOTS)) {
                        void string3;
                        fileArray = file.listFiles();
                        int n = fileArray.length;
                        boolean bl2 = false;
                        while (string3 < n) {
                            serializable = fileArray[string3];
                            if (serializable.isDirectory() && serializable.getName().equals(BOOTANIMATION)) {
                                object = new ZipCompressor(this.mCacheDirPath + File.separator + BOOTS + File.separator + BOOTANIMATION_DOT_ZIP);
                                ((ZipCompressor)object).compressContent(this.mSrcPath + File.separator + BOOTS + File.separator + BOOTANIMATION);
                            } else if (serializable.isFile()) {
                                this.copyDirectory(this.mSrcPath + File.separator + string2, this.mCacheDirPath + File.separator + BOOTS, this.mEncode9PatchFlag);
                            }
                            ++string3;
                        }
                    } else {
                        this.copyDirectory(this.mSrcPath + File.separator + string2, this.mCacheDirPath + File.separator + string2, this.mEncode9PatchFlag);
                    }
                } else {
                    fileArray = ThemeHelper.getFilesWithSuffix(file.getAbsolutePath(), ".unzip");
                    for (String zipCompressor : fileArray) {
                        serializable = new File(zipCompressor);
                        if (serializable.listFiles() == null) {
                            return;
                        }
                        this.checkAndImportManifest(zipCompressor);
                        object = zipCompressor.replace(".unzip", "");
                        ThemeHelper.zip(zipCompressor, (String)object);
                    }
                    String string4 = file.getName();
                    ZipCompressor zipCompressor = new ZipCompressor(this.mCacheDirPath + File.separator + (String)string4, this.mEncode9PatchFlag);
                    serializable = zipCompressor.compressContent(this.mSrcPath + File.separator + (String)string4);
                    this.mNinePatchWrongs.addAll((Collection<String>)((Object)serializable));
                    for (String string3 : fileArray) {
                        String string5 = string3.replace(".unzip", "");
                        new File(string5).delete();
                    }
                }
            }
            long l = System.currentTimeMillis() - this.mLastTime;
            this.mLastTime = System.currentTimeMillis();
            long l2 = System.currentTimeMillis() - this.mStartTime;
            System.out.println("spend:" + l + " total:" + l2 + "      " + file.getName());
        }
    }

    private void checkAndImportManifest(String string) {
        String string2 = string + File.separator + "manifest.xml";
        File file = new File(string2);
        if (file.exists()) {
            return;
        }
        File file2 = ThemeHelper.getCatalogFileFromReplaceFile(new File(string2));
        try {
            ThemeHelper.copyFile(file2, file);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void optimizePacakge(File file, File file2) {
        if (file.getName().equals("description.xml")) {
            return;
        }
        HashMap<String, Long> hashMap = new HashMap<String, Long>();
        if (!file2.exists()) {
            this.optimzeFolder(file, "", hashMap);
            return;
        }
        if (file2.isDirectory()) {
            this.getFileMapRecursive(file2, "", hashMap);
        } else {
            this.getFileMapFromZip(file2, hashMap);
        }
        this.optimzeFolder(file, "", hashMap);
    }

    private void optimzeFolder(File file, String string, HashMap<String, Long> hashMap) {
        File[] fileArray = new File(file.getAbsolutePath() + File.separator + string).listFiles();
        if (fileArray == null) {
            return;
        }
        for (File file2 : fileArray) {
            String string2 = string;
            string2 = string.isEmpty() ? string2 + file2.getName() : string2 + File.separator + file2.getName();
            if (file2.isFile()) {
                if (!hashMap.containsKey(string2 = ThemeHelper.assurePath(string2, "/"))) {
                    if (!string2.endsWith(".png")) continue;
                    this.optimizeFile(file2.getAbsolutePath());
                    continue;
                }
                if (this.fileTimeEqual(file2.lastModified(), hashMap.get(string2)) || !string2.endsWith(".png")) continue;
                this.optimizeFile(file2.getAbsolutePath());
                continue;
            }
            this.optimzeFolder(file, string2, hashMap);
        }
    }

    private void optimizeFile(final String string) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                CmdUtils.optimizePng(string);
            }
        };
        sThreadPool.submit(runnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getFileMapFromZip(File file, HashMap<String, Long> hashMap) {
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(file.getAbsolutePath());
            Enumeration enumeration = zipFile.getEntries();
            while (enumeration.hasMoreElements()) {
                ZipEntry zipEntry = (ZipEntry)enumeration.nextElement();
                if (zipEntry.isDirectory()) continue;
                hashMap.put(zipEntry.getName(), zipEntry.getTime());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            try {
                if (zipFile != null) {
                    zipFile.close();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    private void getFileMapRecursive(File file, String string, HashMap<String, Long> hashMap) {
        File[] fileArray = new File(file.getAbsolutePath() + File.separator + string).listFiles();
        if (fileArray == null) {
            return;
        }
        for (File file2 : fileArray) {
            if (file2.isFile()) {
                String string2 = string;
                string2 = string.isEmpty() ? string2 + file2.getName() : string2 + File.separator + file2.getName();
                string2 = ThemeHelper.assurePath(string2, "/");
                hashMap.put(string2, file2.lastModified());
                continue;
            }
            this.getFileMapRecursive(file, string + File.separator + file2.getName(), hashMap);
        }
    }

    private boolean checkFileByMapRecursive(File file, String string, HashMap<String, Long> hashMap) {
        File[] fileArray = new File(file.getAbsolutePath() + File.separator + string).listFiles();
        if (fileArray == null) {
            return false;
        }
        for (File file2 : fileArray) {
            String string2 = string;
            string2 = string.isEmpty() ? string2 + file2.getName() : string2 + File.separator + file2.getName();
            if (file2.isFile()) {
                if (!hashMap.containsKey(string2 = ThemeHelper.assurePath(string2, "/"))) {
                    System.out.println(file2.getName() + " " + file2.lastModified() + "~ empty");
                    return true;
                }
                if (!this.fileTimeEqual(file2.lastModified(), hashMap.get(string2))) {
                    System.out.println(file2.getName() + " " + file2.lastModified() + "~" + hashMap.get(string2));
                    return true;
                }
                hashMap.remove(string2);
                continue;
            }
            if (!this.checkFileByMapRecursive(file, string2, hashMap)) continue;
            return true;
        }
        return false;
    }

    private boolean fileTimeEqual(long l, long l2) {
        return Math.abs(l - l2) <= 2001L;
    }

    private void removePackage(File file) {
        if (file.isFile()) {
            file.delete();
        } else {
            OS.rmDir(file.getAbsolutePath());
        }
    }

    public void printTime(long l) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH mm ss E");
        System.out.println(simpleDateFormat.format(new Date(l)));
    }

    public void generateMtz() {
        Object object;
        File file = new File(this.mCacheDirPath);
        for (File file2 : file.listFiles()) {
            if (new File(this.mSrcPath + File.separator + file2.getName()).exists()) continue;
            this.removePackage(file2);
        }
        new File(this.mTmpDirPath).mkdirs();
        if (this.mFullCompressFlag) {
            object = new HashSet();
            for (File file3 : new File(this.mCacheDirPath).listFiles()) {
                ((HashSet)object).add(file3.getName());
            }
        } else {
            object = this.mRepackagedSet;
        }
        Object object2 = ((HashSet)object).iterator();
        while (object2.hasNext()) {
            String string = (String)object2.next();
            if (string.equals(FONT) && !this.mCompressFontFlag) continue;
            File file4 = new File(this.mCacheDirPath + File.separator + string);
            if (file4.isFile()) {
                this.copyFile(file4.getAbsolutePath(), this.mTmpDirPath + File.separator + string, false);
                continue;
            }
            this.copyDirectory(file4.getAbsolutePath(), this.mTmpDirPath + File.separator + string, false);
        }
        object2 = new ZipCompressor(this.mDestPath);
        ((ZipCompressor)object2).compressContent(this.mTmpDirPath);
        long l = System.currentTimeMillis() - this.mLastTime;
        this.mLastTime = System.currentTimeMillis();
        long l2 = System.currentTimeMillis() - this.mStartTime;
        System.out.println("spend:" + l + " total:" + l2 + "      " + this.mDestPath);
        OS.rmDir(this.mTmpDirPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyFile(String string, String string2, boolean bl) {
        FileInputStream fileInputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            if (bl && ThemeHelper.isNinePatchName(string) && !NinePatchDecoder.decode(string, false)) {
                fileOutputStream = new FileOutputStream(string2);
                NinePatchUtils.compileSinglePng(string, fileOutputStream);
                return;
            }
            File file = new File(string);
            File file2 = new File(string2);
            ThemeHelper.copyFile(file, file2);
            file2.setLastModified(file.lastModified());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.mNinePatchWrongs.add(exception.getMessage() + string.substring(new File(ConfigUtil.getThemePath()).getParent().length() + 1));
        }
        finally {
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    private void copyDirectory(String string, String string2, boolean bl) {
        new File(string2).mkdirs();
        File[] fileArray = new File(string).listFiles();
        if (fileArray == null) {
            return;
        }
        for (File file : fileArray) {
            Object object;
            Object object2;
            if (file.isFile()) {
                object2 = file;
                object = new File(new File(string2).getAbsolutePath() + File.separator + file.getName());
                this.copyFile(((File)object2).getAbsolutePath(), ((File)object).getAbsolutePath(), bl);
                continue;
            }
            if (!file.isDirectory()) continue;
            object2 = string + File.separator + file.getName();
            object = string2 + File.separator + file.getName();
            this.copyDirectory((String)object2, (String)object, bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean startCompress(String string, String string2) {
        NewMainFrame.getInstance().setCursor(Cursor.getPredefinedCursor(3));
        boolean bl = true;
        boolean bl2 = false;
        try {
            MtzCompressor mtzCompressor = new MtzCompressor();
            mtzCompressor.setSrcPath(string);
            mtzCompressor.setDestPath(string2);
            mtzCompressor.setCompressFont(false);
            mtzCompressor.setFullCompress(true);
            mtzCompressor.generate();
            bl2 = true;
        }
        catch (Exception exception) {
            bl = false;
            exception.printStackTrace();
        }
        finally {
            NewMainFrame.getInstance().setCursor(new Cursor(0));
        }
        if (!bl) {
            return false;
        }
        return bl2;
    }
}

