/*
 * Decompiled with CFR 0.152.
 */
package com.miui.theme.tool.catalog;

import com.miui.theme.tool.catalog.MIUIThemeValues;
import com.miui.theme.tool.resource.ResourceFactory;
import com.miui.theme.tool.util.Log;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Vector;

public class ThemeValue {
    private final String[] VALID_NAMES = new String[]{"bool", "integer", "string", "color", "fraction", "dimen", "array"};
    private File mOriginFile;
    private File mTargetXml;
    private String mPkgName = null;
    private String mStr;
    private Vector<Vector<String>> mThemeValues;
    public final String DEPRECATED_SUFFIX = "deprecated_";
    private BufferedReader mBufferedReader;
    private int mConfigCount;
    private int mEntryCount;

    public ThemeValue(File file, File file2) {
        this.mOriginFile = file;
        this.mTargetXml = file2;
        this.mThemeValues = new Vector();
    }

    public ThemeValue(String string, String string2) {
        this(new File(string), new File(string2));
    }

    public ThemeValue(String string) {
        this.mOriginFile = new File(string);
    }

    public void generateThemeValuesXml() {
        try {
            this.process();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.saveThemeValues();
    }

    private void saveThemeValues() {
        MIUIThemeValues mIUIThemeValues = new MIUIThemeValues();
        mIUIThemeValues.setXmlFile(this.mTargetXml);
        mIUIThemeValues.setAll(this.mThemeValues);
        mIUIThemeValues.save();
    }

    public String getPackageName() {
        if (this.mPkgName == null) {
            this.loadPackageName();
        }
        return this.mPkgName;
    }

    private void loadPackageName() {
        try {
            FileInputStream fileInputStream = new FileInputStream(this.mOriginFile);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
            bufferedReader.readLine();
            this.mStr = bufferedReader.readLine().trim();
            int n = this.mStr.lastIndexOf(61);
            if (n == -1) {
                return;
            }
            this.mPkgName = this.mStr.substring(n + 1, this.mStr.length());
            bufferedReader.close();
            fileInputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private String getPattern(String string) {
        String string2 = "";
        try {
            string2 = string.split(" ")[3].split(":")[1].split("/")[0];
        }
        catch (Exception exception) {
            string2 = "";
        }
        return string2;
    }

    private String getId(String string) {
        return string.split(" ")[2];
    }

    private String getName(String string) {
        return string.split(" ")[2].split(":")[1].split("/")[1];
    }

    private String getNameFirst(String string) {
        String string2 = "";
        try {
            string2 = string.split(" ")[3].split(":")[1].split("/")[1];
        }
        catch (Exception exception) {
            string2 = "";
        }
        return string2;
    }

    private int getConfigPriority(String string) {
        if (string.matches("config [0-9]*")) {
            return 0;
        }
        int n = 0;
        if (string.contains("default")) {
            ++n;
        }
        if (string.contains(ResourceFactory.sLocale.getCountry())) {
            ++n;
        }
        if (n > 0 && string.contains(ResourceFactory.sLocale.getLanguage())) {
            ++n;
        }
        return n;
    }

    private void process() throws IOException {
        FileInputStream fileInputStream = new FileInputStream(this.mOriginFile);
        this.mBufferedReader = new BufferedReader(new InputStreamReader((InputStream)fileInputStream, "utf-8"));
        while (this.mStr != null && this.mStr.startsWith("type") || (this.mStr = this.mBufferedReader.readLine()) != null) {
            this.mStr = this.mStr.trim();
            if (!this.mStr.startsWith("type")) continue;
            this.mConfigCount = 0;
            this.mEntryCount = 0;
            this.mConfigCount = this.getConfigCount(this.mStr);
            this.mEntryCount = this.getEntryCount(this.mStr);
            if (this.mConfigCount == 0) {
                this.mStr = this.mBufferedReader.readLine();
                continue;
            }
            this.mStr = this.mBufferedReader.readLine();
            if (this.mStr == null) break;
            this.mStr = this.mStr.trim();
            String string = this.getPattern(this.mStr);
            if (!this.isValid(string)) continue;
            Log.l(this.mStr);
            if (string.equals("array")) {
                this.processArray();
                continue;
            }
            this.processOtherItems(string);
        }
        this.mBufferedReader.close();
        fileInputStream.close();
    }

    private void processOtherItems(String string) throws IOException {
        Object object2;
        int n;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        Item item = new Item(string, this.getNameFirst(this.mStr));
        hashMap.put(this.getId(this.mStr), item);
        for (n = 1; n < this.mEntryCount && (this.mStr = this.mBufferedReader.readLine()) != null; ++n) {
            this.mStr = this.mStr.trim();
            object2 = new Item(string, this.getNameFirst(this.mStr));
            hashMap.put(this.getId(this.mStr), object2);
        }
        for (n = 0; n < this.mConfigCount; ++n) {
            this.gotoNextConfig(this.mBufferedReader);
            object2 = this.mStr;
            int n2 = this.getConfigPriority((String)object2);
            for (int i = 0; !(i >= this.mEntryCount || !this.mStr.startsWith("resource") && (this.mStr = this.mBufferedReader.readLine().trim()) == null || this.mStr.startsWith("config") || this.mStr.startsWith("type")); ++i) {
                String string2 = this.getName(this.mStr);
                String string3 = this.mStr.split(" ")[1];
                Item item2 = (Item)hashMap.get(string3);
                this.mStr = this.mBufferedReader.readLine().trim();
                if (this.mStr == null) break;
                String string4 = this.getValue(this.mStr);
                if (n2 <= item2.priority) continue;
                item2.priority = n2;
                item2.name = string2;
                item2.setValue(string4);
            }
            if (this.mStr == null || this.mStr.startsWith("type")) break;
        }
        for (Object object2 : hashMap.values()) {
            this.writeOneElement((Item)object2);
        }
    }

    private void processArray() throws IOException {
        int n;
        HashMap<String, Item> hashMap = new HashMap<String, Item>();
        for (n = 1; n < this.mEntryCount && (this.mStr = this.mBufferedReader.readLine().trim()) != null; ++n) {
            this.mStr = this.mStr.trim();
        }
        for (n = 0; n < this.mConfigCount; ++n) {
            this.gotoNextConfig(this.mBufferedReader);
            Object object = this.mStr;
            int n2 = this.getConfigPriority((String)object);
            for (int i = 0; !(i >= this.mEntryCount || !this.mStr.startsWith("resource") && (this.mStr = this.mBufferedReader.readLine().trim()) == null || this.mStr.startsWith("config") || this.mStr.startsWith("type")); ++i) {
                String string = this.getName(this.mStr);
                this.mStr = this.mBufferedReader.readLine().trim();
                int n3 = this.getArrayCount();
                for (int j = 0; j < n3; ++j) {
                    Item item;
                    this.mStr = this.mBufferedReader.readLine().trim();
                    if (!this.isStringArray(this.mStr)) continue;
                    String string2 = string + "#" + j;
                    String string3 = this.getValue(this.mStr);
                    if (hashMap.containsKey(string2)) {
                        item = (Item)hashMap.get(string2);
                    } else {
                        item = new Item("string", string2);
                        hashMap.put(string2, item);
                    }
                    if (n2 <= item.priority) continue;
                    item.priority = n2;
                    item.name = string2;
                    item.setValue(string3);
                }
            }
            if (this.mStr == null || this.mStr.startsWith("type")) break;
        }
        for (Object object : hashMap.values()) {
            this.writeOneElement((Item)object);
        }
    }

    private boolean isStringArray(String string) {
        return string.contains("(string8)");
    }

    private int getArrayCount() {
        if (!this.mStr.startsWith("Parent")) {
            return 0;
        }
        return Integer.parseInt(this.mStr.split(",")[1].split("=")[1]);
    }

    private String getValue(String string) {
        String string2 = "";
        if (string.trim().startsWith("(reference)")) {
            return string2;
        }
        int n = string.lastIndexOf(32);
        string2 = string.substring(n + 1, string.length());
        return string2;
    }

    private void gotoNextConfig(BufferedReader bufferedReader) throws IOException {
        if (this.mStr.startsWith("config")) {
            return;
        }
        this.mStr = bufferedReader.readLine();
        if (this.mStr == null) {
            return;
        }
        this.mStr = this.mStr.trim();
        while (!this.mStr.startsWith("config")) {
            this.mStr = bufferedReader.readLine();
            if (this.mStr == null) {
                return;
            }
            this.mStr = this.mStr.trim();
        }
    }

    private void writeOneElement(Item item) {
        if (item.value == null) {
            return;
        }
        if (item.pattern.equals("string")) {
            if (item.value == null) {
                return;
            }
            item.value = item.value.replace('\"', ' ');
        }
        item.value = item.value.trim();
        if (item.value.startsWith("\"")) {
            return;
        }
        if (item.name.startsWith("deprecated_")) {
            return;
        }
        Vector<String> vector = new Vector<String>();
        vector.add(0, item.pattern);
        vector.add(1, item.name);
        vector.add(2, item.value);
        vector.add(3, "");
        this.mThemeValues.add(vector);
    }

    private boolean isValid(String string) {
        for (int i = 0; i < this.VALID_NAMES.length; ++i) {
            if (!this.VALID_NAMES[i].equals(string)) continue;
            return true;
        }
        return false;
    }

    private int getEntryCount(String string) {
        String[] stringArray = string.split(" ");
        String string2 = stringArray[3].substring("entryCount=".length(), stringArray[3].length());
        int n = 0;
        n = Integer.parseInt(string2);
        return n;
    }

    private int getConfigCount(String string) {
        String[] stringArray = string.split(" ");
        String string2 = stringArray[2].substring("configCount=".length(), stringArray[2].length());
        int n = 0;
        n = Integer.parseInt(string2);
        return n;
    }

    private class Item {
        public String pattern;
        public String name;
        public String value;
        public int priority = -1;

        public Item(String string, String string2) {
            this.pattern = string;
            this.name = string2;
        }

        public void setValue(String string) {
            if ("bool".equals(this.pattern)) {
                if (string.equals("#ffffffff")) {
                    string = "true";
                } else if (string.equals("#00000000")) {
                    string = "false";
                }
            }
            this.value = string;
        }
    }
}

