/*
 * Decompiled with CFR 0.152.
 */
package com.miui.theme.tool.catalog;

import com.android.internal.util.FastXmlSerializer;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;

public class MIUIThemeValues {
    public static final int TYPE = 0;
    public static final int NAME = 1;
    public static final int VALUE = 2;
    public static final int PACKAGE = 3;
    public static final String ATTRIBUTE_NAME = "name";
    public static final String ATTRIBUTE_PACKAGE = "package";
    public static final String THEME_VALUES_ROOT_NODE = "MIUI_Theme_Values";
    public static final String NODE_ITEM = "item";
    public static final String NODE_STRING_ARRAY = "string-array";
    public static final String ARRAY_SEP = "#";
    File mThemeValuesFile;
    Vector<Vector<String>> mThemeValues;
    private HashMap<String, HashMap<String, Vector<String>>> mSaveHelpMap;
    private Vector<Vector<String>> mSaveHelpVector;
    public HashMap<String, Vector<String>> mCatalogThemeMap;

    public void setXmlFile(File file) {
        this.mThemeValuesFile = file;
    }

    public void parse() {
        this.mThemeValues = new Vector();
        SAXBuilder sAXBuilder = new SAXBuilder();
        try {
            Document document = sAXBuilder.build(this.mThemeValuesFile);
            Element element = document.getRootElement();
            for (Element element2 : element.getChildren()) {
                Object object;
                if (element2.getName().equals(NODE_STRING_ARRAY)) {
                    object = element2.getAttributeValue(ATTRIBUTE_NAME);
                    List list = element2.getChildren();
                    for (int i = 0; i < list.size(); ++i) {
                        Vector<String> vector = new Vector<String>();
                        vector.add(0, "string");
                        vector.add(1, (String)object + ARRAY_SEP + i);
                        vector.add(((Element)list.get(i)).getText());
                        vector.add(3, "");
                        if (vector.get(1) == null || vector.get(0) == null) continue;
                        if (vector.get(2) == null) {
                            vector.set(2, "");
                        }
                        if (vector.get(3) == null) {
                            vector.set(3, "");
                        }
                        this.mThemeValues.add(vector);
                    }
                    continue;
                }
                object = new Vector();
                ((Vector)object).add(0, element2.getName());
                ((Vector)object).add(1, element2.getAttributeValue(ATTRIBUTE_NAME));
                ((Vector)object).add(2, element2.getText());
                ((Vector)object).add(3, element2.getAttributeValue(ATTRIBUTE_PACKAGE));
                if (((Vector)object).get(1) == null || ((Vector)object).get(0) == null) continue;
                if (((Vector)object).get(2) == null) {
                    ((Vector)object).set(2, "");
                }
                if (((Vector)object).get(3) == null) {
                    ((Vector)object).set(3, "");
                }
                this.mThemeValues.add((Vector<String>)object);
            }
        }
        catch (JDOMException jDOMException) {
            jDOMException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static Vector<Vector<String>> getThemeValuesFromFile(File file) {
        if (!file.exists()) {
            return new Vector<Vector<String>>();
        }
        MIUIThemeValues mIUIThemeValues = new MIUIThemeValues();
        mIUIThemeValues.setXmlFile(file);
        mIUIThemeValues.parse();
        return mIUIThemeValues.getAll();
    }

    public static void saveThemeValuesFromToFile(File file, Vector<Vector<String>> vector) {
        MIUIThemeValues mIUIThemeValues = new MIUIThemeValues();
        mIUIThemeValues.setXmlFile(file);
        mIUIThemeValues.setAll(vector);
        mIUIThemeValues.save();
    }

    public void setAll(Vector<Vector<String>> vector) {
        this.mThemeValues = vector;
    }

    Vector<Vector<String>> getAll() {
        return this.mThemeValues;
    }

    public void save() {
        this.prepareSave();
        FastXmlSerializer fastXmlSerializer = new FastXmlSerializer();
        try {
            this.mThemeValuesFile.getParentFile().mkdirs();
            FileOutputStream fileOutputStream = new FileOutputStream(this.mThemeValuesFile);
            fastXmlSerializer.setOutput(fileOutputStream, "UTF-8");
            fastXmlSerializer.startDocument(null, true);
            fastXmlSerializer.startTag(null, THEME_VALUES_ROOT_NODE);
            for (Vector<String> object : this.mSaveHelpVector) {
                fastXmlSerializer.startTag(null, object.get(0));
                fastXmlSerializer.attribute(null, ATTRIBUTE_NAME, object.get(1));
                if (!object.get(3).equals("")) {
                    fastXmlSerializer.attribute(null, ATTRIBUTE_PACKAGE, object.get(3));
                }
                fastXmlSerializer.text(object.get(2));
                fastXmlSerializer.endTag(null, object.get(0));
            }
            for (String string : this.mSaveHelpMap.keySet()) {
                Vector<String> vector;
                int n;
                fastXmlSerializer.startTag(null, NODE_STRING_ARRAY);
                fastXmlSerializer.attribute(null, ATTRIBUTE_NAME, string);
                HashMap<String, Vector<String>> hashMap = this.mSaveHelpMap.get(string);
                if (this.mCatalogThemeMap != null) {
                    n = 0;
                    while (this.mCatalogThemeMap.containsKey(string + ARRAY_SEP + n)) {
                        vector = hashMap.get("" + n);
                        fastXmlSerializer.startTag(null, NODE_ITEM);
                        if (hashMap.containsKey("" + n)) {
                            fastXmlSerializer.text(vector.get(2));
                        } else {
                            fastXmlSerializer.text(this.mCatalogThemeMap.get(string + ARRAY_SEP + n).get(2));
                        }
                        fastXmlSerializer.endTag(null, NODE_ITEM);
                        ++n;
                    }
                } else {
                    n = 0;
                    while (hashMap.containsKey("" + n)) {
                        vector = hashMap.get("" + n);
                        fastXmlSerializer.startTag(null, NODE_ITEM);
                        fastXmlSerializer.text(vector.get(2));
                        fastXmlSerializer.endTag(null, NODE_ITEM);
                        ++n;
                    }
                }
                fastXmlSerializer.endTag(null, NODE_STRING_ARRAY);
            }
            fastXmlSerializer.endTag(null, THEME_VALUES_ROOT_NODE);
            fastXmlSerializer.flush();
            fileOutputStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void prepareSave() {
        this.mSaveHelpMap = new HashMap();
        this.mSaveHelpVector = new Vector();
        for (Vector<String> vector : this.mThemeValues) {
            if (vector.get(1).contains(ARRAY_SEP)) {
                HashMap<Object, Object> hashMap;
                String[] stringArray = vector.get(1).split(ARRAY_SEP);
                String string = stringArray[0];
                String string2 = stringArray[1];
                if (this.mSaveHelpMap.containsKey(string)) {
                    hashMap = this.mSaveHelpMap.get(string);
                } else {
                    hashMap = new HashMap();
                    this.mSaveHelpMap.put(string, hashMap);
                }
                hashMap.put(string2, vector);
                continue;
            }
            this.mSaveHelpVector.add(vector);
        }
    }

    public void setSaveHelpData(Vector<Vector<String>> vector) {
        this.mCatalogThemeMap = new HashMap();
        for (Vector<String> vector2 : vector) {
            this.mCatalogThemeMap.put(MIUIThemeValues.getMapKey(vector2), vector2);
        }
    }

    public static String getMapKey(Vector<String> vector) {
        if (vector.get(3).equals("")) {
            return vector.get(1);
        }
        return vector.get(1) + "_" + vector.get(3);
    }
}

