/*
 * Decompiled with CFR 0.152.
 */
package com.miui.theme.tool.catalog;

import com.miui.theme.tool.catalog.CatalogManager;
import com.miui.theme.tool.catalog.Member;
import com.miui.theme.tool.catalog.ThemeValue;
import com.miui.theme.tool.extract.Extractor;
import com.miui.theme.tool.gui.main.NewMainFrame;
import com.miui.theme.tool.ninepatch.NinePatchUtils;
import com.miui.theme.tool.os.CmdUtils;
import com.miui.theme.tool.os.OS;
import com.miui.theme.tool.resource.ResourceFactory;
import com.miui.theme.tool.util.GUIUtil;
import com.miui.theme.tool.util.ThemeHelper;
import java.awt.Component;
import java.awt.Cursor;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;

class ImportResourceToCatalog
extends Thread {
    private final String mPackageName;
    private HashMap<String, Member> mHashMapApp;
    private Member mMember;
    public boolean mResult;
    private String mLocation;
    public static final String SYSTEM_APP = "/system/app";
    public static final String SYSTEM_PRIV_APP = "/system/priv-app";

    public ImportResourceToCatalog(String string) {
        this.mPackageName = string;
        String string2 = ThemeHelper.getImportResourceCatalogPath();
        try {
            this.mHashMapApp = CatalogManager.getHashMapApps();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.mMember = this.mHashMapApp.get(string);
        this.mLocation = this.mMember.mLocation;
        this.mResult = this.doImport();
    }

    public ImportResourceToCatalog(String string, String string2) {
        this.mPackageName = string;
        this.mLocation = string2;
        this.mResult = this.doImport();
    }

    private boolean doImport() {
        String string = ThemeHelper.getTmpFolder().getAbsolutePath();
        NewMainFrame newMainFrame = NewMainFrame.getInstance();
        ((Component)newMainFrame).setCursor(Cursor.getPredefinedCursor(3));
        String string2 = ThemeHelper.getImportResourceCatalogPath();
        String string3 = new File(this.mLocation).getName();
        boolean bl = CmdUtils.adb_pull(this.mLocation, string);
        if (!bl) {
            this.fixLocation();
            bl = CmdUtils.adb_pull(this.mLocation, string);
        }
        if (!bl) {
            GUIUtil.toastLong(ResourceFactory.getString("AdbPullError"));
            ((Component)newMainFrame).setCursor(new Cursor(0));
            return false;
        }
        String string4 = string + File.separator + string3;
        String string5 = string + File.separator + "values.txt";
        CmdUtils.aapt_dump_resources(string4, string5);
        String string6 = string2 + File.separator + this.mPackageName;
        Extractor extractor = new Extractor(string4, string6);
        extractor.unzipApkRes();
        NinePatchUtils.decompile(string6);
        String string7 = new File(string2).getName();
        ThemeValue themeValue = new ThemeValue(string5, string6 + File.separator + "theme_values.xml");
        themeValue.generateThemeValuesXml();
        OS.rmFile(string5);
        OS.rmFile(string4);
        GUIUtil.toastLong(ResourceFactory.getString("ImportComplete"));
        ((Component)newMainFrame).setCursor(new Cursor(0));
        this.afterImport(string6);
        return true;
    }

    private void afterImport(String string) {
        HashSet<String> hashSet = ThemeHelper.getFilesWithSuffix(string, ".maml");
        for (String string2 : hashSet) {
            File file = new File(string2);
            File file2 = new File(string2 + ".unzip");
            System.out.println(string2);
            System.out.println(string2 + ".unzip");
            ThemeHelper.unzip(file, file2);
            file.delete();
        }
    }

    private void fixLocation() {
        String string = CmdUtils.adb_getApkPath(this.mPackageName);
        if (string == null) {
            if (this.mLocation.startsWith(SYSTEM_APP)) {
                this.mLocation = this.mLocation.replace(SYSTEM_APP, SYSTEM_PRIV_APP);
            } else if (this.mLocation.startsWith(SYSTEM_PRIV_APP)) {
                this.mLocation = this.mLocation.replace(SYSTEM_PRIV_APP, SYSTEM_APP);
            }
        } else {
            this.mLocation = string;
        }
    }
}

