/*
 * Decompiled with CFR 0.152.
 */
package com.miui.theme.tool.catalog;

import com.miui.theme.tool.catalog.ImportResourceToCatalog;
import com.miui.theme.tool.catalog.MIUIThemeValues;
import com.miui.theme.tool.catalog.Member;
import com.miui.theme.tool.gui.ConfirmDialog;
import com.miui.theme.tool.gui.main.NewMainFrame;
import com.miui.theme.tool.gui.main.ThemeManager;
import com.miui.theme.tool.os.CmdUtils;
import com.miui.theme.tool.resource.ResourceFactory;
import com.miui.theme.tool.util.GUIUtil;
import com.miui.theme.tool.util.Log;
import com.miui.theme.tool.util.ThemeHelper;
import com.miui.theme.tool.util.ToastPanel;
import java.awt.Component;
import java.awt.Cursor;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Vector;

public class CatalogManager {
    private static final String APPINFO_FOLDER = "/data/data/com.miui.themetool/app_appinfo/";
    private static final String APPINFO_FILE = "/data/data/com.miui.themetool/app_appinfo/apps.txt";
    private static final File APP_LOCAL_FILE = new File(ThemeHelper.getTmpFolder() + File.separator + "apps.txt");
    public static HashMap<String, String> PACKAGE_TO_NAME = new HashMap();

    public static boolean checkAndImportCatalog(String string) throws Exception {
        File file = new File(ThemeHelper.getResourceCatalogPath() + File.separator + string);
        if (file.exists()) {
            return true;
        }
        ConfirmDialog confirmDialog = new ConfirmDialog(ResourceFactory.getString("Notice"), ResourceFactory.getString("NeedImportCatalog"));
        confirmDialog.setVisible(true);
        if (confirmDialog.mResult == "cancle") {
            return false;
        }
        return CatalogManager.doImportCatalog(string);
    }

    public static boolean doImportCatalog(String string) throws Exception {
        int n = ThemeHelper.getRomUIVersion();
        if (n == -1) {
            return false;
        }
        if (n != ThemeManager.getInstance().getThemeInfoData().mUIVersion) {
            ConfirmDialog confirmDialog = new ConfirmDialog(ResourceFactory.getString("Notice"), ResourceFactory.getString("UIVersionMismatch"));
            confirmDialog.setVisible(true);
            throw new Exception("version mismatch");
        }
        ToastPanel toastPanel = GUIUtil.toastEver(ResourceFactory.getString("Importing"));
        if (string.equals("framework-miui-res")) {
            CatalogManager.importAndMergeFrameworkMIUI();
            toastPanel.hideToast();
            return true;
        }
        ImportResourceToCatalog importResourceToCatalog = new ImportResourceToCatalog(string);
        if (!importResourceToCatalog.mResult) {
            return false;
        }
        if (!new File(ThemeHelper.getImportResourceCatalogPath() + File.separator + "framework-res").exists()) {
            new ImportResourceToCatalog("framework-res");
        }
        if (!new File(ThemeHelper.getImportResourceCatalogPath() + File.separator + "framework-miui-res").exists()) {
            new ImportResourceToCatalog("framework-miui-res");
            CatalogManager.importAndMergeFrameworkMIUI();
        }
        toastPanel.hideToast();
        return true;
    }

    private static void importAndMergeFrameworkMIUI() {
        String string = "framework-miui-res";
        String string2 = "origin-framework-miui-res";
        if (ThemeHelper.getRomUIVersion() < 4) {
            String string3 = "/system/framework/framework-miui-res.apk";
            CatalogManager.doMergePackage(string, string2, string3);
            return;
        }
        if (ThemeHelper.getAndroidSDKVersion() == 21) {
            String string4 = "/system/app/miui/miui.apk";
            CatalogManager.doMergePackage(string, string2, string4);
            string4 = "/system/app/MiuiFramework/MiuiFramework.apk";
            CatalogManager.doMergePackage(string, string2, string4);
            string4 = "/system/framework/framework-ext-res/framework-ext-res.apk";
            CatalogManager.doMergePackage(string, string2, string4);
        } else {
            String string5 = "/system/app/miui.apk";
            CatalogManager.doMergePackage(string, string2, string5);
            string5 = "/system/app/MiuiFramework.apk";
            CatalogManager.doMergePackage(string, string2, string5);
            string5 = "/system/framework/framework-ext-res.apk";
            CatalogManager.doMergePackage(string, string2, string5);
        }
    }

    private static void doMergePackage(String string, String string2, String string3) {
        String string4 = ThemeHelper.getImportResourceCatalogPath();
        new ImportResourceToCatalog(string2, string3);
        String string5 = string4 + File.separator + string2;
        CatalogManager.mergeFiles(string5, string2, string);
        File file = new File(string4 + File.separator + string2 + File.separator + "theme_values.xml");
        Vector<Vector<String>> vector = MIUIThemeValues.getThemeValuesFromFile(file);
        File file2 = new File(string4 + File.separator + string + File.separator + "theme_values.xml");
        Vector<Vector<String>> vector2 = MIUIThemeValues.getThemeValuesFromFile(file2);
        for (Vector<String> vector3 : vector) {
            vector2.add(vector3);
        }
        MIUIThemeValues.saveThemeValuesFromToFile(file2, vector2);
        CmdUtils.deleteDir(string5);
    }

    private static void mergeFiles(String string, String string2, String string3) {
        File file = new File(string);
        File[] fileArray = file.listFiles();
        if (fileArray == null || fileArray.length <= 0) {
            return;
        }
        for (File file2 : fileArray) {
            if (file2.isDirectory()) {
                CatalogManager.mergeFiles(file2.getAbsolutePath(), string2, string3);
                continue;
            }
            if (!file2.getAbsolutePath().endsWith(".png")) continue;
            try {
                ThemeHelper.copyFile(file2, new File(file2.getAbsolutePath().replace(string2, string3)));
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean refreshAppList() {
        boolean bl = false;
        NewMainFrame newMainFrame = NewMainFrame.getInstance();
        CmdUtils.adb_uninstall("com.miui.themetool");
        bl = CmdUtils.adb_install(CmdUtils.IMPORT_APPS_APK_FILE);
        try {
            Thread.sleep(300L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!bl) {
            GUIUtil.toast(ResourceFactory.getString("Catalog.RefreshAppInstallFailed"));
            ((Component)newMainFrame).setCursor(new Cursor(0));
            return false;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("generate", "appinfo");
        bl = CmdUtils.adb_shell_start("com.miui.themetool/com.miui.themetool.ShowAppsActivity", hashMap);
        if (!bl) {
            GUIUtil.toast(ResourceFactory.getString("Catalog.RefreshAppStartFailed"));
            ((Component)newMainFrame).setCursor(Cursor.getPredefinedCursor(0));
            return false;
        }
        ThemeHelper.waitForCompleteFile("/data/data/com.miui.themetool/app_appinfo/complete");
        APP_LOCAL_FILE.delete();
        try {
            while (!APP_LOCAL_FILE.exists() || new FileInputStream(APP_LOCAL_FILE).available() <= 0) {
                Log.l("apps.txt empty");
                Thread.sleep(2000L);
                bl = CmdUtils.adb_pull(APPINFO_FILE, APP_LOCAL_FILE.getParent());
                if (bl) continue;
                GUIUtil.toast(ResourceFactory.getString("Catalog.RefreshAppPullingFailed"));
                Log.l("adb pull error.");
                ((Component)newMainFrame).setCursor(Cursor.getPredefinedCursor(0));
                boolean bl2 = false;
                return bl2;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        finally {
            ((Component)newMainFrame).setCursor(Cursor.getPredefinedCursor(0));
        }
        return true;
    }

    public static Member getMemberByPackageName(String string) {
        HashMap<String, Member> hashMap = null;
        try {
            hashMap = CatalogManager.getHashMapApps();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return hashMap.get(string);
    }

    public static HashMap<String, Member> getHashMapApps() throws IOException {
        Object object;
        String string;
        HashMap<String, Member> hashMap = new HashMap<String, Member>();
        FileInputStream fileInputStream = new FileInputStream(APP_LOCAL_FILE);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)fileInputStream, "UTF-8"));
        while ((string = bufferedReader.readLine()) != null) {
            if (string.trim().equals("") || (object = string.split("#")) == null || ((String[])object).length < 3) continue;
            String string2 = object[0];
            String string3 = object[1];
            String string4 = null;
            String[] stringArray = object[2].split("/");
            String string5 = stringArray[0];
            if (stringArray.length > 1) {
                string4 = stringArray[1];
            }
            if (string5.equals("android")) {
                string5 = "framework-res";
            }
            if (string5.equals("miui")) {
                string2 = ResourceFactory.getString("framework-miui-res");
                string5 = "framework-miui-res";
            }
            if (string5.equals("com.miui.sdk")) {
                string5 = "framework-miui-res";
            }
            if (PACKAGE_TO_NAME.containsKey(string5)) {
                string2 = PACKAGE_TO_NAME.get(string5);
            }
            if (!string3.startsWith("/system")) continue;
            Member member = new Member(string3, string5, string4, string2);
            hashMap.put(string5, member);
        }
        object = ThemeHelper.getAndroidSDKVersion() == 3 ? new Member("/system/priv-app/MiuiKeyguard/MiuiKeyguard.apk", "com.android.keyguard", null, "Keyguard") : new Member("/system/priv-app/MiuiKeyguard.apk", "com.android.keyguard", null, "Keyguard");
        hashMap.put(object.mPackageName, (Member)object);
        bufferedReader.close();
        fileInputStream.close();
        return hashMap;
    }

    static {
        PACKAGE_TO_NAME.put("com.miui.home", ResourceFactory.getString("com.miui.home"));
        PACKAGE_TO_NAME.put("com.android.systemui", ResourceFactory.getString("com.android.systemui"));
    }
}

