/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.util;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import org.xmlpull.v1.XmlSerializer;

public class FastXmlSerializer
implements XmlSerializer {
    private static final String[] ESCAPE_TABLE = new String[]{null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, "&quot;", null, null, null, "&amp;", null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, "&lt;", null, "&gt;", null};
    private static final int BUFFER_LEN = 8192;
    private final char[] mText = new char[8192];
    private int mPos;
    private Writer mWriter;
    private OutputStream mOutputStream;
    private CharsetEncoder mCharset;
    private ByteBuffer mBytes = ByteBuffer.allocate(8192);
    private boolean mInTag;

    private void append(char c) throws IOException {
        int n = this.mPos;
        if (n >= 8191) {
            this.flush();
            n = this.mPos;
        }
        this.mText[n] = c;
        this.mPos = n + 1;
    }

    private void append(String string, int n, int n2) throws IOException {
        if (n2 > 8192) {
            int n3 = n + n2;
            while (n < n3) {
                int n4 = n + 8192;
                this.append(string, n, n4 < n3 ? 8192 : n3 - n);
                n = n4;
            }
            return;
        }
        int n5 = this.mPos;
        if (n5 + n2 > 8192) {
            this.flush();
            n5 = this.mPos;
        }
        string.getChars(n, n + n2, this.mText, n5);
        this.mPos = n5 + n2;
    }

    private void append(char[] cArray, int n, int n2) throws IOException {
        if (n2 > 8192) {
            int n3 = n + n2;
            while (n < n3) {
                int n4 = n + 8192;
                this.append(cArray, n, n4 < n3 ? 8192 : n3 - n);
                n = n4;
            }
            return;
        }
        int n5 = this.mPos;
        if (n5 + n2 > 8192) {
            this.flush();
            n5 = this.mPos;
        }
        System.arraycopy(cArray, n, this.mText, n5, n2);
        this.mPos = n5 + n2;
    }

    private void append(String string) throws IOException {
        this.append(string, 0, string.length());
    }

    private void escapeAndAppendString(String string) throws IOException {
        int n;
        int n2 = string.length();
        char c = (char)ESCAPE_TABLE.length;
        String[] stringArray = ESCAPE_TABLE;
        int n3 = 0;
        for (n = 0; n < n2; ++n) {
            String string2;
            char c2 = string.charAt(n);
            if (c2 >= c || (string2 = stringArray[c2]) == null) continue;
            if (n3 < n) {
                this.append(string, n3, n - n3);
            }
            n3 = n + 1;
            this.append(string2);
        }
        if (n3 < n) {
            this.append(string, n3, n - n3);
        }
    }

    private void escapeAndAppendString(char[] cArray, int n, int n2) throws IOException {
        int n3;
        char c = (char)ESCAPE_TABLE.length;
        String[] stringArray = ESCAPE_TABLE;
        int n4 = n + n2;
        int n5 = n;
        for (n3 = n; n3 < n4; ++n3) {
            String string;
            char c2 = cArray[n3];
            if (c2 >= c || (string = stringArray[c2]) == null) continue;
            if (n5 < n3) {
                this.append(cArray, n5, n3 - n5);
            }
            n5 = n3 + 1;
            this.append(string);
        }
        if (n5 < n3) {
            this.append(cArray, n5, n3 - n5);
        }
    }

    @Override
    public XmlSerializer attribute(String string, String string2, String string3) throws IOException, IllegalArgumentException, IllegalStateException {
        this.append(' ');
        if (string != null) {
            this.append(string);
            this.append(':');
        }
        this.append(string2);
        this.append("=\"");
        this.escapeAndAppendString(string3);
        this.append('\"');
        return this;
    }

    @Override
    public void cdsect(String string) throws IOException, IllegalArgumentException, IllegalStateException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void comment(String string) throws IOException, IllegalArgumentException, IllegalStateException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void docdecl(String string) throws IOException, IllegalArgumentException, IllegalStateException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void endDocument() throws IOException, IllegalArgumentException, IllegalStateException {
        this.flush();
    }

    @Override
    public XmlSerializer endTag(String string, String string2) throws IOException, IllegalArgumentException, IllegalStateException {
        if (this.mInTag) {
            this.append(" />\n");
        } else {
            this.append("</");
            if (string != null) {
                this.append(string);
                this.append(':');
            }
            this.append(string2);
            this.append(">\n");
        }
        this.mInTag = false;
        return this;
    }

    @Override
    public void entityRef(String string) throws IOException, IllegalArgumentException, IllegalStateException {
        throw new UnsupportedOperationException();
    }

    private void flushBytes() throws IOException {
        int n = this.mBytes.position();
        if (n > 0) {
            this.mBytes.flip();
            this.mOutputStream.write(this.mBytes.array(), 0, n);
            this.mBytes.clear();
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.mPos > 0) {
            if (this.mOutputStream != null) {
                CharBuffer charBuffer = CharBuffer.wrap(this.mText, 0, this.mPos);
                CoderResult coderResult = this.mCharset.encode(charBuffer, this.mBytes, true);
                while (true) {
                    if (coderResult.isError()) {
                        throw new IOException(coderResult.toString());
                    }
                    if (!coderResult.isOverflow()) break;
                    this.flushBytes();
                    coderResult = this.mCharset.encode(charBuffer, this.mBytes, true);
                }
                this.flushBytes();
                this.mOutputStream.flush();
            } else {
                this.mWriter.write(this.mText, 0, this.mPos);
                this.mWriter.flush();
            }
            this.mPos = 0;
        }
    }

    @Override
    public int getDepth() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean getFeature(String string) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getName() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getNamespace() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getPrefix(String string, boolean bl) throws IllegalArgumentException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object getProperty(String string) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void ignorableWhitespace(String string) throws IOException, IllegalArgumentException, IllegalStateException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void processingInstruction(String string) throws IOException, IllegalArgumentException, IllegalStateException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setFeature(String string, boolean bl) throws IllegalArgumentException, IllegalStateException {
        if (string.equals("http://xmlpull.org/v1/doc/features.html#indent-output")) {
            return;
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public void setOutput(OutputStream outputStream, String string) throws IOException, IllegalArgumentException, IllegalStateException {
        if (outputStream == null) {
            throw new IllegalArgumentException();
        }
        try {
            this.mCharset = Charset.forName(string).newEncoder();
        }
        catch (IllegalCharsetNameException illegalCharsetNameException) {
            throw (UnsupportedEncodingException)new UnsupportedEncodingException(string).initCause(illegalCharsetNameException);
        }
        catch (UnsupportedCharsetException unsupportedCharsetException) {
            throw (UnsupportedEncodingException)new UnsupportedEncodingException(string).initCause(unsupportedCharsetException);
        }
        this.mOutputStream = outputStream;
    }

    @Override
    public void setOutput(Writer writer) throws IOException, IllegalArgumentException, IllegalStateException {
        this.mWriter = writer;
    }

    @Override
    public void setPrefix(String string, String string2) throws IOException, IllegalArgumentException, IllegalStateException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setProperty(String string, Object object) throws IllegalArgumentException, IllegalStateException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void startDocument(String string, Boolean bl) throws IOException, IllegalArgumentException, IllegalStateException {
        this.append("<?xml version='1.0' encoding='utf-8' standalone='" + (bl != false ? "yes" : "no") + "' ?>\n");
    }

    @Override
    public XmlSerializer startTag(String string, String string2) throws IOException, IllegalArgumentException, IllegalStateException {
        if (this.mInTag) {
            this.append(">\n");
        }
        this.append('<');
        if (string != null) {
            this.append(string);
            this.append(':');
        }
        this.append(string2);
        this.mInTag = true;
        return this;
    }

    @Override
    public XmlSerializer text(char[] cArray, int n, int n2) throws IOException, IllegalArgumentException, IllegalStateException {
        if (this.mInTag) {
            this.append(">");
            this.mInTag = false;
        }
        this.escapeAndAppendString(cArray, n, n2);
        return this;
    }

    @Override
    public XmlSerializer text(String string) throws IOException, IllegalArgumentException, IllegalStateException {
        if (this.mInTag) {
            this.append(">");
            this.mInTag = false;
        }
        this.escapeAndAppendString(string);
        return this;
    }
}

