/*
 * Decompiled with CFR 0.152.
 */
package chrriis.dj.nativeswing.swtimpl.core;

import chrriis.common.Utils;
import chrriis.dj.nativeswing.swtimpl.core.ControlCommandMessage;
import chrriis.dj.nativeswing.swtimpl.core.SWTNativeComponent;
import chrriis.dj.nativeswing.swtimpl.internal.IOleNativeComponent;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.eclipse.swt.ole.win32.OLE;
import org.eclipse.swt.ole.win32.OleAutomation;
import org.eclipse.swt.ole.win32.OleClientSite;
import org.eclipse.swt.ole.win32.OleFrame;
import org.eclipse.swt.ole.win32.OleFunctionDescription;
import org.eclipse.swt.ole.win32.OleParameterDescription;
import org.eclipse.swt.ole.win32.Variant;

public abstract class SWTOleNativeComponent
extends SWTNativeComponent
implements IOleNativeComponent {
    protected static void configureOleFrame(OleClientSite oleClientSite, OleFrame oleFrame) {
        oleFrame.setData("NS_site", (Object)oleClientSite);
    }

    protected static OleClientSite getSite(OleFrame oleFrame) {
        OleClientSite oleClientSite = (OleClientSite)oleFrame.getData("NS_site");
        if (oleClientSite == null) {
            throw new IllegalStateException("The OleNativeComponent is not properly initialized! You need to call configureOleFrame() after the site creation.");
        }
        return oleClientSite;
    }

    @Override
    public void invokeOleFunction(String string, Object ... objectArray) {
        this.invokeOleFunction(new String[]{string}, objectArray);
    }

    @Override
    public void invokeOleFunction(String[] stringArray, Object ... objectArray) {
        this.runAsync(new CMN_invokeOleFunction(), false, stringArray, objectArray);
    }

    @Override
    public Object invokeOleFunctionWithResult(String string, Object ... objectArray) {
        return this.invokeOleFunctionWithResult(new String[]{string}, objectArray);
    }

    @Override
    public Object invokeOleFunctionWithResult(String[] stringArray, Object ... objectArray) {
        return this.runSync(new CMN_invokeOleFunction(), true, stringArray, objectArray);
    }

    @Override
    public void setOleProperty(String string, Object ... objectArray) {
        this.setOleProperty(new String[]{string}, objectArray);
    }

    @Override
    public void setOleProperty(String[] stringArray, Object ... objectArray) {
        this.runAsync(new CMN_setOleProperty(), stringArray, objectArray);
    }

    @Override
    public Object getOleProperty(String string, Object ... objectArray) {
        return this.getOleProperty(new String[]{string}, objectArray);
    }

    @Override
    public Object getOleProperty(String[] stringArray, Object ... objectArray) {
        return this.runSync(new CMN_getOleProperty(), stringArray, objectArray);
    }

    protected static Variant createVariant(Object object) {
        if (object instanceof Boolean) {
            return new Variant(((Boolean)object).booleanValue());
        }
        if (object instanceof Short) {
            return new Variant(((Short)object).shortValue());
        }
        if (object instanceof Integer) {
            return new Variant(((Integer)object).intValue());
        }
        if (object instanceof Long) {
            return new Variant(((Long)object).longValue());
        }
        if (object instanceof Float) {
            return new Variant(((Float)object).floatValue());
        }
        if (object instanceof Double) {
            return new Variant(((Double)object).doubleValue());
        }
        if (object instanceof String || object == null) {
            return new Variant((String)object);
        }
        throw new IllegalArgumentException("The value could not be converted to a Variant: " + object);
    }

    protected static Object getVariantValue(Variant variant) {
        if (variant == null) {
            return null;
        }
        switch (variant.getType()) {
            case 11: {
                return variant.getBoolean();
            }
            case 2: {
                return variant.getShort();
            }
            case 3: {
                return variant.getInt();
            }
            case 20: {
                return variant.getLong();
            }
            case 4: {
                return Float.valueOf(variant.getFloat());
            }
            case 5: {
                return variant.getDouble();
            }
            case 8: {
                return variant.getString();
            }
        }
        throw new IllegalArgumentException("The value could not be converted from a Variant: " + variant);
    }

    private static void dispose(Variant variant) {
        if (variant == null) {
            return;
        }
        variant.dispose();
    }

    @Override
    public void dumpOleInterfaceDefinitions() {
        this.runSync(new CMN_dumpOleInterfaceDefinitions(), new Object[0]);
    }

    private static class CMN_dumpOleInterfaceDefinitions
    extends ControlCommandMessage {
        private Map<Short, String> oleTypeToDescriptionMap;

        private CMN_dumpOleInterfaceDefinitions() {
        }

        private void dumpOleInterfaceDefinitions(StringBuilder stringBuilder, OleAutomation oleAutomation, int n) {
            String string;
            OleParameterDescription oleParameterDescription;
            OleFunctionDescription oleFunctionDescription2;
            ArrayList<OleFunctionDescription> arrayList = new ArrayList<OleFunctionDescription>();
            int n2 = 0;
            while ((oleFunctionDescription2 = oleAutomation.getFunctionDescription(n2)) != null) {
                arrayList.add(oleFunctionDescription2);
                ++n2;
            }
            Collections.sort(arrayList, new Comparator<OleFunctionDescription>(){

                @Override
                public int compare(OleFunctionDescription oleFunctionDescription, OleFunctionDescription oleFunctionDescription2) {
                    return oleFunctionDescription.name.toLowerCase(Locale.ENGLISH).compareTo(oleFunctionDescription2.name.toLowerCase(Locale.ENGLISH));
                }
            });
            for (OleFunctionDescription oleFunctionDescription2 : arrayList) {
                int n3;
                for (n3 = 0; n3 < n; ++n3) {
                    stringBuilder.append("  ");
                }
                stringBuilder.append(oleFunctionDescription2.name).append("(");
                for (n3 = 0; n3 < oleFunctionDescription2.args.length; ++n3) {
                    oleParameterDescription = oleFunctionDescription2.args[n3];
                    if (n3 > 0) {
                        stringBuilder.append(", ");
                    }
                    stringBuilder.append(this.getTypeDescription(oleParameterDescription.type)).append(' ').append(oleParameterDescription.name == null ? "arg" + n3 : oleParameterDescription.name);
                }
                stringBuilder.append("): ").append(this.getTypeDescription(oleFunctionDescription2.returnType)).append(Utils.LINE_SEPARATOR);
            }
            ArrayList arrayList2 = new ArrayList();
            int n4 = 1;
            while ((string = oleAutomation.getName(n4)) != null) {
                arrayList2.add(string);
                ++n4;
            }
            Collections.sort(arrayList2, new Comparator<String>(){

                @Override
                public int compare(String string, String string2) {
                    return string.toLowerCase(Locale.ENGLISH).compareTo(string2.toLowerCase(Locale.ENGLISH));
                }
            });
            Iterator iterator = arrayList2.iterator();
            while (iterator.hasNext()) {
                string = (String)iterator.next();
                for (int i = 0; i < n; ++i) {
                    stringBuilder.append("  ");
                }
                stringBuilder.append(string).append(Utils.LINE_SEPARATOR);
                oleParameterDescription = oleAutomation.getProperty(oleAutomation.getIDsOfNames(new String[]{string})[0]);
                if (oleParameterDescription != null && oleParameterDescription.getType() == 9) {
                    OleAutomation oleAutomation2 = oleParameterDescription.getAutomation();
                    this.dumpOleInterfaceDefinitions(stringBuilder, oleAutomation2, n + 1);
                    oleAutomation2.dispose();
                }
                SWTOleNativeComponent.dispose((Variant)oleParameterDescription);
            }
        }

        private String getTypeDescription(short s) {
            String string = this.oleTypeToDescriptionMap.get(s);
            if (string == null) {
                string = '[' + String.valueOf(s) + ']';
            }
            return string;
        }

        @Override
        public Object run(Object[] objectArray) {
            this.oleTypeToDescriptionMap = new HashMap<Short, String>();
            for (Field field : OLE.class.getDeclaredFields()) {
                String string = field.getName();
                Short s = null;
                if (string.startsWith("VT_")) {
                    try {
                        s = (Short)field.get(null);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (s == null) continue;
                String string2 = string.substring("VT_".length()).toLowerCase(Locale.ENGLISH);
                this.oleTypeToDescriptionMap.put(s, string2);
            }
            OleAutomation oleAutomation = new OleAutomation(SWTOleNativeComponent.getSite((OleFrame)this.getControl()));
            StringBuilder stringBuilder = new StringBuilder();
            this.dumpOleInterfaceDefinitions(stringBuilder, oleAutomation, 0);
            oleAutomation.dispose();
            System.out.print(stringBuilder.toString());
            return null;
        }
    }

    private static class CMN_getOleProperty
    extends ControlCommandMessage {
        private CMN_getOleProperty() {
        }

        @Override
        public Object run(Object[] objectArray) {
            String[] stringArray = (String[])objectArray[0];
            Variant[] variantArray = new OleAutomation(SWTOleNativeComponent.getSite((OleFrame)this.getControl()));
            for (int i = 0; i < stringArray.length; ++i) {
                Variant[] variantArray2;
                Variant variant;
                int[] nArray = variantArray.getIDsOfNames(new String[]{stringArray[i]});
                if (nArray == null) {
                    variantArray.dispose();
                    return null;
                }
                if (i == stringArray.length - 1) {
                    variant = (Variant)objectArray[1];
                    variantArray2 = new Variant[((Variant)variant).length];
                    for (int j = 0; j < ((Variant)variant).length; ++j) {
                        variantArray2[j] = SWTOleNativeComponent.createVariant(variant[j]);
                    }
                    Variant variant2 = variantArray.getProperty(nArray[0], variantArray2);
                    for (Variant variant3 : variantArray2) {
                        SWTOleNativeComponent.dispose(variant3);
                    }
                    Object object = SWTOleNativeComponent.getVariantValue(variant2);
                    SWTOleNativeComponent.dispose(variant2);
                    variantArray.dispose();
                    return object;
                }
                variant = variantArray.getProperty(nArray[0]);
                variantArray2 = variant.getAutomation();
                variant.dispose();
                variantArray.dispose();
                variantArray = variantArray2;
            }
            variantArray.dispose();
            return null;
        }
    }

    private static class CMN_setOleProperty
    extends ControlCommandMessage {
        private CMN_setOleProperty() {
        }

        @Override
        public Object run(Object[] objectArray) {
            String[] stringArray = (String[])objectArray[0];
            Variant[] variantArray = new OleAutomation(SWTOleNativeComponent.getSite((OleFrame)this.getControl()));
            for (int i = 0; i < stringArray.length; ++i) {
                Variant[] variantArray2;
                Variant variant;
                int[] nArray = variantArray.getIDsOfNames(new String[]{stringArray[i]});
                if (nArray == null) {
                    variantArray.dispose();
                    return false;
                }
                if (i == stringArray.length - 1) {
                    boolean bl;
                    variant = (Variant)objectArray[1];
                    variantArray2 = new Variant[((Variant)variant).length];
                    for (bl = false; bl < ((Variant)variant).length; bl += 1) {
                        variantArray2[bl] = SWTOleNativeComponent.createVariant(variant[bl]);
                    }
                    bl = variantArray.setProperty(nArray[0], variantArray2);
                    for (Variant variant2 : variantArray2) {
                        SWTOleNativeComponent.dispose(variant2);
                    }
                    variantArray.dispose();
                    return bl;
                }
                variant = variantArray.getProperty(nArray[0]);
                variantArray2 = variant.getAutomation();
                variant.dispose();
                variantArray.dispose();
                variantArray = variantArray2;
            }
            variantArray.dispose();
            return false;
        }
    }

    private static class CMN_invokeOleFunction
    extends ControlCommandMessage {
        private CMN_invokeOleFunction() {
        }

        @Override
        public Object run(Object[] objectArray) {
            String[] stringArray = (String[])objectArray[1];
            Variant[] variantArray = new OleAutomation(SWTOleNativeComponent.getSite((OleFrame)this.getControl()));
            for (int i = 0; i < stringArray.length; ++i) {
                Variant[] variantArray2;
                Variant variant;
                int[] nArray = variantArray.getIDsOfNames(new String[]{stringArray[i]});
                if (nArray == null) {
                    variantArray.dispose();
                    return null;
                }
                if (i == stringArray.length - 1) {
                    Object object;
                    variant = (Variant)objectArray[2];
                    variantArray2 = new Variant[((Variant)variant).length];
                    for (int j = 0; j < ((Variant)variant).length; ++j) {
                        variantArray2[j] = SWTOleNativeComponent.createVariant(variant[j]);
                    }
                    if (((Boolean)objectArray[0]).booleanValue()) {
                        Variant[] variantArray3 = variantArray.invoke(nArray[0], variantArray2);
                        object = SWTOleNativeComponent.getVariantValue((Variant)variantArray3);
                        SWTOleNativeComponent.dispose((Variant)variantArray3);
                    } else {
                        object = null;
                        variantArray.invokeNoReply(nArray[0], variantArray2);
                    }
                    for (Variant variant2 : variantArray2) {
                        SWTOleNativeComponent.dispose(variant2);
                    }
                    variantArray.dispose();
                    return object;
                }
                variant = variantArray.getProperty(nArray[0]);
                variantArray2 = variant.getAutomation();
                variant.dispose();
                variantArray.dispose();
                variantArray = variantArray2;
            }
            variantArray.dispose();
            return null;
        }
    }
}

