/*
 * Decompiled with CFR 0.152.
 */
package chrriis.dj.nativeswing.swtimpl.components.core;

import chrriis.common.Utils;
import chrriis.dj.nativeswing.NSOption;
import chrriis.dj.nativeswing.swtimpl.CommandMessage;
import chrriis.dj.nativeswing.swtimpl.NSSystemPropertySWT;
import chrriis.dj.nativeswing.swtimpl.components.Credentials;
import chrriis.dj.nativeswing.swtimpl.components.JWebBrowser;
import chrriis.dj.nativeswing.swtimpl.components.JWebBrowserWindow;
import chrriis.dj.nativeswing.swtimpl.components.WebBrowserAuthenticationHandler;
import chrriis.dj.nativeswing.swtimpl.components.WebBrowserCommandEvent;
import chrriis.dj.nativeswing.swtimpl.components.WebBrowserEvent;
import chrriis.dj.nativeswing.swtimpl.components.WebBrowserFunction;
import chrriis.dj.nativeswing.swtimpl.components.WebBrowserListener;
import chrriis.dj.nativeswing.swtimpl.components.WebBrowserNavigationEvent;
import chrriis.dj.nativeswing.swtimpl.components.WebBrowserNavigationParameters;
import chrriis.dj.nativeswing.swtimpl.components.WebBrowserWindowFactory;
import chrriis.dj.nativeswing.swtimpl.components.WebBrowserWindowOpeningEvent;
import chrriis.dj.nativeswing.swtimpl.components.WebBrowserWindowWillOpenEvent;
import chrriis.dj.nativeswing.swtimpl.components.core.NativeJSBrowserDetection;
import chrriis.dj.nativeswing.swtimpl.components.internal.INativeWebBrowser;
import chrriis.dj.nativeswing.swtimpl.core.ControlCommandMessage;
import chrriis.dj.nativeswing.swtimpl.core.SWTNativeComponent;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Window;
import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import javax.swing.SwingUtilities;
import org.eclipse.swt.browser.AuthenticationEvent;
import org.eclipse.swt.browser.AuthenticationListener;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.BrowserFunction;
import org.eclipse.swt.browser.CloseWindowListener;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.browser.OpenWindowListener;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.browser.StatusTextEvent;
import org.eclipse.swt.browser.StatusTextListener;
import org.eclipse.swt.browser.TitleEvent;
import org.eclipse.swt.browser.TitleListener;
import org.eclipse.swt.browser.VisibilityWindowAdapter;
import org.eclipse.swt.browser.VisibilityWindowListener;
import org.eclipse.swt.browser.WindowEvent;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.ole.win32.OleAutomation;
import org.eclipse.swt.ole.win32.Variant;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;

class NativeWebBrowser
extends SWTNativeComponent
implements INativeWebBrowser {
    private INativeWebBrowser.WebBrowserRuntime runtime;
    private String xulRunnerHome;
    private Reference<JWebBrowser> webBrowser;
    private static Pattern JAVASCRIPT_LINE_COMMENT_PATTERN = Pattern.compile("^\\s*//.*$", 8);
    private static volatile Boolean isFixedJS;
    private String status;
    private String title;
    private int loadingProgress = 100;
    private Map<String, WebBrowserFunction> nameToFunctionMap;
    private WebBrowserAuthenticationHandler authenticationHandler;
    private Component embeddableComponent;

    @Override
    public INativeWebBrowser.WebBrowserRuntime getRuntime() {
        return this.runtime;
    }

    @Override
    protected Object[] getNativePeerCreationParameters() {
        return new Object[]{this.runtime, this.xulRunnerHome};
    }

    protected static Control createControl(Composite composite, Object[] objectArray) {
        String string = (String)objectArray[1];
        if (string != null) {
            NSSystemPropertySWT.ORG_ECLIPSE_SWT_BROWSER_XULRUNNERPATH.set(string);
        } else {
            string = NSSystemPropertySWT.ORG_ECLIPSE_SWT_BROWSER_XULRUNNERPATH.get();
            if (string == null && (string = System.getenv("XULRUNNER_HOME")) != null) {
                NSSystemPropertySWT.ORG_ECLIPSE_SWT_BROWSER_XULRUNNERPATH.set(string);
            }
        }
        int n = 0;
        INativeWebBrowser.WebBrowserRuntime webBrowserRuntime = (INativeWebBrowser.WebBrowserRuntime)((Object)objectArray[0]);
        switch (webBrowserRuntime) {
            case XULRUNNER: {
                n |= 0x8000;
                break;
            }
            case WEBKIT: {
                n |= 0x10000;
            }
        }
        final Browser browser = new Browser(composite, n);
        NativeWebBrowser.configureBrowserFunction(browser);
        browser.addCloseWindowListener(new CloseWindowListener(){

            public void close(WindowEvent windowEvent) {
                new CMJ_closeWindow().asyncExec((Control)browser, new Object[0]);
            }
        });
        browser.addOpenWindowListener(new OpenWindowListener(){

            public void open(WindowEvent windowEvent) {
                Browser browser2;
                boolean bl;
                windowEvent.required = true;
                final Integer n = (Integer)new CMJ_createWindow().syncExec((Control)browser, new Object[0]);
                if (n == null) {
                    bl = true;
                    Shell shell = new Shell();
                    browser2 = new Browser((Composite)shell, browser.getStyle());
                    NativeWebBrowser.configureBrowserFunction(browser2);
                } else {
                    bl = false;
                    browser2 = (Browser)NativeWebBrowser.getControlRegistry().get(n);
                }
                windowEvent.browser = browser2;
                browser2.addVisibilityWindowListener((VisibilityWindowListener)new VisibilityWindowAdapter(){

                    public void show(WindowEvent windowEvent) {
                        Browser browser = (Browser)windowEvent.widget;
                        if (bl) {
                            final Shell shell = browser.getShell();
                            windowEvent.display.asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    shell.close();
                                }
                            });
                        } else {
                            browser.removeVisibilityWindowListener((VisibilityWindowListener)this);
                            Point point = windowEvent.location == null ? null : new Point(windowEvent.location.x, windowEvent.location.y);
                            Dimension dimension = windowEvent.size == null || windowEvent.size.x == 1 && windowEvent.size.y == 1 ? null : new Dimension(windowEvent.size.x, windowEvent.size.y);
                            new CMJ_showWindow().asyncExec((Control)browser2, n, windowEvent.menuBar, windowEvent.toolBar, windowEvent.addressBar, windowEvent.statusBar, point, dimension);
                        }
                    }
                });
            }
        });
        browser.addLocationListener(new LocationListener(){

            public void changed(LocationEvent locationEvent) {
                browser.setData("Browser.loading", (Object)false);
                new CMJ_locationChanged().asyncExec((Control)browser, locationEvent.location, locationEvent.top);
            }

            public void changing(LocationEvent locationEvent) {
                String string = locationEvent.location;
                if (string.startsWith("command://")) {
                    String string2;
                    locationEvent.doit = false;
                    String string3 = string.substring("command://".length());
                    if (string3.endsWith("/")) {
                        string3 = string3.substring(0, string3.length() - 1);
                    }
                    ArrayList<String> arrayList = new ArrayList<String>();
                    StringTokenizer stringTokenizer = new StringTokenizer(string3, "&", true);
                    String string4 = null;
                    while (stringTokenizer.hasMoreTokens()) {
                        string2 = stringTokenizer.nextToken();
                        if ("&".equals(string2)) {
                            if (string4 == null) {
                                arrayList.add("");
                            }
                            string4 = null;
                            continue;
                        }
                        string4 = string2;
                        arrayList.add(Utils.decodeURL(string2));
                    }
                    if (string4 == null) {
                        arrayList.add("");
                    }
                    string2 = arrayList.isEmpty() ? "" : (String)arrayList.remove(0);
                    String[] stringArray = arrayList.toArray(new String[0]);
                    new CMJ_commandReceived().asyncExec((Control)browser, string2, stringArray);
                    return;
                }
                if (string.startsWith("javascript:")) {
                    return;
                }
                browser.setData("CMJ_updateStatus.status", null);
                browser.setData("CMJ_updateProgress.progress", null);
                browser.setData("Browser.loading", (Object)true);
                locationEvent.doit = Boolean.TRUE.equals(new CMJ_locationChanging().syncExec((Control)browser, string, locationEvent.top));
                if (!locationEvent.doit) {
                    browser.setData("Browser.loading", (Object)false);
                    new CMJ_locationChangeCanceled().asyncExec((Control)browser, string, locationEvent.top);
                }
            }
        });
        browser.addTitleListener(new TitleListener(){

            public void changed(TitleEvent titleEvent) {
                new CMJ_updateTitle().asyncExec((Control)browser, titleEvent.title);
            }
        });
        browser.addStatusTextListener(new StatusTextListener(){

            public void changed(StatusTextEvent statusTextEvent) {
                final String string = (String)browser.getData("CMJ_updateStatus.status");
                final String string2 = statusTextEvent.text;
                if (string2.startsWith("scommand://")) {
                    String string3;
                    statusTextEvent.display.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            browser.execute(NativeWebBrowser.fixJavascript(browser, "if(decodeURIComponent('" + Utils.encodeURL(string2) + "') == window.status) {window.status = decodeURIComponent('" + Utils.encodeURL(string == null ? "" : string) + "');}"));
                        }
                    });
                    String string4 = string2.substring("scommand://".length());
                    if (string4.endsWith("/")) {
                        string4 = string4.substring(0, string4.length() - 1);
                    }
                    ArrayList<String> arrayList = new ArrayList<String>();
                    StringTokenizer stringTokenizer = new StringTokenizer(string4, "&", true);
                    String string5 = null;
                    while (stringTokenizer.hasMoreTokens()) {
                        string3 = stringTokenizer.nextToken();
                        if ("&".equals(string3)) {
                            if (string5 == null) {
                                arrayList.add("");
                            }
                            string5 = null;
                            continue;
                        }
                        string5 = string3;
                        arrayList.add(Utils.decodeURL(string3));
                    }
                    if (string5 == null) {
                        arrayList.add("");
                    }
                    string3 = arrayList.isEmpty() ? "" : (String)arrayList.remove(0);
                    String[] stringArray = arrayList.toArray(new String[0]);
                    new CMJ_commandReceived().asyncExec((Control)browser, string3, stringArray);
                    return;
                }
                if (!Utils.equals(string, string2)) {
                    browser.setData("CMJ_updateStatus.status", (Object)string2);
                    new CMJ_updateStatus().asyncExec((Control)browser, string2);
                }
            }
        });
        browser.addProgressListener(new ProgressListener(){

            private void updateProgress(int n) {
                Integer n2 = (Integer)browser.getData("CMJ_updateProgress.progress");
                if (!Utils.equals(n2, n)) {
                    browser.setData("CMJ_updateProgress.progress", (Object)n);
                    new CMJ_updateLoadingProgress().asyncExec((Control)browser, n);
                }
            }

            public void changed(ProgressEvent progressEvent) {
                if (progressEvent.total <= 0 || progressEvent.total < progressEvent.current) {
                    return;
                }
                browser.setData("Browser.loading", (Object)true);
                this.updateProgress(progressEvent.current == progressEvent.total ? 100 : Math.min(progressEvent.current * 100 / progressEvent.total, 99));
            }

            public void completed(ProgressEvent progressEvent) {
                browser.setData("Browser.loading", (Object)false);
                this.updateProgress(100);
            }
        });
        NativeWebBrowser.registerDefaultPopupMenu(browser);
        return browser;
    }

    private static void configureBrowserFunction(Browser browser) {
        new NSCommandBrowserFunction(browser);
        new NSConsolePrintingBrowserFunction(browser, false);
        new NSConsolePrintingBrowserFunction(browser, true);
    }

    public NativeWebBrowser(JWebBrowser jWebBrowser, INativeWebBrowser.WebBrowserRuntime webBrowserRuntime) {
        this.webBrowser = new WeakReference<JWebBrowser>(jWebBrowser);
        if (webBrowserRuntime == INativeWebBrowser.WebBrowserRuntime.DEFAULT) {
            String string = NSSystemPropertySWT.WEBBROWSER_RUNTIME.get();
            if ("xulrunner".equals(string)) {
                webBrowserRuntime = INativeWebBrowser.WebBrowserRuntime.XULRUNNER;
            } else if ("webkit".equals(string)) {
                webBrowserRuntime = INativeWebBrowser.WebBrowserRuntime.WEBKIT;
            }
        }
        this.runtime = webBrowserRuntime;
        if (webBrowserRuntime == INativeWebBrowser.WebBrowserRuntime.XULRUNNER) {
            this.xulRunnerHome = NSSystemPropertySWT.WEBBROWSER_XULRUNNER_HOME.get();
        }
    }

    public static void clearSessionCookies() {
        new CMN_clearSessionCookies().asyncExec(true, new Object[0]);
    }

    public static String getCookie(String string, String string2) {
        return (String)new CMN_getCookie().syncExec(true, string, string2);
    }

    public static void setCookie(String string, String string2) {
        new CMN_setCookie().asyncExec(true, string, string2);
    }

    @Override
    public String getResourceLocation() {
        return (String)this.runSync(new CMN_getResourceLocation(), new Object[0]);
    }

    @Override
    public boolean navigate(String string, WebBrowserNavigationParameters webBrowserNavigationParameters) {
        return Boolean.TRUE.equals(this.runSync(new CMN_navigate(), string, webBrowserNavigationParameters == null ? null : webBrowserNavigationParameters.getPostData(), webBrowserNavigationParameters == null ? null : webBrowserNavigationParameters.getHeaders()));
    }

    @Override
    public String getHTMLContent() {
        return (String)this.runSync(new CMN_getHTMLContent(), new Object[0]);
    }

    @Override
    public boolean setHTMLContent(String string) {
        return Boolean.TRUE.equals(this.runSync(new CMN_setHTMLContent(), string));
    }

    @Override
    public boolean isJavascriptEnabled() {
        return Boolean.TRUE.equals(this.runSync(new CMN_isJavascriptEnabled(), new Object[0]));
    }

    @Override
    public void setJavascriptEnabled(boolean bl) {
        this.runAsync(new CMN_setJavascriptEnabled(), bl);
    }

    private static String fixJavascript(Browser browser, String string) {
        if ("mozilla".equals(browser.getBrowserType())) {
            if (isFixedJS == null) {
                isFixedJS = "%25".equals(browser.evaluate("return '%25'"));
            }
            if (!isFixedJS.booleanValue()) {
                string = JAVASCRIPT_LINE_COMMENT_PATTERN.matcher(string).replaceAll("");
                string = Utils.encodeURL(string);
            }
        }
        return string;
    }

    @Override
    public boolean executeJavascriptAndWait(String string) {
        return Boolean.TRUE.equals(this.runSync(new CMN_executeJavascript(), string));
    }

    @Override
    public void executeJavascript(String string) {
        this.runAsync(new CMN_executeJavascript(), string);
    }

    @Override
    public Object executeJavascriptWithResult(String string) {
        return this.runSync(new CMN_executeJavascriptWithResult(), string);
    }

    @Override
    public void stopLoading() {
        this.runAsync(new CMN_stopLoading(), new Object[0]);
    }

    @Override
    public void reloadPage() {
        this.runAsync(new CMN_reloadPage(), new Object[0]);
    }

    @Override
    public boolean isBackNavigationEnabled() {
        return Boolean.TRUE.equals(this.runSync(new CMN_isBackNavigationEnabled(), new Object[0]));
    }

    @Override
    public void navigateBack() {
        this.runAsync(new CMN_navigateBack(), new Object[0]);
    }

    @Override
    public boolean isForwardNavigationEnabled() {
        return Boolean.TRUE.equals(this.runSync(new CMN_isForwardNavigationEnabled(), new Object[0]));
    }

    @Override
    public void navigateForward() {
        this.runAsync(new CMN_navigateForward(), new Object[0]);
    }

    private static void registerDefaultPopupMenu(final Browser browser) {
        Menu menu = browser.getMenu();
        if (menu != null) {
            menu.dispose();
        }
        if (!"mozilla".equals(browser.getBrowserType())) {
            browser.setMenu(null);
            return;
        }
        Menu menu2 = new Menu((Decorations)browser.getShell(), 8);
        String string = JWebBrowser.class.getName();
        ResourceBundle resourceBundle = ResourceBundle.getBundle(string.substring(0, string.lastIndexOf(46)).replace('.', '/') + "/resource/WebBrowser");
        final MenuItem menuItem = new MenuItem(menu2, 8);
        menuItem.setText(resourceBundle.getString("SystemMenuBack"));
        menuItem.setImage(new Image((Device)browser.getDisplay(), JWebBrowser.class.getResourceAsStream(resourceBundle.getString("SystemMenuBackIcon"))));
        menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                browser.back();
            }
        });
        final MenuItem menuItem2 = new MenuItem(menu2, 8);
        menuItem2.setText(resourceBundle.getString("SystemMenuForward"));
        menuItem2.setImage(new Image((Device)browser.getDisplay(), JWebBrowser.class.getResourceAsStream(resourceBundle.getString("SystemMenuForwardIcon"))));
        menuItem2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                browser.forward();
            }
        });
        MenuItem menuItem3 = new MenuItem(menu2, 8);
        menuItem3.setText(resourceBundle.getString("SystemMenuReload"));
        menuItem3.setImage(new Image((Device)browser.getDisplay(), JWebBrowser.class.getResourceAsStream(resourceBundle.getString("SystemMenuReloadIcon"))));
        menuItem3.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                browser.refresh();
            }
        });
        final MenuItem menuItem4 = new MenuItem(menu2, 8);
        menuItem4.setText(resourceBundle.getString("SystemMenuStop"));
        menuItem4.setImage(new Image((Device)browser.getDisplay(), JWebBrowser.class.getResourceAsStream(resourceBundle.getString("SystemMenuStopIcon"))));
        menuItem4.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                browser.stop();
            }
        });
        menu2.addMenuListener((MenuListener)new MenuAdapter(){

            public void menuShown(MenuEvent menuEvent) {
                menuItem.setEnabled(browser.isBackEnabled());
                menuItem2.setEnabled(browser.isForwardEnabled());
                menuItem4.setEnabled(Boolean.TRUE.equals(browser.getData("Browser.loading")));
            }
        });
        browser.setMenu(menu2);
    }

    @Override
    public void setDefaultPopupMenuRegistered(boolean bl) {
        this.runAsync(new CMN_setDefaultPopupMenuRegistered(), bl);
    }

    @Override
    public String getStatusText() {
        return this.status == null ? "" : this.status;
    }

    @Override
    public String getPageTitle() {
        return this.title == null ? "" : this.title;
    }

    @Override
    public int getLoadingProgress() {
        return this.loadingProgress;
    }

    @Override
    public void registerFunction(WebBrowserFunction webBrowserFunction) {
        String string = webBrowserFunction.getName();
        if (this.nameToFunctionMap == null) {
            this.nameToFunctionMap = new HashMap<String, WebBrowserFunction>();
        } else {
            WebBrowserFunction webBrowserFunction2 = this.nameToFunctionMap.get(string);
            if (webBrowserFunction2 == webBrowserFunction) {
                return;
            }
            if (webBrowserFunction2 != null) {
                this.unregisterFunction(webBrowserFunction2);
            }
        }
        this.nameToFunctionMap.put(string, webBrowserFunction);
        this.runAsync(new CMN_registerFunction(), string);
    }

    @Override
    public void unregisterFunction(WebBrowserFunction webBrowserFunction) {
        if (this.nameToFunctionMap == null) {
            return;
        }
        String string = webBrowserFunction.getName();
        WebBrowserFunction webBrowserFunction2 = this.nameToFunctionMap.get(string);
        if (webBrowserFunction2 != webBrowserFunction) {
            return;
        }
        this.nameToFunctionMap.remove(webBrowserFunction);
        if (this.nameToFunctionMap.isEmpty()) {
            this.nameToFunctionMap = null;
        }
        this.runAsync(new CMN_unregisterFunction(), string);
    }

    @Override
    public void setAuthenticationHandler(WebBrowserAuthenticationHandler webBrowserAuthenticationHandler) {
        if (this.authenticationHandler == webBrowserAuthenticationHandler) {
            return;
        }
        boolean bl = this.authenticationHandler == null;
        boolean bl2 = webBrowserAuthenticationHandler == null;
        this.authenticationHandler = webBrowserAuthenticationHandler;
        if (bl || bl2) {
            this.runAsync(new CMN_setAuthenticationHandler(), bl);
        }
    }

    @Override
    public WebBrowserAuthenticationHandler getAuthenticationHandler() {
        return this.authenticationHandler;
    }

    @Override
    public String getBrowserType() {
        return (String)this.runSync(new CMN_getBrowserType(), new Object[0]);
    }

    @Override
    public String getBrowserVersion() {
        return (String)this.runSync(new CMN_getBrowserVersion(), new Object[0]);
    }

    @Override
    public void addWebBrowserListener(WebBrowserListener webBrowserListener) {
        this.listenerList.add(WebBrowserListener.class, webBrowserListener);
    }

    @Override
    public void removeWebBrowserListener(WebBrowserListener webBrowserListener) {
        this.listenerList.remove(WebBrowserListener.class, webBrowserListener);
    }

    @Override
    public Component createEmbeddableComponent(Map<Object, Object> map) {
        this.embeddableComponent = super.createEmbeddableComponent(map);
        return this.embeddableComponent;
    }

    @Override
    protected void disposeNativePeer() {
        super.disposeNativePeer();
    }

    @Override
    public boolean unloadAndDispose() {
        if (this.isNativePeerInitialized() && Boolean.TRUE.equals(this.runSync(new CMN_unloadAndDispose(), new Object[0]))) {
            return false;
        }
        this.disposeNativePeer();
        return true;
    }

    @Override
    public boolean print(boolean bl) {
        return Boolean.TRUE.equals(this.runSync(new CMN_print(), bl));
    }

    private static class CMN_print
    extends ControlCommandMessage {
        private CMN_print() {
        }

        @Override
        public Object run(Object[] objectArray) {
            boolean bl = (Boolean)objectArray[0];
            Browser browser = (Browser)this.getControl();
            if (Utils.IS_WINDOWS && "ie".equals(browser.getBrowserType())) {
                try {
                    Class<?> clazz = Class.forName("org.eclipse.swt.browser.IE");
                    Field field = Browser.class.getDeclaredField("webBrowser");
                    field.setAccessible(true);
                    Object object = field.get(browser);
                    if (clazz.isInstance(object)) {
                        Field field2 = clazz.getDeclaredField("auto");
                        field2.setAccessible(true);
                        OleAutomation oleAutomation = (OleAutomation)field2.get(object);
                        int[] nArray = oleAutomation.getIDsOfNames(new String[]{"ExecWB", "cmdID", "cmdexecopt"});
                        Variant[] variantArray = new Variant[]{new Variant(6), new Variant(bl ? 1 : 2)};
                        int[] nArray2 = new int[]{nArray[1], nArray[2]};
                        oleAutomation.invoke(nArray[0], variantArray, nArray2);
                        return true;
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (!bl) {
                return false;
            }
            return browser.execute("print();");
        }
    }

    private static class CMN_unloadAndDispose
    extends ControlCommandMessage {
        private CMN_unloadAndDispose() {
        }

        @Override
        public Object run(Object[] objectArray) {
            boolean bl = true;
            Browser browser = (Browser)this.getControl();
            if (browser != null && !browser.isDisposed()) {
                Shell shell = browser.getShell();
                if (browser.close()) {
                    bl = false;
                    if (shell != null) {
                        shell.dispose();
                    }
                }
            }
            return bl;
        }
    }

    private static class CMN_getBrowserVersion
    extends ControlCommandMessage {
        private CMN_getBrowserVersion() {
        }

        @Override
        public Object run(Object[] objectArray) {
            return new NativeJSBrowserDetection((Browser)((Browser)this.getControl())).browserVersion;
        }
    }

    private static class CMN_getBrowserType
    extends ControlCommandMessage {
        private CMN_getBrowserType() {
        }

        @Override
        public Object run(Object[] objectArray) {
            return ((Browser)this.getControl()).getBrowserType();
        }
    }

    private static class CMN_setAuthenticationHandler
    extends ControlCommandMessage {
        private CMN_setAuthenticationHandler() {
        }

        @Override
        public Object run(Object[] objectArray) {
            final Browser browser = (Browser)this.getControl();
            boolean bl = (Boolean)objectArray[0];
            if (bl) {
                AuthenticationListener authenticationListener = new AuthenticationListener(){

                    public void authenticate(AuthenticationEvent authenticationEvent) {
                        Object[] objectArray = (Object[])new CMJ_getCredentials().syncExec((Control)browser, authenticationEvent.location);
                        boolean bl = (Boolean)objectArray[0];
                        if (bl) {
                            authenticationEvent.user = (String)objectArray[1];
                            authenticationEvent.password = (String)objectArray[2];
                        } else {
                            authenticationEvent.doit = false;
                        }
                    }
                };
                browser.setData("Browser.authenticationListener", (Object)authenticationListener);
                browser.addAuthenticationListener(authenticationListener);
            } else {
                browser.removeAuthenticationListener((AuthenticationListener)browser.getData("Browser.authenticationListener"));
                browser.setData("Browser.authenticationListener", null);
            }
            return null;
        }
    }

    private static class CMJ_getCredentials
    extends ControlCommandMessage {
        private CMJ_getCredentials() {
        }

        @Override
        public Object run(Object[] objectArray) {
            JWebBrowser jWebBrowser;
            NativeWebBrowser nativeWebBrowser = (NativeWebBrowser)this.getNativeComponent();
            JWebBrowser jWebBrowser2 = jWebBrowser = nativeWebBrowser == null ? null : (JWebBrowser)nativeWebBrowser.webBrowser.get();
            if (jWebBrowser == null) {
                return null;
            }
            WebBrowserAuthenticationHandler webBrowserAuthenticationHandler = nativeWebBrowser.getAuthenticationHandler();
            if (webBrowserAuthenticationHandler == null) {
                return new Object[]{true, null, null};
            }
            String string = (String)objectArray[0];
            Credentials credentials = webBrowserAuthenticationHandler.getCredentials(jWebBrowser, string);
            if (credentials == null) {
                return new Object[]{false, null, null};
            }
            return new Object[]{true, credentials.getUserName(), credentials.getPassword()};
        }
    }

    private static class CMN_unregisterFunction
    extends ControlCommandMessage {
        private CMN_unregisterFunction() {
        }

        @Override
        public Object run(Object[] objectArray) {
            Browser browser = (Browser)this.getControl();
            String string = "nsFunction_" + (String)objectArray[0];
            BrowserFunction browserFunction = (BrowserFunction)browser.getData(string);
            browser.setData(string, null);
            browserFunction.dispose();
            return null;
        }
    }

    private static class CMN_registerFunction
    extends ControlCommandMessage {
        private CMN_registerFunction() {
        }

        @Override
        public Object run(Object[] objectArray) {
            Browser browser = (Browser)this.getControl();
            String string = (String)objectArray[0];
            BrowserFunction browserFunction = new BrowserFunction(browser, string){

                public Object function(Object[] objectArray) {
                    return new CMJ_invokeFunction().syncExec((Control)this.getBrowser(), this.getName(), objectArray);
                }
            };
            browser.setData("nsFunction_" + string, (Object)browserFunction);
            return null;
        }
    }

    private static class CMJ_invokeFunction
    extends ControlCommandMessage {
        private CMJ_invokeFunction() {
        }

        @Override
        public Object run(Object[] objectArray) {
            WebBrowserFunction webBrowserFunction;
            JWebBrowser jWebBrowser;
            NativeWebBrowser nativeWebBrowser = (NativeWebBrowser)this.getNativeComponent();
            JWebBrowser jWebBrowser2 = jWebBrowser = nativeWebBrowser == null ? null : (JWebBrowser)nativeWebBrowser.webBrowser.get();
            if (jWebBrowser == null) {
                return null;
            }
            if (nativeWebBrowser.nameToFunctionMap != null && (webBrowserFunction = (WebBrowserFunction)nativeWebBrowser.nameToFunctionMap.get(objectArray[0])) != null) {
                return webBrowserFunction.invoke(jWebBrowser, (Object[])objectArray[1]);
            }
            return null;
        }
    }

    private static class CMN_setDefaultPopupMenuRegistered
    extends ControlCommandMessage {
        private CMN_setDefaultPopupMenuRegistered() {
        }

        @Override
        public Object run(Object[] objectArray) {
            Browser browser = (Browser)this.getControl();
            boolean bl = (Boolean)objectArray[0];
            if (bl) {
                NativeWebBrowser.registerDefaultPopupMenu(browser);
            } else {
                Menu menu = browser.getMenu();
                if (menu != null) {
                    menu.dispose();
                }
                final Menu menu2 = new Menu((Decorations)browser.getShell(), 8);
                menu2.addMenuListener((MenuListener)new MenuAdapter(){

                    public void menuShown(MenuEvent menuEvent) {
                        menu2.setVisible(false);
                    }
                });
                browser.setMenu(menu2);
            }
            return null;
        }
    }

    private static class CMN_navigateForward
    extends ControlCommandMessage {
        private CMN_navigateForward() {
        }

        @Override
        public Object run(Object[] objectArray) {
            return ((Browser)this.getControl()).forward();
        }
    }

    private static class CMN_isForwardNavigationEnabled
    extends ControlCommandMessage {
        private CMN_isForwardNavigationEnabled() {
        }

        @Override
        public Object run(Object[] objectArray) {
            return ((Browser)this.getControl()).isForwardEnabled();
        }
    }

    private static class CMN_navigateBack
    extends ControlCommandMessage {
        private CMN_navigateBack() {
        }

        @Override
        public Object run(Object[] objectArray) {
            return ((Browser)this.getControl()).back();
        }
    }

    private static class CMN_isBackNavigationEnabled
    extends ControlCommandMessage {
        private CMN_isBackNavigationEnabled() {
        }

        @Override
        public Object run(Object[] objectArray) {
            return ((Browser)this.getControl()).isBackEnabled();
        }
    }

    private static class CMN_reloadPage
    extends ControlCommandMessage {
        private CMN_reloadPage() {
        }

        @Override
        public Object run(Object[] objectArray) {
            ((Browser)this.getControl()).refresh();
            return null;
        }
    }

    private static class CMN_stopLoading
    extends ControlCommandMessage {
        private CMN_stopLoading() {
        }

        @Override
        public Object run(Object[] objectArray) {
            ((Browser)this.getControl()).stop();
            return null;
        }
    }

    private static class CMN_executeJavascriptWithResult
    extends ControlCommandMessage {
        private CMN_executeJavascriptWithResult() {
        }

        @Override
        public Object run(Object[] objectArray) {
            String string = (String)objectArray[0];
            Browser browser = (Browser)this.getControl();
            return browser.evaluate(NativeWebBrowser.fixJavascript(browser, string));
        }
    }

    private static class CMN_executeJavascript
    extends ControlCommandMessage {
        private CMN_executeJavascript() {
        }

        @Override
        public Object run(Object[] objectArray) {
            String string = (String)objectArray[0];
            Browser browser = (Browser)this.getControl();
            return browser.execute(NativeWebBrowser.fixJavascript(browser, string));
        }
    }

    private static class CMN_setJavascriptEnabled
    extends ControlCommandMessage {
        private CMN_setJavascriptEnabled() {
        }

        @Override
        public Object run(Object[] objectArray) {
            ((Browser)this.getControl()).setJavascriptEnabled(((Boolean)objectArray[0]).booleanValue());
            return null;
        }
    }

    private static class CMN_isJavascriptEnabled
    extends ControlCommandMessage {
        private CMN_isJavascriptEnabled() {
        }

        @Override
        public Object run(Object[] objectArray) {
            return ((Browser)this.getControl()).getJavascriptEnabled();
        }
    }

    private static class CMN_setHTMLContent
    extends ControlCommandMessage {
        private CMN_setHTMLContent() {
        }

        @Override
        public Object run(Object[] objectArray) {
            return ((Browser)this.getControl()).setText((String)objectArray[0]);
        }
    }

    private static class CMN_getHTMLContent
    extends ControlCommandMessage {
        private CMN_getHTMLContent() {
        }

        @Override
        public Object run(Object[] objectArray) {
            return ((Browser)this.getControl()).getText();
        }
    }

    private static class CMN_navigate
    extends ControlCommandMessage {
        private CMN_navigate() {
        }

        @Override
        public Object run(Object[] objectArray) {
            return ((Browser)this.getControl()).setUrl((String)objectArray[0], (String)objectArray[1], (String[])objectArray[2]);
        }
    }

    private static class CMN_getResourceLocation
    extends ControlCommandMessage {
        private CMN_getResourceLocation() {
        }

        @Override
        public Object run(Object[] objectArray) {
            return ((Browser)this.getControl()).getUrl();
        }
    }

    private static class CMN_setCookie
    extends CommandMessage {
        private CMN_setCookie() {
        }

        @Override
        public Object run(Object[] objectArray) {
            Browser.setCookie((String)((String)objectArray[1]), (String)((String)objectArray[0]));
            return null;
        }
    }

    private static class CMN_getCookie
    extends CommandMessage {
        private CMN_getCookie() {
        }

        @Override
        public Object run(Object[] objectArray) {
            return Browser.getCookie((String)((String)objectArray[1]), (String)((String)objectArray[0]));
        }
    }

    private static class CMN_clearSessionCookies
    extends CommandMessage {
        private CMN_clearSessionCookies() {
        }

        @Override
        public Object run(Object[] objectArray) {
            Browser.clearSessions();
            return null;
        }
    }

    private static class NSConsolePrintingBrowserFunction
    extends BrowserFunction {
        public NSConsolePrintingBrowserFunction(Browser browser, boolean bl) {
            super(browser, bl ? "nsConsoleErr" : "nsConsoleOut");
        }

        public Object function(Object[] objectArray) {
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < objectArray.length; ++i) {
                if (i > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(objectArray[i]);
            }
            new CMJ_consolePrinting().asyncExec((Control)this.getBrowser(), stringBuilder.toString());
            return null;
        }
    }

    private static class CMJ_consolePrinting
    extends ControlCommandMessage {
        private CMJ_consolePrinting() {
        }

        @Override
        public Object run(Object[] objectArray) {
            JWebBrowser jWebBrowser;
            NativeWebBrowser nativeWebBrowser = (NativeWebBrowser)this.getNativeComponent();
            JWebBrowser jWebBrowser2 = jWebBrowser = nativeWebBrowser == null ? null : (JWebBrowser)nativeWebBrowser.webBrowser.get();
            if (jWebBrowser == null) {
                return null;
            }
            System.out.println(objectArray[0]);
            return null;
        }
    }

    private static class NSCommandBrowserFunction
    extends BrowserFunction {
        public NSCommandBrowserFunction(Browser browser) {
            super(browser, "sendNSCommand");
        }

        public Object function(Object[] objectArray) {
            Object[] objectArray2;
            String string;
            String string2 = objectArray.length >= 1 ? (objectArray[0] instanceof String ? (String)objectArray[0] : "") : (string = "");
            if (objectArray.length > 1) {
                objectArray2 = new Object[objectArray.length - 1];
                System.arraycopy(objectArray, 1, objectArray2, 0, objectArray2.length);
                objectArray = objectArray2;
            } else {
                objectArray2 = new Object[]{};
            }
            new CMJ_commandReceived().asyncExec((Control)this.getBrowser(), string, objectArray2);
            return null;
        }
    }

    private static class CMJ_updateLoadingProgress
    extends ControlCommandMessage {
        private CMJ_updateLoadingProgress() {
        }

        @Override
        public Object run(Object[] objectArray) {
            JWebBrowser jWebBrowser;
            NativeWebBrowser nativeWebBrowser = (NativeWebBrowser)this.getNativeComponent();
            JWebBrowser jWebBrowser2 = jWebBrowser = nativeWebBrowser == null ? null : (JWebBrowser)nativeWebBrowser.webBrowser.get();
            if (jWebBrowser == null) {
                return null;
            }
            nativeWebBrowser.loadingProgress = (Integer)objectArray[0];
            Object[] objectArray2 = nativeWebBrowser.listenerList.getListenerList();
            WebBrowserEvent webBrowserEvent = null;
            for (int i = objectArray2.length - 2; i >= 0; i -= 2) {
                if (objectArray2[i] != WebBrowserListener.class) continue;
                if (webBrowserEvent == null) {
                    webBrowserEvent = new WebBrowserEvent(jWebBrowser);
                }
                ((WebBrowserListener)objectArray2[i + 1]).loadingProgressChanged(webBrowserEvent);
            }
            return null;
        }
    }

    private static class CMJ_updateStatus
    extends ControlCommandMessage {
        private CMJ_updateStatus() {
        }

        @Override
        public Object run(Object[] objectArray) {
            JWebBrowser jWebBrowser;
            NativeWebBrowser nativeWebBrowser = (NativeWebBrowser)this.getNativeComponent();
            JWebBrowser jWebBrowser2 = jWebBrowser = nativeWebBrowser == null ? null : (JWebBrowser)nativeWebBrowser.webBrowser.get();
            if (jWebBrowser == null) {
                return null;
            }
            nativeWebBrowser.status = (String)objectArray[0];
            Object[] objectArray2 = nativeWebBrowser.listenerList.getListenerList();
            WebBrowserEvent webBrowserEvent = null;
            for (int i = objectArray2.length - 2; i >= 0; i -= 2) {
                if (objectArray2[i] != WebBrowserListener.class) continue;
                if (webBrowserEvent == null) {
                    webBrowserEvent = new WebBrowserEvent(jWebBrowser);
                }
                ((WebBrowserListener)objectArray2[i + 1]).statusChanged(webBrowserEvent);
            }
            return null;
        }
    }

    private static class CMJ_updateTitle
    extends ControlCommandMessage {
        private CMJ_updateTitle() {
        }

        @Override
        public Object run(Object[] objectArray) {
            JWebBrowser jWebBrowser;
            NativeWebBrowser nativeWebBrowser = (NativeWebBrowser)this.getNativeComponent();
            JWebBrowser jWebBrowser2 = jWebBrowser = nativeWebBrowser == null ? null : (JWebBrowser)nativeWebBrowser.webBrowser.get();
            if (jWebBrowser == null) {
                return null;
            }
            nativeWebBrowser.title = (String)objectArray[0];
            Object[] objectArray2 = nativeWebBrowser.listenerList.getListenerList();
            WebBrowserEvent webBrowserEvent = null;
            for (int i = objectArray2.length - 2; i >= 0; i -= 2) {
                if (objectArray2[i] != WebBrowserListener.class) continue;
                if (webBrowserEvent == null) {
                    webBrowserEvent = new WebBrowserEvent(jWebBrowser);
                }
                ((WebBrowserListener)objectArray2[i + 1]).titleChanged(webBrowserEvent);
            }
            return null;
        }
    }

    private static class CMJ_locationChangeCanceled
    extends ControlCommandMessage {
        private CMJ_locationChangeCanceled() {
        }

        @Override
        public Object run(Object[] objectArray) {
            JWebBrowser jWebBrowser;
            NativeWebBrowser nativeWebBrowser = (NativeWebBrowser)this.getNativeComponent();
            JWebBrowser jWebBrowser2 = jWebBrowser = nativeWebBrowser == null ? null : (JWebBrowser)nativeWebBrowser.webBrowser.get();
            if (jWebBrowser == null) {
                return null;
            }
            Object[] objectArray2 = nativeWebBrowser.listenerList.getListenerList();
            String string = (String)objectArray[0];
            boolean bl = (Boolean)objectArray[1];
            WebBrowserNavigationEvent webBrowserNavigationEvent = null;
            for (int i = objectArray2.length - 2; i >= 0; i -= 2) {
                if (objectArray2[i] != WebBrowserListener.class) continue;
                if (webBrowserNavigationEvent == null) {
                    webBrowserNavigationEvent = new WebBrowserNavigationEvent(jWebBrowser, string, bl);
                }
                ((WebBrowserListener)objectArray2[i + 1]).locationChangeCanceled(webBrowserNavigationEvent);
            }
            return null;
        }
    }

    private static class CMJ_locationChanging
    extends ControlCommandMessage {
        private CMJ_locationChanging() {
        }

        @Override
        public Object run(Object[] objectArray) {
            JWebBrowser jWebBrowser;
            NativeWebBrowser nativeWebBrowser = (NativeWebBrowser)this.getNativeComponent();
            JWebBrowser jWebBrowser2 = jWebBrowser = nativeWebBrowser == null ? null : (JWebBrowser)nativeWebBrowser.webBrowser.get();
            if (jWebBrowser == null) {
                return false;
            }
            Object[] objectArray2 = nativeWebBrowser.listenerList.getListenerList();
            String string = (String)objectArray[0];
            boolean bl = (Boolean)objectArray[1];
            boolean bl2 = true;
            WebBrowserNavigationEvent webBrowserNavigationEvent = null;
            for (int i = objectArray2.length - 2; i >= 0; i -= 2) {
                if (objectArray2[i] != WebBrowserListener.class) continue;
                if (webBrowserNavigationEvent == null) {
                    webBrowserNavigationEvent = new WebBrowserNavigationEvent(jWebBrowser, string, bl);
                }
                ((WebBrowserListener)objectArray2[i + 1]).locationChanging(webBrowserNavigationEvent);
                bl2 &= !webBrowserNavigationEvent.isConsumed();
            }
            return bl2;
        }
    }

    private static class CMJ_commandReceived
    extends ControlCommandMessage {
        private CMJ_commandReceived() {
        }

        @Override
        public Object run(Object[] objectArray) {
            JWebBrowser jWebBrowser;
            NativeWebBrowser nativeWebBrowser = (NativeWebBrowser)this.getNativeComponent();
            JWebBrowser jWebBrowser2 = jWebBrowser = nativeWebBrowser == null ? null : (JWebBrowser)nativeWebBrowser.webBrowser.get();
            if (jWebBrowser == null) {
                return null;
            }
            Object[] objectArray2 = nativeWebBrowser.listenerList.getListenerList();
            WebBrowserCommandEvent webBrowserCommandEvent = null;
            String string = (String)objectArray[0];
            Object[] objectArray3 = (Object[])objectArray[1];
            boolean bl = string.startsWith("[Chrriis]");
            for (int i = objectArray2.length - 2; i >= 0; i -= 2) {
                if (objectArray2[i] != WebBrowserListener.class) continue;
                if (webBrowserCommandEvent == null) {
                    webBrowserCommandEvent = new WebBrowserCommandEvent(jWebBrowser, string, objectArray3);
                }
                WebBrowserListener webBrowserListener = (WebBrowserListener)objectArray2[i + 1];
                if (bl && !webBrowserListener.getClass().getName().startsWith("chrriis.")) continue;
                webBrowserListener.commandReceived(webBrowserCommandEvent);
            }
            return null;
        }
    }

    private static class CMJ_locationChanged
    extends ControlCommandMessage {
        private CMJ_locationChanged() {
        }

        @Override
        public Object run(Object[] objectArray) {
            JWebBrowser jWebBrowser;
            NativeWebBrowser nativeWebBrowser = (NativeWebBrowser)this.getNativeComponent();
            JWebBrowser jWebBrowser2 = jWebBrowser = nativeWebBrowser == null ? null : (JWebBrowser)nativeWebBrowser.webBrowser.get();
            if (jWebBrowser == null) {
                return null;
            }
            Object[] objectArray2 = nativeWebBrowser.listenerList.getListenerList();
            String string = (String)objectArray[0];
            boolean bl = (Boolean)objectArray[1];
            WebBrowserNavigationEvent webBrowserNavigationEvent = null;
            for (int i = objectArray2.length - 2; i >= 0; i -= 2) {
                if (objectArray2[i] != WebBrowserListener.class) continue;
                if (webBrowserNavigationEvent == null) {
                    webBrowserNavigationEvent = new WebBrowserNavigationEvent(jWebBrowser, string, bl);
                }
                ((WebBrowserListener)objectArray2[i + 1]).locationChanged(webBrowserNavigationEvent);
            }
            return null;
        }
    }

    private static class CMJ_showWindow
    extends ControlCommandMessage {
        private CMJ_showWindow() {
        }

        @Override
        public Object run(Object[] objectArray) {
            Serializable serializable;
            Object object;
            JWebBrowser jWebBrowser;
            NativeWebBrowser nativeWebBrowser = (NativeWebBrowser)this.getNativeComponent();
            JWebBrowser jWebBrowser2 = jWebBrowser = nativeWebBrowser == null ? null : (JWebBrowser)nativeWebBrowser.webBrowser.get();
            if (jWebBrowser == null) {
                return null;
            }
            int n = (Integer)objectArray[0];
            final JWebBrowser jWebBrowser3 = (JWebBrowser)((NativeWebBrowser)NativeWebBrowser.getNativeComponentRegistry().get(n)).webBrowser.get();
            jWebBrowser3.setMenuBarVisible((Boolean)objectArray[1]);
            jWebBrowser3.setButtonBarVisible((Boolean)objectArray[2]);
            jWebBrowser3.setLocationBarVisible((Boolean)objectArray[3]);
            jWebBrowser3.setStatusBarVisible((Boolean)objectArray[4]);
            Point point = (Point)objectArray[5];
            Dimension dimension = (Dimension)objectArray[6];
            JWebBrowserWindow jWebBrowserWindow = jWebBrowser3.getWebBrowserWindow();
            if (jWebBrowserWindow != null) {
                if (dimension != null) {
                    ((Window)((Object)jWebBrowserWindow)).validate();
                    object = jWebBrowserWindow.getSize();
                    serializable = ((NativeWebBrowser)jWebBrowserWindow.getWebBrowser().getNativeComponent()).embeddableComponent.getSize();
                    if (dimension.width > 0) {
                        object.width -= serializable.width;
                        object.width += dimension.width;
                    }
                    if (dimension.height > 0) {
                        object.height -= serializable.height;
                        object.height += dimension.height;
                    }
                    jWebBrowserWindow.setSize((Dimension)object);
                }
                if (point != null) {
                    jWebBrowserWindow.setLocation(point);
                }
            }
            object = nativeWebBrowser.listenerList.getListenerList();
            serializable = null;
            for (int i = ((Object[])object).length - 2; i >= 0 && jWebBrowser3 != null; i -= 2) {
                if (object[i] != WebBrowserListener.class) continue;
                if (serializable == null) {
                    serializable = new WebBrowserWindowOpeningEvent(jWebBrowser, jWebBrowser3, point, dimension);
                }
                ((WebBrowserListener)object[i + 1]).windowOpening((WebBrowserWindowOpeningEvent)serializable);
            }
            new Thread(){

                @Override
                public void run() {
                    try {
                        1.sleep(600L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            JWebBrowserWindow jWebBrowserWindow = jWebBrowser3.getWebBrowserWindow();
                            if (jWebBrowserWindow != null && !jWebBrowser3.getNativeComponent().isNativePeerDisposed()) {
                                jWebBrowserWindow.setVisible(true);
                            }
                        }
                    });
                }
            }.start();
            return null;
        }
    }

    private static class CMJ_createWindow
    extends ControlCommandMessage {
        private CMJ_createWindow() {
        }

        @Override
        public Object run(Object[] objectArray) {
            JWebBrowser jWebBrowser;
            JWebBrowser jWebBrowser2;
            NativeWebBrowser nativeWebBrowser = (NativeWebBrowser)this.getNativeComponent();
            JWebBrowser jWebBrowser3 = jWebBrowser2 = nativeWebBrowser == null ? null : (JWebBrowser)nativeWebBrowser.webBrowser.get();
            if (jWebBrowser2 == null) {
                return null;
            }
            switch (nativeWebBrowser.getRuntime()) {
                case WEBKIT: {
                    jWebBrowser = new JWebBrowser(JWebBrowser.useWebkitRuntime());
                    break;
                }
                case XULRUNNER: {
                    jWebBrowser = new JWebBrowser(JWebBrowser.useXULRunnerRuntime());
                    break;
                }
                default: {
                    jWebBrowser = new JWebBrowser(new NSOption[0]);
                }
            }
            Object[] objectArray2 = nativeWebBrowser.listenerList.getListenerList();
            WebBrowserWindowWillOpenEvent webBrowserWindowWillOpenEvent = null;
            for (int i = objectArray2.length - 2; i >= 0 && jWebBrowser != null; i -= 2) {
                if (objectArray2[i] != WebBrowserListener.class) continue;
                if (webBrowserWindowWillOpenEvent == null) {
                    webBrowserWindowWillOpenEvent = new WebBrowserWindowWillOpenEvent(jWebBrowser2, jWebBrowser);
                }
                ((WebBrowserListener)objectArray2[i + 1]).windowWillOpen(webBrowserWindowWillOpenEvent);
                jWebBrowser = webBrowserWindowWillOpenEvent.isConsumed() ? null : webBrowserWindowWillOpenEvent.getNewWebBrowser();
            }
            if (jWebBrowser == null) {
                return null;
            }
            if (!jWebBrowser.isNativePeerInitialized()) {
                Window window = SwingUtilities.getWindowAncestor(jWebBrowser);
                if (window == null) {
                    Window window2 = webBrowserWindowWillOpenEvent.isDialogWindow() ? SwingUtilities.getWindowAncestor(jWebBrowser2) : null;
                    window = (Window)((Object)WebBrowserWindowFactory.create(window2, jWebBrowser));
                }
                jWebBrowser.getNativeComponent().initializeNativePeer();
            }
            return ((NativeWebBrowser)jWebBrowser.getNativeComponent()).getComponentID();
        }
    }

    private static class CMJ_closeWindow
    extends ControlCommandMessage {
        private CMJ_closeWindow() {
        }

        @Override
        public Object run(Object[] objectArray) {
            JWebBrowser jWebBrowser;
            NativeWebBrowser nativeWebBrowser = (NativeWebBrowser)this.getNativeComponent();
            JWebBrowser jWebBrowser2 = jWebBrowser = nativeWebBrowser == null ? null : (JWebBrowser)nativeWebBrowser.webBrowser.get();
            if (jWebBrowser == null) {
                return null;
            }
            Object[] objectArray2 = nativeWebBrowser.listenerList.getListenerList();
            WebBrowserEvent webBrowserEvent = null;
            for (int i = objectArray2.length - 2; i >= 0; i -= 2) {
                if (objectArray2[i] != WebBrowserListener.class) continue;
                if (webBrowserEvent == null) {
                    webBrowserEvent = new WebBrowserEvent(jWebBrowser);
                }
                ((WebBrowserListener)objectArray2[i + 1]).windowClosing(webBrowserEvent);
            }
            JWebBrowserWindow jWebBrowserWindow = jWebBrowser.getWebBrowserWindow();
            if (jWebBrowserWindow != null) {
                jWebBrowserWindow.dispose();
            }
            jWebBrowser.disposeNativePeer();
            return null;
        }
    }
}

