/*
 * Decompiled with CFR 0.152.
 */
package chrriis.dj.nativeswing.swtimpl.components.core;

import chrriis.common.Utils;
import chrriis.dj.nativeswing.swtimpl.CommandMessage;
import chrriis.dj.nativeswing.swtimpl.NSSystemPropertySWT;
import chrriis.dj.nativeswing.swtimpl.components.JWebBrowser;
import chrriis.dj.nativeswing.swtimpl.components.MozillaXPCOM;
import chrriis.dj.nativeswing.swtimpl.components.internal.INativeMozillaXPCOM;
import chrriis.dj.nativeswing.swtimpl.core.ControlCommandMessage;
import java.io.File;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.mozilla.xpcom.Mozilla;

class NativeMozillaXPCOM
implements INativeMozillaXPCOM {
    private static Map<Integer, Object> idToNativeInterfaceMap = new HashMap<Integer, Object>();
    private static Map<Integer, WeakReference<NativeSwingProxy>> idToProxyInterfaceReferenceMap = new HashMap<Integer, WeakReference<NativeSwingProxy>>();
    private static Map<InterfaceInfo, Integer> interfaceInfoToIDMap = new HashMap<InterfaceInfo, Integer>();
    private static int nextNativeSideID = 1;
    private static int nextSwingSideID = -1;

    NativeMozillaXPCOM() {
    }

    @Override
    public Object getWebBrowser(JWebBrowser jWebBrowser) {
        return this.unpack(jWebBrowser.getNativeComponent().runSync(new CMN_getWebBrowser(), new Object[0]));
    }

    @Override
    public boolean initialize() {
        String string = NSSystemPropertySWT.WEBBROWSER_XULRUNNER_HOME.get();
        if (string == null) {
            string = NSSystemPropertySWT.ORG_ECLIPSE_SWT_BROWSER_XULRUNNERPATH.get();
        } else {
            NSSystemPropertySWT.ORG_ECLIPSE_SWT_BROWSER_XULRUNNERPATH.set(string);
        }
        if (Utils.IS_MAC) {
            if (string == null) {
                string = System.getenv("XULRUNNER_HOME");
            }
            if (string == null) {
                return false;
            }
            File file = new File(string);
            if (!file.exists()) {
                return false;
            }
            Mozilla.getInstance().initialize(file);
        } else {
            Shell shell = new Shell(0);
            new Browser((Composite)shell, 32768);
            shell.dispose();
        }
        return true;
    }

    @Override
    public Object pack(Object object, boolean bl) {
        return NativeMozillaXPCOM.pack_(object, bl);
    }

    static Object pack_(Object object, boolean bl) {
        if (object == null) {
            return null;
        }
        if (object instanceof Object[]) {
            Object[] objectArray = (Object[])object;
            Object[] objectArray2 = new Object[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                objectArray2[i] = NativeMozillaXPCOM.pack_(objectArray[i], bl);
            }
            return new ArrayInfo(objectArray.getClass(), objectArray2);
        }
        Package package_ = object.getClass().getPackage();
        if (package_ != null && package_.getName().equals("java.lang")) {
            return object;
        }
        InterfaceInfo interfaceInfo = new InterfaceInfo(object);
        Integer n = interfaceInfoToIDMap.get(interfaceInfo);
        if (n == null) {
            ArrayList arrayList = new ArrayList();
            ClassLoader classLoader = MozillaXPCOM.class.getClassLoader();
            for (Class<?> clazz : object.getClass().getInterfaces()) {
                Class<?> clazz2 = null;
                try {
                    clazz2 = Class.forName(clazz.getName(), false, classLoader);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
                if (clazz2 != clazz) continue;
                arrayList.add(clazz);
            }
            arrayList.add(NativeSwingProxy.class);
            n = bl ? Integer.valueOf(nextNativeSideID++) : Integer.valueOf(nextSwingSideID--);
            idToNativeInterfaceMap.put(n, object);
            interfaceInfoToIDMap.put(interfaceInfo, n);
            return new InterfaceDefinition(n, arrayList.toArray(new Class[0]), true, !bl);
        }
        return new InterfaceDefinition(n, null, !(object instanceof NativeSwingProxy), !bl);
    }

    @Override
    public Object unpack(Object object) {
        return NativeMozillaXPCOM.unpack_(object);
    }

    static Object unpack_(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof ArrayInfo) {
            ArrayInfo arrayInfo = (ArrayInfo)object;
            Class<?> clazz = arrayInfo.getArrayClass();
            Object[] objectArray = arrayInfo.getItems();
            Object[] objectArray2 = (Object[])Array.newInstance(clazz.getComponentType(), objectArray.length);
            for (int i = 0; i < objectArray.length; ++i) {
                objectArray2[i] = NativeMozillaXPCOM.unpack_(objectArray[i]);
            }
            return objectArray2;
        }
        if (object instanceof InterfaceDefinition) {
            InterfaceDefinition interfaceDefinition = (InterfaceDefinition)object;
            final Integer n = interfaceDefinition.getID();
            if (interfaceDefinition.isProxy()) {
                NativeSwingProxy nativeSwingProxy;
                WeakReference<NativeSwingProxy> weakReference = idToProxyInterfaceReferenceMap.get(n);
                NativeSwingProxy nativeSwingProxy2 = nativeSwingProxy = weakReference == null ? null : (NativeSwingProxy)weakReference.get();
                if (nativeSwingProxy == null) {
                    Class<?>[] classArray = interfaceDefinition.getInterfaces();
                    final boolean bl = interfaceDefinition.isNativeSide();
                    nativeSwingProxy = (NativeSwingProxy)Proxy.newProxyInstance(MozillaXPCOM.class.getClassLoader(), classArray, new InvocationHandler(){

                        @Override
                        public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
                            String string = method.getName();
                            Class<?>[] classArray = method.getParameterTypes();
                            if ("finalize".equals(string) && classArray.length == 0) {
                                idToProxyInterfaceReferenceMap.remove(n);
                                interfaceInfoToIDMap.remove(new InterfaceInfo(this));
                                new CM_disposeResources().syncExec(!bl, n);
                                return null;
                            }
                            RunMethodResult runMethodResult = (RunMethodResult)new CM_runMethod().syncExec(!bl, n, string, classArray, NativeMozillaXPCOM.pack_(objectArray, bl), !bl);
                            Object[] objectArray2 = runMethodResult.getOutParams();
                            if (objectArray2 != null) {
                                int n2 = 0;
                                for (Object object2 : objectArray) {
                                    if (!(object2 instanceof Object[])) continue;
                                    Object[] objectArray3 = (Object[])object2;
                                    Object[] objectArray4 = (Object[])NativeMozillaXPCOM.unpack_(objectArray2[n2++]);
                                    for (int i = 0; i < objectArray3.length; ++i) {
                                        objectArray3[i] = objectArray4[i];
                                    }
                                }
                            }
                            return NativeMozillaXPCOM.unpack_(runMethodResult.getResult());
                        }
                    });
                    idToProxyInterfaceReferenceMap.put(n, new WeakReference<NativeSwingProxy>(nativeSwingProxy));
                    interfaceInfoToIDMap.put(new InterfaceInfo(nativeSwingProxy), n);
                }
                return nativeSwingProxy;
            }
            return idToNativeInterfaceMap.get(n);
        }
        return object;
    }

    private static class CM_disposeResources
    extends CommandMessage {
        private CM_disposeResources() {
        }

        @Override
        public Object run(Object[] objectArray) {
            Object v = idToNativeInterfaceMap.remove(objectArray[0]);
            interfaceInfoToIDMap.remove(new InterfaceInfo(v));
            return null;
        }
    }

    private static class CM_runMethod
    extends CommandMessage {
        private CM_runMethod() {
        }

        @Override
        public Object run(Object[] objectArray) {
            Integer n = (Integer)objectArray[0];
            String string = (String)objectArray[1];
            Class[] classArray = (Class[])objectArray[2];
            Object[] objectArray2 = (Object[])NativeMozillaXPCOM.unpack_(objectArray[3]);
            boolean bl = (Boolean)objectArray[4];
            Object v = idToNativeInterfaceMap.get(n);
            try {
                Method method = v.getClass().getMethod(string, classArray);
                method.setAccessible(true);
                Object object = method.invoke(v, objectArray2);
                ArrayList<Object> arrayList = null;
                if (objectArray2 != null) {
                    arrayList = new ArrayList<Object>();
                    for (Object object2 : objectArray2) {
                        if (!(object2 instanceof Object[])) continue;
                        arrayList.add(NativeMozillaXPCOM.pack_(object2, bl));
                    }
                }
                return new RunMethodResult(NativeMozillaXPCOM.pack_(object, bl), arrayList == null || arrayList.isEmpty() ? null : arrayList.toArray());
            }
            catch (Exception exception) {
                throw new IllegalStateException("The method " + string + " could not be invoked on interface " + v + "!", exception);
            }
        }
    }

    private static class RunMethodResult
    implements Serializable {
        private Object result;
        private Object[] outParams;

        public RunMethodResult(Object object, Object[] objectArray) {
            this.result = object;
            this.outParams = objectArray;
        }

        public Object getResult() {
            return this.result;
        }

        public Object[] getOutParams() {
            return this.outParams;
        }
    }

    private static class ArrayInfo
    implements Serializable {
        private Class<?> arrayClass;
        private Object[] content;

        public ArrayInfo(Class<?> clazz, Object[] objectArray) {
            ClassLoader classLoader = MozillaXPCOM.class.getClassLoader();
            Class<?> clazz2 = null;
            while (true) {
                try {
                    clazz2 = Class.forName(clazz.getName(), false, classLoader);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
                if (clazz2 == clazz) break;
                clazz2 = clazz2.getSuperclass();
            }
            this.arrayClass = clazz;
            this.content = objectArray;
        }

        public Class<?> getArrayClass() {
            return this.arrayClass;
        }

        public Object[] getItems() {
            return this.content;
        }

        public String toString() {
            return Arrays.deepToString(this.content);
        }
    }

    private static class InterfaceInfo {
        private int id;

        public InterfaceInfo(Object object) {
            this.id = System.identityHashCode(object);
        }

        public int hashCode() {
            return this.id;
        }

        public boolean equals(Object object) {
            return ((InterfaceInfo)object).id == this.id;
        }
    }

    private static interface NativeSwingProxy {
        public void finalize();
    }

    private static class InterfaceDefinition
    implements Serializable {
        private int id;
        private Class<?>[] interfaces;
        private boolean isProxy;
        private boolean isNativeSide;

        private InterfaceDefinition(int n, Class<?>[] classArray, boolean bl, boolean bl2) {
            this.id = n;
            this.interfaces = classArray;
            this.isProxy = bl;
            this.isNativeSide = bl2;
        }

        public int getID() {
            return this.id;
        }

        public Class<?>[] getInterfaces() {
            return this.interfaces;
        }

        public boolean isProxy() {
            return this.isProxy;
        }

        public boolean isNativeSide() {
            return this.isNativeSide;
        }
    }

    private static class CMN_getWebBrowser
    extends ControlCommandMessage {
        private CMN_getWebBrowser() {
        }

        @Override
        public Object run(Object[] objectArray) {
            return NativeMozillaXPCOM.pack_(((Browser)this.getControl()).getWebBrowser(), true);
        }
    }
}

