/*
 * Decompiled with CFR 0.152.
 */
package chrriis.dj.nativeswing.swtimpl.components;

import chrriis.common.Utils;
import chrriis.common.WebServer;
import chrriis.dj.nativeswing.swtimpl.NSSystemPropertySWT;
import chrriis.dj.nativeswing.swtimpl.WebBrowserObject;
import chrriis.dj.nativeswing.swtimpl.components.JVLCPlayer;
import chrriis.dj.nativeswing.swtimpl.components.VLCInput;
import java.io.File;
import javax.swing.SwingUtilities;

public class VLCPlaylist {
    private JVLCPlayer vlcPlayer;
    private WebBrowserObject webBrowserObject;
    private volatile Thread playlistFixThread;

    VLCPlaylist(JVLCPlayer jVLCPlayer) {
        this.vlcPlayer = jVLCPlayer;
        this.webBrowserObject = jVLCPlayer.getWebBrowserObject();
    }

    public int getItemCount() {
        Object object = this.webBrowserObject.getObjectProperty("playlist.items.count");
        return object == null ? -1 : ((Number)object).intValue();
    }

    public boolean isPlaying() {
        return Boolean.TRUE.equals(this.webBrowserObject.getObjectProperty("playlist.isPlaying"));
    }

    public void addItem(Class<?> clazz, String string) {
        this.addItem(clazz, string, null);
    }

    public void addItem(Class<?> clazz, String string, String string2) {
        this.vlcPlayer.addReferenceClassLoader(clazz.getClassLoader());
        this.addItem(WebServer.getDefaultWebServer().getClassPathResourceURL(clazz.getName(), string), string2);
    }

    public void addItem(String string) {
        this.addItem(string, null);
    }

    public void addItem(String string, String string2) {
        File file;
        if (!this.webBrowserObject.hasContent()) {
            this.vlcPlayer.load();
            this.clear();
        }
        if ((file = Utils.getLocalFile(string)) != null) {
            string = this.webBrowserObject.getLocalFileURL(file);
        }
        this.webBrowserObject.invokeObjectFunction("playlist.add", string, string, string2);
    }

    public void play() {
        this.setPlaylistFixActive(false);
        this.webBrowserObject.invokeObjectFunction("playlist.play", new Object[0]);
        this.setPlaylistFixActive(true);
    }

    public void playItem(int n) {
        this.setPlaylistFixActive(false);
        this.webBrowserObject.invokeObjectFunction("playlist.playItem", n);
        this.setPlaylistFixActive(true);
    }

    public void togglePause() {
        this.webBrowserObject.invokeObjectFunction("playlist.togglePause", new Object[0]);
    }

    public void stop() {
        this.setPlaylistFixActive(false);
        this.webBrowserObject.invokeObjectFunction("playlist.stop", new Object[0]);
    }

    public void goNext() {
        this.setPlaylistFixActive(false);
        this.webBrowserObject.invokeObjectFunction("playlist.next", new Object[0]);
        this.setPlaylistFixActive(true);
    }

    public void goPrevious() {
        this.setPlaylistFixActive(false);
        this.webBrowserObject.invokeObjectFunction("playlist.prev", new Object[0]);
        this.setPlaylistFixActive(true);
    }

    public void clear() {
        this.setPlaylistFixActive(false);
        this.webBrowserObject.invokeObjectFunction("playlist.items.clear", new Object[0]);
    }

    public void removeItem(int n) {
        this.webBrowserObject.invokeObjectFunction("playlist.items.removeItem", n);
    }

    private void setPlaylistFixActive(boolean bl) {
        if (this.playlistFixThread != null == bl) {
            return;
        }
        if (bl) {
            if (!Boolean.parseBoolean(NSSystemPropertySWT.VLCPLAYER_FIXPLAYLISTAUTOPLAYNEXT.get("true"))) {
                return;
            }
            this.playlistFixThread = new Thread("NativeSwing - VLC Player playlist fix"){

                @Override
                public void run() {
                    final 1 var1_1 = this;
                    boolean bl = true;
                    while (var1_1 == VLCPlaylist.this.playlistFixThread) {
                        if (VLCPlaylist.this.vlcPlayer.isNativePeerDisposed()) {
                            VLCPlaylist.this.setPlaylistFixActive(false);
                            return;
                        }
                        try {
                            1.sleep(bl ? 3000L : 500L);
                            bl = false;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                if (var1_1 != VLCPlaylist.this.playlistFixThread) {
                                    return;
                                }
                                if (!VLCPlaylist.this.vlcPlayer.isNativePeerValid()) {
                                    return;
                                }
                                if (VLCPlaylist.this.vlcPlayer.getVLCInput().getMediaState() == VLCInput.VLCMediaState.ERROR) {
                                    VLCPlaylist.this.goNext();
                                }
                            }
                        });
                    }
                }
            };
            this.playlistFixThread.setDaemon(true);
            this.playlistFixThread.start();
        } else {
            this.playlistFixThread = null;
        }
    }
}

