/*
 * Decompiled with CFR 0.152.
 */
package chrriis.dj.nativeswing.swtimpl.components;

import chrriis.common.Utils;
import chrriis.common.WebServer;
import chrriis.dj.nativeswing.NSOption;
import chrriis.dj.nativeswing.NSSystemProperty;
import chrriis.dj.nativeswing.swtimpl.NSPanelComponent;
import chrriis.dj.nativeswing.swtimpl.WebBrowserObject;
import chrriis.dj.nativeswing.swtimpl.components.DefaultFlashPlayerDecorator;
import chrriis.dj.nativeswing.swtimpl.components.FlashPlayerCommandEvent;
import chrriis.dj.nativeswing.swtimpl.components.FlashPlayerDecorator;
import chrriis.dj.nativeswing.swtimpl.components.FlashPlayerListener;
import chrriis.dj.nativeswing.swtimpl.components.FlashPluginOptions;
import chrriis.dj.nativeswing.swtimpl.components.JWebBrowser;
import chrriis.dj.nativeswing.swtimpl.components.WebBrowserAdapter;
import chrriis.dj.nativeswing.swtimpl.components.WebBrowserCommandEvent;
import java.awt.Component;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class JFlashPlayer
extends NSPanelComponent {
    private static final String SET_CUSTOM_JAVASCRIPT_DEFINITIONS_OPTION_KEY = "Flash Player Custom Javascript definitions";
    private static FlashPlayerDecoratorFactory flashPlayerDecoratorFactory;
    private FlashPlayerDecorator flashPlayerDecorator;
    private JWebBrowser webBrowser;
    private WebBrowserObject webBrowserObject;
    private volatile String customJavascriptDefinitions;
    private volatile FlashPluginOptions options;
    private List<ClassLoader> referenceClassLoaderList = new ArrayList<ClassLoader>(1);

    public static NSOption setCustomJavascriptDefinitions(final String string) {
        return new NSOption(SET_CUSTOM_JAVASCRIPT_DEFINITIONS_OPTION_KEY){

            @Override
            public Object getOptionValue() {
                return string;
            }
        };
    }

    public static void setFlashPlayerDecoratorFactory(FlashPlayerDecoratorFactory flashPlayerDecoratorFactory) {
        JFlashPlayer.flashPlayerDecoratorFactory = flashPlayerDecoratorFactory;
    }

    FlashPlayerDecorator getFlashPlayerDecorator() {
        return this.flashPlayerDecorator;
    }

    protected FlashPlayerDecorator createFlashPlayerDecorator(Component component) {
        FlashPlayerDecorator flashPlayerDecorator;
        if (flashPlayerDecoratorFactory != null && (flashPlayerDecorator = flashPlayerDecoratorFactory.createFlashPlayerDecorator(this, component)) != null) {
            return flashPlayerDecorator;
        }
        return new DefaultFlashPlayerDecorator(this, component);
    }

    public JFlashPlayer(NSOption ... nSOptionArray) {
        Map<Object, Object> map = NSOption.createOptionMap(nSOptionArray);
        this.customJavascriptDefinitions = (String)map.get(SET_CUSTOM_JAVASCRIPT_DEFINITIONS_OPTION_KEY);
        this.webBrowser = new JWebBrowser(nSOptionArray);
        this.initialize(this.webBrowser.getNativeComponent());
        this.webBrowserObject = new NWebBrowserObject(this);
        this.webBrowser.addWebBrowserListener(new WebBrowserAdapter(){

            @Override
            public void commandReceived(WebBrowserCommandEvent webBrowserCommandEvent) {
                String string = webBrowserCommandEvent.getCommand();
                Object[] objectArray = webBrowserCommandEvent.getParameters();
                boolean bl = string.startsWith("[Chrriis]");
                FlashPlayerCommandEvent flashPlayerCommandEvent = null;
                for (FlashPlayerListener flashPlayerListener : JFlashPlayer.this.getFlashPlayerListeners()) {
                    if (bl && !flashPlayerListener.getClass().getName().startsWith("chrriis.")) continue;
                    if (flashPlayerCommandEvent == null) {
                        flashPlayerCommandEvent = new FlashPlayerCommandEvent(JFlashPlayer.this, string, objectArray);
                    }
                    flashPlayerListener.commandReceived(flashPlayerCommandEvent);
                }
            }
        });
        this.flashPlayerDecorator = this.createFlashPlayerDecorator(this.webBrowser);
        this.add((Component)this.flashPlayerDecorator, "Center");
    }

    public void load(Class<?> clazz, String string) {
        this.load(clazz, string, null);
    }

    public void load(Class<?> clazz, String string, FlashPluginOptions flashPluginOptions) {
        this.addReferenceClassLoader(clazz.getClassLoader());
        this.load(WebServer.getDefaultWebServer().getClassPathResourceURL(clazz.getName(), string), flashPluginOptions);
    }

    public void load(String string) {
        this.load(string, null);
    }

    public void load(String string, FlashPluginOptions flashPluginOptions) {
        if ("".equals(string)) {
            string = null;
        }
        if (flashPluginOptions == null) {
            flashPluginOptions = new FlashPluginOptions();
        }
        this.options = flashPluginOptions;
        this.webBrowserObject.load(string);
    }

    public void play() {
        if (!this.webBrowserObject.hasContent()) {
            return;
        }
        this.webBrowserObject.invokeObjectFunction("Play", new Object[0]);
    }

    public void pause() {
        if (!this.webBrowserObject.hasContent()) {
            return;
        }
        this.webBrowserObject.invokeObjectFunction("StopPlay", new Object[0]);
    }

    public void stop() {
        if (!this.webBrowserObject.hasContent()) {
            return;
        }
        this.webBrowserObject.invokeObjectFunction("Rewind", new Object[0]);
    }

    public void setVariable(String string, String string2) {
        if (!this.webBrowserObject.hasContent()) {
            return;
        }
        this.webBrowserObject.invokeObjectFunction("SetVariable", string, string2);
    }

    public Object getVariable(String string) {
        if (!this.webBrowserObject.hasContent()) {
            return null;
        }
        return this.webBrowserObject.invokeObjectFunctionWithResult("GetVariable", string);
    }

    public void invokeFlashFunction(String string, Object ... objectArray) {
        this.webBrowserObject.invokeObjectFunction(string, objectArray);
    }

    public Object invokeFlashFunctionWithResult(String string, Object ... objectArray) {
        return this.webBrowserObject.invokeObjectFunctionWithResult(string, objectArray);
    }

    public JWebBrowser getWebBrowser() {
        return this.webBrowser;
    }

    public boolean isControlBarVisible() {
        return this.flashPlayerDecorator.isControlBarVisible();
    }

    public void setControlBarVisible(boolean bl) {
        this.flashPlayerDecorator.setControlBarVisible(bl);
    }

    public void addFlashPlayerListener(FlashPlayerListener flashPlayerListener) {
        this.listenerList.add(FlashPlayerListener.class, flashPlayerListener);
    }

    public void removeFlashPlayerListener(FlashPlayerListener flashPlayerListener) {
        this.listenerList.remove(FlashPlayerListener.class, flashPlayerListener);
    }

    public FlashPlayerListener[] getFlashPlayerListeners() {
        return (FlashPlayerListener[])this.listenerList.getListeners(FlashPlayerListener.class);
    }

    private void addReferenceClassLoader(ClassLoader classLoader) {
        if (classLoader == null || classLoader == this.getClass().getClassLoader() || this.referenceClassLoaderList.contains(classLoader)) {
            return;
        }
        this.referenceClassLoaderList.add(classLoader);
        WebServer.getDefaultWebServer().addReferenceClassLoader(classLoader);
    }

    protected void finalize() throws Throwable {
        for (ClassLoader classLoader : this.referenceClassLoaderList) {
            WebServer.getDefaultWebServer().removeReferenceClassLoader(classLoader);
        }
        this.referenceClassLoaderList.clear();
        super.finalize();
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.cleanup();
    }

    @Override
    public void disposeNativePeer() {
        super.disposeNativePeer();
        this.cleanup();
    }

    private void cleanup() {
        if (this.isNativePeerDisposed()) {
            this.webBrowserObject.load(null);
        }
    }

    static {
        WebServer.getDefaultWebServer().addContentProvider(new WebServer.WebServerContentProvider(){

            @Override
            public WebServer.WebServerContent getWebServerContent(WebServer.HTTPRequest hTTPRequest) {
                if ("/crossdomain.xml".equals(hTTPRequest.getResourcePath())) {
                    return new WebServer.WebServerContent(){

                        @Override
                        public InputStream getInputStream() {
                            return 1.getInputStream("<?xml version=\"1.0\"?>" + Utils.LINE_SEPARATOR + "<!DOCTYPE cross-domain-policy SYSTEM \"http://www.adobe.com/xml/dtds/cross-domain-policy.dtd\">" + Utils.LINE_SEPARATOR + "<cross-domain-policy>" + Utils.LINE_SEPARATOR + "  <site-control permitted-cross-domain-policies=\"all\"/>" + Utils.LINE_SEPARATOR + "  <allow-access-from domain=\"*\" secure=\"false\"/>" + Utils.LINE_SEPARATOR + "  <allow-http-request-headers-from domain=\"*\" headers=\"*\" secure=\"false\"/>" + Utils.LINE_SEPARATOR + "</cross-domain-policy>");
                        }
                    };
                }
                return null;
            }
        });
    }

    private static class NWebBrowserObject
    extends WebBrowserObject {
        private final JFlashPlayer flashPlayer;
        private final String LS = Utils.LINE_SEPARATOR;

        NWebBrowserObject(JFlashPlayer jFlashPlayer) {
            super(jFlashPlayer.webBrowser);
            this.flashPlayer = jFlashPlayer;
        }

        @Override
        protected WebBrowserObject.ObjectHTMLConfiguration getObjectHtmlConfiguration() {
            WebBrowserObject.ObjectHTMLConfiguration objectHTMLConfiguration = new WebBrowserObject.ObjectHTMLConfiguration();
            if (this.flashPlayer.options != null) {
                String string;
                Map<String, String> map = this.flashPlayer.options.getHTMLParameters();
                if (!map.containsKey("base") && (string = this.flashPlayer.webBrowserObject.getLoadedResource()) != null) {
                    int n = string.lastIndexOf(47);
                    map.put("base", string.substring(0, n + 1));
                }
                objectHTMLConfiguration.setHTMLParameters(map);
            }
            objectHTMLConfiguration.setWindowsClassID("D27CDB6E-AE6D-11cf-96B8-444553540000");
            objectHTMLConfiguration.setWindowsInstallationURL("http://fpdownload.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=9,0,0,0");
            objectHTMLConfiguration.setMimeType("application/x-shockwave-flash");
            objectHTMLConfiguration.setInstallationURL("http://www.adobe.com/go/getflashplayer");
            objectHTMLConfiguration.setWindowsParamName("movie");
            objectHTMLConfiguration.setParamName("src");
            return objectHTMLConfiguration;
        }

        @Override
        protected String getJavascriptDefinitions() {
            String string = this.flashPlayer.customJavascriptDefinitions;
            return "      function " + NWebBrowserObject.getEmbeddedObjectJavascriptName() + "_DoFSCommand(command, args) {" + this.LS + "        sendCommand(command, args);" + this.LS + "      }" + (string == null ? "" : this.LS + string);
        }

        @Override
        protected String getAdditionalHeadDefinitions() {
            return "    <script language=\"VBScript\">" + this.LS + "    <!-- " + this.LS + "    Sub " + NWebBrowserObject.getEmbeddedObjectJavascriptName() + "_FSCommand(ByVal command, ByVal args)" + this.LS + "      call " + NWebBrowserObject.getEmbeddedObjectJavascriptName() + "_DoFSCommand(command, args)" + this.LS + "    end sub" + this.LS + "    //-->" + this.LS + "    </script>";
        }

        @Override
        public String getLocalFileURL(File file) {
            if (Boolean.parseBoolean(NSSystemProperty.WEBSERVER_ACTIVATEOLDRESOURCEMETHOD.get())) {
                return WebServer.getDefaultWebServer().getResourcePathURL(this.encodeSpecialCharacters(file.getParent()), this.encodeSpecialCharacters(file.getName()));
            }
            return WebServer.getDefaultWebServer().getResourcePathURL(file.getParent(), file.getName());
        }

        private String encodeSpecialCharacters(String string) {
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < string.length(); ++i) {
                int n = string.charAt(i);
                boolean bl = false;
                if (!(n >= 97 && n <= 122 || n >= 65 && n <= 90 || n >= 48 && n <= 57)) {
                    switch (n) {
                        case 37: 
                        case 42: 
                        case 43: 
                        case 45: 
                        case 46: 
                        case 47: 
                        case 58: 
                        case 95: {
                            break;
                        }
                        case 92: {
                            if (!Utils.IS_WINDOWS) break;
                            n = 47;
                            break;
                        }
                        default: {
                            bl = true;
                        }
                    }
                }
                if (bl) {
                    stringBuilder.append(Utils.encodeURL(String.valueOf((char)n)));
                    continue;
                }
                stringBuilder.append((char)n);
            }
            return stringBuilder.toString();
        }
    }

    public static interface FlashPlayerDecoratorFactory {
        public FlashPlayerDecorator createFlashPlayerDecorator(JFlashPlayer var1, Component var2);
    }
}

