/*
 * Decompiled with CFR 0.152.
 */
package chrriis.dj.nativeswing.swtimpl;

import chrriis.common.ObjectRegistry;
import chrriis.common.Utils;
import chrriis.common.WebServer;
import chrriis.dj.nativeswing.swtimpl.EventDispatchUtils;
import chrriis.dj.nativeswing.swtimpl.LocalMessage;
import chrriis.dj.nativeswing.swtimpl.components.JWebBrowser;
import chrriis.dj.nativeswing.swtimpl.components.WebBrowserAdapter;
import chrriis.dj.nativeswing.swtimpl.components.WebBrowserCommandEvent;
import chrriis.dj.nativeswing.swtimpl.components.WebBrowserListener;
import java.awt.Color;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;

public abstract class WebBrowserObject {
    private final JWebBrowser webBrowser;
    private volatile int instanceID;
    private volatile String resourcePath;
    private volatile String backgroundColor;
    private static final String LS = Utils.LINE_SEPARATOR;
    private EventListenerList listenerList = new EventListenerList();

    public WebBrowserObject(JWebBrowser jWebBrowser) {
        this.webBrowser = jWebBrowser;
        jWebBrowser.getNativeComponent().setBackground(Color.WHITE);
        jWebBrowser.setDefaultPopupMenuRegistered(false);
        jWebBrowser.setBarsVisible(false);
        jWebBrowser.addWebBrowserListener(new WebBrowserAdapter(){

            @Override
            public void commandReceived(WebBrowserCommandEvent webBrowserCommandEvent) {
                if ("[Chrriis]WB_setLoaded".equals(webBrowserCommandEvent.getCommand())) {
                    Object[] objectArray = WebBrowserObject.this.listenerList.getListenerList();
                    for (int i = objectArray.length - 2; i >= 0; i -= 2) {
                        if (objectArray[i] != InitializationListener.class) continue;
                        ((InitializationListener)objectArray[i + 1]).objectInitialized();
                    }
                }
            }
        });
    }

    public String getLoadedResource() {
        return "".equals(this.resourcePath) ? null : this.resourcePath;
    }

    public boolean hasContent() {
        return this.resourcePath != null;
    }

    protected void finalize() throws Throwable {
        ObjectRegistry.getInstance().remove(this.instanceID);
        super.finalize();
    }

    public void load(String string) {
        this.backgroundColor = WebBrowserObject.getHexStringColor(this.webBrowser.getNativeComponent().getBackground());
        this.resourcePath = string;
        ObjectRegistry.getInstance().remove(this.instanceID);
        if (string == null) {
            if (!this.webBrowser.isNativePeerDisposed()) {
                this.webBrowser.setHTMLContent("");
            }
            return;
        }
        this.instanceID = ObjectRegistry.getInstance().add(this);
        String string2 = WebServer.getDefaultWebServer().getDynamicContentURL(WebBrowserObject.class.getName(), String.valueOf(this.instanceID), "html");
        final AtomicBoolean atomicBoolean = new AtomicBoolean();
        InitializationListener initializationListener = new InitializationListener(){

            @Override
            public void objectInitialized() {
                WebBrowserObject.this.removeInitializationListener(this);
                atomicBoolean.set(true);
            }
        };
        this.addInitializationListener(initializationListener);
        this.webBrowser.navigate(string2);
        this.webBrowser.getNativeComponent().runSync(new LocalMessage(){

            @Override
            public Object run(Object[] objectArray) {
                InitializationListener initializationListener = (InitializationListener)objectArray[0];
                final AtomicBoolean atomicBoolean = (AtomicBoolean)objectArray[1];
                EventDispatchUtils.sleepWithEventDispatch(new EventDispatchUtils.Condition(){

                    @Override
                    public boolean getValue() {
                        return atomicBoolean.get();
                    }
                }, 4000);
                WebBrowserObject.this.removeInitializationListener(initializationListener);
                return null;
            }
        }, initializationListener, atomicBoolean);
    }

    public String getLocalFileURL(File file) {
        try {
            return file.toURI().toURL().toExternalForm();
        }
        catch (Exception exception) {
            return WebServer.getDefaultWebServer().getResourcePathURL(file.getParent(), file.getName());
        }
    }

    public static String getEmbeddedObjectJavascriptName() {
        return "myEmbeddedObject";
    }

    protected static WebServer.WebServerContent getWebServerContent(WebServer.HTTPRequest hTTPRequest) {
        String string = hTTPRequest.getResourcePath();
        int n = string.indexOf(47);
        final int n2 = Integer.parseInt(string.substring(0, n));
        final WebBrowserObject webBrowserObject = (WebBrowserObject)ObjectRegistry.getInstance().get(n2);
        if (webBrowserObject == null) {
            return null;
        }
        String string2 = string = string.substring(n + 1);
        if ("html".equals(string2)) {
            final WebBrowserObject webBrowserObject2 = (WebBrowserObject)ObjectRegistry.getInstance().get(n2);
            if (webBrowserObject2 == null) {
                return new WebServer.WebServerContent(){

                    @Override
                    public InputStream getInputStream() {
                        return 4.getInputStream("<html><body></body></html>");
                    }
                };
            }
            return new WebServer.WebServerContent(){

                @Override
                public InputStream getInputStream() {
                    String string = webBrowserObject2.getJavascriptDefinitions();
                    string = string == null ? "" : string + LS;
                    String string2 = webBrowserObject2.getAdditionalHeadDefinitions();
                    string2 = string2 == null ? "" : string2 + LS;
                    String string3 = "<html>" + LS + "  <head>" + LS + "    <meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\"/>" + LS + "    <script language=\"JavaScript\" type=\"text/javascript\">" + LS + "      <!--" + LS + "      var sendCommand = " + "sendNSCommand" + ";" + LS + "      function postCommand(command) {" + LS + "        var elements = new Array();" + LS + "        for(var i=1; i<arguments.length; i++) {" + LS + "          var element = document.createElement('input');" + LS + "          element.type='text';" + LS + "          element.name='j_arg' + (i-1);" + LS + "          element.value=arguments[i];" + LS + "          document.createElement('j_arg' + (i-1));" + LS + "          elements[i-1] = element;" + LS + "          document.j_form.appendChild(element);" + LS + "        }" + LS + "        document.j_form.j_command.value = command;" + LS + "        document.j_form.submit();" + LS + "        for(var i=0; i<elements.length; i++) {" + LS + "          document.j_form.removeChild(elements[i]);" + LS + "        }" + LS + "      }" + LS + "      function getEmbeddedObject() {" + LS + "        var movieName = \"" + WebBrowserObject.getEmbeddedObjectJavascriptName() + "\";" + LS + "        if(window.document[movieName]) {" + LS + "          return window.document[movieName];" + LS + "        }" + LS + "        if(navigator.appName.indexOf(\"Microsoft Internet\") == -1) {" + LS + "          if(document.embeds && document.embeds[movieName]) {" + LS + "            return document.embeds[movieName];" + LS + "          }" + LS + "        } else {" + LS + "          return document.getElementById(movieName);" + LS + "        }" + LS + "      }" + LS + string + "      //-->" + LS + "    </script>" + LS + "    <style type=\"text/css\">" + LS + "      html { background-color: " + webBrowserObject.backgroundColor + "; }" + LS + "      html, object, embed, div, body, table { width: 100%; height: 100%; min-height: 100%; margin: 0; padding: 0; overflow: hidden; text-align: center; }" + LS + "      object, embed, div { position: absolute; left:0; top:0;}" + LS + "      td { vertical-align: middle; }" + LS + "    </style>" + LS + string2 + "  </head>" + LS + "  <body height=\"*\">" + LS + "    <iframe style=\"display:none;\" name=\"j_iframe\"></iframe>" + LS + "    <form style=\"display:none;\" name=\"j_form\" action=\"" + WebServer.getDefaultWebServer().getDynamicContentURL(WebBrowserObject.class.getName(), "postCommand/" + n2) + "\" method=\"POST\" target=\"j_iframe\">" + LS + "      <input name=\"j_command\" type=\"text\"></input>" + LS + "    </form>" + LS + "    <script src=\"" + WebServer.getDefaultWebServer().getDynamicContentURL(WebBrowserObject.class.getName(), String.valueOf(n2), "js") + "\"></script>" + LS + "  </body>" + LS + "</html>" + LS;
                    return 5.getInputStream(string3);
                }
            };
        }
        if ("js".equals(string2)) {
            String string3 = webBrowserObject.resourcePath;
            File file = Utils.getLocalFile(string3);
            if (file != null) {
                string3 = webBrowserObject.getLocalFileURL(file);
            }
            final String string4 = Utils.escapeXML(string3);
            final String string5 = Utils.encodeURL(string3);
            return new WebServer.WebServerContent(){

                @Override
                public String getContentType() {
                    return 6.getDefaultMimeType(".js");
                }

                @Override
                public InputStream getInputStream() {
                    String string;
                    String string2;
                    ObjectHTMLConfiguration objectHTMLConfiguration = webBrowserObject.getObjectHtmlConfiguration();
                    StringBuilder stringBuilder = new StringBuilder();
                    StringBuilder stringBuilder2 = new StringBuilder();
                    Map<String, String> map = objectHTMLConfiguration.getHTMLParameters();
                    HashMap hashMap = map == null ? new HashMap() : new HashMap<String, String>(map);
                    String string3 = objectHTMLConfiguration.getWindowsParamName();
                    String string42 = objectHTMLConfiguration.getParamName();
                    hashMap.remove("width");
                    hashMap.remove("height");
                    hashMap.remove("type");
                    hashMap.remove("name");
                    if (string3 != null) {
                        hashMap.remove(string3);
                    }
                    if (string42 != null) {
                        hashMap.remove(string42);
                    }
                    for (Map.Entry object2 : hashMap.entrySet()) {
                        string2 = Utils.escapeXML((String)object2.getKey());
                        string = Utils.escapeXML((String)object2.getValue());
                        stringBuilder2.append(' ').append(string2).append("=\"").append(string).append("\"");
                        stringBuilder.append("window.document.write('  <param name=\"").append(string2).append("\" value=\"").append(string).append("\"/>');" + LS);
                    }
                    String string52 = objectHTMLConfiguration.getVersion();
                    String string6 = string52 != null ? " version=\"" + (String)string52 + "\"" : "";
                    string2 = WebBrowserObject.getEmbeddedObjectJavascriptName();
                    string = "<!--" + LS + "window.document.write('<object classid=\"clsid:" + objectHTMLConfiguration.getWindowsClassID() + "\" id=\"" + string2 + "\" codebase=\"" + objectHTMLConfiguration.getWindowsInstallationURL() + "\" events=\"true\">');" + LS + (string3 == null ? "" : "window.document.write('  <param name=\"" + string3 + "\" value=\"' + decodeURIComponent('" + string5 + "') + '\"/>');" + LS) + stringBuilder + "window.document.write('  <embed" + stringBuilder2 + " name=\"" + string2 + "\"" + (string42 == null ? "" : " " + string42 + "=\"" + string4 + "\"") + " type=\"" + objectHTMLConfiguration.getMimeType() + "\" pluginspage=\"" + objectHTMLConfiguration.getInstallationURL() + "\"" + string6 + ">');" + LS + "window.document.write('  </embed>');" + LS + "window.document.write('</object>');" + LS + "var embeddedObject = getEmbeddedObject();" + LS + "embeddedObject.style.width = '100%';" + LS + "embeddedObject.style.height = '100%';" + LS + "sendCommand('[Chrriis]WB_setLoaded');" + LS + "window.document.attachEvent(\"onkeydown\", function() {" + LS + "  switch (event.keyCode) {" + LS + "    case 116 :" + LS + "      event.returnValue = false;" + LS + "      event.keyCode = 0;" + LS + "      break;" + LS + "  }" + LS + "});" + LS + "//-->" + LS;
                    return 6.getInputStream(string);
                }
            };
        }
        if ("postCommand".equals(string2)) {
            WebServer.HTTPData hTTPData = hTTPRequest.getHTTPPostDataArray()[0];
            Map<String, String> map = hTTPData.getHeaderMap();
            int n3 = map.size();
            final String string6 = map.get("j_command");
            final String[] stringArray = new String[n3 - 1];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = map.get("j_arg" + i);
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    WebBrowserListener[] webBrowserListenerArray = webBrowserObject.webBrowser.getWebBrowserListeners();
                    WebBrowserCommandEvent webBrowserCommandEvent = null;
                    for (int i = webBrowserListenerArray.length - 1; i >= 0; --i) {
                        if (webBrowserCommandEvent == null) {
                            webBrowserCommandEvent = new WebBrowserCommandEvent(webBrowserObject.webBrowser, string6, stringArray);
                        }
                        webBrowserListenerArray[i].commandReceived(webBrowserCommandEvent);
                    }
                }
            });
            return new WebServer.WebServerContent(){

                @Override
                public InputStream getInputStream() {
                    String string = "<html>" + LS + "  <body>" + LS + "    Command sent successfully." + LS + "  </body>" + LS + "</html>" + LS;
                    return 8.getInputStream(string);
                }
            };
        }
        final String string7 = string;
        return new WebServer.WebServerContent(){

            @Override
            public InputStream getInputStream() {
                try {
                    String string = webBrowserObject.resourcePath;
                    File file = Utils.getLocalFile(string);
                    if (file != null) {
                        string = webBrowserObject.getLocalFileURL(file);
                    }
                    string = string.substring(0, string.lastIndexOf(47)) + "/" + string7;
                    return new URL(string).openStream();
                }
                catch (Exception exception) {
                    return null;
                }
            }
        };
    }

    protected abstract ObjectHTMLConfiguration getObjectHtmlConfiguration();

    protected String getJavascriptDefinitions() {
        return null;
    }

    protected String getAdditionalHeadDefinitions() {
        return null;
    }

    private void addInitializationListener(InitializationListener initializationListener) {
        this.listenerList.add(InitializationListener.class, initializationListener);
    }

    private void removeInitializationListener(InitializationListener initializationListener) {
        this.listenerList.remove(InitializationListener.class, initializationListener);
    }

    public void setObjectProperty(String string, Object object) {
        this.webBrowser.executeJavascript("try {getEmbeddedObject()." + string + " = " + JWebBrowser.convertJavaObjectToJavascript(object) + ";} catch(exxxxx) {}");
    }

    public Object getObjectProperty(String string) {
        return this.webBrowser.executeJavascriptWithResult("return getEmbeddedObject()." + string);
    }

    public void invokeObjectFunction(String string, Object ... objectArray) {
        this.webBrowser.executeJavascript("try {getEmbeddedObject()." + JWebBrowser.createJavascriptFunctionCall(string, objectArray) + ";} catch(exxxxx) {}");
    }

    public Object invokeObjectFunctionWithResult(String string, Object ... objectArray) {
        return this.webBrowser.executeJavascriptWithResult("return getEmbeddedObject()." + JWebBrowser.createJavascriptFunctionCall(string, objectArray));
    }

    public void setBackground(Color color) {
        this.backgroundColor = WebBrowserObject.getHexStringColor(color);
        this.webBrowser.executeJavascript("document.bgColor = '" + this.backgroundColor + "';");
    }

    private static String getHexStringColor(Color color) {
        String string = Integer.toHexString(color.getRGB() & 0xFFFFFF).toUpperCase(Locale.ENGLISH);
        string = '#' + "000000".substring(string.length()) + string;
        return string;
    }

    private static interface InitializationListener
    extends EventListener {
        public void objectInitialized();
    }

    public static class ObjectHTMLConfiguration {
        private String windowsClassID;
        private String windowsInstallationURL;
        private String installationURL;
        private String version;
        private String windowsParamName;
        private String paramName;
        private Map<String, String> htmlParameters;
        private String mimeType;

        public void setWindowsClassID(String string) {
            this.windowsClassID = string;
        }

        public String getWindowsClassID() {
            return this.windowsClassID;
        }

        public String getWindowsInstallationURL() {
            return this.windowsInstallationURL;
        }

        public void setWindowsInstallationURL(String string) {
            this.windowsInstallationURL = string;
        }

        public String getInstallationURL() {
            return this.installationURL;
        }

        public void setInstallationURL(String string) {
            this.installationURL = string;
        }

        public String getVersion() {
            return this.version;
        }

        public void setVersion(String string) {
            this.version = string;
        }

        public String getWindowsParamName() {
            return this.windowsParamName;
        }

        public void setWindowsParamName(String string) {
            this.windowsParamName = string;
        }

        public String getParamName() {
            return this.paramName;
        }

        public void setParamName(String string) {
            this.paramName = string;
        }

        public Map<String, String> getHTMLParameters() {
            return this.htmlParameters;
        }

        public void setHTMLParameters(Map<String, String> map) {
            this.htmlParameters = map;
        }

        public String getMimeType() {
            return this.mimeType;
        }

        public void setMimeType(String string) {
            this.mimeType = string;
        }
    }
}

