/*
 * Decompiled with CFR 0.152.
 */
package chrriis.dj.nativeswing;

import chrriis.common.SystemProperty;
import chrriis.common.Utils;
import chrriis.dj.nativeswing.NSSystemProperty;
import chrriis.dj.nativeswing.NativeComponentProxy;
import chrriis.dj.nativeswing.NativeComponentWrapper;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.event.AWTEventListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.io.BufferedReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.swing.SwingUtilities;

public class NativeSwing {
    private static volatile List<NativeComponentWrapper> nativeComponentWrapperList;
    private static List<Window> windowList;
    private static volatile boolean isInitialized;
    private static volatile boolean isHeavyWeightForcerEnabled;

    static NativeComponentWrapper[] getNativeComponentWrappers() {
        if (nativeComponentWrapperList == null) {
            return new NativeComponentWrapper[0];
        }
        return nativeComponentWrapperList.toArray(new NativeComponentWrapper[0]);
    }

    static void addNativeComponentWrapper(NativeComponentWrapper nativeComponentWrapper) {
        NativeSwing.checkInitialized();
        if (nativeComponentWrapperList == null) {
            nativeComponentWrapperList = new ArrayList<NativeComponentWrapper>();
        }
        nativeComponentWrapperList.add(nativeComponentWrapper);
        if (!isHeavyWeightForcerEnabled) {
            HeavyweightForcer.activate(nativeComponentWrapper.getNativeComponent());
        }
    }

    static boolean removeNativeComponentWrapper(NativeComponentWrapper nativeComponentWrapper) {
        if (nativeComponentWrapperList == null) {
            return false;
        }
        return nativeComponentWrapperList.remove(nativeComponentWrapper);
    }

    static Window[] getWindows() {
        return windowList == null ? new Window[]{} : windowList.toArray(new Window[0]);
    }

    private static boolean isInitialized() {
        return isInitialized;
    }

    private static void checkInitialized() {
        if (!NativeSwing.isInitialized()) {
            throw new IllegalStateException("The Native Swing framework is not initialized! Please refer to the instructions to set it up properly.");
        }
    }

    private static void loadClipboardDebuggingProperties() {
        try {
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            if (!clipboard.isDataFlavorAvailable(DataFlavor.stringFlavor)) {
                return;
            }
            BufferedReader bufferedReader = new BufferedReader(new StringReader((String)clipboard.getData(DataFlavor.stringFlavor)));
            if ("[nativeswing debug]".equals(bufferedReader.readLine().trim().toLowerCase(Locale.ENGLISH))) {
                String string;
                while ((string = bufferedReader.readLine()) != null) {
                    if (string.length() == 0) continue;
                    int n = string.indexOf(61);
                    if (n <= 0) break;
                    String string2 = string.substring(0, n).trim();
                    String string3 = string.substring(n + 1).trim();
                    if (!string2.startsWith("nativeswing.")) continue;
                    System.setProperty(string2, string3);
                }
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void initialize() {
        boolean bl;
        if (NativeSwing.isInitialized()) {
            return;
        }
        NativeSwing.loadClipboardDebuggingProperties();
        SystemProperty.SUN_AWT_NOERASEBACKGROUND.set("true");
        SystemProperty.SUN_AWT_XEMBEDSERVER.set("true");
        NSSystemProperty.JNA_FORCE_HW_POPUP.set("false");
        if (SystemProperty.JAVAWEBSTART_VERSION.get() != null && SystemProperty.JAVA_VERSION.get().compareTo("1.6.0_18") >= 0) {
            if (SystemProperty.SUN_AWT_DISABLEMIXING.get() == null) {
                System.err.println("Under WebStart on Java >= 1.6.0_18, the value of the \"" + SystemProperty.SUN_AWT_DISABLEMIXING.getName() + "\" system property needs to be defined in the JNLP descriptor with value \"true\" (or \"false\" if you really want the default behavior). When not set to \"true\", the content of the native components may not be displayed.");
                SystemProperty.SUN_AWT_DISABLEMIXING.set("false");
            }
        } else if (SystemProperty.SUN_AWT_DISABLEMIXING.get() == null) {
            SystemProperty.SUN_AWT_DISABLEMIXING.set("true");
        }
        isHeavyWeightForcerEnabled = bl = !"true".equals(SystemProperty.SUN_AWT_DISABLEMIXING.get()) && SystemProperty.JAVA_VERSION.get().compareTo("1.6.0_12") >= 0;
        NSSystemProperty.INTEGRATION_USEDEFAULTCLIPPING.set(String.valueOf(bl));
        long l = 65L;
        if (Utils.IS_JAVA_7_OR_GREATER) {
            l |= 0x14L;
        }
        Toolkit.getDefaultToolkit().addAWTEventListener(new NIAWTEventListener(), l);
        isInitialized = true;
    }

    private NativeSwing() {
    }

    private static class NIAWTEventListener
    implements AWTEventListener {
        private List<Dialog> dialogList = new ArrayList<Dialog>();
        private volatile Set<Window> blockedWindowSet = new HashSet<Window>();

        private NIAWTEventListener() {
        }

        private static boolean isDescendant(Window window, Window window2) {
            while (window != null) {
                if (window == window2) {
                    return true;
                }
                window = window.getOwner();
            }
            return false;
        }

        private void computeBlockedDialogs() {
            int n;
            Object object;
            boolean bl;
            this.blockedWindowSet.clear();
            Window[] windowArray = NativeSwing.getWindows();
            ArrayList<Dialog> arrayList = new ArrayList<Dialog>();
            for (Dialog window2 : this.dialogList) {
                if (!window2.isVisible()) continue;
                bl = false;
                if (Utils.IS_JAVA_6_OR_GREATER) {
                    switch (window2.getModalityType()) {
                        case APPLICATION_MODAL: 
                        case TOOLKIT_MODAL: {
                            bl = true;
                        }
                    }
                } else if (window2.isModal()) {
                    bl = true;
                }
                if (!bl) continue;
                arrayList.add(window2);
            }
            if (!arrayList.isEmpty()) {
                for (int i = 0; i < windowArray.length; ++i) {
                    Window window = windowArray[i];
                    bl = false;
                    object = arrayList.iterator();
                    while (object.hasNext()) {
                        Dialog dialog = (Dialog)object.next();
                        if (window != dialog && !NIAWTEventListener.isDescendant(window, dialog)) {
                            bl = true;
                            for (n = 0; n < i; ++n) {
                                if (windowArray[n] != dialog) continue;
                                bl = false;
                                break;
                            }
                            if (bl && Utils.IS_JAVA_6_OR_GREATER) {
                                switch (window.getModalExclusionType()) {
                                    case APPLICATION_EXCLUDE: 
                                    case TOOLKIT_EXCLUDE: {
                                        bl = false;
                                    }
                                }
                            }
                        }
                        if (!bl) continue;
                        break;
                    }
                    if (!bl) continue;
                    this.blockedWindowSet.add(window);
                }
            }
            if (Utils.IS_JAVA_6_OR_GREATER) {
                block13: for (int i = this.dialogList.size() - 1; i >= 0; --i) {
                    Dialog dialog = this.dialogList.get(i);
                    if (!dialog.isVisible() || this.blockedWindowSet.contains(dialog)) continue;
                    switch (dialog.getModalityType()) {
                        case DOCUMENT_MODAL: {
                            Object object2 = dialog.getOwner();
                            for (object = object2; object != null; object = object.getOwner()) {
                                object2 = object;
                            }
                            if (object2 == null) continue block13;
                            object = windowArray;
                            int n2 = ((Window[])object).length;
                            for (n = 0; n < n2; ++n) {
                                Window window = object[n];
                                if (window == dialog || NIAWTEventListener.isDescendant(window, dialog) || window != object2 && !NIAWTEventListener.isDescendant(window, (Window)object2)) continue;
                                this.blockedWindowSet.add(window);
                            }
                            continue block13;
                        }
                    }
                }
            }
        }

        private void adjustNativeComponents() {
            if (nativeComponentWrapperList == null) {
                return;
            }
            for (int i = nativeComponentWrapperList.size() - 1; i >= 0; --i) {
                Component component;
                NativeComponentWrapper nativeComponentWrapper = (NativeComponentWrapper)nativeComponentWrapperList.get(i);
                Component component2 = component = nativeComponentWrapper.getNativeComponent();
                NativeComponentProxy nativeComponentProxy = nativeComponentWrapper.getNativeComponentProxy();
                if (nativeComponentProxy != null) {
                    component2 = nativeComponentProxy;
                }
                Window window = SwingUtilities.getWindowAncestor(component2);
                boolean bl = this.blockedWindowSet.contains(window);
                boolean bl2 = component2.isShowing();
                nativeComponentWrapper.setNativeComponentEnabled(!bl && bl2);
                if (Utils.IS_MAC || bl2 || !component.hasFocus()) continue;
                component.transferFocus();
            }
        }

        @Override
        public void eventDispatched(AWTEvent aWTEvent) {
            Window window;
            int n = aWTEvent.getID();
            if (Utils.IS_JAVA_7_OR_GREATER) {
                switch (n) {
                    case 501: 
                    case 1004: {
                        if (nativeComponentWrapperList == null) {
                            return;
                        }
                        for (int i = nativeComponentWrapperList.size() - 1; i >= 0; --i) {
                            NativeComponentWrapper nativeComponentWrapper = (NativeComponentWrapper)nativeComponentWrapperList.get(i);
                            if (!nativeComponentWrapper.isNativeComponentEnabled()) continue;
                            nativeComponentWrapper.setNativeComponentEnabled(false);
                            nativeComponentWrapper.setNativeComponentEnabled(true);
                        }
                        return;
                    }
                }
            }
            boolean bl = false;
            switch (n) {
                case 102: 
                case 103: {
                    bl = true;
                }
            }
            if (aWTEvent.getSource() instanceof Window) {
                if (windowList == null) {
                    windowList = new ArrayList();
                }
                switch (n) {
                    case 102: 
                    case 200: {
                        window = (Window)aWTEvent.getSource();
                        windowList.remove(window);
                        windowList.add(window);
                        break;
                    }
                    case 103: 
                    case 202: {
                        windowList.remove(aWTEvent.getSource());
                    }
                }
            }
            if (aWTEvent.getSource() instanceof Dialog) {
                switch (n) {
                    case 102: 
                    case 200: {
                        window = (Dialog)aWTEvent.getSource();
                        this.dialogList.remove(window);
                        this.dialogList.add((Dialog)window);
                        break;
                    }
                    case 103: 
                    case 202: {
                        this.dialogList.remove(aWTEvent.getSource());
                    }
                }
                switch (n) {
                    case 102: 
                    case 103: 
                    case 200: 
                    case 202: {
                        this.computeBlockedDialogs();
                        bl = true;
                    }
                }
            }
            if (bl) {
                this.adjustNativeComponents();
            }
            switch (n) {
                case 208: {
                    if (!(aWTEvent.getSource() instanceof Dialog) || !(window = (Dialog)aWTEvent.getSource()).getFocusableWindowState()) break;
                    window.setFocusableWindowState(false);
                    Thread thread = new Thread("Dialog focus fixer", (Dialog)window){
                        final /* synthetic */ Dialog val$d;
                        {
                            this.val$d = dialog;
                            super(string);
                        }

                        @Override
                        public void run() {
                            try {
                                1.sleep(125L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    val$d.setFocusableWindowState(true);
                                }
                            });
                        }
                    };
                    thread.setDaemon(true);
                    thread.start();
                    break;
                }
            }
        }
    }

    private static class HeavyweightForcer
    implements HierarchyListener {
        private Component component;
        private HeavyweightForcerWindow forcer;

        private HeavyweightForcer(Component component) {
            this.component = component;
            if (component.isShowing()) {
                this.createForcer();
            }
        }

        public static void activate(Component component) {
            component.addHierarchyListener(new HeavyweightForcer(component));
        }

        private void destroyForcer() {
            if (!SwingUtilities.isEventDispatchThread()) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        HeavyweightForcer.this.destroyForcer();
                    }
                });
                return;
            }
            if (this.forcer == null) {
                return;
            }
            int n = this.forcer.getCount() - 1;
            this.forcer.setCount(n);
            if (n == 0) {
                this.forcer.dispose();
            }
            this.forcer = null;
        }

        private void createForcer() {
            if (!SwingUtilities.isEventDispatchThread()) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        HeavyweightForcer.this.createForcer();
                    }
                });
                return;
            }
            Window window = SwingUtilities.getWindowAncestor(this.component);
            if (window == null) {
                return;
            }
            for (Window window2 : window.getOwnedWindows()) {
                if (!(window2 instanceof HeavyweightForcerWindow)) continue;
                this.forcer = (HeavyweightForcerWindow)window2;
                break;
            }
            if (this.forcer == null) {
                this.forcer = new HeavyweightForcerWindow(window);
            }
            this.forcer.setCount(this.forcer.getCount() + 1);
        }

        @Override
        public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
            long l = hierarchyEvent.getChangeFlags();
            if ((l & 2L) != 0L) {
                if (!this.component.isDisplayable()) {
                    this.component.removeHierarchyListener(this);
                    this.destroyForcer();
                }
            } else if ((l & 4L) != 0L) {
                if (this.component.isShowing()) {
                    this.createForcer();
                } else {
                    this.destroyForcer();
                }
            }
        }
    }

    private static class HeavyweightForcerWindow
    extends Window {
        private boolean isPacked;
        private int count;

        public HeavyweightForcerWindow(Window window) {
            super(window);
            this.pack();
            this.isPacked = true;
        }

        @Override
        public boolean isVisible() {
            return this.isPacked;
        }

        @Override
        public Rectangle getBounds() {
            Window window = this.getOwner();
            return window == null ? super.getBounds() : window.getBounds();
        }

        public void setCount(int n) {
            this.count = n;
        }

        public int getCount() {
            return this.count;
        }
    }
}

