/*
 * Decompiled with CFR 0.152.
 */
package android.util;

import java.util.Random;

public final class MathUtils {
    private static final Random sRandom = new Random();
    private static final float DEG_TO_RAD = (float)Math.PI / 180;
    private static final float RAD_TO_DEG = 57.295784f;

    private MathUtils() {
    }

    public static float abs(float f) {
        return f > 0.0f ? f : -f;
    }

    public static int constrain(int n, int n2, int n3) {
        return n < n2 ? n2 : (n > n3 ? n3 : n);
    }

    public static long constrain(long l, long l2, long l3) {
        return l < l2 ? l2 : (l > l3 ? l3 : l);
    }

    public static float constrain(float f, float f2, float f3) {
        return f < f2 ? f2 : (f > f3 ? f3 : f);
    }

    public static float log(float f) {
        return (float)Math.log(f);
    }

    public static float exp(float f) {
        return (float)Math.exp(f);
    }

    public static float pow(float f, float f2) {
        return (float)Math.pow(f, f2);
    }

    public static float max(float f, float f2) {
        return f > f2 ? f : f2;
    }

    public static float max(int n, int n2) {
        return n > n2 ? (float)n : (float)n2;
    }

    public static float max(float f, float f2, float f3) {
        return f > f2 ? (f > f3 ? f : f3) : (f2 > f3 ? f2 : f3);
    }

    public static float max(int n, int n2, int n3) {
        return n > n2 ? (float)(n > n3 ? n : n3) : (float)(n2 > n3 ? n2 : n3);
    }

    public static float min(float f, float f2) {
        return f < f2 ? f : f2;
    }

    public static float min(int n, int n2) {
        return n < n2 ? (float)n : (float)n2;
    }

    public static float min(float f, float f2, float f3) {
        return f < f2 ? (f < f3 ? f : f3) : (f2 < f3 ? f2 : f3);
    }

    public static float min(int n, int n2, int n3) {
        return n < n2 ? (float)(n < n3 ? n : n3) : (float)(n2 < n3 ? n2 : n3);
    }

    public static float dist(float f, float f2, float f3, float f4) {
        float f5 = f3 - f;
        float f6 = f4 - f2;
        return (float)Math.sqrt(f5 * f5 + f6 * f6);
    }

    public static float dist(float f, float f2, float f3, float f4, float f5, float f6) {
        float f7 = f4 - f;
        float f8 = f5 - f2;
        float f9 = f6 - f3;
        return (float)Math.sqrt(f7 * f7 + f8 * f8 + f9 * f9);
    }

    public static float mag(float f, float f2) {
        return (float)Math.sqrt(f * f + f2 * f2);
    }

    public static float mag(float f, float f2, float f3) {
        return (float)Math.sqrt(f * f + f2 * f2 + f3 * f3);
    }

    public static float sq(float f) {
        return f * f;
    }

    public static float radians(float f) {
        return f * ((float)Math.PI / 180);
    }

    public static float degrees(float f) {
        return f * 57.295784f;
    }

    public static float acos(float f) {
        return (float)Math.acos(f);
    }

    public static float asin(float f) {
        return (float)Math.asin(f);
    }

    public static float atan(float f) {
        return (float)Math.atan(f);
    }

    public static float atan2(float f, float f2) {
        return (float)Math.atan2(f, f2);
    }

    public static float tan(float f) {
        return (float)Math.tan(f);
    }

    public static float lerp(float f, float f2, float f3) {
        return f + (f2 - f) * f3;
    }

    public static float norm(float f, float f2, float f3) {
        return (f3 - f) / (f2 - f);
    }

    public static float map(float f, float f2, float f3, float f4, float f5) {
        return f3 + (f3 - f4) * ((f5 - f) / (f2 - f));
    }

    public static int random(int n) {
        return (int)(sRandom.nextFloat() * (float)n);
    }

    public static int random(int n, int n2) {
        if (n >= n2) {
            return n;
        }
        return (int)(sRandom.nextFloat() * (float)(n2 - n) + (float)n);
    }

    public static float random(float f) {
        return sRandom.nextFloat() * f;
    }

    public static float random(float f, float f2) {
        if (f >= f2) {
            return f;
        }
        return sRandom.nextFloat() * (f2 - f) + f;
    }

    public static void randomSeed(long l) {
        sRandom.setSeed(l);
    }
}

