/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.util.MathUtils;
import java.util.HashMap;
import java.util.Locale;

public class Color {
    public static final int BLACK = -16777216;
    public static final int DKGRAY = -12303292;
    public static final int GRAY = -7829368;
    public static final int LTGRAY = -3355444;
    public static final int WHITE = -1;
    public static final int RED = -65536;
    public static final int GREEN = -16711936;
    public static final int BLUE = -16776961;
    public static final int YELLOW = -256;
    public static final int CYAN = -16711681;
    public static final int MAGENTA = -65281;
    public static final int TRANSPARENT = 0;
    private static final HashMap<String, Integer> sColorNameMap = new HashMap();

    public static int alpha(int n) {
        return n >>> 24;
    }

    public static int red(int n) {
        return n >> 16 & 0xFF;
    }

    public static int green(int n) {
        return n >> 8 & 0xFF;
    }

    public static int blue(int n) {
        return n & 0xFF;
    }

    public static int rgb(int n, int n2, int n3) {
        return 0xFF000000 | n << 16 | n2 << 8 | n3;
    }

    public static int argb(int n, int n2, int n3, int n4) {
        return n << 24 | n2 << 16 | n3 << 8 | n4;
    }

    public static float hue(int n) {
        float f;
        int n2;
        int n3 = n & 0xFF;
        int n4 = n >> 16 & 0xFF;
        int n5 = n >> 8 & 0xFF;
        int n6 = Math.max(n3, Math.max(n4, n5));
        if (n6 == (n2 = Math.min(n3, Math.min(n4, n5)))) {
            f = 0.0f;
        } else {
            float f2 = n6 - n2;
            float f3 = (float)(n6 - n4) / f2;
            float f4 = (float)(n6 - n5) / f2;
            float f5 = (float)(n6 - n3) / f2;
            f = n4 == n6 ? f5 - f4 : (n5 == n6 ? 2.0f + f3 - f5 : 4.0f + f4 - f3);
            if ((f /= 6.0f) < 0.0f) {
                f += 1.0f;
            }
        }
        return f;
    }

    public static float saturation(int n) {
        int n2;
        int n3 = n & 0xFF;
        int n4 = n >> 16 & 0xFF;
        int n5 = n >> 8 & 0xFF;
        int n6 = Math.max(n3, Math.max(n4, n5));
        float f = n6 == (n2 = Math.min(n3, Math.min(n4, n5))) ? 0.0f : (float)(n6 - n2) / (float)n6;
        return f;
    }

    public static float brightness(int n) {
        int n2 = n >> 16 & 0xFF;
        int n3 = n >> 8 & 0xFF;
        int n4 = n & 0xFF;
        int n5 = Math.max(n4, Math.max(n2, n3));
        return (float)n5 / 255.0f;
    }

    public static int parseColor(String string) {
        if (string.charAt(0) == '#') {
            long l = Long.parseLong(string.substring(1), 16);
            if (string.length() == 7) {
                l |= 0xFFFFFFFFFF000000L;
            } else if (string.length() != 9) {
                throw new IllegalArgumentException("Unknown color");
            }
            return (int)l;
        }
        Integer n = sColorNameMap.get(string.toLowerCase(Locale.US));
        if (n != null) {
            return n;
        }
        throw new IllegalArgumentException("Unknown color");
    }

    public static int HSBtoColor(float[] fArray) {
        return Color.HSBtoColor(fArray[0], fArray[1], fArray[2]);
    }

    public static int HSBtoColor(float f, float f2, float f3) {
        f = MathUtils.constrain(f, 0.0f, 1.0f);
        f2 = MathUtils.constrain(f2, 0.0f, 1.0f);
        f3 = MathUtils.constrain(f3, 0.0f, 1.0f);
        float f4 = 0.0f;
        float f5 = 0.0f;
        float f6 = 0.0f;
        float f7 = (f - (float)((int)f)) * 6.0f;
        int n = (int)f7;
        float f8 = f7 - (float)n;
        float f9 = f3 * (1.0f - f2);
        float f10 = f3 * (1.0f - f2 * f8);
        float f11 = f3 * (1.0f - f2 * (1.0f - f8));
        switch (n) {
            case 0: {
                f4 = f3;
                f5 = f11;
                f6 = f9;
                break;
            }
            case 1: {
                f4 = f10;
                f5 = f3;
                f6 = f9;
                break;
            }
            case 2: {
                f4 = f9;
                f5 = f3;
                f6 = f11;
                break;
            }
            case 3: {
                f4 = f9;
                f5 = f10;
                f6 = f3;
                break;
            }
            case 4: {
                f4 = f11;
                f5 = f9;
                f6 = f3;
                break;
            }
            case 5: {
                f4 = f3;
                f5 = f9;
                f6 = f10;
            }
        }
        return 0xFF000000 | (int)(f4 * 255.0f) << 16 | (int)(f5 * 255.0f) << 8 | (int)(f6 * 255.0f);
    }

    public static void RGBToHSV(int n, int n2, int n3, float[] fArray) {
        if (fArray.length < 3) {
            throw new RuntimeException("3 components required for hsv");
        }
        Color.nativeRGBToHSV(n, n2, n3, fArray);
    }

    public static void colorToHSV(int n, float[] fArray) {
        Color.RGBToHSV(n >> 16 & 0xFF, n >> 8 & 0xFF, n & 0xFF, fArray);
    }

    public static int HSVToColor(float[] fArray) {
        return Color.HSVToColor(255, fArray);
    }

    public static int HSVToColor(int n, float[] fArray) {
        if (fArray.length < 3) {
            throw new RuntimeException("3 components required for hsv");
        }
        return Color.nativeHSVToColor(n, fArray);
    }

    private static native void nativeRGBToHSV(int var0, int var1, int var2, float[] var3);

    private static native int nativeHSVToColor(int var0, float[] var1);

    static {
        sColorNameMap.put("black", -16777216);
        sColorNameMap.put("darkgray", -12303292);
        sColorNameMap.put("gray", -7829368);
        sColorNameMap.put("lightgray", -3355444);
        sColorNameMap.put("white", -1);
        sColorNameMap.put("red", -65536);
        sColorNameMap.put("green", -16711936);
        sColorNameMap.put("blue", -16776961);
        sColorNameMap.put("yellow", -256);
        sColorNameMap.put("cyan", -16711681);
        sColorNameMap.put("magenta", -65281);
    }
}

