/*
 * Decompiled with CFR 0.152.
 */
package dnl.confij.ini;

import dnl.confij.BaseConfigurationSource;
import dnl.confij.ConfigException;
import dnl.confij.ConfigParam;
import dnl.confij.ConfigSection;
import dnl.confij.Configuration;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.ini4j.Ini;

public class IniConfigurationSource
extends BaseConfigurationSource {
    private Ini ini;

    public IniConfigurationSource(File iniFile) {
        super(iniFile);
    }

    protected void loadConfigurationImpl(Configuration config) throws ConfigException {
        try {
            this.ini = new Ini((Reader)new FileReader(this.getConfigFile()));
        }
        catch (Exception e) {
            throw new ConfigException(e);
        }
        Collection iniSections = this.ini.values();
        for (Ini.Section section : iniSections) {
            ConfigSection cs = new ConfigSection(section.getName());
            config.addSection(cs);
            Set sectionEntries = section.entrySet();
            for (Map.Entry entry : sectionEntries) {
                cs.setParamValue((String)entry.getKey(), (String)entry.getValue());
            }
        }
    }

    protected void saveConfigurationImpl(Configuration config) throws ConfigException {
        this.ini.clear();
        Collection<ConfigSection> sections = config.getSections();
        for (ConfigSection section : sections) {
            Ini.Section sect = this.ini.add(section.getName());
            Collection<ConfigParam> configParameters = section.getConfigParameters();
            for (ConfigParam configParam : configParameters) {
                sect.put((Object)configParam.getName(), (Object)configParam.getValue());
            }
        }
        try {
            this.ini.store((Writer)new FileWriter(this.getConfigFile()));
        }
        catch (IOException e) {
            throw new ConfigException(e);
        }
    }
}

