/*
 * Decompiled with CFR 0.152.
 */
package dnl.confij;

import dnl.confij.ValueConverter;
import dnl.confij.c9s.BooleanConversion;
import dnl.confij.c9s.ColorConversion;
import dnl.confij.c9s.DoubleConversion;
import dnl.confij.c9s.IntegerConversion;
import dnl.confij.c9s.LongConversion;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConvertersRegistry {
    private Map<Class<?>, ValueConverter> converters = new HashMap();
    private static ConvertersRegistry instance;

    public static synchronized ConvertersRegistry getInstance() {
        if (instance == null) {
            instance = new ConvertersRegistry();
            ConvertersRegistry.registerDefaultConverters();
        }
        return instance;
    }

    private static void registerDefaultConverters() {
        ValueConverter[] defaultConverters;
        for (ValueConverter converter : defaultConverters = new ValueConverter[]{new ColorConversion(), new IntegerConversion(), new BooleanConversion(), new DoubleConversion(), new LongConversion()}) {
            for (Class<?> type : converter.getSupportedTypes()) {
                instance.register(type, converter);
            }
        }
    }

    public void register(Class<?> clazz, ValueConverter converter) {
        this.converters.put(clazz, converter);
    }

    public void unRegister(Class<?> clazz) {
        this.converters.remove(clazz);
    }

    public ValueConverter getConverter(Class<?> clazz) {
        return this.converters.get(clazz);
    }
}

