/*
 * Decompiled with CFR 0.152.
 */
package dnl.confij;

import dnl.confij.ConfigException;
import dnl.confij.ConfigSection;
import dnl.confij.ConfigurationSource;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Configuration {
    protected Map<String, ConfigSection> sectionsMap = new HashMap<String, ConfigSection>();
    protected ConfigurationSource configSource;

    public void addSection(ConfigSection section) {
        this.sectionsMap.put(section.getName(), section);
    }

    public void removeSection(ConfigSection section) {
        this.sectionsMap.remove(section.getName());
    }

    public void removeSection(String sectionName) {
        this.sectionsMap.remove(sectionName);
    }

    public ConfigSection getSection(String sectionName) {
        return this.sectionsMap.get(sectionName);
    }

    public ConfigSection getOrCreateSection(String sectionName) {
        ConfigSection configSection = this.sectionsMap.get(sectionName);
        if (configSection == null) {
            configSection = new ConfigSection(sectionName);
            this.addSection(configSection);
        }
        return configSection;
    }

    public Collection<ConfigSection> getSections() {
        return this.sectionsMap.values();
    }

    public ConfigurationSource getSource() {
        return this.configSource;
    }

    public void loadConfiguration() throws ConfigException {
        this.configSource.loadConfiguration(this);
    }

    public void saveConfiguration() throws ConfigException {
        this.configSource.saveConfiguration(this);
    }
}

