/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.language.updaters;

import com.alee.managers.hotkey.HotkeyInfo;
import com.alee.managers.language.data.Value;
import com.alee.managers.language.updaters.LanguageUpdater;
import java.awt.Component;
import java.lang.reflect.ParameterizedType;
import java.util.Map;
import java.util.WeakHashMap;

public abstract class DefaultLanguageUpdater<E extends Component>
implements LanguageUpdater<E> {
    public static final String INPUT_PROMPT = "inputPropmt";
    public static final String DROP_TEXT = "dropText";
    private static Map<Component, HotkeyInfo> hotkeysCache = new WeakHashMap<Component, HotkeyInfo>();

    @Override
    public Class getComponentClass() {
        try {
            return (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    protected static void cacheHotkey(Component component, HotkeyInfo hotkeyInfo) {
        hotkeysCache.put(component, hotkeyInfo);
    }

    protected static boolean isHotkeyCached(Component component) {
        return hotkeysCache.containsKey(component);
    }

    protected static HotkeyInfo getCachedHotkey(Component component) {
        return hotkeysCache.get(component);
    }

    protected String getDefaultText(Value value, Object ... objectArray) {
        return this.getDefaultText(null, value, objectArray);
    }

    protected String getDefaultText(String string, Value value, Object ... objectArray) {
        return this.getDefaultText(string, false, value, objectArray);
    }

    protected String getDefaultText(String string, boolean bl, Value value, Object ... objectArray) {
        String string2 = value.getText(string, bl);
        return objectArray != null && string2 != null ? this.formatDefaultText(string2, objectArray) : string2;
    }

    private String formatDefaultText(String string, Object[] objectArray) {
        return String.format(string, objectArray);
    }
}

