/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.toolbar;

import com.alee.extended.layout.ToolbarLayout;
import com.alee.extended.painter.Painter;
import com.alee.laf.StyleConstants;
import com.alee.laf.rootpane.WebDialog;
import com.alee.laf.toolbar.ToolbarStyle;
import com.alee.laf.toolbar.WebToolbarStyle;
import com.alee.utils.LafUtils;
import com.alee.utils.SwingUtils;
import com.alee.utils.laf.ShapeProvider;
import com.alee.utils.swing.AncestorAdapter;
import java.awt.Color;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LinearGradientPaint;
import java.awt.Shape;
import java.awt.Window;
import java.awt.event.WindowListener;
import java.awt.geom.RoundRectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.JToolBar;
import javax.swing.RootPaneContainer;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicToolBarUI;

public class WebToolBarUI
extends BasicToolBarUI
implements ShapeProvider {
    public static final int gripperSpace = 5;
    private Color topBgColor = WebToolbarStyle.topBgColor;
    private Color bottomBgColor = WebToolbarStyle.bottomBgColor;
    private Color borderColor = WebToolbarStyle.borderColor;
    private Color disabledBorderColor = WebToolbarStyle.disabledBorderColor;
    private boolean undecorated = WebToolbarStyle.undecorated;
    private int round = WebToolbarStyle.round;
    private int shadeWidth = WebToolbarStyle.shadeWidth;
    private Insets margin = WebToolbarStyle.margin;
    private int spacing = WebToolbarStyle.spacing;
    private ToolbarStyle toolbarStyle = WebToolbarStyle.toolbarStyle;
    private Painter painter = WebToolbarStyle.painter;
    private AncestorListener ancestorListener;
    private PropertyChangeListener propertyChangeListener;
    private PropertyChangeListener componentOrientationListener;
    private Color color = new Color(158, 158, 158);
    private Color transparent = new Color(0, 0, 0, 0);
    private Color[] gradient = new Color[]{this.transparent, this.color, this.color, this.transparent};
    private float[] fractions = new float[]{0.0f, 0.33f, 0.66f, 1.0f};

    public static ComponentUI createUI(JComponent jComponent) {
        return new WebToolBarUI();
    }

    @Override
    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        SwingUtils.setOrientation(this.toolBar);
        this.toolBar.setOpaque(false);
        this.updateBorder(this.toolBar);
        this.updateLayout(this.toolBar);
        this.ancestorListener = new AncestorAdapter(){

            @Override
            public void ancestorAdded(AncestorEvent ancestorEvent) {
                WebToolBarUI.this.updateBorder(WebToolBarUI.this.toolBar);
                WebToolBarUI.this.updateLayout(WebToolBarUI.this.toolBar);
            }
        };
        this.toolBar.addAncestorListener(this.ancestorListener);
        this.propertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                WebToolBarUI.this.updateBorder(WebToolBarUI.this.toolBar);
                WebToolBarUI.this.updateLayout(WebToolBarUI.this.toolBar);
            }
        };
        this.toolBar.addPropertyChangeListener("floatable", this.propertyChangeListener);
        this.componentOrientationListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                WebToolBarUI.this.updateBorder(WebToolBarUI.this.toolBar);
            }
        };
        this.toolBar.addPropertyChangeListener("componentOrientation", this.componentOrientationListener);
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        jComponent.removeAncestorListener(this.ancestorListener);
        jComponent.removePropertyChangeListener("floatable", this.propertyChangeListener);
        jComponent.removePropertyChangeListener("componentOrientation", this.componentOrientationListener);
        super.uninstallUI(jComponent);
    }

    @Override
    public Shape provideShape() {
        if (this.painter != null || this.undecorated) {
            return SwingUtils.size(this.toolBar);
        }
        return LafUtils.getWebBorderShape(this.toolBar, this.getShadeWidth(), this.getRound());
    }

    public boolean isUndecorated() {
        return this.undecorated;
    }

    public void setUndecorated(boolean bl) {
        this.undecorated = bl;
        this.updateBorder(this.toolBar);
        if (this.painter != null && !bl) {
            this.toolBar.setOpaque(false);
        }
    }

    public Painter getPainter() {
        return this.painter;
    }

    public void setPainter(Painter painter) {
        this.painter = painter;
        this.updateBorder(this.toolBar);
    }

    public int getRound() {
        if (this.undecorated) {
            return 0;
        }
        return this.round;
    }

    public void setRound(int n) {
        this.round = n;
    }

    public Color getTopBgColor() {
        return this.topBgColor;
    }

    public void setTopBgColor(Color color) {
        this.topBgColor = color;
    }

    public Color getBottomBgColor() {
        return this.bottomBgColor;
    }

    public void setBottomBgColor(Color color) {
        this.bottomBgColor = color;
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(Color color) {
        this.borderColor = color;
    }

    public Color getDisabledBorderColor() {
        return this.disabledBorderColor;
    }

    public void setDisabledBorderColor(Color color) {
        this.disabledBorderColor = color;
    }

    public int getShadeWidth() {
        if (this.undecorated) {
            return 0;
        }
        return this.shadeWidth;
    }

    public void setShadeWidth(int n) {
        this.shadeWidth = n;
        this.updateBorder(this.toolBar);
    }

    public Insets getMargin() {
        return this.margin;
    }

    public void setMargin(Insets insets) {
        this.margin = insets;
        this.updateBorder(this.toolBar);
    }

    public ToolbarStyle getToolbarStyle() {
        return this.toolbarStyle;
    }

    public void setToolbarStyle(ToolbarStyle toolbarStyle) {
        this.toolbarStyle = toolbarStyle;
        this.updateBorder(this.toolBar);
    }

    public int getSpacing() {
        return this.spacing;
    }

    public void setSpacing(int n) {
        this.spacing = n;
        this.updateLayout(this.toolBar);
    }

    private void updateBorder(JComponent jComponent) {
        if (this.painter != null) {
            Insets insets = this.painter.getMargin(jComponent);
            jComponent.setBorder(BorderFactory.createEmptyBorder(this.margin.top + insets.top, this.margin.left + insets.left, this.margin.bottom + insets.bottom, this.margin.right + insets.right));
        } else if (!this.undecorated) {
            int n = this.toolBar.isFloatable() ? 5 : 0;
            boolean bl = this.toolBar.getOrientation() == 0;
            boolean bl2 = jComponent.getComponentOrientation().isLeftToRight();
            if (this.toolbarStyle.equals((Object)ToolbarStyle.standalone)) {
                if (this.isFloating()) {
                    jComponent.setBorder(BorderFactory.createEmptyBorder(this.margin.top + (!bl ? n : 0), this.margin.left + (bl && bl2 ? n : 0), this.margin.bottom, this.margin.right + (bl && !bl2 ? n : 0)));
                } else {
                    jComponent.setBorder(BorderFactory.createEmptyBorder(this.margin.top + 1 + this.shadeWidth + (!bl ? n : 0), this.margin.left + 1 + this.shadeWidth + (bl && bl2 ? n : 0), this.margin.bottom + 1 + this.shadeWidth, this.margin.right + 1 + this.shadeWidth + (bl && !bl2 ? n : 0)));
                }
            } else if (this.isFloating()) {
                jComponent.setBorder(BorderFactory.createEmptyBorder(this.margin.top + (!bl ? n : 0), this.margin.left + (bl && bl2 ? n : 0), this.margin.bottom, this.margin.right + (bl && !bl2 ? n : 0)));
            } else {
                jComponent.setBorder(BorderFactory.createEmptyBorder(this.margin.top + (!bl ? n : 0), this.margin.left + (bl && bl2 ? n : 0) + (!bl && !bl2 ? 1 : 0), this.margin.bottom + (bl ? 1 : 0), this.margin.right + (bl && !bl2 ? n : 0) + (!bl && bl2 ? 1 : 0)));
            }
        } else {
            jComponent.setBorder(BorderFactory.createEmptyBorder(this.margin.top, this.margin.left, this.margin.bottom, this.margin.right));
        }
    }

    private void updateLayout(JComponent jComponent) {
        ToolbarLayout toolbarLayout = new ToolbarLayout(this.spacing, this.toolBar.getOrientation());
        if (jComponent.getLayout() instanceof ToolbarLayout) {
            ToolbarLayout toolbarLayout2 = (ToolbarLayout)jComponent.getLayout();
            toolbarLayout.setConstraints(toolbarLayout2.getConstraints());
        }
        jComponent.setLayout(toolbarLayout);
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        if (this.painter != null) {
            this.painter.paint((Graphics2D)graphics, SwingUtils.size(jComponent), jComponent);
        } else if (!this.undecorated) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            Object object = LafUtils.setupAntialias(graphics2D);
            boolean bl = this.toolBar.getOrientation() == 0;
            boolean bl2 = jComponent.getComponentOrientation().isLeftToRight();
            if (this.isFloating()) {
                if (bl) {
                    graphics2D.setPaint(new GradientPaint(0.0f, jComponent.getHeight() / 2, this.topBgColor, 0.0f, jComponent.getHeight(), this.bottomBgColor));
                } else {
                    graphics2D.setPaint(new GradientPaint(jComponent.getWidth() / 2, 0.0f, this.topBgColor, jComponent.getWidth(), 0.0f, this.bottomBgColor));
                }
                graphics2D.fillRect(0, 0, jComponent.getWidth(), jComponent.getHeight());
            } else if (this.toolbarStyle.equals((Object)ToolbarStyle.standalone)) {
                RoundRectangle2D.Double double_ = new RoundRectangle2D.Double(this.shadeWidth, this.shadeWidth, jComponent.getWidth() - this.shadeWidth * 2 - 1, jComponent.getHeight() - this.shadeWidth * 2 - 1, this.round, this.round);
                if (jComponent.isEnabled()) {
                    LafUtils.drawShade(graphics2D, double_, StyleConstants.shadeColor, this.shadeWidth);
                }
                if (bl) {
                    graphics2D.setPaint(new GradientPaint(0.0f, jComponent.getHeight() / 2, this.topBgColor, 0.0f, jComponent.getHeight(), this.bottomBgColor));
                } else {
                    graphics2D.setPaint(new GradientPaint(jComponent.getWidth() / 2, 0.0f, this.topBgColor, jComponent.getWidth(), 0.0f, this.bottomBgColor));
                }
                graphics2D.fill(double_);
                graphics2D.setPaint(jComponent.isEnabled() ? this.borderColor : this.disabledBorderColor);
                graphics2D.draw(double_);
            } else {
                if (bl) {
                    graphics2D.setPaint(new GradientPaint(0.0f, jComponent.getHeight() / 2, this.topBgColor, 0.0f, jComponent.getHeight(), this.bottomBgColor));
                } else {
                    graphics2D.setPaint(new GradientPaint(jComponent.getWidth() / 2, 0.0f, this.topBgColor, jComponent.getWidth(), 0.0f, this.bottomBgColor));
                }
                graphics2D.fillRect(0, 0, jComponent.getWidth(), jComponent.getHeight());
                graphics2D.setPaint(jComponent.isEnabled() ? this.borderColor : this.disabledBorderColor);
                if (bl) {
                    graphics2D.drawLine(0, jComponent.getHeight() - 1, jComponent.getWidth() - 1, jComponent.getHeight() - 1);
                } else if (bl2) {
                    graphics2D.drawLine(jComponent.getWidth() - 1, 0, jComponent.getWidth() - 1, jComponent.getHeight() - 1);
                } else {
                    graphics2D.drawLine(0, 0, 0, jComponent.getHeight() - 1);
                }
            }
            if (this.toolBar.isFloatable()) {
                if (this.toolBar.getOrientation() == 0) {
                    int n = this.shadeWidth + 1;
                    int n2 = jComponent.getHeight() - this.shadeWidth - 2;
                    if (n2 > n) {
                        int n3;
                        int n4;
                        graphics2D.setPaint(new LinearGradientPaint(0.0f, n, 0.0f, n2, this.fractions, this.gradient));
                        int n5 = this.toolbarStyle.equals((Object)ToolbarStyle.standalone) ? this.shadeWidth + 1 + this.margin.left + (this.isFloating() ? -1 : 1) : (n4 = this.margin.left + 2 - 1);
                        if (!bl2) {
                            n4 = jComponent.getWidth() - n4 - 2;
                        }
                        for (n3 = jComponent.getHeight() / 2 - 3; n3 >= n; n3 -= 4) {
                            graphics2D.fillRect(n4, n3, 2, 2);
                        }
                        n3 = jComponent.getHeight() / 2 + 1;
                        while (n3 + 2 <= n2) {
                            graphics2D.fillRect(n4, n3, 2, 2);
                            n3 += 4;
                        }
                    }
                } else {
                    int n = this.shadeWidth + 1;
                    int n6 = jComponent.getWidth() - this.shadeWidth - 2;
                    if (n6 > n) {
                        int n7;
                        graphics2D.setPaint(new LinearGradientPaint(n, 0.0f, n6, 0.0f, this.fractions, this.gradient));
                        int n8 = this.toolbarStyle.equals((Object)ToolbarStyle.standalone) ? this.shadeWidth + 1 + this.margin.top + (this.isFloating() ? -1 : 1) : this.margin.top + 2 - 1;
                        for (n7 = jComponent.getWidth() / 2 - 3; n7 >= n; n7 -= 4) {
                            graphics2D.fillRect(n7, n8, 2, 2);
                        }
                        n7 = jComponent.getWidth() / 2 + 1;
                        while (n7 + 2 <= n6) {
                            graphics2D.fillRect(n7, n8, 2, 2);
                            n7 += 4;
                        }
                    }
                }
            }
            LafUtils.restoreAntialias(graphics2D, object);
        }
    }

    @Override
    public Dimension getPreferredSize(JComponent jComponent) {
        Dimension dimension;
        Dimension dimension2 = dimension = jComponent.getLayout() != null ? jComponent.getLayout().preferredLayoutSize(jComponent) : null;
        if (this.painter != null) {
            dimension = SwingUtils.max(dimension, this.painter.getPreferredSize(jComponent));
        }
        return dimension;
    }

    @Override
    protected RootPaneContainer createFloatingWindow(JToolBar jToolBar) {
        Window window = SwingUtils.getWindowAncestor(jToolBar);
        class ToolBarDialog
        extends WebDialog {
            public ToolBarDialog(Frame frame, String string, boolean bl) {
                super(frame, string, bl);
            }

            public ToolBarDialog(Dialog dialog, String string, boolean bl) {
                super(dialog, string, bl);
            }

            @Override
            protected JRootPane createRootPane() {
                JRootPane jRootPane = new JRootPane(){
                    private boolean packing = false;

                    @Override
                    public void validate() {
                        super.validate();
                        if (!this.packing) {
                            this.packing = true;
                            this.pack();
                            this.packing = false;
                        }
                    }
                };
                jRootPane.setOpaque(true);
                return jRootPane;
            }
        }
        ToolBarDialog toolBarDialog = window instanceof Frame ? new ToolBarDialog((Frame)window, jToolBar.getName(), false) : (window instanceof Dialog ? new ToolBarDialog((Dialog)window, jToolBar.getName(), false) : new ToolBarDialog((Frame)null, jToolBar.getName(), false));
        toolBarDialog.getRootPane().setName("ToolBar.FloatingWindow");
        toolBarDialog.setTitle(jToolBar.getName());
        toolBarDialog.setResizable(false);
        WindowListener windowListener = this.createFrameListener();
        toolBarDialog.addWindowListener(windowListener);
        return toolBarDialog;
    }

    @Override
    protected BasicToolBarUI.DragWindow createDragWindow(JToolBar jToolBar) {
        BasicToolBarUI.DragWindow dragWindow = super.createDragWindow(jToolBar);
        SwingUtils.setWindowOpacity(dragWindow, 0.5f);
        return dragWindow;
    }
}

