/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.rootpane;

import com.alee.managers.focus.FocusManager;
import com.alee.managers.focus.FocusTracker;
import com.alee.utils.SwingUtils;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.JWindow;

public class WebWindow
extends JWindow
implements FocusTracker {
    private boolean closeOnFocusLoss = false;
    protected boolean focused;

    public WebWindow() {
        this.initialize();
    }

    public WebWindow(GraphicsConfiguration graphicsConfiguration) {
        super(graphicsConfiguration);
        this.initialize();
    }

    public WebWindow(Frame frame) {
        super(frame);
        this.initialize();
    }

    public WebWindow(Component component) {
        super(SwingUtils.getWindowAncestor(component));
        this.initialize();
    }

    public WebWindow(Window window) {
        super(window);
        this.initialize();
    }

    public WebWindow(Window window, GraphicsConfiguration graphicsConfiguration) {
        super(window, graphicsConfiguration);
        this.initialize();
    }

    private void initialize() {
        this.setFocusable(true);
        SwingUtils.setOrientation(this);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent componentEvent) {
                WebWindow.this.updateFocusTracker();
            }

            @Override
            public void componentHidden(ComponentEvent componentEvent) {
                WebWindow.this.updateFocusTracker();
            }
        });
    }

    public boolean isCloseOnFocusLoss() {
        return this.closeOnFocusLoss;
    }

    public void setCloseOnFocusLoss(boolean bl) {
        this.closeOnFocusLoss = bl;
        this.updateFocusTracker();
    }

    @Override
    public boolean isTrackingEnabled() {
        return this.isShowing();
    }

    @Override
    public Component getTrackedComponent() {
        return this;
    }

    @Override
    public boolean isUniteWithChilds() {
        return true;
    }

    @Override
    public boolean isListenGlobalChange() {
        return false;
    }

    @Override
    public void focusChanged(boolean bl) {
        this.focused = bl;
        if (this.isShowing() && !bl && this.closeOnFocusLoss) {
            this.setVisible(false);
        }
    }

    private void updateFocusTracker() {
        if (this.isShowing() && this.closeOnFocusLoss) {
            FocusManager.registerFocusTracker(this);
        } else {
            FocusManager.unregisterFocusTracker(this);
        }
    }

    public void setWindowOpaque(boolean bl) {
        SwingUtils.setWindowOpaque(this, bl);
    }

    public boolean isWindowOpaque() {
        return SwingUtils.isWindowOpaque(this);
    }

    public void setWindowOpacity(float f) {
        SwingUtils.setWindowOpacity(this, f);
    }

    public float getWindowOpacity() {
        return SwingUtils.getWindowOpacity(this);
    }

    public void packAndCenter() {
        SwingUtils.packAndCenter(this);
    }

    public void packAndCenter(boolean bl) {
        SwingUtils.packAndCenter(this, bl);
    }

    public void center() {
        this.setLocationRelativeTo(null);
    }

    public void center(Component component) {
        this.setLocationRelativeTo(component);
    }

    public void center(int n, int n2) {
        this.setSize(n, n2);
        this.center();
    }

    public void packToWidth(int n) {
        this.setSize(n, this.getPreferredSize().height);
    }

    public void packToHeight(int n) {
        this.setSize(this.getPreferredSize().width, n);
    }
}

