/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.window;

import com.alee.laf.StyleConstants;
import com.alee.laf.rootpane.WebDialog;
import com.alee.utils.MathUtils;
import com.alee.utils.swing.Timer;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.awt.event.WindowListener;

public class WebFadeDialog
extends WebDialog
implements ActionListener,
WindowFocusListener,
WindowListener {
    private float maximumOpacity = 0.9f;
    private float minimumOpacity = 0.3f;
    private int minimumOpacityDistance = 200;
    private float opacity = 1.0f;
    private Timer updater = new Timer("WebFadeDialog.updater", (long)StyleConstants.fastAnimationDelay, (ActionListener)this);

    public WebFadeDialog() {
        this.addWindowFocusListener(this);
        this.addWindowListener(this);
    }

    public float getMaximumOpacity() {
        return this.maximumOpacity;
    }

    public void setMaximumOpacity(float f) {
        this.maximumOpacity = f;
    }

    public float getMinimumOpacity() {
        return this.minimumOpacity;
    }

    public void setMinimumOpacity(float f) {
        this.minimumOpacity = f;
    }

    public int getMinimumOpacityDistance() {
        return this.minimumOpacityDistance;
    }

    public void setMinimumOpacityDistance(int n) {
        this.minimumOpacityDistance = n;
    }

    @Override
    public void windowGainedFocus(WindowEvent windowEvent) {
        this.updater.stop();
        this.opacity = this.maximumOpacity;
        this.updateOpacity();
    }

    @Override
    public void windowLostFocus(WindowEvent windowEvent) {
        if (this.isShowing()) {
            this.updater.start();
        }
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
        this.updater.stop();
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        float f;
        if (!this.isActive()) {
            Point point = MouseInfo.getPointerInfo().getLocation();
            Rectangle rectangle = this.getBounds();
            if (rectangle.contains(point)) {
                f = this.maximumOpacity;
            } else {
                int n = point.y < rectangle.y ? (point.x < rectangle.x ? this.minimumOpacityDistance - MathUtils.sqrt(MathUtils.sqr(rectangle.y - point.y) + MathUtils.sqr(rectangle.x - point.x)) : (point.x > rectangle.x + rectangle.width ? this.minimumOpacityDistance - MathUtils.sqrt(MathUtils.sqr(rectangle.y - point.y) + MathUtils.sqr(point.x - rectangle.x - rectangle.width)) : this.minimumOpacityDistance - (rectangle.y - point.y))) : (point.y > rectangle.y && point.y < rectangle.y + rectangle.height ? (point.x < rectangle.x ? this.minimumOpacityDistance - (rectangle.x - point.x) : this.minimumOpacityDistance - (point.x - rectangle.x - rectangle.width)) : (point.x < rectangle.x ? this.minimumOpacityDistance - MathUtils.sqrt(MathUtils.sqr(point.y - rectangle.y - rectangle.height) + MathUtils.sqr(rectangle.x - point.x)) : (point.x > rectangle.x + rectangle.width ? this.minimumOpacityDistance - MathUtils.sqrt(MathUtils.sqr(point.y - rectangle.y - rectangle.height) + MathUtils.sqr(point.x - rectangle.x - rectangle.width)) : this.minimumOpacityDistance - (point.y - rectangle.y - rectangle.height))));
                f = this.minimumOpacity + (this.maximumOpacity - this.minimumOpacity) * ((float)Math.max(0, n) / (float)this.minimumOpacityDistance);
            }
        } else {
            f = this.maximumOpacity;
        }
        if (f != this.opacity) {
            this.opacity = f;
            this.updateOpacity();
        }
    }

    private void updateOpacity() {
        System.out.println(this.opacity);
        this.setWindowOpacity(this.opacity);
    }
}

