/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.language;

import com.alee.extended.language.DictionariesTree;
import com.alee.laf.text.WebTextField;
import com.alee.laf.tree.WebTreeCellEditor;
import com.alee.managers.language.data.Dictionary;
import com.alee.managers.language.data.Record;
import com.alee.managers.language.data.Text;
import com.alee.managers.language.data.Tooltip;
import com.alee.managers.language.data.Value;
import java.awt.Component;
import java.util.EventObject;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;

public class DictionariesTreeEditor
extends WebTreeCellEditor {
    private DictionariesTree tree;
    private DefaultMutableTreeNode lastValue = null;

    public DictionariesTreeEditor(DictionariesTree dictionariesTree) {
        this.tree = dictionariesTree;
    }

    @Override
    public Component getTreeCellEditorComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n) {
        WebTextField webTextField = (WebTextField)super.getTreeCellEditorComponent(jTree, object, bl, bl2, bl3, n);
        this.lastValue = (DefaultMutableTreeNode)object;
        Object object2 = this.lastValue.getUserObject();
        if (object2 instanceof Dictionary) {
            webTextField.setText(((Dictionary)object2).getPrefix());
        } else if (object2 instanceof Record) {
            webTextField.setText(((Record)object2).getKey());
        } else if (object2 instanceof Value) {
            webTextField.setText(((Value)object2).getLang());
        } else if (object2 instanceof Text) {
            webTextField.setText(((Text)object2).getText());
        } else if (object2 instanceof Tooltip) {
            webTextField.setText(((Tooltip)object2).getText());
        }
        return webTextField;
    }

    @Override
    public Object getCellEditorValue() {
        String string = (String)super.getCellEditorValue();
        Object object = this.lastValue.getUserObject();
        if (object instanceof Dictionary) {
            ((Dictionary)object).setPrefix(string);
        } else if (object instanceof Record) {
            ((Record)object).setKey(string);
        } else if (object instanceof Value) {
            ((Value)object).setLang(string);
        } else if (object instanceof Text) {
            ((Text)object).setText(string);
        } else if (object instanceof Tooltip) {
            ((Tooltip)object).setText(string);
        }
        return object;
    }

    @Override
    public boolean isCellEditable(EventObject eventObject) {
        Object object = this.tree.getSelectedValue();
        return object != null && (object instanceof Dictionary || object instanceof Record || object instanceof Value || object instanceof Text || object instanceof Tooltip) && super.isCellEditable(eventObject);
    }
}

