/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.language;

import com.alee.extended.language.DictionariesTree;
import com.alee.managers.language.data.Dictionary;
import com.alee.managers.language.data.Record;
import com.alee.managers.language.data.Text;
import com.alee.managers.language.data.Tooltip;
import com.alee.managers.language.data.Value;
import com.alee.utils.SwingUtils;
import com.alee.utils.XmlUtils;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public class DictionariesTransferHandler
extends TransferHandler {
    private final DataFlavor[] flavors = new DataFlavor[]{DataFlavor.stringFlavor};
    private DictionariesTree tree;

    public static void install(DictionariesTree dictionariesTree) {
        dictionariesTree.setTransferHandler(new DictionariesTransferHandler(dictionariesTree));
    }

    public DictionariesTransferHandler(DictionariesTree dictionariesTree) {
        this.tree = dictionariesTree;
        dictionariesTree.addMouseMotionListener(new MouseAdapter(){

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
                if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                    DictionariesTransferHandler.this.exportAsDrag(DictionariesTransferHandler.this.tree, mouseEvent, SwingUtils.isCtrl(mouseEvent) ? 1 : 2);
                }
            }
        });
    }

    public DictionariesTree getTree() {
        return this.tree;
    }

    @Override
    public int getSourceActions(JComponent jComponent) {
        return 3;
    }

    @Override
    protected Transferable createTransferable(JComponent jComponent) {
        Object object = this.tree.getSelectedValue();
        if (object == null) {
            return null;
        }
        final String string = XmlUtils.toXML(object);
        return new Transferable(){

            @Override
            public DataFlavor[] getTransferDataFlavors() {
                return DictionariesTransferHandler.this.flavors;
            }

            @Override
            public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
                return dataFlavor.equals(DataFlavor.stringFlavor);
            }

            @Override
            public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
                if (this.isDataFlavorSupported(dataFlavor)) {
                    return string;
                }
                return null;
            }
        };
    }

    @Override
    public boolean canImport(TransferHandler.TransferSupport transferSupport) {
        try {
            Point point = transferSupport.getDropLocation().getDropPoint();
            TreePath treePath = this.tree.getPathForLocation(point.x, point.y);
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            Object object = defaultMutableTreeNode.getUserObject();
            String string = (String)transferSupport.getTransferable().getTransferData(DataFlavor.stringFlavor);
            Object object2 = XmlUtils.fromXML(string);
            if (object == null && object2 instanceof Dictionary) {
                return true;
            }
            if (object instanceof Dictionary && (object2 instanceof Dictionary || object2 instanceof Record)) {
                return true;
            }
            if (object instanceof Record && object2 instanceof Value) {
                return true;
            }
            return object instanceof Value && (object2 instanceof Text || object2 instanceof Tooltip);
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    @Override
    public boolean importData(TransferHandler.TransferSupport transferSupport) {
        try {
            Point point = transferSupport.getDropLocation().getDropPoint();
            TreePath treePath = this.tree.getPathForLocation(point.x, point.y);
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            Object object = defaultMutableTreeNode.getUserObject();
            String string = (String)transferSupport.getTransferable().getTransferData(DataFlavor.stringFlavor);
            Object object2 = XmlUtils.fromXML(string);
            if (object == null) {
                if (object2 instanceof Dictionary) {
                    Dictionary dictionary = (Dictionary)object2;
                    dictionary.setId();
                    DefaultMutableTreeNode defaultMutableTreeNode2 = this.tree.createDictionaryNode(dictionary);
                    this.tree.getActualModel().insertNodeInto(defaultMutableTreeNode2, defaultMutableTreeNode, defaultMutableTreeNode.getChildCount());
                    this.tree.selectAndShow(defaultMutableTreeNode2);
                    return true;
                }
                return false;
            }
            if (object instanceof Dictionary) {
                Dictionary dictionary = (Dictionary)object;
                if (object2 instanceof Dictionary) {
                    Dictionary dictionary2 = (Dictionary)object2;
                    dictionary2.setId();
                    dictionary.addSubdictionary(dictionary2);
                    DefaultMutableTreeNode defaultMutableTreeNode3 = this.tree.createDictionaryNode(dictionary2);
                    this.tree.getActualModel().insertNodeInto(defaultMutableTreeNode3, defaultMutableTreeNode, defaultMutableTreeNode.getChildCount());
                    this.tree.selectAndShow(defaultMutableTreeNode3);
                    return true;
                }
                if (object2 instanceof Record) {
                    Record record = (Record)object2;
                    record = dictionary.addRecord(record);
                    DefaultMutableTreeNode defaultMutableTreeNode4 = this.tree.createRecordNode(record);
                    this.tree.getActualModel().insertNodeInto(defaultMutableTreeNode4, defaultMutableTreeNode, defaultMutableTreeNode.getChildCount());
                    this.tree.selectAndShow(defaultMutableTreeNode4);
                    return true;
                }
                return false;
            }
            if (object instanceof Record) {
                if (object2 instanceof Value) {
                    Value value = (Value)object2;
                    value = ((Record)object).addValue(value);
                    DefaultMutableTreeNode defaultMutableTreeNode5 = this.tree.createValueNode(value);
                    this.tree.getActualModel().insertNodeInto(defaultMutableTreeNode5, defaultMutableTreeNode, defaultMutableTreeNode.getChildCount());
                    this.tree.selectAndShow(defaultMutableTreeNode5);
                    return true;
                }
                return false;
            }
            if (object instanceof Value) {
                Value value = (Value)object;
                if (object2 instanceof Text) {
                    Text text = (Text)object2;
                    text = value.addText(text);
                    DefaultMutableTreeNode defaultMutableTreeNode6 = this.tree.createTextNode(text);
                    this.tree.getActualModel().insertNodeInto(defaultMutableTreeNode6, defaultMutableTreeNode, defaultMutableTreeNode.getChildCount());
                    this.tree.selectAndShow(defaultMutableTreeNode6);
                    return true;
                }
                if (object2 instanceof Tooltip) {
                    Tooltip tooltip = (Tooltip)object2;
                    tooltip = value.addTooltip(tooltip);
                    DefaultMutableTreeNode defaultMutableTreeNode7 = this.tree.createTooltipNode(tooltip);
                    this.tree.getActualModel().insertNodeInto(defaultMutableTreeNode7, defaultMutableTreeNode, defaultMutableTreeNode.getChildCount());
                    this.tree.selectAndShow(defaultMutableTreeNode7);
                    return true;
                }
                return false;
            }
            return false;
        }
        catch (Throwable throwable) {
            return false;
        }
    }
}

