/*
 * Decompiled with CFR 0.152.
 */
package com.alee.extended.breadcrumb;

import com.alee.extended.breadcrumb.WebBreadcrumb;
import com.alee.extended.breadcrumb.WebBreadcrumbButton;
import com.alee.extended.breadcrumb.WebBreadcrumbLabel;
import com.alee.extended.breadcrumb.WebFileBreadcrumbStyle;
import com.alee.extended.layout.VerticalFlowLayout;
import com.alee.laf.label.WebLabel;
import com.alee.laf.list.WebList;
import com.alee.laf.list.WebListCellRenderer;
import com.alee.laf.list.WebListElement;
import com.alee.laf.panel.WebPanel;
import com.alee.laf.rootpane.WebWindow;
import com.alee.laf.scroll.WebScrollPane;
import com.alee.laf.separator.WebSeparator;
import com.alee.managers.hotkey.Hotkey;
import com.alee.managers.tooltip.TooltipManager;
import com.alee.utils.FileUtils;
import com.alee.utils.SwingUtils;
import com.alee.utils.file.FileComparator;
import com.alee.utils.swing.AncestorAdapter;
import java.awt.Component;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.Arrays;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.event.AncestorEvent;

public class WebFileBreadcrumb
extends WebBreadcrumb {
    public static ImageIcon typeIcon = new ImageIcon(WebFileBreadcrumb.class.getResource("icons/file/type.png"));
    public static ImageIcon dateIcon = new ImageIcon(WebFileBreadcrumb.class.getResource("icons/file/date.png"));
    public static ImageIcon sizeIcon = new ImageIcon(WebFileBreadcrumb.class.getResource("icons/file/size.png"));
    private boolean displayFileIcon = WebFileBreadcrumbStyle.displayFileIcon;
    private boolean displayFileName = WebFileBreadcrumbStyle.displayFileName;
    private boolean displayFileTip = WebFileBreadcrumbStyle.displayFileTip;
    private int fileNameLength = WebFileBreadcrumbStyle.fileNameLength;
    private int listFileNameLength = WebFileBreadcrumbStyle.listFileNameLength;
    private boolean showFullNameInTip = WebFileBreadcrumbStyle.showFullNameInTip;
    private int maxVisibleListFiles = WebFileBreadcrumbStyle.maxVisibleListFiles;
    private boolean autoExpandLastElement = WebFileBreadcrumbStyle.autoExpandLastElement;
    private File root;
    private File currentFile;

    public WebFileBreadcrumb() {
        this(FileUtils.getSystemRoot());
    }

    public WebFileBreadcrumb(String string) {
        this(new File(string));
    }

    public WebFileBreadcrumb(File file) {
        this.initialize();
        this.setRoot(file);
    }

    public WebFileBreadcrumb(boolean bl) {
        super(bl);
        this.initialize();
        this.setRoot(FileUtils.getSystemRoot());
    }

    public WebFileBreadcrumb(String string, boolean bl) {
        this(new File(string), bl);
    }

    public WebFileBreadcrumb(File file, boolean bl) {
        super(bl);
        this.initialize();
        this.setRoot(file);
    }

    private void initialize() {
        this.setEncloseLastElement(WebFileBreadcrumbStyle.encloseLastElement);
    }

    public File getRoot() {
        return this.root;
    }

    public void setRoot(String string) {
        this.setRoot(new File(string));
    }

    public void setRoot(File file) {
        this.root = file.getAbsoluteFile();
        this.setCurrentFile(file);
    }

    public File getCurrentFile() {
        return this.currentFile;
    }

    public void setCurrentFile(String string) {
        this.setCurrentFile(new File(string));
    }

    public void setCurrentFile(File file) {
        if (!FileUtils.equals(this.root, file = file.getAbsoluteFile()) && !FileUtils.isParent(this.root, file)) {
            this.root = FileUtils.getTopParent(file);
        }
        this.currentFile = file;
        this.updatePath();
    }

    public boolean isDisplayFileIcon() {
        return this.displayFileIcon;
    }

    public void setDisplayFileIcon(boolean bl) {
        this.displayFileIcon = bl;
        this.updatePath();
    }

    public boolean isDisplayFileName() {
        return this.displayFileName;
    }

    public void setDisplayFileName(boolean bl) {
        this.displayFileName = bl;
        this.updatePath();
    }

    public boolean isDisplayFileTip() {
        return this.displayFileTip;
    }

    public void setDisplayFileTip(boolean bl) {
        this.displayFileTip = bl;
        this.updatePath();
    }

    public int getFileNameLength() {
        return this.fileNameLength;
    }

    public void setFileNameLength(int n) {
        this.fileNameLength = n;
        this.updatePath();
    }

    public int getListFileNameLength() {
        return this.listFileNameLength;
    }

    public void setListFileNameLength(int n) {
        this.listFileNameLength = n;
    }

    public boolean isShowFullNameInTip() {
        return this.showFullNameInTip;
    }

    public void setShowFullNameInTip(boolean bl) {
        this.showFullNameInTip = bl;
        this.updatePath();
    }

    public int getMaxVisibleListFiles() {
        return this.maxVisibleListFiles;
    }

    public void setMaxVisibleListFiles(int n) {
        this.maxVisibleListFiles = n;
    }

    public boolean isAutoExpandLastElement() {
        return this.autoExpandLastElement;
    }

    public void setAutoExpandLastElement(boolean bl) {
        this.autoExpandLastElement = bl;
    }

    private void updatePath() {
        this.setAutoUpdate(false);
        this.removeAll();
        File file = this.currentFile;
        while (!FileUtils.equals(file, this.root)) {
            this.addFile(file);
            file = file.getParentFile();
        }
        this.addFile(this.root);
        this.setAutoUpdate(true);
        this.updateElements();
    }

    private void addFile(final File file) {
        if (file.isDirectory()) {
            boolean bl = this.showFullNameInTip;
            final WebBreadcrumbButton webBreadcrumbButton = new WebBreadcrumbButton();
            if (this.displayFileIcon) {
                webBreadcrumbButton.setIcon(FileUtils.getFileIcon(file));
            }
            if (this.displayFileName) {
                String string = FileUtils.getDisplayFileName(file);
                String string2 = FileUtils.getShortFileName(string, this.fileNameLength);
                bl = bl && string2.length() != string.length();
                webBreadcrumbButton.setText(string2);
            }
            if (this.displayFileTip) {
                this.installTip(file, webBreadcrumbButton, bl);
            }
            webBreadcrumbButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    File[] fileArray = file.listFiles();
                    if (fileArray != null && fileArray.length > 0) {
                        Arrays.sort(fileArray, new FileComparator());
                        WebFileBreadcrumb.this.showFilesPopup(fileArray, webBreadcrumbButton);
                    } else {
                        TooltipManager.showOneTimeTooltip((Component)webBreadcrumbButton, null, "There are no files inside");
                    }
                }
            });
            this.add((Component)webBreadcrumbButton, 0);
        } else {
            boolean bl = this.showFullNameInTip;
            WebBreadcrumbLabel webBreadcrumbLabel = new WebBreadcrumbLabel();
            if (this.displayFileIcon) {
                webBreadcrumbLabel.setIcon(FileUtils.getFileIcon(file));
            }
            if (this.displayFileName) {
                String string = FileUtils.getDisplayFileName(file);
                String string3 = FileUtils.getShortFileName(string, this.fileNameLength);
                bl = bl && string3.length() != string.length();
                webBreadcrumbLabel.setText(string3);
            }
            if (this.displayFileTip) {
                this.installTip(file, webBreadcrumbLabel, bl);
            }
            this.add((Component)webBreadcrumbLabel, 0);
        }
    }

    private void showFilesPopup(File[] fileArray, final WebBreadcrumbButton webBreadcrumbButton) {
        WebWindow webWindow = new WebWindow(SwingUtils.getWindowAncestor(webBreadcrumbButton));
        webWindow.setCloseOnFocusLoss(true);
        webWindow.setAlwaysOnTop(true);
        final WebList webList = new WebList(fileArray);
        webList.setRolloverSelectionEnabled(true);
        webList.setSelectedIndex(0);
        webList.setVisibleRowCount(Math.min(this.maxVisibleListFiles, fileArray.length));
        webList.setCellRenderer(new WebListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                WebListElement webListElement = (WebListElement)super.getListCellRendererComponent(jList, object, n, bl, bl2);
                File file = (File)object;
                webListElement.setIcon(FileUtils.getFileIcon(file));
                String string = FileUtils.getDisplayFileName(file);
                webListElement.setText(FileUtils.getShortFileName(string, WebFileBreadcrumb.this.listFileNameLength));
                return webListElement;
            }
        });
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (webList.getSelectedIndex() != -1) {
                    WebFileBreadcrumb.this.setCurrentFile((File)webList.getSelectedValue());
                    Component component = WebFileBreadcrumb.this.getLastComponent();
                    component.requestFocus();
                    component.requestFocusInWindow();
                    if (WebFileBreadcrumb.this.autoExpandLastElement && component instanceof AbstractButton) {
                        ((AbstractButton)component).doClick();
                    }
                }
            }
        };
        webList.addMouseListener(mouseAdapter);
        webList.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                if (Hotkey.ESCAPE.isTriggered(keyEvent)) {
                    webBreadcrumbButton.requestFocusInWindow();
                }
            }
        });
        WebScrollPane webScrollPane = new WebScrollPane(webList);
        webScrollPane.setShadeWidth(0);
        webScrollPane.setDrawFocus(false);
        webWindow.add(webScrollPane);
        webWindow.applyComponentOrientation(this.getComponentOrientation());
        webWindow.pack();
        Point point = webBreadcrumbButton.getLocationOnScreen();
        Insets insets = webList.getWebListCellRenderer().getBorder().getBorderInsets(webList);
        if (this.getComponentOrientation().isLeftToRight()) {
            webWindow.setLocation(point.x + webBreadcrumbButton.getInsets().left - webScrollPane.getInsets().left - insets.left, point.y + webBreadcrumbButton.getHeight() + 2);
        } else {
            webWindow.setLocation(point.x + webBreadcrumbButton.getWidth() - webBreadcrumbButton.getInsets().right - webScrollPane.getWidth() + webScrollPane.getInsets().right + insets.right, point.y + webBreadcrumbButton.getHeight() + 2);
        }
        webWindow.setVisible(true);
        webList.requestFocusInWindow();
    }

    private void installTip(File file, final JComponent jComponent, boolean bl) {
        WebPanel webPanel = new WebPanel(new VerticalFlowLayout(4, 4));
        webPanel.setOpaque(false);
        if (bl) {
            webPanel.add((Component)new WebLabel(FileUtils.getDisplayFileName(file), FileUtils.getFileIcon(file)));
            webPanel.add((Component)new WebSeparator(false, 0, true));
        }
        webPanel.add((Component)new WebLabel(FileUtils.getFileTypeDescription(file), typeIcon));
        if (FileUtils.isFile(file)) {
            webPanel.add((Component)new WebLabel(FileUtils.getDisplayFileModificationDate(file), dateIcon));
            webPanel.add((Component)new WebLabel(FileUtils.getDisplayFileSize(file), sizeIcon));
        }
        TooltipManager.setTooltip((Component)jComponent, webPanel);
        jComponent.addAncestorListener(new AncestorAdapter(){

            @Override
            public void ancestorRemoved(AncestorEvent ancestorEvent) {
                TooltipManager.removeTooltips(jComponent);
            }
        });
    }
}

