/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna.examples.win32;

import com.sun.jna.LastErrorException;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.examples.win32.Kernel32;
import com.sun.jna.examples.win32.W32Errors;
import com.sun.jna.examples.win32.Win32Exception;
import com.sun.jna.examples.win32.WinBase;
import com.sun.jna.examples.win32.WinDef;
import com.sun.jna.examples.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;

public abstract class Kernel32Util
implements WinDef {
    public static String getComputerName() {
        char[] buffer = new char[WinBase.MAX_COMPUTERNAME_LENGTH + 1];
        IntByReference lpnSize = new IntByReference(buffer.length);
        if (!Kernel32.INSTANCE.GetComputerName(buffer, lpnSize)) {
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
        return Native.toString((char[])buffer);
    }

    public static String formatMessage(int code) {
        PointerByReference buffer = new PointerByReference();
        if (Kernel32.INSTANCE.FormatMessage(4864, null, code, 0, buffer, 0, null) == 0) {
            throw new LastErrorException(Kernel32.INSTANCE.GetLastError());
        }
        String s = buffer.getValue().getWideString(0L);
        Kernel32.INSTANCE.LocalFree(buffer.getValue());
        return s.trim();
    }

    public static String formatMessage(WinNT.HRESULT code) {
        return Kernel32Util.formatMessage(code.intValue());
    }

    @Deprecated
    public static String formatMessageFromHR(WinNT.HRESULT code) {
        return Kernel32Util.formatMessage(code.intValue());
    }

    public static String formatMessageFromLastErrorCode(int code) {
        return Kernel32Util.formatMessageFromHR(W32Errors.HRESULT_FROM_WIN32(code));
    }

    public static String getTempPath() {
        WinDef.DWORD nBufferLength = new WinDef.DWORD(260L);
        char[] buffer = new char[nBufferLength.intValue()];
        if (Kernel32.INSTANCE.GetTempPath(nBufferLength, buffer).intValue() == 0) {
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
        return Native.toString((char[])buffer);
    }

    public static void deleteFile(String filename) {
        if (!Kernel32.INSTANCE.DeleteFile(filename)) {
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
    }

    public static String[] getLogicalDriveStrings() {
        WinDef.DWORD dwSize = Kernel32.INSTANCE.GetLogicalDriveStrings(new WinDef.DWORD(0L), null);
        if (dwSize.intValue() <= 0) {
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
        char[] buf = new char[dwSize.intValue()];
        if ((dwSize = Kernel32.INSTANCE.GetLogicalDriveStrings(dwSize, buf)).intValue() <= 0) {
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
        ArrayList<String> drives = new ArrayList<String>();
        String drive = "";
        int i = 0;
        while (i < buf.length - 1) {
            if (buf[i] == '\u0000') {
                drives.add(drive);
                drive = "";
            } else {
                drive = String.valueOf(drive) + buf[i];
            }
            ++i;
        }
        return drives.toArray(new String[0]);
    }

    public static int getFileAttributes(String fileName) {
        int fileAttributes = Kernel32.INSTANCE.GetFileAttributes(fileName);
        if (fileAttributes == -1) {
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
        return fileAttributes;
    }

    public static int getFileType(String fileName) throws FileNotFoundException {
        File f = new File(fileName);
        if (!f.exists()) {
            throw new FileNotFoundException(fileName);
        }
        WinNT.HANDLE hFile = null;
        try {
            hFile = Kernel32.INSTANCE.CreateFile(fileName, Integer.MIN_VALUE, 1, new WinBase.SECURITY_ATTRIBUTES(), 3, 128, new WinNT.HANDLEByReference().getValue());
            if (WinBase.INVALID_HANDLE_VALUE.equals((Object)hFile)) {
                throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
            }
            int type = Kernel32.INSTANCE.GetFileType(hFile);
            block1 : switch (type) {
                case 0: {
                    int err = Kernel32.INSTANCE.GetLastError();
                    switch (err) {
                        case 0: {
                            break block1;
                        }
                    }
                    throw new Win32Exception(err);
                }
            }
            int n = type;
            return n;
        }
        finally {
            if (hFile != null && !Kernel32.INSTANCE.CloseHandle(hFile)) {
                throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
            }
        }
    }

    public static int getDriveType(String rootName) {
        return Kernel32.INSTANCE.GetDriveType(rootName);
    }

    public static String getEnvironmentVariable(String name) {
        int size = Kernel32.INSTANCE.GetEnvironmentVariable(name, null, 0);
        if (size == 0) {
            return null;
        }
        if (size < 0) {
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
        char[] buffer = new char[size];
        if ((size = Kernel32.INSTANCE.GetEnvironmentVariable(name, buffer, buffer.length)) <= 0) {
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
        return Native.toString((char[])buffer);
    }

    public static final int getPrivateProfileInt(String appName, String keyName, int defaultValue, String fileName) {
        return Kernel32.INSTANCE.GetPrivateProfileInt(appName, keyName, defaultValue, fileName);
    }

    public static final String getPrivateProfileString(String lpAppName, String lpKeyName, String lpDefault, String lpFileName) {
        char[] buffer = new char[1024];
        Kernel32.INSTANCE.GetPrivateProfileString(lpAppName, lpKeyName, lpDefault, buffer, new WinDef.DWORD(buffer.length), lpFileName);
        return Native.toString((char[])buffer);
    }

    public static final void writePrivateProfileString(String appName, String keyName, String string, String fileName) {
        if (!Kernel32.INSTANCE.WritePrivateProfileString(appName, keyName, string, fileName)) {
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
    }

    public static final WinNT.SYSTEM_LOGICAL_PROCESSOR_INFORMATION[] getLogicalProcessorInformation() {
        Memory memory;
        int sizePerStruct = new WinNT.SYSTEM_LOGICAL_PROCESSOR_INFORMATION().size();
        WinDef.DWORDByReference bufferSize = new WinDef.DWORDByReference(new WinDef.DWORD(sizePerStruct));
        while (!Kernel32.INSTANCE.GetLogicalProcessorInformation((Pointer)(memory = new Memory((long)bufferSize.getValue().intValue())), bufferSize)) {
            int err = Kernel32.INSTANCE.GetLastError();
            if (err == 122) continue;
            throw new Win32Exception(err);
        }
        WinNT.SYSTEM_LOGICAL_PROCESSOR_INFORMATION firstInformation = new WinNT.SYSTEM_LOGICAL_PROCESSOR_INFORMATION((Pointer)memory);
        int returnedStructCount = bufferSize.getValue().intValue() / sizePerStruct;
        return (WinNT.SYSTEM_LOGICAL_PROCESSOR_INFORMATION[])firstInformation.toArray(new WinNT.SYSTEM_LOGICAL_PROCESSOR_INFORMATION[returnedStructCount]);
    }

    public static final String[] getPrivateProfileSection(String appName, String fileName) {
        char[] buffer = new char[32768];
        if (Kernel32.INSTANCE.GetPrivateProfileSection(appName, buffer, new WinDef.DWORD(buffer.length), fileName).intValue() == 0) {
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
        return new String(buffer).split("\u0000");
    }

    public static final String[] getPrivateProfileSectionNames(String fileName) {
        char[] buffer = new char[65536];
        if (Kernel32.INSTANCE.GetPrivateProfileSectionNames(buffer, new WinDef.DWORD(buffer.length), fileName).intValue() == 0) {
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
        return new String(buffer).split("\u0000");
    }

    public static final void writePrivateProfileSection(String appName, String[] strings, String fileName) {
        StringBuilder buffer = new StringBuilder();
        String[] stringArray = strings;
        int n = strings.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            buffer.append(string).append('\u0000');
            ++n2;
        }
        buffer.append('\u0000');
        if (!Kernel32.INSTANCE.WritePrivateProfileSection(appName, buffer.toString(), fileName)) {
            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
        }
    }
}

