/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.win32.LRESULT;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.SCROLLBARINFO;
import org.eclipse.swt.internal.win32.SCROLLINFO;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.ScrollBar;

public abstract class Scrollable
extends Control {
    ScrollBar horizontalBar;
    ScrollBar verticalBar;

    Scrollable() {
    }

    public Scrollable(Composite composite, int n) {
        super(composite, n);
    }

    int callWindowProc(int n, int n2, int n3, int n4) {
        if (this.handle == 0) {
            return 0;
        }
        return OS.DefWindowProc(n, n2, n3, n4);
    }

    public Rectangle computeTrim(int n, int n2, int n3, int n4) {
        this.checkWidget();
        int n5 = this.scrolledHandle();
        RECT rECT = new RECT();
        OS.SetRect(rECT, n, n2, n + n3, n2 + n4);
        int n6 = OS.GetWindowLong(n5, -16);
        int n7 = OS.GetWindowLong(n5, -20);
        OS.AdjustWindowRectEx(rECT, n6, false, n7);
        if (this.horizontalBar != null) {
            rECT.bottom += OS.GetSystemMetrics(3);
        }
        if (this.verticalBar != null) {
            rECT.right += OS.GetSystemMetrics(2);
        }
        int n8 = rECT.right - rECT.left;
        int n9 = rECT.bottom - rECT.top;
        return new Rectangle(rECT.left, rECT.top, n8, n9);
    }

    ScrollBar createScrollBar(int n) {
        ScrollBar scrollBar = new ScrollBar(this, n);
        if ((this.state & 2) != 0) {
            scrollBar.setMaximum(100);
            scrollBar.setThumb(10);
        }
        return scrollBar;
    }

    void createWidget() {
        super.createWidget();
        if ((this.style & 0x100) != 0) {
            this.horizontalBar = this.createScrollBar(256);
        }
        if ((this.style & 0x200) != 0) {
            this.verticalBar = this.createScrollBar(512);
        }
    }

    void destroyScrollBar(int n) {
        int n2 = this.scrolledHandle();
        int n3 = OS.GetWindowLong(n2, -16);
        if ((n & 0x100) != 0) {
            this.style &= 0xFFFFFEFF;
            n3 &= 0xFFEFFFFF;
        }
        if ((n & 0x200) != 0) {
            this.style &= 0xFFFFFDFF;
            n3 &= 0xFFDFFFFF;
        }
        OS.SetWindowLong(n2, -16, n3);
    }

    public Rectangle getClientArea() {
        this.checkWidget();
        this.forceResize();
        RECT rECT = new RECT();
        int n = this.scrolledHandle();
        OS.GetClientRect(n, rECT);
        int n2 = rECT.left;
        int n3 = rECT.top;
        int n4 = rECT.right - rECT.left;
        int n5 = rECT.bottom - rECT.top;
        if (n != this.handle) {
            OS.GetClientRect(this.handle, rECT);
            OS.MapWindowPoints(this.handle, n, rECT, 2);
            n2 = -rECT.left;
            n3 = -rECT.top;
        }
        return new Rectangle(n2, n3, n4, n5);
    }

    public ScrollBar getHorizontalBar() {
        this.checkWidget();
        return this.horizontalBar;
    }

    public int getScrollbarsMode() {
        this.checkWidget();
        return 0;
    }

    public ScrollBar getVerticalBar() {
        this.checkWidget();
        return this.verticalBar;
    }

    void releaseChildren(boolean bl) {
        if (this.horizontalBar != null) {
            this.horizontalBar.release(false);
            this.horizontalBar = null;
        }
        if (this.verticalBar != null) {
            this.verticalBar.release(false);
            this.verticalBar = null;
        }
        super.releaseChildren(bl);
    }

    void reskinChildren(int n) {
        if (this.horizontalBar != null) {
            this.horizontalBar.reskin(n);
        }
        if (this.verticalBar != null) {
            this.verticalBar.reskin(n);
        }
        super.reskinChildren(n);
    }

    int scrolledHandle() {
        return this.handle;
    }

    int widgetExtStyle() {
        return super.widgetExtStyle();
    }

    int widgetStyle() {
        int n = super.widgetStyle() | 0x10000;
        if ((this.style & 0x100) != 0) {
            n |= 0x100000;
        }
        if ((this.style & 0x200) != 0) {
            n |= 0x200000;
        }
        return n;
    }

    TCHAR windowClass() {
        return this.display.windowClass;
    }

    int windowProc() {
        return this.display.windowProc;
    }

    LRESULT WM_HSCROLL(int n, int n2) {
        LRESULT lRESULT = super.WM_HSCROLL(n, n2);
        if (lRESULT != null) {
            return lRESULT;
        }
        if (this.horizontalBar != null && (n2 == 0 || n2 == this.handle)) {
            return this.wmScroll(this.horizontalBar, (this.state & 2) != 0, this.handle, 276, n, n2);
        }
        return lRESULT;
    }

    LRESULT WM_MOUSEWHEEL(int n, int n2) {
        return this.wmScrollWheel((this.state & 2) != 0, n, n2);
    }

    LRESULT WM_SIZE(int n, int n2) {
        int n3 = this.callWindowProc(this.handle, 5, n, n2);
        super.WM_SIZE(n, n2);
        if (n3 == 0) {
            return LRESULT.ZERO;
        }
        return new LRESULT(n3);
    }

    LRESULT WM_VSCROLL(int n, int n2) {
        LRESULT lRESULT = super.WM_VSCROLL(n, n2);
        if (lRESULT != null) {
            return lRESULT;
        }
        if (this.verticalBar != null && (n2 == 0 || n2 == this.handle)) {
            return this.wmScroll(this.verticalBar, (this.state & 2) != 0, this.handle, 277, n, n2);
        }
        return lRESULT;
    }

    LRESULT wmNCPaint(int n, int n2, int n3) {
        int n4;
        LRESULT lRESULT = super.wmNCPaint(n, n2, n3);
        if (lRESULT != null) {
            return lRESULT;
        }
        if (OS.COMCTL32_MAJOR >= 6 && OS.IsAppThemed() && !OS.IsWinCE && OS.WIN32_VERSION < OS.VERSION(6, 0) && ((n4 = OS.GetWindowLong(n, -16)) & 0x300000) != 0) {
            RECT rECT = new RECT();
            OS.GetWindowRect(n, rECT);
            RECT rECT2 = new RECT();
            int n5 = OS.GetWindowLong(n, -20);
            OS.AdjustWindowRectEx(rECT2, n4, false, n5);
            boolean bl = false;
            boolean bl2 = false;
            SCROLLBARINFO sCROLLBARINFO = new SCROLLBARINFO();
            sCROLLBARINFO.cbSize = SCROLLBARINFO.sizeof;
            if (OS.GetScrollBarInfo(n, -6, sCROLLBARINFO)) {
                boolean bl3 = bl = (sCROLLBARINFO.rgstate[0] & 0x8000) == 0;
            }
            if (OS.GetScrollBarInfo(n, -5, sCROLLBARINFO)) {
                bl2 = (sCROLLBARINFO.rgstate[0] & 0x8000) == 0;
            }
            RECT rECT3 = new RECT();
            rECT3.bottom = rECT.bottom - rECT.top - rECT2.bottom;
            rECT3.top = rECT3.bottom - (bl2 ? OS.GetSystemMetrics(3) : 0);
            if ((n5 & 0x4000) != 0) {
                rECT3.left = rECT2.left;
                rECT3.right = rECT3.left + (bl ? OS.GetSystemMetrics(2) : 0);
            } else {
                rECT3.right = rECT.right - rECT.left - rECT2.right;
                rECT3.left = rECT3.right - (bl ? OS.GetSystemMetrics(2) : 0);
            }
            if (rECT3.left != rECT3.right && rECT3.top != rECT3.bottom) {
                int n6 = OS.GetWindowDC(n);
                OS.FillRect(n6, rECT3, OS.COLOR_BTNFACE + 1);
                Decorations decorations = this.menuShell();
                if ((decorations.style & 0x10) != 0) {
                    boolean bl4;
                    int n7 = decorations.scrolledHandle();
                    boolean bl5 = bl4 = n == n7;
                    if (!bl4) {
                        RECT rECT4 = new RECT();
                        OS.GetClientRect(n7, rECT4);
                        OS.MapWindowPoints(n7, 0, rECT4, 2);
                        boolean bl6 = bl4 = rECT4.right == rECT.right && rECT4.bottom == rECT.bottom;
                    }
                    if (bl4) {
                        OS.DrawThemeBackground(this.display.hScrollBarTheme(), n6, 10, 0, rECT3, null);
                    }
                }
                OS.ReleaseDC(n, n6);
            }
        }
        return lRESULT;
    }

    LRESULT wmScrollWheel(boolean bl, int n, int n2) {
        Event event;
        int n3;
        int n4 = this.display.scrollRemainder;
        LRESULT lRESULT = super.WM_MOUSEWHEEL(n, n2);
        if (lRESULT != null) {
            return lRESULT;
        }
        if (bl) {
            boolean bl2;
            int n5;
            boolean bl3;
            if ((n & 0xC) != 0) {
                return lRESULT;
            }
            boolean bl4 = this.verticalBar != null && this.verticalBar.getEnabled();
            boolean bl5 = bl3 = this.horizontalBar != null && this.horizontalBar.getEnabled();
            int n6 = bl4 ? 277 : (n5 = bl3 ? 276 : 0);
            if (n5 == 0) {
                return lRESULT;
            }
            int[] nArray = new int[1];
            OS.SystemParametersInfo(104, 0, nArray, 0);
            int n7 = OS.GET_WHEEL_DELTA_WPARAM(n);
            boolean bl6 = bl2 = nArray[0] == -1;
            if (!OS.IsWinCE && OS.WIN32_VERSION >= OS.VERSION(5, 1)) {
                ScrollBar scrollBar = bl4 ? this.verticalBar : this.horizontalBar;
                SCROLLINFO sCROLLINFO = new SCROLLINFO();
                sCROLLINFO.cbSize = SCROLLINFO.sizeof;
                sCROLLINFO.fMask = 4;
                OS.GetScrollInfo(this.handle, scrollBar.scrollBarType(), sCROLLINFO);
                if (bl4 && !bl2) {
                    n7 *= nArray[0];
                }
                int n8 = bl2 ? scrollBar.getPageIncrement() : scrollBar.getIncrement();
                sCROLLINFO.nPos -= n8 * n7 / 120;
                OS.SetScrollInfo(this.handle, scrollBar.scrollBarType(), sCROLLINFO, true);
                OS.SendMessage(this.handle, n5, 4, 0);
            } else {
                int n9 = 0;
                if (bl2) {
                    n9 = n7 < 0 ? 3 : 2;
                } else {
                    int n10 = n9 = n7 < 0 ? 1 : 0;
                    if (n5 == 277) {
                        n7 *= nArray[0];
                    }
                }
                if ((n7 ^ n4) >= 0) {
                    n7 += n4;
                }
                int n11 = Math.abs(n7) / 120;
                for (int i = 0; i < n11; ++i) {
                    OS.SendMessage(this.handle, n5, n9, 0);
                }
            }
            return LRESULT.ZERO;
        }
        int n12 = this.verticalBar == null ? 0 : this.verticalBar.getSelection();
        int n13 = this.horizontalBar == null ? 0 : this.horizontalBar.getSelection();
        int n14 = this.callWindowProc(this.handle, 522, n, n2);
        if (this.verticalBar != null && (n3 = this.verticalBar.getSelection()) != n12) {
            event = new Event();
            event.detail = n3 < n12 ? 0x1000005 : 0x1000006;
            this.verticalBar.sendSelectionEvent(13, event, true);
        }
        if (this.horizontalBar != null && (n3 = this.horizontalBar.getSelection()) != n13) {
            event = new Event();
            event.detail = n3 < n13 ? 0x1000005 : 0x1000006;
            this.horizontalBar.sendSelectionEvent(13, event, true);
        }
        return new LRESULT(n14);
    }

    LRESULT wmScroll(ScrollBar scrollBar, boolean bl, int n, int n2, int n3, int n4) {
        LRESULT lRESULT = null;
        if (bl) {
            int n5 = n2 == 276 ? 0 : 1;
            SCROLLINFO sCROLLINFO = new SCROLLINFO();
            sCROLLINFO.cbSize = SCROLLINFO.sizeof;
            sCROLLINFO.fMask = 21;
            OS.GetScrollInfo(n, n5, sCROLLINFO);
            sCROLLINFO.fMask = 4;
            int n6 = OS.LOWORD(n3);
            switch (n6) {
                case 8: {
                    return null;
                }
                case 4: 
                case 5: {
                    sCROLLINFO.nPos = sCROLLINFO.nTrackPos;
                    break;
                }
                case 6: {
                    sCROLLINFO.nPos = sCROLLINFO.nMin;
                    break;
                }
                case 7: {
                    sCROLLINFO.nPos = sCROLLINFO.nMax;
                    break;
                }
                case 1: {
                    sCROLLINFO.nPos += scrollBar.getIncrement();
                    break;
                }
                case 0: {
                    int n7 = scrollBar.getIncrement();
                    sCROLLINFO.nPos = Math.max(sCROLLINFO.nMin, sCROLLINFO.nPos - n7);
                    break;
                }
                case 3: {
                    sCROLLINFO.nPos += scrollBar.getPageIncrement();
                    break;
                }
                case 2: {
                    int n8 = scrollBar.getPageIncrement();
                    sCROLLINFO.nPos = Math.max(sCROLLINFO.nMin, sCROLLINFO.nPos - n8);
                }
            }
            OS.SetScrollInfo(n, n5, sCROLLINFO, true);
        } else {
            int n9 = this.callWindowProc(n, n2, n3, n4);
            lRESULT = n9 == 0 ? LRESULT.ZERO : new LRESULT(n9);
        }
        scrollBar.wmScrollChild(n3, n4);
        return lRESULT;
    }
}

