/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.GlyphMetrics;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.internal.gdip.Gdip;
import org.eclipse.swt.internal.gdip.Rect;
import org.eclipse.swt.internal.win32.EMR;
import org.eclipse.swt.internal.win32.EMREXTCREATEFONTINDIRECTW;
import org.eclipse.swt.internal.win32.LOGBRUSH;
import org.eclipse.swt.internal.win32.LOGFONT;
import org.eclipse.swt.internal.win32.LOGFONTA;
import org.eclipse.swt.internal.win32.LOGFONTW;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.OUTLINETEXTMETRIC;
import org.eclipse.swt.internal.win32.OUTLINETEXTMETRICA;
import org.eclipse.swt.internal.win32.OUTLINETEXTMETRICW;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.SCRIPT_ANALYSIS;
import org.eclipse.swt.internal.win32.SCRIPT_CONTROL;
import org.eclipse.swt.internal.win32.SCRIPT_FONTPROPERTIES;
import org.eclipse.swt.internal.win32.SCRIPT_ITEM;
import org.eclipse.swt.internal.win32.SCRIPT_LOGATTR;
import org.eclipse.swt.internal.win32.SCRIPT_PROPERTIES;
import org.eclipse.swt.internal.win32.SCRIPT_STATE;
import org.eclipse.swt.internal.win32.TEXTMETRIC;
import org.eclipse.swt.internal.win32.TEXTMETRICA;
import org.eclipse.swt.internal.win32.TEXTMETRICW;

public final class TextLayout
extends Resource {
    Font font;
    String text;
    String segmentsText;
    int lineSpacing = 0;
    int ascent = -1;
    int descent = -1;
    int alignment;
    int wrapWidth = -1;
    int orientation = 0x2000000;
    int indent;
    int wrapIndent;
    boolean justify;
    int[] tabs;
    int[] segments;
    char[] segmentsChars;
    StyleItem[] styles = new StyleItem[2];
    int stylesCount;
    StyleItem[] allRuns;
    StyleItem[][] runs;
    int[] lineOffset;
    int[] lineY;
    int[] lineWidth;
    int mLangFontLink2;
    static final char LTR_MARK = '\u200e';
    static final char RTL_MARK = '\u200f';
    static final int SCRIPT_VISATTR_SIZEOF = 2;
    static final int GOFFSET_SIZEOF = 8;
    static final byte[] CLSID_CMultiLanguage = new byte[16];
    static final byte[] IID_IMLangFontLink2 = new byte[16];
    static final int MERGE_MAX = 512;
    static final int TOO_MANY_RUNS = 1024;
    static final int UNDERLINE_IME_DOT = 65536;
    static final int UNDERLINE_IME_DASH = 131072;
    static final int UNDERLINE_IME_THICK = 196608;

    public TextLayout(Device device) {
        super(device);
        this.styles[0] = new StyleItem();
        this.styles[1] = new StyleItem();
        this.stylesCount = 2;
        this.text = "";
        int[] nArray = new int[1];
        OS.OleInitialize(0);
        if (OS.CoCreateInstance(CLSID_CMultiLanguage, 0, 1, IID_IMLangFontLink2, nArray) == 0) {
            this.mLangFontLink2 = nArray[0];
        }
        this.init();
    }

    RECT addClipRect(StyleItem styleItem, RECT rECT, RECT rECT2, int n, int n2) {
        if (rECT2 != null) {
            boolean bl;
            if (rECT == null) {
                rECT = new RECT();
                OS.SetRect(rECT, -1, rECT2.top, -1, rECT2.bottom);
            }
            boolean bl2 = bl = (this.orientation & 0x4000000) != 0;
            if (styleItem.start <= n && n <= styleItem.start + styleItem.length) {
                if (styleItem.analysis.fRTL ^ bl) {
                    rECT.right = rECT2.left;
                } else {
                    rECT.left = rECT2.left;
                }
            }
            if (styleItem.start <= n2 && n2 <= styleItem.start + styleItem.length) {
                if (styleItem.analysis.fRTL ^ bl) {
                    rECT.left = rECT2.right;
                } else {
                    rECT.right = rECT2.right;
                }
            }
        }
        return rECT;
    }

    void breakRun(StyleItem styleItem) {
        if (styleItem.psla != 0) {
            return;
        }
        char[] cArray = new char[styleItem.length];
        this.segmentsText.getChars(styleItem.start, styleItem.start + styleItem.length, cArray, 0);
        int n = OS.GetProcessHeap();
        styleItem.psla = OS.HeapAlloc(n, 8, SCRIPT_LOGATTR.sizeof * cArray.length);
        if (styleItem.psla == 0) {
            SWT.error(2);
        }
        OS.ScriptBreak(cArray, cArray.length, styleItem.analysis, styleItem.psla);
    }

    void checkLayout() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
    }

    void computeRuns(GC gC) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        Object object;
        if (this.runs != null) {
            return;
        }
        int n6 = gC != null ? gC.handle : this.device.internal_new_GC(null);
        int n7 = OS.CreateCompatibleDC(n6);
        this.allRuns = this.itemize();
        for (int i = 0; i < this.allRuns.length - 1; ++i) {
            object = this.allRuns[i];
            OS.SelectObject(n7, this.getItemFont((StyleItem)object));
            this.shape(n7, (StyleItem)object);
        }
        SCRIPT_LOGATTR sCRIPT_LOGATTR = new SCRIPT_LOGATTR();
        object = new SCRIPT_PROPERTIES();
        int n8 = this.indent;
        int n9 = 0;
        int n10 = 1;
        for (n5 = 0; n5 < this.allRuns.length - 1; ++n5) {
            int n11;
            int n12;
            StyleItem styleItem = this.allRuns[n5];
            if (this.tabs != null && styleItem.tab) {
                n4 = this.tabs.length;
                for (n3 = 0; n3 < n4; ++n3) {
                    if (this.tabs[n3] <= n8) continue;
                    styleItem.width = this.tabs[n3] - n8;
                    break;
                }
                if (n3 == n4) {
                    int n13 = n2 = n4 > 1 ? this.tabs[n4 - 1] - this.tabs[n4 - 2] : this.tabs[0];
                    if (n2 > 0) {
                        for (n12 = this.tabs[n4 - 1]; n12 <= n8; n12 += n2) {
                        }
                        styleItem.width = n12 - n8;
                    }
                }
                if ((n12 = styleItem.length) > 1) {
                    n2 = n3 + n12 - 1;
                    if (n2 < n4) {
                        styleItem.width += this.tabs[n2] - this.tabs[n3];
                    } else {
                        if (n3 < n4) {
                            styleItem.width += this.tabs[n4 - 1] - this.tabs[n3];
                            n12 -= n4 - 1 - n3;
                        }
                        n11 = n4 > 1 ? this.tabs[n4 - 1] - this.tabs[n4 - 2] : this.tabs[0];
                        styleItem.width += n11 * (n12 - 1);
                    }
                }
            }
            if (this.wrapWidth != -1 && n8 + styleItem.width > this.wrapWidth && !styleItem.tab && !styleItem.lineBreak) {
                StyleItem styleItem2;
                n4 = 0;
                int[] nArray = new int[styleItem.length];
                if (styleItem.style != null && styleItem.style.metrics != null) {
                    nArray[0] = styleItem.width;
                } else {
                    OS.ScriptGetLogicalWidths(styleItem.analysis, styleItem.length, styleItem.glyphCount, styleItem.advances, styleItem.clusters, styleItem.visAttrs, nArray);
                }
                n12 = 0;
                n2 = this.wrapWidth - n8;
                while (n12 + nArray[n4] < n2) {
                    n12 += nArray[n4++];
                }
                n11 = n4;
                int n14 = n5;
                while (n5 >= n9) {
                    this.breakRun(styleItem);
                    while (n4 >= 0) {
                        OS.MoveMemory(sCRIPT_LOGATTR, styleItem.psla + n4 * SCRIPT_LOGATTR.sizeof, SCRIPT_LOGATTR.sizeof);
                        if (sCRIPT_LOGATTR.fSoftBreak || sCRIPT_LOGATTR.fWhiteSpace) break;
                        --n4;
                    }
                    if (n4 == 0 && n5 != n9 && !styleItem.tab && sCRIPT_LOGATTR.fSoftBreak && !sCRIPT_LOGATTR.fWhiteSpace) {
                        OS.MoveMemory((SCRIPT_PROPERTIES)object, this.device.scripts[styleItem.analysis.eScript], SCRIPT_PROPERTIES.sizeof);
                        n = ((SCRIPT_PROPERTIES)object).langid;
                        styleItem2 = this.allRuns[n5 - 1];
                        OS.MoveMemory((SCRIPT_PROPERTIES)object, this.device.scripts[styleItem2.analysis.eScript], SCRIPT_PROPERTIES.sizeof);
                        if (((SCRIPT_PROPERTIES)object).langid == n || n == 0 || ((SCRIPT_PROPERTIES)object).langid == 0) {
                            this.breakRun(styleItem2);
                            OS.MoveMemory(sCRIPT_LOGATTR, styleItem2.psla + (styleItem2.length - 1) * SCRIPT_LOGATTR.sizeof, SCRIPT_LOGATTR.sizeof);
                            if (!sCRIPT_LOGATTR.fWhiteSpace) {
                                n4 = -1;
                            }
                        }
                    }
                    if (n4 >= 0 || n5 == n9) break;
                    styleItem = this.allRuns[--n5];
                    n4 = styleItem.length - 1;
                }
                int n15 = n = n4 == 0 && n5 != n9 && !styleItem.tab ? 1 : 0;
                if (n != 0) {
                    this.breakRun(styleItem);
                    OS.MoveMemory(sCRIPT_LOGATTR, styleItem.psla + n4 * SCRIPT_LOGATTR.sizeof, SCRIPT_LOGATTR.sizeof);
                    int n16 = n = !sCRIPT_LOGATTR.fWhiteSpace ? 1 : 0;
                }
                if (n != 0) {
                    styleItem = this.allRuns[--n5];
                    n4 = styleItem.length;
                } else if (n4 <= 0 && n5 == n9) {
                    if (n8 == this.wrapWidth && n14 > 0) {
                        n5 = n14 - 1;
                        styleItem = this.allRuns[n5];
                        n4 = styleItem.length;
                    } else {
                        n5 = n14;
                        styleItem = this.allRuns[n5];
                        n4 = Math.max(1, n11);
                    }
                }
                this.breakRun(styleItem);
                while (n4 < styleItem.length) {
                    OS.MoveMemory(sCRIPT_LOGATTR, styleItem.psla + n4 * SCRIPT_LOGATTR.sizeof, SCRIPT_LOGATTR.sizeof);
                    if (!sCRIPT_LOGATTR.fWhiteSpace) break;
                    ++n4;
                }
                if (0 < n4 && n4 < styleItem.length) {
                    styleItem2 = new StyleItem();
                    styleItem2.start = styleItem.start + n4;
                    styleItem2.length = styleItem.length - n4;
                    styleItem2.style = styleItem.style;
                    styleItem2.analysis = this.cloneScriptAnalysis(styleItem.analysis);
                    styleItem.free();
                    styleItem.length = n4;
                    OS.SelectObject(n7, this.getItemFont(styleItem));
                    styleItem.analysis.fNoGlyphIndex = false;
                    this.shape(n7, styleItem);
                    OS.SelectObject(n7, this.getItemFont(styleItem2));
                    styleItem2.analysis.fNoGlyphIndex = false;
                    this.shape(n7, styleItem2);
                    StyleItem[] styleItemArray = new StyleItem[this.allRuns.length + 1];
                    System.arraycopy(this.allRuns, 0, styleItemArray, 0, n5 + 1);
                    System.arraycopy(this.allRuns, n5 + 1, styleItemArray, n5 + 2, this.allRuns.length - n5 - 1);
                    this.allRuns = styleItemArray;
                    this.allRuns[n5 + 1] = styleItem2;
                }
                if (n5 != this.allRuns.length - 2) {
                    styleItem.lineBreak = true;
                    styleItem.softBreak = true;
                }
            }
            n8 += styleItem.width;
            if (!styleItem.lineBreak) continue;
            n9 = n5 + 1;
            n8 = styleItem.softBreak ? this.wrapIndent : this.indent;
            ++n10;
        }
        n8 = 0;
        this.runs = new StyleItem[n10][];
        this.lineOffset = new int[n10 + 1];
        this.lineY = new int[n10 + 1];
        this.lineWidth = new int[n10];
        n5 = 0;
        int n17 = 0;
        n4 = Math.max(0, this.ascent);
        n3 = Math.max(0, this.descent);
        StyleItem[] styleItemArray = new StyleItem[this.allRuns.length];
        for (n2 = 0; n2 < this.allRuns.length; ++n2) {
            StyleItem styleItem = this.allRuns[n2];
            styleItemArray[n5++] = styleItem;
            n8 += styleItem.width;
            n4 = Math.max(n4, styleItem.ascent);
            n3 = Math.max(n3, styleItem.descent);
            if (!styleItem.lineBreak && n2 != this.allRuns.length - 1) continue;
            if (!(n5 != 1 || n2 != this.allRuns.length - 1 && styleItem.softBreak)) {
                TEXTMETRIC tEXTMETRIC = OS.IsUnicode ? new TEXTMETRICW() : new TEXTMETRICA();
                OS.SelectObject(n7, this.getItemFont(styleItem));
                OS.GetTextMetrics(n7, tEXTMETRIC);
                styleItem.ascent = tEXTMETRIC.tmAscent;
                styleItem.descent = tEXTMETRIC.tmDescent;
                n4 = Math.max(n4, styleItem.ascent);
                n3 = Math.max(n3, styleItem.descent);
            }
            this.runs[n17] = new StyleItem[n5];
            System.arraycopy(styleItemArray, 0, this.runs[n17], 0, n5);
            if (this.justify && this.wrapWidth != -1 && styleItem.softBreak && n8 > 0) {
                int n18 = this.wrapIndent;
                if (n17 == 0) {
                    n18 = this.indent;
                } else {
                    StyleItem[] styleItemArray2 = this.runs[n17 - 1];
                    StyleItem styleItem3 = styleItemArray2[styleItemArray2.length - 1];
                    if (styleItem3.lineBreak && !styleItem3.softBreak) {
                        n18 = this.indent;
                    }
                }
                n8 += n18;
                n = OS.GetProcessHeap();
                int n19 = 0;
                for (int i = 0; i < this.runs[n17].length; ++i) {
                    StyleItem styleItem4 = this.runs[n17][i];
                    int n20 = styleItem4.width * this.wrapWidth / n8;
                    if (n20 != styleItem4.width) {
                        styleItem4.justify = OS.HeapAlloc(n, 8, styleItem4.glyphCount * 4);
                        if (styleItem4.justify == 0) {
                            SWT.error(2);
                        }
                        OS.ScriptJustify(styleItem4.visAttrs, styleItem4.advances, styleItem4.glyphCount, n20 - styleItem4.width, 2, styleItem4.justify);
                        styleItem4.width = n20;
                    }
                    n19 += styleItem4.width;
                }
                n8 = n19;
            }
            this.lineWidth[n17] = n8;
            StyleItem styleItem5 = this.runs[n17][n5 - 1];
            n = styleItem5.start + styleItem5.length;
            this.runs[n17] = this.reorder(this.runs[n17], n2 == this.allRuns.length - 1);
            styleItem5 = this.runs[n17][n5 - 1];
            if (styleItem.softBreak && styleItem != styleItem5) {
                styleItem.lineBreak = false;
                styleItem.softBreak = false;
                styleItem5.lineBreak = true;
                styleItem5.softBreak = true;
            }
            n8 = this.getLineIndent(n17);
            for (int i = 0; i < this.runs[n17].length; ++i) {
                this.runs[n17][i].x = n8;
                n8 += this.runs[n17][i].width;
            }
            this.lineY[++n17] = this.lineY[n17 - 1] + n4 + n3 + this.lineSpacing;
            this.lineOffset[n17] = n;
            n8 = 0;
            n5 = 0;
            n4 = Math.max(0, this.ascent);
            n3 = Math.max(0, this.descent);
        }
        if (n7 != 0) {
            OS.DeleteDC(n7);
        }
        if (gC == null) {
            this.device.internal_dispose_GC(n6, null);
        }
    }

    void destroy() {
        this.freeRuns();
        this.font = null;
        this.text = null;
        this.segmentsText = null;
        this.tabs = null;
        this.styles = null;
        this.runs = null;
        this.lineOffset = null;
        this.lineY = null;
        this.lineWidth = null;
        this.segments = null;
        this.segmentsChars = null;
        if (this.mLangFontLink2 != 0) {
            OS.VtblCall(2, this.mLangFontLink2);
            this.mLangFontLink2 = 0;
        }
        OS.OleUninitialize();
    }

    SCRIPT_ANALYSIS cloneScriptAnalysis(SCRIPT_ANALYSIS sCRIPT_ANALYSIS) {
        SCRIPT_ANALYSIS sCRIPT_ANALYSIS2 = new SCRIPT_ANALYSIS();
        sCRIPT_ANALYSIS2.eScript = sCRIPT_ANALYSIS.eScript;
        sCRIPT_ANALYSIS2.fRTL = sCRIPT_ANALYSIS.fRTL;
        sCRIPT_ANALYSIS2.fLayoutRTL = sCRIPT_ANALYSIS.fLayoutRTL;
        sCRIPT_ANALYSIS2.fLinkBefore = sCRIPT_ANALYSIS.fLinkBefore;
        sCRIPT_ANALYSIS2.fLinkAfter = sCRIPT_ANALYSIS.fLinkAfter;
        sCRIPT_ANALYSIS2.fLogicalOrder = sCRIPT_ANALYSIS.fLogicalOrder;
        sCRIPT_ANALYSIS2.fNoGlyphIndex = sCRIPT_ANALYSIS.fNoGlyphIndex;
        sCRIPT_ANALYSIS2.s = new SCRIPT_STATE();
        sCRIPT_ANALYSIS2.s.uBidiLevel = sCRIPT_ANALYSIS.s.uBidiLevel;
        sCRIPT_ANALYSIS2.s.fOverrideDirection = sCRIPT_ANALYSIS.s.fOverrideDirection;
        sCRIPT_ANALYSIS2.s.fInhibitSymSwap = sCRIPT_ANALYSIS.s.fInhibitSymSwap;
        sCRIPT_ANALYSIS2.s.fCharShape = sCRIPT_ANALYSIS.s.fCharShape;
        sCRIPT_ANALYSIS2.s.fDigitSubstitute = sCRIPT_ANALYSIS.s.fDigitSubstitute;
        sCRIPT_ANALYSIS2.s.fInhibitLigate = sCRIPT_ANALYSIS.s.fInhibitLigate;
        sCRIPT_ANALYSIS2.s.fDisplayZWG = sCRIPT_ANALYSIS.s.fDisplayZWG;
        sCRIPT_ANALYSIS2.s.fArabicNumContext = sCRIPT_ANALYSIS.s.fArabicNumContext;
        sCRIPT_ANALYSIS2.s.fGcpClusters = sCRIPT_ANALYSIS.s.fGcpClusters;
        sCRIPT_ANALYSIS2.s.fReserved = sCRIPT_ANALYSIS.s.fReserved;
        sCRIPT_ANALYSIS2.s.fEngineReserved = sCRIPT_ANALYSIS.s.fEngineReserved;
        return sCRIPT_ANALYSIS2;
    }

    int[] computePolyline(int n, int n2, int n3, int n4) {
        int n5;
        int n6 = n4 - n2;
        int n7 = 2 * n6;
        int n8 = Compatibility.ceil(n3 - n, n7);
        if (n8 == 0 && n3 - n > 2) {
            n8 = 1;
        }
        if ((n5 = (2 * n8 + 1) * 2) < 0) {
            return new int[0];
        }
        int[] nArray = new int[n5];
        for (int i = 0; i < n8; ++i) {
            int n9 = 4 * i;
            nArray[n9] = n + n7 * i;
            nArray[n9 + 1] = n4;
            nArray[n9 + 2] = nArray[n9] + n7 / 2;
            nArray[n9 + 3] = n2;
        }
        nArray[n5 - 2] = n + n7 * n8;
        nArray[n5 - 1] = n4;
        return nArray;
    }

    int createGdipBrush(int n, int n2) {
        int n3 = (n2 & 0xFF) << 24 | n >> 16 & 0xFF | n & 0xFF00 | (n & 0xFF) << 16;
        int n4 = Gdip.Color_new(n3);
        int n5 = Gdip.SolidBrush_new(n4);
        Gdip.Color_delete(n4);
        return n5;
    }

    int createGdipBrush(Color color, int n) {
        return this.createGdipBrush(color.handle, n);
    }

    public void draw(GC gC, int n, int n2) {
        this.draw(gC, n, n2, -1, -1, null, null);
    }

    public void draw(GC gC, int n, int n2, int n3, int n4, Color color, Color color2) {
        this.draw(gC, n, n2, n3, n4, color, color2, 0);
    }

    public void draw(GC gC, int n, int n2, int n3, int n4, Color color, Color color2, int n5) {
        int n6;
        int n7;
        this.checkLayout();
        this.computeRuns(gC);
        if (gC == null) {
            SWT.error(4);
        }
        if (gC.isDisposed()) {
            SWT.error(5);
        }
        if (color != null && color.isDisposed()) {
            SWT.error(5);
        }
        if (color2 != null && color2.isDisposed()) {
            SWT.error(5);
        }
        if ((n7 = this.text.length()) == 0 && n5 == 0) {
            return;
        }
        int n8 = gC.handle;
        Rectangle rectangle = gC.getClipping();
        GCData gCData = gC.data;
        int n9 = gCData.gdipGraphics;
        int n10 = gCData.foreground;
        int n11 = OS.GetSysColor(OS.COLOR_HOTLIGHT);
        int n12 = gCData.alpha;
        boolean bl = n9 != 0;
        int n13 = 0;
        int n14 = 0;
        int n15 = 0;
        if (bl) {
            gC.checkGC(1);
            n13 = gC.getFgBrush();
        } else {
            n15 = OS.SaveDC(n8);
            if ((gCData.style & 0x8000000) != 0) {
                OS.SetLayout(n8, OS.GetLayout(n8) | 1);
            }
        }
        boolean bl2 = n3 <= n4 && n3 != -1 && n4 != -1;
        int n16 = 0;
        int n17 = 0;
        int n18 = 0;
        int n19 = 0;
        int n20 = 0;
        int n21 = 0;
        if (bl2 || (n5 & 0x100000) != 0 && (n5 & 0x30000) != 0) {
            int n22 = color != null ? color.handle : OS.GetSysColor(OS.COLOR_HIGHLIGHTTEXT);
            int n23 = n6 = color2 != null ? color2.handle : OS.GetSysColor(OS.COLOR_HIGHLIGHT);
            if (bl) {
                n16 = this.createGdipBrush(n6, n12);
                n17 = this.createGdipBrush(n22, n12);
            } else {
                n20 = OS.CreateSolidBrush(n6);
                n21 = n22;
            }
            if (bl2) {
                n3 = this.translateOffset(Math.min(Math.max(0, n3), n7 - 1));
                n4 = this.translateOffset(Math.min(Math.max(0, n4), n7 - 1));
            }
        }
        RECT rECT = new RECT();
        OS.SetBkMode(n8, 1);
        block0: for (n6 = 0; n6 < this.runs.length; ++n6) {
            int n24;
            int n25;
            int n26;
            int n27 = n + this.getLineIndent(n6);
            int n28 = n2 + this.lineY[n6];
            StyleItem[] styleItemArray = this.runs[n6];
            int n29 = this.lineY[n6 + 1] - this.lineY[n6] - this.lineSpacing;
            if ((n5 & 0x30000) != 0 && (bl2 || (n5 & 0x100000) != 0)) {
                n26 = 0;
                if (n6 == this.runs.length - 1 && (n5 & 0x100000) != 0) {
                    n26 = 1;
                } else {
                    StyleItem styleItem = styleItemArray[styleItemArray.length - 1];
                    if (styleItem.lineBreak && !styleItem.softBreak) {
                        if (n3 <= styleItem.start && styleItem.start <= n4) {
                            n26 = 1;
                        }
                    } else {
                        n25 = styleItem.start + styleItem.length - 1;
                        if (n3 <= n25 && n25 < n4 && (n5 & 0x10000) != 0) {
                            n26 = 1;
                        }
                    }
                }
                if (n26 != 0) {
                    int n30 = (n5 & 0x10000) != 0 ? (OS.IsWin95 ? Short.MAX_VALUE : 0x6FFFFFF) : n29 / 3;
                    if (bl) {
                        Gdip.Graphics_FillRectangle(n9, n16, n27 + this.lineWidth[n6], n28, n30, n29);
                    } else {
                        OS.SelectObject(n8, n20);
                        OS.PatBlt(n8, n27 + this.lineWidth[n6], n28, n30, n29, 15728673);
                    }
                }
            }
            if (n27 > rectangle.x + rectangle.width || n27 + this.lineWidth[n6] < rectangle.x) continue;
            n26 = n27;
            for (n24 = 0; n24 < styleItemArray.length; ++n24) {
                StyleItem styleItem = styleItemArray[n24];
                if (styleItem.length == 0) continue;
                if (n27 > rectangle.x + rectangle.width) break;
                if (n27 + styleItem.width >= rectangle.x && (!styleItem.lineBreak || styleItem.softBreak)) {
                    OS.SetRect(rECT, n27, n28, n27 + styleItem.width, n28 + n29);
                    if (bl) {
                        this.drawRunBackgroundGDIP(styleItem, n9, rECT, n3, n4, n12, n16, bl2);
                    } else {
                        this.drawRunBackground(styleItem, n8, rECT, n3, n4, n20, bl2);
                    }
                }
                n27 += styleItem.width;
            }
            n24 = Math.max(0, this.ascent);
            n25 = 0;
            for (int i = 0; i < styleItemArray.length; ++i) {
                n24 = Math.max(n24, styleItemArray[i].ascent);
                n25 = Math.min(n25, styleItemArray[i].underlinePos);
            }
            RECT rECT2 = null;
            RECT rECT3 = null;
            RECT rECT4 = null;
            RECT rECT5 = null;
            n27 = n26;
            for (int i = 0; i < styleItemArray.length; ++i) {
                boolean bl3;
                StyleItem styleItem = styleItemArray[i];
                TextStyle textStyle = styleItem.style;
                boolean bl4 = bl3 = textStyle != null && (textStyle.underline || textStyle.strikeout || textStyle.borderStyle != 0);
                if (styleItem.length == 0) continue;
                if (n27 > rectangle.x + rectangle.width) continue block0;
                if (n27 + styleItem.width >= rectangle.x) {
                    boolean bl5;
                    boolean bl6 = bl5 = styleItem.tab && !bl3;
                    if (!(bl5 || styleItem.lineBreak && !styleItem.softBreak || textStyle != null && textStyle.metrics != null)) {
                        int n31;
                        OS.SetRect(rECT, n27, n28, n27 + styleItem.width, n28 + n29);
                        if (bl) {
                            int n32;
                            n31 = this.getItemFont(styleItem);
                            if (n31 != n19) {
                                n19 = n31;
                                if (n18 != 0) {
                                    Gdip.Font_delete(n18);
                                }
                                n32 = OS.SelectObject(n8, n31);
                                n18 = Gdip.Font_new(n8, n31);
                                OS.SelectObject(n8, n32);
                                if (n18 == 0) {
                                    SWT.error(2);
                                }
                                if (!Gdip.Font_IsAvailable(n18)) {
                                    Gdip.Font_delete(n18);
                                    n18 = 0;
                                }
                            }
                            n32 = n13;
                            if (textStyle != null && textStyle.underline && textStyle.underlineStyle == 4) {
                                if (n14 == 0) {
                                    n14 = this.createGdipBrush(n11, n12);
                                }
                                n32 = n14;
                            }
                            if (n18 != 0 && !styleItem.analysis.fNoGlyphIndex) {
                                rECT5 = this.drawRunTextGDIP(n9, styleItem, rECT, n18, n24, n32, n17, n3, n4, n12);
                            } else {
                                int n33 = textStyle != null && textStyle.underline && textStyle.underlineStyle == 4 ? n11 : n10;
                                rECT5 = this.drawRunTextGDIPRaster(n9, styleItem, rECT, n24, n33, n21, n3, n4);
                            }
                            rECT3 = this.drawUnderlineGDIP(n9, n, n28 + n24, n25, n28 + n29, styleItemArray, i, n32, n17, rECT3, rECT5, n3, n4, n12, rectangle);
                            rECT4 = this.drawStrikeoutGDIP(n9, n, n28 + n24, styleItemArray, i, n32, n17, rECT4, rECT5, n3, n4, n12, rectangle);
                            rECT2 = this.drawBorderGDIP(n9, n, n28, n29, styleItemArray, i, n32, n17, rECT2, rECT5, n3, n4, n12, rectangle);
                        } else {
                            n31 = textStyle != null && textStyle.underline && textStyle.underlineStyle == 4 ? n11 : n10;
                            rECT5 = this.drawRunText(n8, styleItem, rECT, n24, n31, n21, n3, n4);
                            rECT3 = this.drawUnderline(n8, n, n28 + n24, n25, n28 + n29, styleItemArray, i, n31, n21, rECT3, rECT5, n3, n4, rectangle);
                            rECT4 = this.drawStrikeout(n8, n, n28 + n24, styleItemArray, i, n31, n21, rECT4, rECT5, n3, n4, rectangle);
                            rECT2 = this.drawBorder(n8, n, n28, n29, styleItemArray, i, n31, n21, rECT2, rECT5, n3, n4, rectangle);
                        }
                    }
                }
                n27 += styleItem.width;
            }
        }
        if (n16 != 0) {
            Gdip.SolidBrush_delete(n16);
        }
        if (n17 != 0) {
            Gdip.SolidBrush_delete(n17);
        }
        if (n14 != 0) {
            Gdip.SolidBrush_delete(n14);
        }
        if (n18 != 0) {
            Gdip.Font_delete(n18);
        }
        if (n15 != 0) {
            OS.RestoreDC(n8, n15);
        }
        if (n20 != 0) {
            OS.DeleteObject(n20);
        }
    }

    RECT drawBorder(int n, int n2, int n3, int n4, StyleItem[] styleItemArray, int n5, int n6, int n7, RECT rECT, RECT rECT2, int n8, int n9, Rectangle rectangle) {
        boolean bl;
        StyleItem styleItem = styleItemArray[n5];
        TextStyle textStyle = styleItem.style;
        if (textStyle == null) {
            return null;
        }
        if (textStyle.borderStyle == 0) {
            return null;
        }
        rECT = this.addClipRect(styleItem, rECT, rECT2, n8, n9);
        boolean bl2 = bl = rectangle != null && n2 + styleItem.x + styleItem.width > rectangle.x + rectangle.width;
        if (n5 + 1 >= styleItemArray.length || bl || !textStyle.isAdherentBorder(styleItemArray[n5 + 1].style)) {
            int n10;
            boolean bl3;
            int n11;
            int n12 = styleItem.x;
            int n13 = styleItem.start;
            int n14 = styleItem.start + styleItem.length - 1;
            for (n11 = n5; n11 > 0 && textStyle.isAdherentBorder(styleItemArray[n11 - 1].style); --n11) {
                n12 = styleItemArray[n11 - 1].x;
                n13 = Math.min(n13, styleItemArray[n11 - 1].start);
                n14 = Math.max(n14, styleItemArray[n11 - 1].start + styleItemArray[n11 - 1].length - 1);
            }
            n11 = n8 <= n9 && n8 != -1 && n9 != -1 ? 1 : 0;
            boolean bl4 = bl3 = n11 != 0 && n8 <= n13 && n14 <= n9;
            if (textStyle.borderColor != null) {
                n6 = textStyle.borderColor.handle;
                rECT = null;
            } else if (bl3) {
                n6 = n7;
                rECT = null;
            } else if (textStyle.foreground != null) {
                n6 = textStyle.foreground.handle;
            }
            int n15 = 1;
            int n16 = 1;
            int n17 = 0;
            switch (textStyle.borderStyle) {
                case 1: {
                    break;
                }
                case 2: {
                    n17 = 1;
                    n16 = 4;
                    break;
                }
                case 4: {
                    n17 = 2;
                    n16 = 2;
                }
            }
            int n18 = OS.SelectObject(n, OS.GetStockObject(5));
            LOGBRUSH lOGBRUSH = new LOGBRUSH();
            lOGBRUSH.lbStyle = 0;
            lOGBRUSH.lbColor = n6;
            int n19 = OS.ExtCreatePen(n17 | 0x10000, n15, lOGBRUSH, 0, null);
            int n20 = OS.SelectObject(n, n19);
            RECT rECT3 = new RECT();
            OS.SetRect(rECT3, n2 + n12, n3, n2 + styleItem.x + styleItem.width, n3 + n4);
            if (rectangle != null) {
                if (rECT3.left < rectangle.x) {
                    n10 = rECT3.left % n16;
                    rECT3.left = rectangle.x / n16 * n16 + n10 - n16;
                }
                if (rECT3.right > rectangle.x + rectangle.width) {
                    n10 = rECT3.right % n16;
                    rECT3.right = (rectangle.x + rectangle.width) / n16 * n16 + n10 + n16;
                }
            }
            OS.Rectangle(n, rECT3.left, rECT3.top, rECT3.right, rECT3.bottom);
            OS.SelectObject(n, n20);
            OS.DeleteObject(n19);
            if (rECT != null) {
                n10 = OS.SaveDC(n);
                if (rECT.left == -1) {
                    rECT.left = 0;
                }
                if (rECT.right == -1) {
                    rECT.right = 524287;
                }
                OS.IntersectClipRect(n, rECT.left, rECT.top, rECT.right, rECT.bottom);
                lOGBRUSH.lbColor = n7;
                int n21 = OS.ExtCreatePen(n17 | 0x10000, n15, lOGBRUSH, 0, null);
                n20 = OS.SelectObject(n, n21);
                OS.Rectangle(n, rECT3.left, rECT3.top, rECT3.right, rECT3.bottom);
                OS.RestoreDC(n, n10);
                OS.SelectObject(n, n20);
                OS.DeleteObject(n21);
            }
            OS.SelectObject(n, n18);
            return null;
        }
        return rECT;
    }

    RECT drawBorderGDIP(int n, int n2, int n3, int n4, StyleItem[] styleItemArray, int n5, int n6, int n7, RECT rECT, RECT rECT2, int n8, int n9, int n10, Rectangle rectangle) {
        boolean bl;
        StyleItem styleItem = styleItemArray[n5];
        TextStyle textStyle = styleItem.style;
        if (textStyle == null) {
            return null;
        }
        if (textStyle.borderStyle == 0) {
            return null;
        }
        rECT = this.addClipRect(styleItem, rECT, rECT2, n8, n9);
        boolean bl2 = bl = rectangle != null && n2 + styleItem.x + styleItem.width > rectangle.x + rectangle.width;
        if (n5 + 1 >= styleItemArray.length || bl || !textStyle.isAdherentBorder(styleItemArray[n5 + 1].style)) {
            int n11;
            int n12 = styleItem.x;
            int n13 = styleItem.start;
            int n14 = styleItem.start + styleItem.length - 1;
            for (n11 = n5; n11 > 0 && textStyle.isAdherentBorder(styleItemArray[n11 - 1].style); --n11) {
                n12 = styleItemArray[n11 - 1].x;
                n13 = Math.min(n13, styleItemArray[n11 - 1].start);
                n14 = Math.max(n14, styleItemArray[n11 - 1].start + styleItemArray[n11 - 1].length - 1);
            }
            n11 = n8 <= n9 && n8 != -1 && n9 != -1 ? 1 : 0;
            boolean bl3 = n11 != 0 && n8 <= n13 && n14 <= n9;
            int n15 = n6;
            if (textStyle.borderColor != null) {
                n15 = this.createGdipBrush(textStyle.borderColor, n10);
                rECT = null;
            } else if (bl3) {
                n15 = n7;
                rECT = null;
            } else if (textStyle.foreground != null) {
                n15 = this.createGdipBrush(textStyle.foreground, n10);
            }
            boolean bl4 = true;
            int n16 = 0;
            switch (textStyle.borderStyle) {
                case 1: {
                    break;
                }
                case 2: {
                    n16 = 1;
                    break;
                }
                case 4: {
                    n16 = 2;
                }
            }
            int n17 = Gdip.Pen_new(n15, (float)bl4);
            Gdip.Pen_SetDashStyle(n17, n16);
            Gdip.Graphics_SetPixelOffsetMode(n, 3);
            int n18 = Gdip.Graphics_GetSmoothingMode(n);
            Gdip.Graphics_SetSmoothingMode(n, 3);
            if (rECT != null) {
                int n19 = Gdip.Graphics_Save(n);
                if (rECT.left == -1) {
                    rECT.left = 0;
                }
                if (rECT.right == -1) {
                    rECT.right = 524287;
                }
                Rect rect = new Rect();
                rect.X = rECT.left;
                rect.Y = rECT.top;
                rect.Width = rECT.right - rECT.left;
                rect.Height = rECT.bottom - rECT.top;
                Gdip.Graphics_SetClip(n, rect, 4);
                Gdip.Graphics_DrawRectangle(n, n17, n2 + n12, n3, styleItem.x + styleItem.width - n12 - 1, n4 - 1);
                Gdip.Graphics_Restore(n, n19);
                n19 = Gdip.Graphics_Save(n);
                Gdip.Graphics_SetClip(n, rect, 1);
                int n20 = Gdip.Pen_new(n7, (float)bl4);
                Gdip.Pen_SetDashStyle(n20, n16);
                Gdip.Graphics_DrawRectangle(n, n20, n2 + n12, n3, styleItem.x + styleItem.width - n12 - 1, n4 - 1);
                Gdip.Pen_delete(n20);
                Gdip.Graphics_Restore(n, n19);
            } else {
                Gdip.Graphics_DrawRectangle(n, n17, n2 + n12, n3, styleItem.x + styleItem.width - n12 - 1, n4 - 1);
            }
            Gdip.Graphics_SetPixelOffsetMode(n, 4);
            Gdip.Graphics_SetSmoothingMode(n, n18);
            Gdip.Pen_delete(n17);
            if (n15 != n7 && n15 != n6) {
                Gdip.SolidBrush_delete(n15);
            }
            return null;
        }
        return rECT;
    }

    void drawRunBackground(StyleItem styleItem, int n, RECT rECT, int n2, int n3, int n4, boolean bl) {
        boolean bl2;
        int n5 = styleItem.start + styleItem.length - 1;
        boolean bl3 = bl2 = bl && n2 <= styleItem.start && n3 >= n5;
        if (bl2) {
            OS.SelectObject(n, n4);
            OS.PatBlt(n, rECT.left, rECT.top, rECT.right - rECT.left, rECT.bottom - rECT.top, 15728673);
        } else {
            int n6;
            if (styleItem.style != null && styleItem.style.background != null) {
                n6 = styleItem.style.background.handle;
                int n7 = OS.CreateSolidBrush(n6);
                int n8 = OS.SelectObject(n, n7);
                OS.PatBlt(n, rECT.left, rECT.top, rECT.right - rECT.left, rECT.bottom - rECT.top, 15728673);
                OS.SelectObject(n, n8);
                OS.DeleteObject(n7);
            }
            int n9 = n6 = bl && n2 <= n5 && styleItem.start <= n3 ? 1 : 0;
            if (n6 != 0) {
                this.getPartialSelection(styleItem, n2, n3, rECT);
                OS.SelectObject(n, n4);
                OS.PatBlt(n, rECT.left, rECT.top, rECT.right - rECT.left, rECT.bottom - rECT.top, 15728673);
            }
        }
    }

    void drawRunBackgroundGDIP(StyleItem styleItem, int n, RECT rECT, int n2, int n3, int n4, int n5, boolean bl) {
        boolean bl2;
        int n6 = styleItem.start + styleItem.length - 1;
        boolean bl3 = bl2 = bl && n2 <= styleItem.start && n3 >= n6;
        if (bl2) {
            Gdip.Graphics_FillRectangle(n, n5, rECT.left, rECT.top, rECT.right - rECT.left, rECT.bottom - rECT.top);
        } else {
            int n7;
            if (styleItem.style != null && styleItem.style.background != null) {
                n7 = this.createGdipBrush(styleItem.style.background, n4);
                Gdip.Graphics_FillRectangle(n, n7, rECT.left, rECT.top, rECT.right - rECT.left, rECT.bottom - rECT.top);
                Gdip.SolidBrush_delete(n7);
            }
            int n8 = n7 = bl && n2 <= n6 && styleItem.start <= n3 ? 1 : 0;
            if (n7 != 0) {
                this.getPartialSelection(styleItem, n2, n3, rECT);
                if (rECT.left > rECT.right) {
                    int n9 = rECT.left;
                    rECT.left = rECT.right;
                    rECT.right = n9;
                }
                Gdip.Graphics_FillRectangle(n, n5, rECT.left, rECT.top, rECT.right - rECT.left, rECT.bottom - rECT.top);
            }
        }
    }

    RECT drawRunText(int n, StyleItem styleItem, RECT rECT, int n2, int n3, int n4, int n5, int n6) {
        int n7 = styleItem.start + styleItem.length - 1;
        boolean bl = n5 <= n6 && n5 != -1 && n6 != -1;
        boolean bl2 = bl && n5 <= styleItem.start && n6 >= n7;
        boolean bl3 = bl && !bl2 && n5 <= n7 && styleItem.start <= n6;
        int n8 = (this.orientation & 0x4000000) != 0 ? -1 : 0;
        int n9 = rECT.left + n8;
        int n10 = rECT.top + (n2 - styleItem.ascent);
        int n11 = this.getItemFont(styleItem);
        OS.SelectObject(n, n11);
        if (bl2) {
            n3 = n4;
        } else if (styleItem.style != null && styleItem.style.foreground != null) {
            n3 = styleItem.style.foreground.handle;
        }
        OS.SetTextColor(n, n3);
        OS.ScriptTextOut(n, styleItem.psc, n9, n10, 0, null, styleItem.analysis, 0, 0, styleItem.glyphs, styleItem.glyphCount, styleItem.advances, styleItem.justify, styleItem.goffsets);
        if (bl3) {
            this.getPartialSelection(styleItem, n5, n6, rECT);
            OS.SetTextColor(n, n4);
            OS.ScriptTextOut(n, styleItem.psc, n9, n10, 4, rECT, styleItem.analysis, 0, 0, styleItem.glyphs, styleItem.glyphCount, styleItem.advances, styleItem.justify, styleItem.goffsets);
        }
        return bl2 || bl3 ? rECT : null;
    }

    RECT drawRunTextGDIP(int n, StyleItem styleItem, RECT rECT, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        boolean bl;
        int n9 = styleItem.start + styleItem.length - 1;
        boolean bl2 = n6 <= n7 && n6 != -1 && n7 != -1;
        boolean bl3 = bl2 && n6 <= styleItem.start && n7 >= n9;
        boolean bl4 = bl2 && !bl3 && n6 <= n9 && styleItem.start <= n7;
        int n10 = rECT.top + n3;
        if (styleItem.style != null && styleItem.style.rise != 0) {
            n10 -= styleItem.style.rise;
        }
        int n11 = rECT.left;
        int n12 = n4;
        if (bl3) {
            n12 = n5;
        } else if (styleItem.style != null && styleItem.style.foreground != null) {
            n12 = this.createGdipBrush(styleItem.style.foreground, n8);
        }
        int n13 = 0;
        Rect rect = null;
        if (bl4) {
            rect = new Rect();
            this.getPartialSelection(styleItem, n6, n7, rECT);
            rect.X = rECT.left;
            rect.Y = rECT.top;
            rect.Width = rECT.right - rECT.left;
            rect.Height = rECT.bottom - rECT.top;
            n13 = Gdip.Graphics_Save(n);
            Gdip.Graphics_SetClip(n, rect, 4);
        }
        int n14 = 0;
        boolean bl5 = bl = (this.orientation & 0x4000000) != 0;
        if (bl) {
            switch (Gdip.Brush_GetType(n12)) {
                case 4: {
                    Gdip.LinearGradientBrush_ScaleTransform(n12, -1.0f, 1.0f, 0);
                    Gdip.LinearGradientBrush_TranslateTransform(n12, -2 * n11 - styleItem.width, 0.0f, 0);
                    break;
                }
                case 2: {
                    Gdip.TextureBrush_ScaleTransform(n12, -1.0f, 1.0f, 0);
                    Gdip.TextureBrush_TranslateTransform(n12, -2 * n11 - styleItem.width, 0.0f, 0);
                }
            }
            n14 = Gdip.Graphics_Save(n);
            Gdip.Graphics_ScaleTransform(n, -1.0f, 1.0f, 0);
            Gdip.Graphics_TranslateTransform(n, -2 * n11 - styleItem.width, 0.0f, 0);
        }
        int[] nArray = new int[styleItem.glyphCount];
        float[] fArray = new float[styleItem.glyphCount * 2];
        OS.memmove(nArray, styleItem.justify != 0 ? styleItem.justify : styleItem.advances, styleItem.glyphCount * 4);
        int n15 = n11;
        int n16 = 0;
        for (int i = 0; i < nArray.length; ++i) {
            fArray[n16++] = n15;
            fArray[n16++] = n10;
            n15 += nArray[i];
        }
        Gdip.Graphics_DrawDriverString(n, styleItem.glyphs, styleItem.glyphCount, n2, n12, fArray, 0, 0);
        if (bl4) {
            if (bl) {
                Gdip.Graphics_Restore(n, n14);
            }
            Gdip.Graphics_Restore(n, n13);
            n13 = Gdip.Graphics_Save(n);
            Gdip.Graphics_SetClip(n, rect, 1);
            if (bl) {
                n14 = Gdip.Graphics_Save(n);
                Gdip.Graphics_ScaleTransform(n, -1.0f, 1.0f, 0);
                Gdip.Graphics_TranslateTransform(n, -2 * n11 - styleItem.width, 0.0f, 0);
            }
            Gdip.Graphics_DrawDriverString(n, styleItem.glyphs, styleItem.glyphCount, n2, n5, fArray, 0, 0);
            Gdip.Graphics_Restore(n, n13);
        }
        if (bl) {
            switch (Gdip.Brush_GetType(n12)) {
                case 4: {
                    Gdip.LinearGradientBrush_ResetTransform(n12);
                    break;
                }
                case 2: {
                    Gdip.TextureBrush_ResetTransform(n12);
                }
            }
            Gdip.Graphics_Restore(n, n14);
        }
        if (n12 != n5 && n12 != n4) {
            Gdip.SolidBrush_delete(n12);
        }
        return bl3 || bl4 ? rECT : null;
    }

    RECT drawRunTextGDIPRaster(int n, StyleItem styleItem, RECT rECT, int n2, int n3, int n4, int n5, int n6) {
        int n7 = 0;
        Gdip.Graphics_SetPixelOffsetMode(n, 3);
        int n8 = Gdip.Region_new();
        if (n8 == 0) {
            SWT.error(2);
        }
        Gdip.Graphics_GetClip(n, n8);
        if (!Gdip.Region_IsInfinite(n8, n)) {
            n7 = Gdip.Region_GetHRGN(n8, n);
        }
        Gdip.Region_delete(n8);
        Gdip.Graphics_SetPixelOffsetMode(n, 4);
        float[] fArray = null;
        int n9 = Gdip.Matrix_new(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f);
        if (n9 == 0) {
            SWT.error(2);
        }
        Gdip.Graphics_GetTransform(n, n9);
        if (!Gdip.Matrix_IsIdentity(n9)) {
            fArray = new float[6];
            Gdip.Matrix_GetElements(n9, fArray);
        }
        Gdip.Matrix_delete(n9);
        int n10 = Gdip.Graphics_GetHDC(n);
        int n11 = OS.SaveDC(n10);
        if (fArray != null) {
            OS.SetGraphicsMode(n10, 2);
            OS.SetWorldTransform(n10, fArray);
        }
        if (n7 != 0) {
            OS.SelectClipRgn(n10, n7);
            OS.DeleteObject(n7);
        }
        if ((this.orientation & 0x4000000) != 0) {
            OS.SetLayout(n10, OS.GetLayout(n10) | 1);
        }
        OS.SetBkMode(n10, 1);
        RECT rECT2 = this.drawRunText(n10, styleItem, rECT, n2, n3, n4, n5, n6);
        OS.RestoreDC(n10, n11);
        Gdip.Graphics_ReleaseHDC(n, n10);
        return rECT2;
    }

    RECT drawStrikeout(int n, int n2, int n3, StyleItem[] styleItemArray, int n4, int n5, int n6, RECT rECT, RECT rECT2, int n7, int n8, Rectangle rectangle) {
        boolean bl;
        StyleItem styleItem = styleItemArray[n4];
        TextStyle textStyle = styleItem.style;
        if (textStyle == null) {
            return null;
        }
        if (!textStyle.strikeout) {
            return null;
        }
        rECT = this.addClipRect(styleItem, rECT, rECT2, n7, n8);
        boolean bl2 = bl = rectangle != null && n2 + styleItem.x + styleItem.width > rectangle.x + rectangle.width;
        if (n4 + 1 >= styleItemArray.length || bl || !textStyle.isAdherentStrikeout(styleItemArray[n4 + 1].style)) {
            boolean bl3;
            int n9;
            int n10 = styleItem.x;
            int n11 = styleItem.start;
            int n12 = styleItem.start + styleItem.length - 1;
            for (n9 = n4; n9 > 0 && textStyle.isAdherentStrikeout(styleItemArray[n9 - 1].style); --n9) {
                n10 = styleItemArray[n9 - 1].x;
                n11 = Math.min(n11, styleItemArray[n9 - 1].start);
                n12 = Math.max(n12, styleItemArray[n9 - 1].start + styleItemArray[n9 - 1].length - 1);
            }
            n9 = n7 <= n8 && n7 != -1 && n8 != -1 ? 1 : 0;
            boolean bl4 = bl3 = n9 != 0 && n7 <= n11 && n12 <= n8;
            if (textStyle.strikeoutColor != null) {
                n5 = textStyle.strikeoutColor.handle;
                rECT = null;
            } else if (bl3) {
                n5 = n6;
                rECT = null;
            } else if (textStyle.foreground != null) {
                n5 = textStyle.foreground.handle;
            }
            RECT rECT3 = new RECT();
            OS.SetRect(rECT3, n2 + n10, n3 - styleItem.strikeoutPos - textStyle.rise, n2 + styleItem.x + styleItem.width, n3 - styleItem.strikeoutPos + styleItem.strikeoutThickness - textStyle.rise);
            int n13 = OS.CreateSolidBrush(n5);
            OS.FillRect(n, rECT3, n13);
            OS.DeleteObject(n13);
            if (rECT != null) {
                int n14 = OS.CreateSolidBrush(n6);
                if (rECT.left == -1) {
                    rECT.left = 0;
                }
                if (rECT.right == -1) {
                    rECT.right = 524287;
                }
                OS.SetRect(rECT, Math.max(rECT3.left, rECT.left), rECT3.top, Math.min(rECT3.right, rECT.right), rECT3.bottom);
                OS.FillRect(n, rECT, n14);
                OS.DeleteObject(n14);
            }
            return null;
        }
        return rECT;
    }

    RECT drawStrikeoutGDIP(int n, int n2, int n3, StyleItem[] styleItemArray, int n4, int n5, int n6, RECT rECT, RECT rECT2, int n7, int n8, int n9, Rectangle rectangle) {
        boolean bl;
        StyleItem styleItem = styleItemArray[n4];
        TextStyle textStyle = styleItem.style;
        if (textStyle == null) {
            return null;
        }
        if (!textStyle.strikeout) {
            return null;
        }
        rECT = this.addClipRect(styleItem, rECT, rECT2, n7, n8);
        boolean bl2 = bl = rectangle != null && n2 + styleItem.x + styleItem.width > rectangle.x + rectangle.width;
        if (n4 + 1 >= styleItemArray.length || bl || !textStyle.isAdherentStrikeout(styleItemArray[n4 + 1].style)) {
            int n10;
            int n11 = styleItem.x;
            int n12 = styleItem.start;
            int n13 = styleItem.start + styleItem.length - 1;
            for (n10 = n4; n10 > 0 && textStyle.isAdherentStrikeout(styleItemArray[n10 - 1].style); --n10) {
                n11 = styleItemArray[n10 - 1].x;
                n12 = Math.min(n12, styleItemArray[n10 - 1].start);
                n13 = Math.max(n13, styleItemArray[n10 - 1].start + styleItemArray[n10 - 1].length - 1);
            }
            n10 = n7 <= n8 && n7 != -1 && n8 != -1 ? 1 : 0;
            boolean bl3 = n10 != 0 && n7 <= n12 && n13 <= n8;
            int n14 = n5;
            if (textStyle.strikeoutColor != null) {
                n14 = this.createGdipBrush(textStyle.strikeoutColor, n9);
                rECT = null;
            } else if (bl3) {
                n14 = n6;
                rECT = null;
            } else if (textStyle.foreground != null) {
                n14 = this.createGdipBrush(textStyle.foreground, n9);
            }
            if (rECT != null) {
                int n15 = Gdip.Graphics_Save(n);
                if (rECT.left == -1) {
                    rECT.left = 0;
                }
                if (rECT.right == -1) {
                    rECT.right = 524287;
                }
                Rect rect = new Rect();
                rect.X = rECT.left;
                rect.Y = rECT.top;
                rect.Width = rECT.right - rECT.left;
                rect.Height = rECT.bottom - rECT.top;
                Gdip.Graphics_SetClip(n, rect, 4);
                Gdip.Graphics_FillRectangle(n, n14, n2 + n11, n3 - styleItem.strikeoutPos - textStyle.rise, styleItem.x + styleItem.width - n11, styleItem.strikeoutThickness);
                Gdip.Graphics_Restore(n, n15);
                n15 = Gdip.Graphics_Save(n);
                Gdip.Graphics_SetClip(n, rect, 1);
                Gdip.Graphics_FillRectangle(n, n6, n2 + n11, n3 - styleItem.strikeoutPos - textStyle.rise, styleItem.x + styleItem.width - n11, styleItem.strikeoutThickness);
                Gdip.Graphics_Restore(n, n15);
            } else {
                Gdip.Graphics_FillRectangle(n, n14, n2 + n11, n3 - styleItem.strikeoutPos - textStyle.rise, styleItem.x + styleItem.width - n11, styleItem.strikeoutThickness);
            }
            if (n14 != n6 && n14 != n5) {
                Gdip.SolidBrush_delete(n14);
            }
            return null;
        }
        return rECT;
    }

    RECT drawUnderline(int n, int n2, int n3, int n4, int n5, StyleItem[] styleItemArray, int n6, int n7, int n8, RECT rECT, RECT rECT2, int n9, int n10, Rectangle rectangle) {
        boolean bl;
        StyleItem styleItem = styleItemArray[n6];
        TextStyle textStyle = styleItem.style;
        if (textStyle == null) {
            return null;
        }
        if (!textStyle.underline) {
            return null;
        }
        rECT = this.addClipRect(styleItem, rECT, rECT2, n9, n10);
        boolean bl2 = bl = rectangle != null && n2 + styleItem.x + styleItem.width > rectangle.x + rectangle.width;
        if (n6 + 1 >= styleItemArray.length || bl || !textStyle.isAdherentUnderline(styleItemArray[n6 + 1].style)) {
            boolean bl3;
            int n11;
            int n12 = styleItem.x;
            int n13 = styleItem.start;
            int n14 = styleItem.start + styleItem.length - 1;
            for (n11 = n6; n11 > 0 && textStyle.isAdherentUnderline(styleItemArray[n11 - 1].style); --n11) {
                n12 = styleItemArray[n11 - 1].x;
                n13 = Math.min(n13, styleItemArray[n11 - 1].start);
                n14 = Math.max(n14, styleItemArray[n11 - 1].start + styleItemArray[n11 - 1].length - 1);
            }
            n11 = n9 <= n10 && n9 != -1 && n10 != -1 ? 1 : 0;
            boolean bl4 = bl3 = n11 != 0 && n9 <= n13 && n14 <= n10;
            if (textStyle.underlineColor != null) {
                n7 = textStyle.underlineColor.handle;
                rECT = null;
            } else if (bl3) {
                n7 = n8;
                rECT = null;
            } else if (textStyle.foreground != null) {
                n7 = textStyle.foreground.handle;
            }
            RECT rECT3 = new RECT();
            OS.SetRect(rECT3, n2 + n12, n3 - n4 - textStyle.rise, n2 + styleItem.x + styleItem.width, n3 - n4 + styleItem.underlineThickness - textStyle.rise);
            if (rECT != null) {
                if (rECT.left == -1) {
                    rECT.left = 0;
                }
                if (rECT.right == -1) {
                    rECT.right = 524287;
                }
                OS.SetRect(rECT, Math.max(rECT3.left, rECT.left), rECT3.top, Math.min(rECT3.right, rECT.right), rECT3.bottom);
            }
            switch (textStyle.underlineStyle) {
                case 2: 
                case 3: {
                    int n15 = 1;
                    int n16 = 2 * n15;
                    int n17 = Math.min(rECT3.top - n16 / 2, n5 - n16 - 1);
                    int[] nArray = this.computePolyline(rECT3.left, n17, rECT3.right, n17 + n16);
                    int n18 = OS.CreatePen(0, n15, n7);
                    int n19 = OS.SelectObject(n, n18);
                    int n20 = OS.SaveDC(n);
                    OS.IntersectClipRect(n, rECT3.left, n17, rECT3.right + 1, n17 + n16 + 1);
                    OS.Polyline(n, nArray, nArray.length / 2);
                    int n21 = nArray.length;
                    if (n21 >= 2 && n15 <= 1) {
                        OS.SetPixel(n, nArray[n21 - 2], nArray[n21 - 1], n7);
                    }
                    OS.SelectObject(n, n19);
                    OS.DeleteObject(n18);
                    OS.RestoreDC(n, n20);
                    if (rECT == null) break;
                    n18 = OS.CreatePen(0, n15, n8);
                    n19 = OS.SelectObject(n, n18);
                    n20 = OS.SaveDC(n);
                    OS.IntersectClipRect(n, rECT.left, n17, rECT.right + 1, n17 + n16 + 1);
                    OS.Polyline(n, nArray, nArray.length / 2);
                    if (n21 >= 2 && n15 <= 1) {
                        OS.SetPixel(n, nArray[n21 - 2], nArray[n21 - 1], n8);
                    }
                    OS.SelectObject(n, n19);
                    OS.DeleteObject(n18);
                    OS.RestoreDC(n, n20);
                    break;
                }
                case 0: 
                case 1: 
                case 4: 
                case 196608: {
                    int n22;
                    if (textStyle.underlineStyle == 196608) {
                        rECT3.top -= styleItem.underlineThickness;
                        if (rECT != null) {
                            rECT.top -= styleItem.underlineThickness;
                        }
                    }
                    int n23 = n22 = textStyle.underlineStyle == 1 ? rECT3.bottom + styleItem.underlineThickness * 2 : rECT3.bottom;
                    if (n22 > n5) {
                        OS.OffsetRect(rECT3, 0, n5 - n22);
                        if (rECT != null) {
                            OS.OffsetRect(rECT, 0, n5 - n22);
                        }
                    }
                    int n24 = OS.CreateSolidBrush(n7);
                    OS.FillRect(n, rECT3, n24);
                    if (textStyle.underlineStyle == 1) {
                        OS.SetRect(rECT3, rECT3.left, rECT3.top + styleItem.underlineThickness * 2, rECT3.right, rECT3.bottom + styleItem.underlineThickness * 2);
                        OS.FillRect(n, rECT3, n24);
                    }
                    OS.DeleteObject(n24);
                    if (rECT == null) break;
                    int n25 = OS.CreateSolidBrush(n8);
                    OS.FillRect(n, rECT, n25);
                    if (textStyle.underlineStyle == 1) {
                        OS.SetRect(rECT, rECT.left, rECT3.top, rECT.right, rECT3.bottom);
                        OS.FillRect(n, rECT, n25);
                    }
                    OS.DeleteObject(n25);
                    break;
                }
                case 65536: 
                case 131072: {
                    int n26 = textStyle.underlineStyle == 131072 ? 1 : 2;
                    int n27 = OS.CreatePen(n26, 1, n7);
                    int n28 = OS.SelectObject(n, n27);
                    OS.SetRect(rECT3, rECT3.left, n3 + styleItem.descent, rECT3.right, n3 + styleItem.descent + styleItem.underlineThickness);
                    OS.MoveToEx(n, rECT3.left, rECT3.top, 0);
                    OS.LineTo(n, rECT3.right, rECT3.top);
                    OS.SelectObject(n, n28);
                    OS.DeleteObject(n27);
                    if (rECT == null) break;
                    n27 = OS.CreatePen(n26, 1, n8);
                    n28 = OS.SelectObject(n, n27);
                    OS.SetRect(rECT, rECT.left, rECT3.top, rECT.right, rECT3.bottom);
                    OS.MoveToEx(n, rECT.left, rECT.top, 0);
                    OS.LineTo(n, rECT.right, rECT.top);
                    OS.SelectObject(n, n28);
                    OS.DeleteObject(n27);
                    break;
                }
            }
            return null;
        }
        return rECT;
    }

    RECT drawUnderlineGDIP(int n, int n2, int n3, int n4, int n5, StyleItem[] styleItemArray, int n6, int n7, int n8, RECT rECT, RECT rECT2, int n9, int n10, int n11, Rectangle rectangle) {
        boolean bl;
        StyleItem styleItem = styleItemArray[n6];
        TextStyle textStyle = styleItem.style;
        if (textStyle == null) {
            return null;
        }
        if (!textStyle.underline) {
            return null;
        }
        rECT = this.addClipRect(styleItem, rECT, rECT2, n9, n10);
        boolean bl2 = bl = rectangle != null && n2 + styleItem.x + styleItem.width > rectangle.x + rectangle.width;
        if (n6 + 1 >= styleItemArray.length || bl || !textStyle.isAdherentUnderline(styleItemArray[n6 + 1].style)) {
            int n12;
            int n13 = styleItem.x;
            int n14 = styleItem.start;
            int n15 = styleItem.start + styleItem.length - 1;
            for (n12 = n6; n12 > 0 && textStyle.isAdherentUnderline(styleItemArray[n12 - 1].style); --n12) {
                n13 = styleItemArray[n12 - 1].x;
                n14 = Math.min(n14, styleItemArray[n12 - 1].start);
                n15 = Math.max(n15, styleItemArray[n12 - 1].start + styleItemArray[n12 - 1].length - 1);
            }
            n12 = n9 <= n10 && n9 != -1 && n10 != -1 ? 1 : 0;
            boolean bl3 = n12 != 0 && n9 <= n14 && n15 <= n10;
            int n16 = n7;
            if (textStyle.underlineColor != null) {
                n16 = this.createGdipBrush(textStyle.underlineColor, n11);
                rECT = null;
            } else if (bl3) {
                n16 = n8;
                rECT = null;
            } else if (textStyle.foreground != null) {
                n16 = this.createGdipBrush(textStyle.foreground, n11);
            }
            RECT rECT3 = new RECT();
            OS.SetRect(rECT3, n2 + n13, n3 - n4 - textStyle.rise, n2 + styleItem.x + styleItem.width, n3 - n4 + styleItem.underlineThickness - textStyle.rise);
            Rect rect = null;
            if (rECT != null) {
                if (rECT.left == -1) {
                    rECT.left = 0;
                }
                if (rECT.right == -1) {
                    rECT.right = 524287;
                }
                OS.SetRect(rECT, Math.max(rECT3.left, rECT.left), rECT3.top, Math.min(rECT3.right, rECT.right), rECT3.bottom);
                rect = new Rect();
                rect.X = rECT.left;
                rect.Y = rECT.top;
                rect.Width = rECT.right - rECT.left;
                rect.Height = rECT.bottom - rECT.top;
            }
            int n17 = 0;
            Gdip.Graphics_SetPixelOffsetMode(n, 3);
            int n18 = Gdip.Graphics_GetSmoothingMode(n);
            Gdip.Graphics_SetSmoothingMode(n, 3);
            switch (textStyle.underlineStyle) {
                case 2: 
                case 3: {
                    int n19 = 1;
                    int n20 = 2 * n19;
                    int n21 = Math.min(rECT3.top - n20 / 2, n5 - n20 - 1);
                    int[] nArray = this.computePolyline(rECT3.left, n21, rECT3.right, n21 + n20);
                    int n22 = Gdip.Pen_new(n16, n19);
                    n17 = Gdip.Graphics_Save(n);
                    if (rect != null) {
                        Gdip.Graphics_SetClip(n, rect, 4);
                    } else {
                        Rect rect2 = new Rect();
                        rect2.X = rECT3.left;
                        rect2.Y = n21;
                        rect2.Width = rECT3.right - rECT3.left;
                        rect2.Height = n20 + 1;
                        Gdip.Graphics_SetClip(n, rect2, 1);
                    }
                    Gdip.Graphics_DrawLines(n, n22, nArray, nArray.length / 2);
                    if (rect != null) {
                        int n23 = Gdip.Pen_new(n8, n19);
                        Gdip.Graphics_Restore(n, n17);
                        n17 = Gdip.Graphics_Save(n);
                        Gdip.Graphics_SetClip(n, rect, 1);
                        Gdip.Graphics_DrawLines(n, n23, nArray, nArray.length / 2);
                        Gdip.Pen_delete(n23);
                    }
                    Gdip.Graphics_Restore(n, n17);
                    Gdip.Pen_delete(n22);
                    if (n17 == 0) break;
                    Gdip.Graphics_Restore(n, n17);
                    break;
                }
                case 0: 
                case 1: 
                case 4: 
                case 196608: {
                    int n24;
                    if (textStyle.underlineStyle == 196608) {
                        rECT3.top -= styleItem.underlineThickness;
                    }
                    int n25 = n24 = textStyle.underlineStyle == 1 ? rECT3.bottom + styleItem.underlineThickness * 2 : rECT3.bottom;
                    if (n24 > n5) {
                        OS.OffsetRect(rECT3, 0, n5 - n24);
                    }
                    if (rect != null) {
                        rect.Y = rECT3.top;
                        if (textStyle.underlineStyle == 196608) {
                            rect.Height = styleItem.underlineThickness * 2;
                        }
                        if (textStyle.underlineStyle == 1) {
                            rect.Height = styleItem.underlineThickness * 3;
                        }
                        n17 = Gdip.Graphics_Save(n);
                        Gdip.Graphics_SetClip(n, rect, 4);
                    }
                    Gdip.Graphics_FillRectangle(n, n16, rECT3.left, rECT3.top, rECT3.right - rECT3.left, rECT3.bottom - rECT3.top);
                    if (textStyle.underlineStyle == 1) {
                        Gdip.Graphics_FillRectangle(n, n16, rECT3.left, rECT3.top + styleItem.underlineThickness * 2, rECT3.right - rECT3.left, rECT3.bottom - rECT3.top);
                    }
                    if (rect == null) break;
                    Gdip.Graphics_Restore(n, n17);
                    n17 = Gdip.Graphics_Save(n);
                    Gdip.Graphics_SetClip(n, rect, 1);
                    Gdip.Graphics_FillRectangle(n, n8, rECT3.left, rECT3.top, rECT3.right - rECT3.left, rECT3.bottom - rECT3.top);
                    if (textStyle.underlineStyle == 1) {
                        Gdip.Graphics_FillRectangle(n, n8, rECT3.left, rECT3.top + styleItem.underlineThickness * 2, rECT3.right - rECT3.left, rECT3.bottom - rECT3.top);
                    }
                    Gdip.Graphics_Restore(n, n17);
                    break;
                }
                case 65536: 
                case 131072: {
                    int n26 = Gdip.Pen_new(n16, 1.0f);
                    int n27 = textStyle.underlineStyle == 65536 ? 2 : 1;
                    Gdip.Pen_SetDashStyle(n26, n27);
                    if (rect != null) {
                        n17 = Gdip.Graphics_Save(n);
                        Gdip.Graphics_SetClip(n, rect, 4);
                    }
                    Gdip.Graphics_DrawLine(n, n26, rECT3.left, n3 + styleItem.descent, styleItem.width - styleItem.length, n3 + styleItem.descent);
                    if (rect != null) {
                        Gdip.Graphics_Restore(n, n17);
                        n17 = Gdip.Graphics_Save(n);
                        Gdip.Graphics_SetClip(n, rect, 1);
                        int n28 = Gdip.Pen_new(n16, 1.0f);
                        Gdip.Pen_SetDashStyle(n28, n27);
                        Gdip.Graphics_DrawLine(n, n28, rECT3.left, n3 + styleItem.descent, styleItem.width - styleItem.length, n3 + styleItem.descent);
                        Gdip.Graphics_Restore(n, n17);
                        Gdip.Pen_delete(n28);
                    }
                    Gdip.Pen_delete(n26);
                    break;
                }
            }
            if (n16 != n8 && n16 != n7) {
                Gdip.SolidBrush_delete(n16);
            }
            Gdip.Graphics_SetPixelOffsetMode(n, 4);
            Gdip.Graphics_SetSmoothingMode(n, n18);
            return null;
        }
        return rECT;
    }

    void freeRuns() {
        if (this.allRuns == null) {
            return;
        }
        for (int i = 0; i < this.allRuns.length; ++i) {
            StyleItem styleItem = this.allRuns[i];
            styleItem.free();
        }
        this.allRuns = null;
        this.runs = null;
        this.segmentsText = null;
    }

    public int getAlignment() {
        this.checkLayout();
        return this.alignment;
    }

    public int getAscent() {
        this.checkLayout();
        return this.ascent;
    }

    public Rectangle getBounds() {
        this.checkLayout();
        this.computeRuns(null);
        int n = 0;
        if (this.wrapWidth != -1) {
            n = this.wrapWidth;
        } else {
            for (int i = 0; i < this.runs.length; ++i) {
                n = Math.max(n, this.lineWidth[i] + this.getLineIndent(i));
            }
        }
        return new Rectangle(0, 0, n, this.lineY[this.lineY.length - 1]);
    }

    public Rectangle getBounds(int n, int n2) {
        this.checkLayout();
        this.computeRuns(null);
        int n3 = this.text.length();
        if (n3 == 0) {
            return new Rectangle(0, 0, 0, 0);
        }
        if (n > n2) {
            return new Rectangle(0, 0, 0, 0);
        }
        n = Math.min(Math.max(0, n), n3 - 1);
        n2 = Math.min(Math.max(0, n2), n3 - 1);
        n = this.translateOffset(n);
        n2 = this.translateOffset(n2);
        n3 = this.segmentsText.length();
        char c = this.segmentsText.charAt(n);
        if ('\udc00' <= c && c <= '\udfff' && n - 1 >= 0 && '\ud800' <= (c = this.segmentsText.charAt(n - 1)) && c <= '\udbff') {
            --n;
        }
        if ('\ud800' <= (c = this.segmentsText.charAt(n2)) && c <= '\udbff' && n2 + 1 < n3 && '\udc00' <= (c = this.segmentsText.charAt(n2 + 1)) && c <= '\udfff') {
            ++n2;
        }
        int n4 = Integer.MAX_VALUE;
        int n5 = 0;
        int n6 = Integer.MAX_VALUE;
        int n7 = 0;
        boolean bl = (this.orientation & 0x4000000) != 0;
        for (int i = 0; i < this.allRuns.length - 1; ++i) {
            int n8;
            Object object;
            int n9;
            StyleItem styleItem = this.allRuns[i];
            int n10 = styleItem.start + styleItem.length;
            if (n10 <= n) continue;
            if (styleItem.start > n2) break;
            int n11 = styleItem.x;
            int n12 = styleItem.x + styleItem.width;
            if (styleItem.start <= n && n < n10) {
                n9 = 0;
                if (styleItem.style != null && styleItem.style.metrics != null) {
                    object = styleItem.style.metrics;
                    n9 = object.width * (n - styleItem.start);
                } else if (!styleItem.tab) {
                    object = new int[1];
                    n8 = styleItem.justify != 0 ? styleItem.justify : styleItem.advances;
                    OS.ScriptCPtoX(n - styleItem.start, false, styleItem.length, styleItem.glyphCount, styleItem.clusters, styleItem.visAttrs, n8, styleItem.analysis, object);
                    int n13 = n9 = bl ? styleItem.width - object[0] : object[0];
                }
                if (styleItem.analysis.fRTL ^ bl) {
                    n12 = styleItem.x + n9;
                } else {
                    n11 = styleItem.x + n9;
                }
            }
            if (styleItem.start <= n2 && n2 < n10) {
                n9 = styleItem.width;
                if (styleItem.style != null && styleItem.style.metrics != null) {
                    object = styleItem.style.metrics;
                    n9 = object.width * (n2 - styleItem.start + 1);
                } else if (!styleItem.tab) {
                    object = new int[1];
                    n8 = styleItem.justify != 0 ? styleItem.justify : styleItem.advances;
                    OS.ScriptCPtoX(n2 - styleItem.start, true, styleItem.length, styleItem.glyphCount, styleItem.clusters, styleItem.visAttrs, n8, styleItem.analysis, object);
                    int n14 = n9 = bl ? styleItem.width - object[0] : object[0];
                }
                if (styleItem.analysis.fRTL ^ bl) {
                    n11 = styleItem.x + n9;
                } else {
                    n12 = styleItem.x + n9;
                }
            }
            for (n9 = 0; n9 < this.runs.length && this.lineOffset[n9 + 1] <= styleItem.start; ++n9) {
            }
            n4 = Math.min(n4, n11);
            n5 = Math.max(n5, n12);
            n6 = Math.min(n6, this.lineY[n9]);
            n7 = Math.max(n7, this.lineY[n9 + 1] - this.lineSpacing);
        }
        return new Rectangle(n4, n6, n5 - n4, n7 - n6);
    }

    public int getDescent() {
        this.checkLayout();
        return this.descent;
    }

    public Font getFont() {
        this.checkLayout();
        return this.font;
    }

    public int getIndent() {
        this.checkLayout();
        return this.indent;
    }

    public boolean getJustify() {
        this.checkLayout();
        return this.justify;
    }

    int getItemFont(StyleItem styleItem) {
        if (styleItem.fallbackFont != 0) {
            return styleItem.fallbackFont;
        }
        if (styleItem.style != null && styleItem.style.font != null) {
            return styleItem.style.font.handle;
        }
        if (this.font != null) {
            return this.font.handle;
        }
        return this.device.systemFont.handle;
    }

    public int getLevel(int n) {
        this.checkLayout();
        this.computeRuns(null);
        int n2 = this.text.length();
        if (0 > n || n > n2) {
            SWT.error(6);
        }
        n = this.translateOffset(n);
        for (int i = 1; i < this.allRuns.length; ++i) {
            if (this.allRuns[i].start <= n) continue;
            return this.allRuns[i - 1].analysis.s.uBidiLevel;
        }
        return (this.orientation & 0x4000000) != 0 ? 1 : 0;
    }

    public Rectangle getLineBounds(int n) {
        this.checkLayout();
        this.computeRuns(null);
        if (0 > n || n >= this.runs.length) {
            SWT.error(6);
        }
        int n2 = this.getLineIndent(n);
        int n3 = this.lineY[n];
        int n4 = this.lineWidth[n];
        int n5 = this.lineY[n + 1] - n3 - this.lineSpacing;
        return new Rectangle(n2, n3, n4, n5);
    }

    public int getLineCount() {
        this.checkLayout();
        this.computeRuns(null);
        return this.runs.length;
    }

    int getLineIndent(int n) {
        StyleItem[] styleItemArray;
        int n2 = this.wrapIndent;
        if (n == 0) {
            n2 = this.indent;
        } else {
            StyleItem[] styleItemArray2 = this.runs[n - 1];
            styleItemArray = styleItemArray2[styleItemArray2.length - 1];
            if (styleItemArray.lineBreak && !styleItemArray.softBreak) {
                n2 = this.indent;
            }
        }
        if (this.wrapWidth != -1) {
            boolean bl = true;
            if (this.justify) {
                styleItemArray = this.runs[n];
                if (styleItemArray[styleItemArray.length - 1].softBreak) {
                    bl = false;
                }
            }
            if (bl) {
                int n3 = this.lineWidth[n] + n2;
                switch (this.alignment) {
                    case 0x1000000: {
                        n2 += (this.wrapWidth - n3) / 2;
                        break;
                    }
                    case 131072: {
                        n2 += this.wrapWidth - n3;
                    }
                }
            }
        }
        return n2;
    }

    public int getLineIndex(int n) {
        this.checkLayout();
        this.computeRuns(null);
        int n2 = this.text.length();
        if (0 > n || n > n2) {
            SWT.error(6);
        }
        n = this.translateOffset(n);
        for (int i = 0; i < this.runs.length; ++i) {
            if (this.lineOffset[i + 1] <= n) continue;
            return i;
        }
        return this.runs.length - 1;
    }

    public FontMetrics getLineMetrics(int n) {
        this.checkLayout();
        this.computeRuns(null);
        if (0 > n || n >= this.runs.length) {
            SWT.error(6);
        }
        int n2 = this.device.internal_new_GC(null);
        int n3 = OS.CreateCompatibleDC(n2);
        TEXTMETRIC tEXTMETRIC = OS.IsUnicode ? new TEXTMETRICW() : new TEXTMETRICA();
        OS.SelectObject(n3, this.font != null ? this.font.handle : this.device.systemFont.handle);
        OS.GetTextMetrics(n3, tEXTMETRIC);
        OS.DeleteDC(n3);
        this.device.internal_dispose_GC(n2, null);
        int n4 = Math.max(tEXTMETRIC.tmAscent, this.ascent);
        int n5 = Math.max(tEXTMETRIC.tmDescent, this.descent);
        int n6 = tEXTMETRIC.tmInternalLeading;
        if (this.text.length() != 0) {
            StyleItem[] styleItemArray = this.runs[n];
            for (int i = 0; i < styleItemArray.length; ++i) {
                StyleItem styleItem = styleItemArray[i];
                if (styleItem.ascent > n4) {
                    n4 = styleItem.ascent;
                    n6 = styleItem.leading;
                }
                n5 = Math.max(n5, styleItem.descent);
            }
        }
        tEXTMETRIC.tmAscent = n4;
        tEXTMETRIC.tmDescent = n5;
        tEXTMETRIC.tmHeight = n4 + n5;
        tEXTMETRIC.tmInternalLeading = n6;
        tEXTMETRIC.tmAveCharWidth = 0;
        return FontMetrics.win32_new(tEXTMETRIC);
    }

    public int[] getLineOffsets() {
        this.checkLayout();
        this.computeRuns(null);
        int[] nArray = new int[this.lineOffset.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = this.untranslateOffset(this.lineOffset[i]);
        }
        return nArray;
    }

    public Point getLocation(int n, boolean bl) {
        int n2;
        this.checkLayout();
        this.computeRuns(null);
        int n3 = this.text.length();
        if (0 > n || n > n3) {
            SWT.error(6);
        }
        n3 = this.segmentsText.length();
        n = this.translateOffset(n);
        for (n2 = 0; n2 < this.runs.length && this.lineOffset[n2 + 1] <= n; ++n2) {
        }
        n2 = Math.min(n2, this.runs.length - 1);
        if (n == n3) {
            return new Point(this.getLineIndent(n2) + this.lineWidth[n2], this.lineY[n2]);
        }
        char c = this.segmentsText.charAt(n);
        if (bl) {
            if ('\ud800' <= c && c <= '\udbff' && n + 1 < n3 && '\udc00' <= (c = this.segmentsText.charAt(n + 1)) && c <= '\udfff') {
                ++n;
            }
        } else if ('\udc00' <= c && c <= '\udfff' && n - 1 >= 0 && '\ud800' <= (c = this.segmentsText.charAt(n - 1)) && c <= '\udbff') {
            --n;
        }
        int n4 = -1;
        int n5 = this.allRuns.length;
        while (n5 - n4 > 1) {
            int n6;
            int n7 = (n5 + n4) / 2;
            StyleItem styleItem = this.allRuns[n7];
            if (styleItem.start > n) {
                n5 = n7;
                continue;
            }
            if (styleItem.start + styleItem.length <= n) {
                n4 = n7;
                continue;
            }
            if (styleItem.style != null && styleItem.style.metrics != null) {
                GlyphMetrics glyphMetrics = styleItem.style.metrics;
                n6 = glyphMetrics.width * (n - styleItem.start + (bl ? 1 : 0));
            } else if (styleItem.tab) {
                n6 = bl || n == n3 ? styleItem.width : 0;
            } else {
                int n8 = n - styleItem.start;
                int n9 = styleItem.length;
                int n10 = styleItem.glyphCount;
                int[] nArray = new int[1];
                int n11 = styleItem.justify != 0 ? styleItem.justify : styleItem.advances;
                OS.ScriptCPtoX(n8, bl, n9, n10, styleItem.clusters, styleItem.visAttrs, n11, styleItem.analysis, nArray);
                n6 = (this.orientation & 0x4000000) != 0 ? styleItem.width - nArray[0] : nArray[0];
            }
            return new Point(styleItem.x + n6, this.lineY[n2]);
        }
        return new Point(0, 0);
    }

    public int getNextOffset(int n, int n2) {
        this.checkLayout();
        return this._getOffset(n, n2, true);
    }

    int _getOffset(int n, int n2, boolean bl) {
        int n3;
        this.computeRuns(null);
        int n4 = this.text.length();
        if (0 > n || n > n4) {
            SWT.error(6);
        }
        if (bl && n == n4) {
            return n4;
        }
        if (!bl && n == 0) {
            return 0;
        }
        int n5 = n3 = bl ? 1 : -1;
        if ((n2 & 1) != 0) {
            return n + n3;
        }
        n4 = this.segmentsText.length();
        n = this.translateOffset(n);
        SCRIPT_LOGATTR sCRIPT_LOGATTR = new SCRIPT_LOGATTR();
        SCRIPT_PROPERTIES sCRIPT_PROPERTIES = new SCRIPT_PROPERTIES();
        int n6 = bl ? 0 : this.allRuns.length - 1;
        n = this.validadeOffset(n, n3);
        do {
            boolean bl2;
            StyleItem styleItem = this.allRuns[n6];
            if (styleItem.start > n || n >= styleItem.start + styleItem.length) continue;
            if (styleItem.lineBreak && !styleItem.softBreak) {
                return this.untranslateOffset(styleItem.start);
            }
            if (styleItem.tab) {
                return this.untranslateOffset(styleItem.start);
            }
            OS.MoveMemory(sCRIPT_PROPERTIES, this.device.scripts[styleItem.analysis.eScript], SCRIPT_PROPERTIES.sizeof);
            boolean bl3 = bl2 = sCRIPT_PROPERTIES.fNeedsCaretInfo || sCRIPT_PROPERTIES.fNeedsWordBreaking;
            if (bl2) {
                this.breakRun(styleItem);
            }
            while (styleItem.start <= n && n < styleItem.start + styleItem.length) {
                if (bl2) {
                    OS.MoveMemory(sCRIPT_LOGATTR, styleItem.psla + (n - styleItem.start) * SCRIPT_LOGATTR.sizeof, SCRIPT_LOGATTR.sizeof);
                }
                switch (n2) {
                    case 2: {
                        if (sCRIPT_PROPERTIES.fNeedsCaretInfo && (sCRIPT_LOGATTR.fInvalid || !sCRIPT_LOGATTR.fCharStop)) break;
                        char c2 = this.segmentsText.charAt(n);
                        if ('\udc00' <= c2 && c2 <= '\udfff' && n > 0 && '\ud800' <= (c2 = this.segmentsText.charAt(n - 1)) && c2 <= '\udbff') {
                            n += n3;
                        }
                        return this.untranslateOffset(n);
                    }
                    case 4: 
                    case 16: {
                        char c;
                        char c2;
                        if (!(sCRIPT_PROPERTIES.fNeedsWordBreaking ? !sCRIPT_LOGATTR.fInvalid && sCRIPT_LOGATTR.fWordStop : n > 0 && ((c2 = (char)(Compatibility.isLetterOrDigit(this.segmentsText.charAt(n)) ? 1 : 0)) != (c = Compatibility.isLetterOrDigit(this.segmentsText.charAt(n - 1))) || c2 == '\u0000') && !Compatibility.isWhitespace(this.segmentsText.charAt(n)))) break;
                        return this.untranslateOffset(n);
                    }
                    case 8: {
                        if (n <= 0) break;
                        char c2 = (char)(Compatibility.isLetterOrDigit(this.segmentsText.charAt(n)) ? 1 : 0);
                        char c = Compatibility.isLetterOrDigit(this.segmentsText.charAt(n - 1));
                        if (c2 != '\u0000' || c == '\u0000') break;
                        return this.untranslateOffset(n);
                    }
                }
                n = this.validadeOffset(n, n3);
            }
        } while (0 <= (n6 += n3) && n6 < this.allRuns.length - 1 && 0 <= n && n < n4);
        return bl ? this.text.length() : 0;
    }

    public int getOffset(Point point, int[] nArray) {
        this.checkLayout();
        if (point == null) {
            SWT.error(4);
        }
        return this.getOffset(point.x, point.y, nArray);
    }

    public int getOffset(int n, int n2, int[] nArray) {
        int n3;
        this.checkLayout();
        this.computeRuns(null);
        if (nArray != null && nArray.length < 1) {
            SWT.error(5);
        }
        int n4 = this.runs.length;
        for (n3 = 0; n3 < n4 && this.lineY[n3 + 1] <= n2; ++n3) {
        }
        n3 = Math.min(n3, this.runs.length - 1);
        StyleItem[] styleItemArray = this.runs[n3];
        int n5 = this.getLineIndent(n3);
        if (n >= n5 + this.lineWidth[n3]) {
            n = n5 + this.lineWidth[n3] - 1;
        }
        if (n < n5) {
            n = n5;
        }
        int n6 = -1;
        int n7 = styleItemArray.length;
        while (n7 - n6 > 1) {
            char c;
            int n8 = (n7 + n6) / 2;
            StyleItem styleItem = styleItemArray[n8];
            if (styleItem.x > n) {
                n7 = n8;
                continue;
            }
            if (styleItem.x + styleItem.width <= n) {
                n6 = n8;
                continue;
            }
            if (styleItem.lineBreak && !styleItem.softBreak) {
                return this.untranslateOffset(styleItem.start);
            }
            int n9 = n - styleItem.x;
            if (styleItem.style != null && styleItem.style.metrics != null) {
                GlyphMetrics glyphMetrics = styleItem.style.metrics;
                if (glyphMetrics.width > 0) {
                    if (nArray != null) {
                        nArray[0] = n9 % glyphMetrics.width < glyphMetrics.width / 2 ? 0 : 1;
                    }
                    return this.untranslateOffset(styleItem.start + n9 / glyphMetrics.width);
                }
            }
            if (styleItem.tab) {
                if (nArray != null) {
                    nArray[0] = n < styleItem.x + styleItem.width / 2 ? 0 : 1;
                }
                return this.untranslateOffset(styleItem.start);
            }
            int n10 = styleItem.length;
            int n11 = styleItem.glyphCount;
            int[] nArray2 = new int[1];
            int[] nArray3 = new int[1];
            if ((this.orientation & 0x4000000) != 0) {
                n9 = styleItem.width - n9;
            }
            int n12 = styleItem.justify != 0 ? styleItem.justify : styleItem.advances;
            OS.ScriptXtoCP(n9, n10, n11, styleItem.clusters, styleItem.visAttrs, n12, styleItem.analysis, nArray2, nArray3);
            int n13 = styleItem.start + nArray2[0];
            int n14 = this.segmentsText.length();
            char c2 = c = n13 < n14 ? this.segmentsText.charAt(n13) : (char)'\u0000';
            if ('\ud800' <= c && c <= '\udbff' && nArray3[0] <= 1) {
                if (n13 + 1 < n14 && '\udc00' <= (c = this.segmentsText.charAt(n13 + 1)) && c <= '\udfff' && nArray != null) {
                    nArray[0] = 0;
                }
            } else if ('\udc00' <= c && c <= '\udfff' && nArray3[0] <= 1) {
                if (n13 - 1 >= 0 && '\ud800' <= (c = this.segmentsText.charAt(n13 - 1)) && c <= '\udbff') {
                    --n13;
                    if (nArray != null) {
                        nArray[0] = 2;
                    }
                }
            } else if (nArray != null) {
                nArray[0] = nArray3[0];
            }
            return this.untranslateOffset(n13);
        }
        if (nArray != null) {
            nArray[0] = 0;
        }
        if (styleItemArray.length == 1) {
            StyleItem styleItem = styleItemArray[0];
            if (styleItem.lineBreak && !styleItem.softBreak) {
                return this.untranslateOffset(styleItem.start);
            }
        }
        return this.untranslateOffset(this.lineOffset[n3 + 1]);
    }

    public int getOrientation() {
        this.checkLayout();
        return this.orientation;
    }

    void getPartialSelection(StyleItem styleItem, int n, int n2, RECT rECT) {
        int n3 = styleItem.start + styleItem.length - 1;
        int n4 = Math.max(n, styleItem.start) - styleItem.start;
        int n5 = Math.min(n2, n3) - styleItem.start;
        int n6 = styleItem.length;
        int n7 = styleItem.glyphCount;
        int[] nArray = new int[1];
        int n8 = rECT.left;
        int n9 = styleItem.justify != 0 ? styleItem.justify : styleItem.advances;
        OS.ScriptCPtoX(n4, false, n6, n7, styleItem.clusters, styleItem.visAttrs, n9, styleItem.analysis, nArray);
        int n10 = (this.orientation & 0x4000000) != 0 ? styleItem.width - nArray[0] : nArray[0];
        rECT.left = n8 + n10;
        OS.ScriptCPtoX(n5, true, n6, n7, styleItem.clusters, styleItem.visAttrs, n9, styleItem.analysis, nArray);
        n10 = (this.orientation & 0x4000000) != 0 ? styleItem.width - nArray[0] : nArray[0];
        rECT.right = n8 + n10;
    }

    public int getPreviousOffset(int n, int n2) {
        this.checkLayout();
        return this._getOffset(n, n2, false);
    }

    public int[] getRanges() {
        this.checkLayout();
        int[] nArray = new int[this.stylesCount * 2];
        int n = 0;
        for (int i = 0; i < this.stylesCount - 1; ++i) {
            if (this.styles[i].style == null) continue;
            nArray[n++] = this.styles[i].start;
            nArray[n++] = this.styles[i + 1].start - 1;
        }
        if (n != nArray.length) {
            int[] nArray2 = new int[n];
            System.arraycopy(nArray, 0, nArray2, 0, n);
            nArray = nArray2;
        }
        return nArray;
    }

    public int[] getSegments() {
        this.checkLayout();
        return this.segments;
    }

    public char[] getSegmentsChars() {
        this.checkLayout();
        return this.segmentsChars;
    }

    String getSegmentsText() {
        int n;
        int n2;
        int n3 = this.text.length();
        if (n3 == 0) {
            return this.text;
        }
        if (this.segments == null) {
            return this.text;
        }
        int n4 = this.segments.length;
        if (n4 == 0) {
            return this.text;
        }
        if (this.segmentsChars == null) {
            if (n4 == 1) {
                return this.text;
            }
            if (n4 == 2 && this.segments[0] == 0 && this.segments[1] == n3) {
                return this.text;
            }
        }
        char[] cArray = new char[n3];
        this.text.getChars(0, n3, cArray, 0);
        char[] cArray2 = new char[n3 + n4];
        int n5 = 0;
        int n6 = 0;
        int n7 = n2 = this.orientation == 0x4000000 ? 8207 : 8206;
        while (n5 < n3) {
            if (n6 < n4 && n5 == this.segments[n6]) {
                n = this.segmentsChars != null && this.segmentsChars.length > n6 ? this.segmentsChars[n6] : n2;
                cArray2[n5 + n6++] = n;
                continue;
            }
            cArray2[n5 + n6] = cArray[n5++];
        }
        while (n6 < n4) {
            this.segments[n6] = n5;
            n = this.segmentsChars != null && this.segmentsChars.length > n6 ? this.segmentsChars[n6] : n2;
            cArray2[n5 + n6++] = n;
        }
        return new String(cArray2, 0, cArray2.length);
    }

    public int getSpacing() {
        this.checkLayout();
        return this.lineSpacing;
    }

    public TextStyle getStyle(int n) {
        this.checkLayout();
        int n2 = this.text.length();
        if (0 > n || n >= n2) {
            SWT.error(6);
        }
        for (int i = 1; i < this.stylesCount; ++i) {
            if (this.styles[i].start <= n) continue;
            return this.styles[i - 1].style;
        }
        return null;
    }

    public TextStyle[] getStyles() {
        this.checkLayout();
        TextStyle[] textStyleArray = new TextStyle[this.stylesCount];
        int n = 0;
        for (int i = 0; i < this.stylesCount; ++i) {
            if (this.styles[i].style == null) continue;
            textStyleArray[n++] = this.styles[i].style;
        }
        if (n != textStyleArray.length) {
            TextStyle[] textStyleArray2 = new TextStyle[n];
            System.arraycopy(textStyleArray, 0, textStyleArray2, 0, n);
            textStyleArray = textStyleArray2;
        }
        return textStyleArray;
    }

    public int[] getTabs() {
        this.checkLayout();
        return this.tabs;
    }

    public String getText() {
        this.checkLayout();
        return this.text;
    }

    public int getWidth() {
        this.checkLayout();
        return this.wrapWidth;
    }

    public int getWrapIndent() {
        this.checkLayout();
        return this.wrapIndent;
    }

    public boolean isDisposed() {
        return this.device == null;
    }

    StyleItem[] itemize() {
        this.segmentsText = this.getSegmentsText();
        int n = this.segmentsText.length();
        SCRIPT_CONTROL sCRIPT_CONTROL = new SCRIPT_CONTROL();
        SCRIPT_STATE sCRIPT_STATE = new SCRIPT_STATE();
        int n2 = n + 1;
        if ((this.orientation & 0x4000000) != 0) {
            sCRIPT_STATE.uBidiLevel = 1;
            sCRIPT_STATE.fArabicNumContext = true;
        }
        OS.ScriptApplyDigitSubstitution(null, sCRIPT_CONTROL, sCRIPT_STATE);
        int n3 = OS.GetProcessHeap();
        int n4 = OS.HeapAlloc(n3, 8, n2 * SCRIPT_ITEM.sizeof);
        if (n4 == 0) {
            SWT.error(2);
        }
        int[] nArray = new int[1];
        char[] cArray = new char[n];
        this.segmentsText.getChars(0, n, cArray, 0);
        OS.ScriptItemize(cArray, n, n2, sCRIPT_CONTROL, sCRIPT_STATE, n4, nArray);
        StyleItem[] styleItemArray = this.merge(n4, nArray[0]);
        OS.HeapFree(n3, 0, n4);
        return styleItemArray;
    }

    StyleItem[] merge(int n, int n2) {
        StyleItem styleItem;
        if (this.styles.length > this.stylesCount) {
            StyleItem[] styleItemArray = new StyleItem[this.stylesCount];
            System.arraycopy(this.styles, 0, styleItemArray, 0, this.stylesCount);
            this.styles = styleItemArray;
        }
        int n3 = 0;
        int n4 = 0;
        int n5 = this.segmentsText.length();
        int n6 = 0;
        int n7 = 0;
        StyleItem[] styleItemArray = new StyleItem[n2 + this.stylesCount];
        SCRIPT_ITEM sCRIPT_ITEM = new SCRIPT_ITEM();
        int n8 = -1;
        int n9 = 0;
        boolean bl = false;
        boolean bl2 = n2 > 1024;
        SCRIPT_PROPERTIES sCRIPT_PROPERTIES = new SCRIPT_PROPERTIES();
        while (n4 < n5) {
            char c;
            int n10;
            styleItem = new StyleItem();
            styleItem.start = n4;
            styleItem.style = this.styles[n7].style;
            styleItemArray[n3++] = styleItem;
            OS.MoveMemory(sCRIPT_ITEM, n + n6 * SCRIPT_ITEM.sizeof, SCRIPT_ITEM.sizeof);
            styleItem.analysis = sCRIPT_ITEM.a;
            sCRIPT_ITEM.a = new SCRIPT_ANALYSIS();
            if (bl) {
                styleItem.analysis.fLinkBefore = true;
                bl = false;
            }
            char c2 = this.segmentsText.charAt(n4);
            switch (c2) {
                case '\n': 
                case '\r': {
                    styleItem.lineBreak = true;
                    break;
                }
                case '\t': {
                    styleItem.tab = true;
                }
            }
            if (n8 == -1) {
                n9 = n6 + 1;
                OS.MoveMemory(sCRIPT_ITEM, n + n9 * SCRIPT_ITEM.sizeof, SCRIPT_ITEM.sizeof);
                n8 = sCRIPT_ITEM.iCharPos;
                if (n9 < n2 && c2 == '\r' && this.segmentsText.charAt(n8) == '\n') {
                    n9 = n6 + 2;
                    OS.MoveMemory(sCRIPT_ITEM, n + n9 * SCRIPT_ITEM.sizeof, SCRIPT_ITEM.sizeof);
                    n8 = sCRIPT_ITEM.iCharPos;
                }
                if (n9 < n2 && bl2 && !styleItem.lineBreak) {
                    OS.MoveMemory(sCRIPT_PROPERTIES, this.device.scripts[styleItem.analysis.eScript], SCRIPT_PROPERTIES.sizeof);
                    if (!sCRIPT_PROPERTIES.fComplex || styleItem.tab) {
                        for (n10 = 0; n10 < 512 && n9 != n2 && (c = this.segmentsText.charAt(n8)) != '\n' && c != '\r' && c == '\t' == styleItem.tab; ++n10) {
                            OS.MoveMemory(sCRIPT_PROPERTIES, this.device.scripts[sCRIPT_ITEM.a.eScript], SCRIPT_PROPERTIES.sizeof);
                            if (!styleItem.tab && sCRIPT_PROPERTIES.fComplex) break;
                            OS.MoveMemory(sCRIPT_ITEM, n + ++n9 * SCRIPT_ITEM.sizeof, SCRIPT_ITEM.sizeof);
                            n8 = sCRIPT_ITEM.iCharPos;
                        }
                    }
                }
            }
            if ((n10 = this.translateOffset(this.styles[n7 + 1].start)) <= n8) {
                ++n7;
                n4 = n10;
                if (n4 < n8 && 0 < n4 && n4 < n5) {
                    c = this.segmentsText.charAt(n4 - 1);
                    char c3 = this.segmentsText.charAt(n4);
                    if (Compatibility.isLetter(c) && Compatibility.isLetter(c3)) {
                        styleItem.analysis.fLinkAfter = true;
                        bl = true;
                    }
                }
            }
            if (n8 <= n10) {
                n6 = n9;
                n4 = n8;
                n8 = -1;
            }
            styleItem.length = n4 - styleItem.start;
        }
        styleItem = new StyleItem();
        styleItem.start = n5;
        OS.MoveMemory(sCRIPT_ITEM, n + n2 * SCRIPT_ITEM.sizeof, SCRIPT_ITEM.sizeof);
        styleItem.analysis = sCRIPT_ITEM.a;
        styleItemArray[n3++] = styleItem;
        if (styleItemArray.length != n3) {
            StyleItem[] styleItemArray2 = new StyleItem[n3];
            System.arraycopy(styleItemArray, 0, styleItemArray2, 0, n3);
            return styleItemArray2;
        }
        return styleItemArray;
    }

    StyleItem[] reorder(StyleItem[] styleItemArray, boolean bl) {
        int n;
        int n2 = styleItemArray.length;
        if (n2 <= 1) {
            return styleItemArray;
        }
        byte[] byArray = new byte[n2];
        for (int i = 0; i < n2; ++i) {
            byArray[i] = (byte)(styleItemArray[i].analysis.s.uBidiLevel & 0x1F);
        }
        StyleItem styleItem = styleItemArray[n2 - 1];
        if (styleItem.lineBreak && !styleItem.softBreak) {
            byArray[n2 - 1] = 0;
        }
        int[] nArray = new int[n2];
        OS.ScriptLayout(n2, byArray, null, nArray);
        StyleItem[] styleItemArray2 = new StyleItem[n2];
        for (n = 0; n < n2; ++n) {
            styleItemArray2[nArray[n]] = styleItemArray[n];
        }
        if ((this.orientation & 0x4000000) != 0) {
            if (bl) {
                --n2;
            }
            for (n = 0; n < n2 / 2; ++n) {
                StyleItem styleItem2 = styleItemArray2[n];
                styleItemArray2[n] = styleItemArray2[n2 - n - 1];
                styleItemArray2[n2 - n - 1] = styleItem2;
            }
        }
        return styleItemArray2;
    }

    public void setAlignment(int n) {
        this.checkLayout();
        int n2 = 16924672;
        if ((n &= n2) == 0) {
            return;
        }
        if ((n & 0x4000) != 0) {
            n = 16384;
        }
        if ((n & 0x20000) != 0) {
            n = 131072;
        }
        if (this.alignment == n) {
            return;
        }
        this.freeRuns();
        this.alignment = n;
    }

    public void setAscent(int n) {
        this.checkLayout();
        if (n < -1) {
            SWT.error(5);
        }
        if (this.ascent == n) {
            return;
        }
        this.freeRuns();
        this.ascent = n;
    }

    public void setDescent(int n) {
        this.checkLayout();
        if (n < -1) {
            SWT.error(5);
        }
        if (this.descent == n) {
            return;
        }
        this.freeRuns();
        this.descent = n;
    }

    public void setFont(Font font) {
        Font font2;
        this.checkLayout();
        if (font != null && font.isDisposed()) {
            SWT.error(5);
        }
        if ((font2 = this.font) == font) {
            return;
        }
        this.font = font;
        if (font2 != null && font2.equals(font)) {
            return;
        }
        this.freeRuns();
    }

    public void setIndent(int n) {
        this.checkLayout();
        if (n < 0) {
            return;
        }
        if (this.indent == n) {
            return;
        }
        this.freeRuns();
        this.indent = n;
    }

    public void setJustify(boolean bl) {
        this.checkLayout();
        if (this.justify == bl) {
            return;
        }
        this.freeRuns();
        this.justify = bl;
    }

    public void setOrientation(int n) {
        this.checkLayout();
        int n2 = 0x6000000;
        if ((n &= n2) == 0) {
            return;
        }
        if ((n & 0x2000000) != 0) {
            n = 0x2000000;
        }
        if (this.orientation == n) {
            return;
        }
        this.orientation = n;
        this.freeRuns();
    }

    public void setSegments(int[] nArray) {
        this.checkLayout();
        if (this.segments == null && nArray == null) {
            return;
        }
        if (this.segments != null && nArray != null && this.segments.length == nArray.length) {
            int n;
            for (n = 0; n < nArray.length && this.segments[n] == nArray[n]; ++n) {
            }
            if (n == nArray.length) {
                return;
            }
        }
        this.freeRuns();
        this.segments = nArray;
    }

    public void setSegmentsChars(char[] cArray) {
        this.checkLayout();
        if (this.segmentsChars == null && cArray == null) {
            return;
        }
        if (this.segmentsChars != null && cArray != null && this.segmentsChars.length == cArray.length) {
            int n;
            for (n = 0; n < cArray.length && this.segmentsChars[n] == cArray[n]; ++n) {
            }
            if (n == cArray.length) {
                return;
            }
        }
        this.freeRuns();
        this.segmentsChars = cArray;
    }

    public void setSpacing(int n) {
        this.checkLayout();
        if (n < 0) {
            SWT.error(5);
        }
        if (this.lineSpacing == n) {
            return;
        }
        this.freeRuns();
        this.lineSpacing = n;
    }

    public void setStyle(TextStyle textStyle, int n, int n2) {
        int n3;
        int n4;
        int n5;
        int n6;
        this.checkLayout();
        int n7 = this.text.length();
        if (n7 == 0) {
            return;
        }
        if (n > n2) {
            return;
        }
        n = Math.min(Math.max(0, n), n7 - 1);
        n2 = Math.min(Math.max(0, n2), n7 - 1);
        int n8 = -1;
        int n9 = this.stylesCount;
        while (n9 - n8 > 1) {
            int n10 = (n9 + n8) / 2;
            if (this.styles[n10 + 1].start > n) {
                n9 = n10;
                continue;
            }
            n8 = n10;
        }
        if (0 <= n9 && n9 < this.stylesCount) {
            StyleItem styleItem = this.styles[n9];
            if (styleItem.start == n && this.styles[n9 + 1].start - 1 == n2 && (textStyle == null ? styleItem.style == null : textStyle.equals(styleItem.style))) {
                return;
            }
        }
        this.freeRuns();
        for (n6 = n5 = n9; n6 < this.stylesCount && this.styles[n6 + 1].start <= n2; ++n6) {
        }
        if (n5 == n6) {
            n4 = this.styles[n5].start;
            n3 = this.styles[n6 + 1].start - 1;
            if (n4 == n && n3 == n2) {
                this.styles[n5].style = textStyle;
                return;
            }
            if (n4 != n && n3 != n2) {
                int n11 = this.stylesCount + 2;
                if (n11 > this.styles.length) {
                    int n12 = Math.min(n11 + 1024, Math.max(64, n11 * 2));
                    StyleItem[] styleItemArray = new StyleItem[n12];
                    System.arraycopy(this.styles, 0, styleItemArray, 0, this.stylesCount);
                    this.styles = styleItemArray;
                }
                System.arraycopy(this.styles, n6 + 1, this.styles, n6 + 3, this.stylesCount - n6 - 1);
                StyleItem styleItem = new StyleItem();
                styleItem.start = n;
                styleItem.style = textStyle;
                this.styles[n5 + 1] = styleItem;
                styleItem = new StyleItem();
                styleItem.start = n2 + 1;
                styleItem.style = this.styles[n5].style;
                this.styles[n5 + 2] = styleItem;
                this.stylesCount = n11;
                return;
            }
        }
        if (n == this.styles[n5].start) {
            --n5;
        }
        if (n2 == this.styles[n6 + 1].start - 1) {
            ++n6;
        }
        if ((n4 = this.stylesCount + 1 - (n6 - n5 - 1)) > this.styles.length) {
            n3 = Math.min(n4 + 1024, Math.max(64, n4 * 2));
            StyleItem[] styleItemArray = new StyleItem[n3];
            System.arraycopy(this.styles, 0, styleItemArray, 0, this.stylesCount);
            this.styles = styleItemArray;
        }
        System.arraycopy(this.styles, n6, this.styles, n5 + 2, this.stylesCount - n6);
        StyleItem styleItem = new StyleItem();
        styleItem.start = n;
        styleItem.style = textStyle;
        this.styles[n5 + 1] = styleItem;
        this.styles[n5 + 2].start = n2 + 1;
        this.stylesCount = n4;
    }

    public void setTabs(int[] nArray) {
        this.checkLayout();
        if (this.tabs == null && nArray == null) {
            return;
        }
        if (this.tabs != null && nArray != null && this.tabs.length == nArray.length) {
            int n;
            for (n = 0; n < nArray.length && this.tabs[n] == nArray[n]; ++n) {
            }
            if (n == nArray.length) {
                return;
            }
        }
        this.freeRuns();
        this.tabs = nArray;
    }

    public void setText(String string) {
        this.checkLayout();
        if (string == null) {
            SWT.error(4);
        }
        if (string.equals(this.text)) {
            return;
        }
        this.freeRuns();
        this.text = string;
        this.styles = new StyleItem[2];
        this.styles[0] = new StyleItem();
        this.styles[1] = new StyleItem();
        this.styles[1].start = string.length();
        this.stylesCount = 2;
    }

    public void setWidth(int n) {
        this.checkLayout();
        if (n < -1 || n == 0) {
            SWT.error(5);
        }
        if (this.wrapWidth == n) {
            return;
        }
        this.freeRuns();
        this.wrapWidth = n;
    }

    public void setWrapIndent(int n) {
        this.checkLayout();
        if (n < 0) {
            return;
        }
        if (this.wrapIndent == n) {
            return;
        }
        this.freeRuns();
        this.wrapIndent = n;
    }

    boolean shape(int n, StyleItem styleItem, char[] cArray, int[] nArray, int n2, SCRIPT_PROPERTIES sCRIPT_PROPERTIES) {
        short[] sArray;
        boolean bl;
        boolean bl2 = bl = !sCRIPT_PROPERTIES.fComplex && !styleItem.analysis.fNoGlyphIndex;
        if (bl && OS.ScriptGetCMap(n, styleItem.psc, cArray, cArray.length, 0, sArray = new short[cArray.length]) != 0) {
            if (styleItem.psc != 0) {
                OS.ScriptFreeCache(styleItem.psc);
                nArray[0] = 0;
                OS.MoveMemory(styleItem.psc, new int[1], OS.PTR_SIZEOF);
            }
            return false;
        }
        int n3 = OS.ScriptShape(n, styleItem.psc, cArray, cArray.length, n2, styleItem.analysis, styleItem.glyphs, styleItem.clusters, styleItem.visAttrs, nArray);
        styleItem.glyphCount = nArray[0];
        if (bl) {
            return true;
        }
        if (n3 != -2147220992) {
            int n4;
            if (styleItem.analysis.fNoGlyphIndex) {
                return true;
            }
            SCRIPT_FONTPROPERTIES sCRIPT_FONTPROPERTIES = new SCRIPT_FONTPROPERTIES();
            sCRIPT_FONTPROPERTIES.cBytes = SCRIPT_FONTPROPERTIES.sizeof;
            OS.ScriptGetFontProperties(n, styleItem.psc, sCRIPT_FONTPROPERTIES);
            short[] sArray2 = new short[nArray[0]];
            OS.MoveMemory(sArray2, styleItem.glyphs, sArray2.length * 2);
            for (n4 = 0; n4 < sArray2.length && sArray2[n4] != sCRIPT_FONTPROPERTIES.wgDefault; ++n4) {
            }
            if (n4 == sArray2.length) {
                return true;
            }
        }
        if (styleItem.psc != 0) {
            OS.ScriptFreeCache(styleItem.psc);
            nArray[0] = 0;
            OS.MoveMemory(styleItem.psc, new int[1], OS.PTR_SIZEOF);
        }
        styleItem.glyphCount = 0;
        return false;
    }

    void shape(int n, StyleItem styleItem) {
        Object object;
        Object object2;
        if (styleItem.tab || styleItem.lineBreak) {
            return;
        }
        if (styleItem.glyphs != 0) {
            return;
        }
        int[] nArray = new int[1];
        char[] cArray = new char[styleItem.length];
        this.segmentsText.getChars(styleItem.start, styleItem.start + styleItem.length, cArray, 0);
        int n2 = cArray.length * 3 / 2 + 16;
        int n3 = OS.GetProcessHeap();
        styleItem.glyphs = OS.HeapAlloc(n3, 8, n2 * 2);
        if (styleItem.glyphs == 0) {
            SWT.error(2);
        }
        styleItem.clusters = OS.HeapAlloc(n3, 8, n2 * 2);
        if (styleItem.clusters == 0) {
            SWT.error(2);
        }
        styleItem.visAttrs = OS.HeapAlloc(n3, 8, n2 * 2);
        if (styleItem.visAttrs == 0) {
            SWT.error(2);
        }
        styleItem.psc = OS.HeapAlloc(n3, 8, OS.PTR_SIZEOF);
        if (styleItem.psc == 0) {
            SWT.error(2);
        }
        short s = styleItem.analysis.eScript;
        SCRIPT_PROPERTIES sCRIPT_PROPERTIES = new SCRIPT_PROPERTIES();
        OS.MoveMemory(sCRIPT_PROPERTIES, this.device.scripts[s], SCRIPT_PROPERTIES.sizeof);
        boolean bl = this.shape(n, styleItem, cArray, nArray, n2, sCRIPT_PROPERTIES);
        if (!bl && sCRIPT_PROPERTIES.fPrivateUseArea) {
            styleItem.analysis.fNoGlyphIndex = true;
            bl = this.shape(n, styleItem, cArray, nArray, n2, sCRIPT_PROPERTIES);
        }
        if (!bl) {
            int n4;
            int n5;
            int n6;
            int n7 = OS.GetCurrentObject(n, 6);
            int n8 = 0;
            object2 = new char[Math.min(cArray.length, 2)];
            object = new SCRIPT_LOGATTR();
            this.breakRun(styleItem);
            int n9 = 0;
            for (n6 = 0; n6 < cArray.length; ++n6) {
                OS.MoveMemory((SCRIPT_LOGATTR)object, styleItem.psla + n6 * SCRIPT_LOGATTR.sizeof, SCRIPT_LOGATTR.sizeof);
                if (((SCRIPT_LOGATTR)object).fWhiteSpace) continue;
                object2[n9++] = cArray[n6];
                if (n9 == ((char[])object2).length) break;
            }
            if (n9 > 0) {
                Callback callback;
                int n10;
                n6 = OS.HeapAlloc(n3, 8, OS.SCRIPT_STRING_ANALYSIS_sizeof());
                int n11 = OS.CreateEnhMetaFile(n, null, null, null);
                n5 = OS.SelectObject(n11, n7);
                int n12 = 6304;
                if (OS.ScriptStringAnalyse(n11, object2, n9, 0, -1, n12, 0, null, null, 0, 0, 0, n6) == 0) {
                    OS.ScriptStringOut(n6, 0, 0, 0, null, 0, 0, false);
                    OS.ScriptStringFree(n6);
                }
                OS.HeapFree(n3, 0, n6);
                OS.SelectObject(n11, n5);
                n4 = OS.CloseEnhMetaFile(n11);
                EMREXTCREATEFONTINDIRECTW eMREXTCREATEFONTINDIRECTW = new EMREXTCREATEFONTINDIRECTW();
                class MetaFileEnumProc {
                    private final /* synthetic */ EMREXTCREATEFONTINDIRECTW val$emr;

                    MetaFileEnumProc(EMREXTCREATEFONTINDIRECTW eMREXTCREATEFONTINDIRECTW) {
                        this.val$emr = eMREXTCREATEFONTINDIRECTW;
                    }

                    int metaFileEnumProc(int n, int n2, int n3, int n4, int n5) {
                        OS.MoveMemory(this.val$emr.emr, n3, EMR.sizeof);
                        switch (this.val$emr.emr.iType) {
                            case 82: {
                                OS.MoveMemory(this.val$emr, n3, EMREXTCREATEFONTINDIRECTW.sizeof);
                                break;
                            }
                            case 84: {
                                return 0;
                            }
                        }
                        return 1;
                    }
                }
                MetaFileEnumProc metaFileEnumProc = new MetaFileEnumProc(eMREXTCREATEFONTINDIRECTW);
                boolean bl2 = false;
                if (bl2) {
                    metaFileEnumProc.metaFileEnumProc(0, 0, 0, 0, 0);
                }
                if ((n10 = (callback = new Callback(metaFileEnumProc, "metaFileEnumProc", 5)).getAddress()) == 0) {
                    SWT.error(3);
                }
                OS.EnumEnhMetaFile(0, n4, n10, 0, null);
                OS.DeleteEnhMetaFile(n4);
                callback.dispose();
                n8 = OS.CreateFontIndirectW(eMREXTCREATEFONTINDIRECTW.elfw.elfLogFont);
            } else {
                for (n6 = 0; n6 < this.allRuns.length - 1; ++n6) {
                    LOGFONT lOGFONT;
                    StyleItem styleItem2;
                    if (this.allRuns[n6] != styleItem) continue;
                    if (n6 > 0) {
                        styleItem2 = this.allRuns[n6 - 1];
                        if (styleItem2.analysis.eScript == styleItem.analysis.eScript) {
                            n5 = this.getItemFont(styleItem2);
                            lOGFONT = OS.IsUnicode ? new LOGFONTW() : new LOGFONTA();
                            OS.GetObject(n5, LOGFONT.sizeof, lOGFONT);
                            n8 = OS.CreateFontIndirect(lOGFONT);
                        }
                    }
                    if (n8 != 0 || n6 + 1 >= this.allRuns.length - 1) break;
                    styleItem2 = this.allRuns[n6 + 1];
                    if (styleItem2.analysis.eScript != styleItem.analysis.eScript) break;
                    OS.SelectObject(n, this.getItemFont(styleItem2));
                    this.shape(n, styleItem2);
                    n5 = this.getItemFont(styleItem2);
                    lOGFONT = OS.IsUnicode ? new LOGFONTW() : new LOGFONTA();
                    OS.GetObject(n5, LOGFONT.sizeof, lOGFONT);
                    n8 = OS.CreateFontIndirect(lOGFONT);
                    break;
                }
            }
            if (n8 != 0) {
                OS.SelectObject(n, n8);
                bl = this.shape(n, styleItem, cArray, nArray, n2, sCRIPT_PROPERTIES);
                if (bl) {
                    styleItem.fallbackFont = n8;
                }
            }
            if (!bl && !sCRIPT_PROPERTIES.fComplex) {
                styleItem.analysis.fNoGlyphIndex = true;
                bl = this.shape(n, styleItem, cArray, nArray, n2, sCRIPT_PROPERTIES);
                if (bl) {
                    styleItem.fallbackFont = n8;
                } else {
                    styleItem.analysis.fNoGlyphIndex = false;
                }
            }
            if (!bl && this.mLangFontLink2 != 0) {
                int[] nArray2 = new int[1];
                int[] nArray3 = new int[1];
                int[] nArray4 = new int[1];
                OS.VtblCall(4, this.mLangFontLink2, cArray, cArray.length, 0, nArray3, nArray4);
                if (OS.VtblCall(10, this.mLangFontLink2, n, nArray3[0], (int)cArray[0], nArray2) == 0) {
                    LOGFONT lOGFONT = OS.IsUnicode ? new LOGFONTW() : new LOGFONTA();
                    OS.GetObject(nArray2[0], LOGFONT.sizeof, lOGFONT);
                    OS.VtblCall(8, this.mLangFontLink2, nArray2[0]);
                    n4 = OS.CreateFontIndirect(lOGFONT);
                    int n13 = OS.SelectObject(n, n4);
                    bl = this.shape(n, styleItem, cArray, nArray, n2, sCRIPT_PROPERTIES);
                    if (bl) {
                        styleItem.fallbackFont = n4;
                    } else {
                        OS.SelectObject(n, n13);
                        OS.DeleteObject(n4);
                    }
                }
            }
            if (!bl) {
                OS.SelectObject(n, n7);
            }
            if (n8 != 0 && n8 != styleItem.fallbackFont) {
                OS.DeleteObject(n8);
            }
        }
        if (!bl) {
            OS.ScriptShape(n, styleItem.psc, cArray, cArray.length, n2, styleItem.analysis, styleItem.glyphs, styleItem.clusters, styleItem.visAttrs, nArray);
            styleItem.glyphCount = nArray[0];
        }
        int[] nArray5 = new int[3];
        styleItem.advances = OS.HeapAlloc(n3, 8, styleItem.glyphCount * 4);
        if (styleItem.advances == 0) {
            SWT.error(2);
        }
        styleItem.goffsets = OS.HeapAlloc(n3, 8, styleItem.glyphCount * 8);
        if (styleItem.goffsets == 0) {
            SWT.error(2);
        }
        OS.ScriptPlace(n, styleItem.psc, styleItem.glyphs, styleItem.glyphCount, styleItem.visAttrs, styleItem.analysis, styleItem.advances, styleItem.goffsets, nArray5);
        styleItem.width = nArray5[0] + nArray5[1] + nArray5[2];
        TextStyle textStyle = styleItem.style;
        if (textStyle != null) {
            object2 = null;
            if ((textStyle.underline || textStyle.strikeout) && OS.GetOutlineTextMetrics(n, OUTLINETEXTMETRIC.sizeof, (OUTLINETEXTMETRIC)(object2 = (Object)(OS.IsUnicode ? new OUTLINETEXTMETRICW() : new OUTLINETEXTMETRICA()))) == 0) {
                object2 = null;
            }
            if (textStyle.metrics != null) {
                object = textStyle.metrics;
                styleItem.width = ((GlyphMetrics)object).width * Math.max(1, styleItem.glyphCount);
                styleItem.ascent = ((GlyphMetrics)object).ascent;
                styleItem.descent = ((GlyphMetrics)object).descent;
                styleItem.leading = 0;
            } else {
                object = null;
                if (object2 != null) {
                    object = OS.IsUnicode ? ((OUTLINETEXTMETRICW)object2).otmTextMetrics : ((OUTLINETEXTMETRICA)object2).otmTextMetrics;
                } else {
                    object = OS.IsUnicode ? new TEXTMETRICW() : new TEXTMETRICA();
                    OS.GetTextMetrics(n, (TEXTMETRIC)object);
                }
                styleItem.ascent = ((TEXTMETRIC)object).tmAscent;
                styleItem.descent = ((TEXTMETRIC)object).tmDescent;
                styleItem.leading = ((TEXTMETRIC)object).tmInternalLeading;
            }
            if (object2 != null) {
                styleItem.underlinePos = object2.otmsUnderscorePosition;
                styleItem.underlineThickness = Math.max(1, object2.otmsUnderscoreSize);
                styleItem.strikeoutPos = object2.otmsStrikeoutPosition;
                styleItem.strikeoutThickness = Math.max(1, object2.otmsStrikeoutSize);
            } else {
                styleItem.underlinePos = 1;
                styleItem.underlineThickness = 1;
                styleItem.strikeoutPos = styleItem.ascent / 2;
                styleItem.strikeoutThickness = 1;
            }
            styleItem.ascent += textStyle.rise;
            styleItem.descent -= textStyle.rise;
        } else {
            object2 = OS.IsUnicode ? new TEXTMETRICW() : new TEXTMETRICA();
            OS.GetTextMetrics(n, (TEXTMETRIC)object2);
            styleItem.ascent = object2.tmAscent;
            styleItem.descent = object2.tmDescent;
            styleItem.leading = object2.tmInternalLeading;
        }
    }

    int validadeOffset(int n, int n2) {
        n = this.untranslateOffset(n);
        return this.translateOffset(n + n2);
    }

    public String toString() {
        if (this.isDisposed()) {
            return "TextLayout {*DISPOSED*}";
        }
        return "TextLayout {}";
    }

    int translateOffset(int n) {
        int n2 = this.text.length();
        if (n2 == 0) {
            return n;
        }
        if (this.segments == null) {
            return n;
        }
        int n3 = this.segments.length;
        if (n3 == 0) {
            return n;
        }
        if (this.segmentsChars == null) {
            if (n3 == 1) {
                return n;
            }
            if (n3 == 2 && this.segments[0] == 0 && this.segments[1] == n2) {
                return n;
            }
        }
        for (int i = 0; i < n3 && n - i >= this.segments[i]; ++i) {
            ++n;
        }
        return n;
    }

    int untranslateOffset(int n) {
        int n2 = this.text.length();
        if (n2 == 0) {
            return n;
        }
        if (this.segments == null) {
            return n;
        }
        int n3 = this.segments.length;
        if (n3 == 0) {
            return n;
        }
        if (this.segmentsChars == null) {
            if (n3 == 1) {
                return n;
            }
            if (n3 == 2 && this.segments[0] == 0 && this.segments[1] == n2) {
                return n;
            }
        }
        for (int i = 0; i < n3 && n > this.segments[i]; --n, ++i) {
        }
        return n;
    }

    static {
        OS.IIDFromString("{275c23e2-3747-11d0-9fea-00aa003f8646}\u0000".toCharArray(), CLSID_CMultiLanguage);
        OS.IIDFromString("{DCCFC162-2B38-11d2-B7EC-00C04F8F5D9A}\u0000".toCharArray(), IID_IMLangFontLink2);
    }

    class StyleItem {
        TextStyle style;
        int start;
        int length;
        boolean lineBreak;
        boolean softBreak;
        boolean tab;
        SCRIPT_ANALYSIS analysis;
        int psc = 0;
        int glyphs;
        int glyphCount;
        int clusters;
        int visAttrs;
        int advances;
        int goffsets;
        int width;
        int ascent;
        int descent;
        int leading;
        int x;
        int underlinePos;
        int underlineThickness;
        int strikeoutPos;
        int strikeoutThickness;
        int justify;
        int psla;
        int fallbackFont;

        StyleItem() {
        }

        void free() {
            int n = OS.GetProcessHeap();
            if (this.psc != 0) {
                OS.ScriptFreeCache(this.psc);
                OS.HeapFree(n, 0, this.psc);
                this.psc = 0;
            }
            if (this.glyphs != 0) {
                OS.HeapFree(n, 0, this.glyphs);
                this.glyphs = 0;
                this.glyphCount = 0;
            }
            if (this.clusters != 0) {
                OS.HeapFree(n, 0, this.clusters);
                this.clusters = 0;
            }
            if (this.visAttrs != 0) {
                OS.HeapFree(n, 0, this.visAttrs);
                this.visAttrs = 0;
            }
            if (this.advances != 0) {
                OS.HeapFree(n, 0, this.advances);
                this.advances = 0;
            }
            if (this.goffsets != 0) {
                OS.HeapFree(n, 0, this.goffsets);
                this.goffsets = 0;
            }
            if (this.justify != 0) {
                OS.HeapFree(n, 0, this.justify);
                this.justify = 0;
            }
            if (this.psla != 0) {
                OS.HeapFree(n, 0, this.psla);
                this.psla = 0;
            }
            if (this.fallbackFont != 0) {
                OS.DeleteObject(this.fallbackFont);
                this.fallbackFont = 0;
            }
            this.x = 0;
            this.descent = 0;
            this.ascent = 0;
            this.width = 0;
            this.softBreak = false;
            this.lineBreak = false;
        }

        public String toString() {
            return "StyleItem {" + this.start + ", " + this.style + "}";
        }
    }
}

