/**
 *  ueditor完整配置项
 *  可以在这里配置整个编辑器的特性
 */
/**************************提示********************************
 * 所有被注释的配置项均为UEditor默认值。
 * 修改默认配置请首先确保已经完全明确该参数的真实用途。
 * 主要有两种修改方案，一种是取消此处注释，然后修改成对应参数；另一种是在实例化编辑器时传入对应参数。
 * 当升级编辑器时，可直接使用旧版配置文件替换新版配置文件,不用担心旧版配置文件中因缺少新功能所需的参数而导致脚本报错。
 **************************提示********************************/


(function() {
    /**
     * 编辑器资源文件根路径。它所表示的含义是：以编辑器实例化页面为当前路径，指向编辑器资源文件（即dialog等文件夹）的路径。
     * 鉴于很多同学在使用编辑器的时候出现的种种路径问题，此处强烈建议大家使用"相对于网站根目录的相对路径"进行配置。
     * "相对于网站根目录的相对路径"也就是以斜杠开头的形如"/myProject/ueditor/"这样的路径。
     * 如果站点中有多个不在同一层级的页面需要实例化编辑器，且引用了同一UEditor的时候，此处的URL可能不适用于每个页面的编辑器。
     * 因此，UEditor提供了针对不同页面的编辑器可单独配置的根路径，具体来说，在需要实例化编辑器的页面最顶部写上如下代码即可。当然，需要令此处的URL等于对应的配置。
     * window.UEDITOR_HOME_URL = "/xxxx/xxxx/";
     */
    var URL;
    var showCheckbox = (function() {
        var browser = $.browser;
        if (browser.msie && browser.version <= 7) {
            return '';
        }
        return 'notecheckbox';
    })();
    /**
     * 此处配置写法适用于UEditor小组成员开发使用，外部部署用户请按照上述说明方式配置即可，建议保留下面两行，以兼容可在具体每个页面配置window.UEDITOR_HOME_URL的功能。
     */
    var tmp = window.location.pathname;
    //URL = window.UEDITOR_HOME_URL||tmp.substr(0,tmp.lastIndexOf("\/")+1).replace("_examples/","").replace("website/","");//这里你可以配置成ueditor目录在您网站的相对路径或者绝对路径（指以http开头的绝对路径）
    URL = '';

    /**
     * 配置项主体。注意，此处所有涉及到路径的配置别遗漏URL变量。
     */
    window.UEDITOR_CONFIG = {

        //为编辑器实例添加一个路径，这个不能被注释
        UEDITOR_HOME_URL: URL
        //工具栏上的所有的功能按钮和下拉框，可以在new编辑器的实例时选择自己需要的从新定义
        ,
        toolbars: [
            ['undo', 'redo', 'FontSize', 'FontFamily', 'Bold', 'Italic', 'Underline', 'StrikeThrough', 'ForeColor', 'BackColor',
                '|', 'lineheight', 'indent', 'InsertOrderedList', 'InsertUnorderedList',
                'JustifyLeft', 'JustifyCenter', 'JustifyRight', 'JustifyFull',
                '|','Horizontal', 'formatmatch',
                'InsertImage', 'Link', 'InsertTable', 'Source', 'HighlightCode', showCheckbox]
        ]
        //当鼠标放在工具栏上时显示的tooltip提示,留空支持自动多语言配置，否则以配置值为准
        ,
        labelMap: {
            'anchor': '锚点',
            'undo': '撤销',
            'redo': '重做',
            'bold': '加粗',
            'indent': '首行缩进',
            'snapscreen': '截图',
            'italic': '斜体',
            'underline': '下划线',
            'strikethrough': '删除线',
            'subscript': '下标',
            'superscript': '上标',
            'formatmatch': '格式刷',
            'source': '源代码',
            'blockquote': '引用',
            'pasteplain': '纯文本粘贴模式',
            'selectall': '全选',
            'print': '打印',
            'preview': '预览',
            'horizontal': '分隔线',
            'removeformat': '清除格式',
            'time': '时间',
            'date': '日期',
            'unlink': '取消链接',
            'insertrow': '前插入行',
            'insertcol': '前插入列',
            'mergeright': '右合并单元格',
            'mergedown': '下合并单元格',
            'deleterow': '删除行',
            'deletecol': '删除列',
            'splittorows': '拆分成行',
            'splittocols': '拆分成列',
            'splittocells': '完全拆分单元格',
            'mergecells': '合并多个单元格',
            'deletetable': '删除表格',
            'insertparagraphbeforetable': '表格前插行',
            'cleardoc': '清空文档',
            'fontfamily': '字体',
            'fontsize': '字号',
            'paragraph': '段落格式',
            'insertimage': '图片',
            'inserttable': '表格',
            'link': '超链接',
            'emotion': '表情',
            'spechars': '特殊字符',
            'searchreplace': '查询替换',
            'map': 'Baidu地图',
            'gmap': 'Google地图',
            'insertvideo': '视频',
            'help': '帮助',
            'justifyleft': '居左对齐',
            'justifyright': '居右对齐',
            'justifycenter': '居中对齐',
            'justifyjustify': '两端对齐',
            'forecolor': '字体颜色',
            'backcolor': '背景色',
            'insertorderedlist': '有序列表',
            'insertunorderedlist': '无序列表',
            'fullscreen': '全屏',
            'directionalityltr': '从左向右输入',
            'directionalityrtl': '从右向左输入',
            'RowSpacingTop': '段前距',
            'RowSpacingBottom': '段后距',
            'highlightcode': '插入代码',
            'pagebreak': '分页',
            'insertframe': '插入Iframe',
            'imagenone': '默认',
            'imageleft': '左浮动',
            'imageright': '右浮动',
            'attachment': '附件',
            'imagecenter': '居中',
            'wordimage': '图片转存',
            'lineheight': '行间距',
            'customstyle': '自定义标题',
            'autotypeset': '自动排版',
            'notecheckbox': '复选框'
        },
        contextMenu: [{
            label: '表格属性',
            cmdName: 'edittable',
            exec: function() {
                if (UE.ui['edittable']) {
                    new UE.ui['edittable'](this);
                }
                this.getDialog('edittable').open();
            }
        }, {
            label: '单元格属性',
            cmdName: 'edittd',
            exec: function() {
                if (UE.ui['edittd']) {
                    new UE.ui['edittd'](this);
                }
                this.getDialog('edittd').open();
            }
        }, {
            group: '表格',
            icon: 'table',

            subMenu: [{
                label: '删除表格',
                cmdName: 'deletetable'
            }, 
            // {
            //     label: '表格前插行',
            //     cmdName: 'insertparagraphbeforetable'
            // },
                '-', {
                label: '删除行',
                cmdName: 'deleterow'
            }, {
                label: '删除列',
                cmdName: 'deletecol'
            },
                '-', {
                label: '上插入行',
                cmdName: 'insertrow'
            }, {
                label: '下插入行',
                cmdName:'insertrownext'
            }, {
                label: '左插入列',
                cmdName: 'insertcol'
            },{
                label: '右插入列',
                cmdName: 'insertcolnext'
            },
                '-', {
                label: '右合并单元格',
                cmdName: 'mergeright'
            }, {
                label: '下合并单元格',
                cmdName: 'mergedown'
            },
                '-', {
                label: '拆分成行',
                cmdName: 'splittorows'
            }, {
                label: '拆分成列',
                cmdName: 'splittocols'
            }, {
                label: '合并多个单元格',
                cmdName: 'mergecells'
            }, {
                label: '完全拆分单元格',
                cmdName: 'splittocells'
            }]
        }],
        initialFrameWidth: 'auto',
        //图片文件夹所在的路径，用于显示时修正后台返回的图片url！具体图片保存路径需要在后台设置。！important
        compressSide: 0,
        //等比压缩的基准，确定maxImageSideLength参数的参照对象。0为按照最长边，1为按照宽度，2为按照高度
        maxImageSideLength: 100000,
        //上传图片最大允许的边长，超过会自动等比缩放,不缩放就设置一个比较大的值
        relativePath: true,
        //是否开启相对路径。开启状态下所有本地图片的路径都将以相对路径形式进行保存.强烈建议开启！
        filePath: URL + "server/upload/",
        //附件文件夹保存路径
        catchRemoteImageEnable: false,
        //是否开启远程图片抓取
        catcherUrl: URL + "server/submit/php/getRemoteImage.php",
        //处理远程图片抓取的地址
        localDomain: "baidu.com",
        //本地顶级域名，当开启远程图片抓取时，除此之外的所有其它域名下的图片都将被抓取到本地
        imageManagerPath: URL + "server/submit/php/imageManager.php",
        //图片在线浏览的处理地址
        UEDITOR_HOME_URL: URL,

        //dialog内容的路径 ～会被替换成URL
        iframeUrlMap: {
            'anchor': '~/dialogs/anchor/anchor.html',
            'insertimage': '~/dialogs/image/image.html',
            'inserttable': '~/dialogs/table/table.html',
            'link': '~/dialogs/link/link.html',
            'spechars': '~/dialogs/spechars/spechars.html',
            'searchreplace': '~/dialogs/searchreplace/searchreplace.html',
            'map': '~/dialogs/map/map.html',
            'gmap': '~/dialogs/gmap/gmap.html',
            'insertvideo': '~/dialogs/video/video.html',
            'help': '~/dialogs/help/help.html',
            'highlightcode': '~/dialogs/code/code.html',
            'emotion': '~/dialogs/emotion/emotion.html',
            'wordimage': '~/dialogs/wordimage/wordimage.html',
            'attachment': '~/dialogs/attachment/attachment.html',
            'insertframe': '~/dialogs/insertframe/insertframe.html',
            'edittd': '~/dialogs/table/edittd.html',
            'snapscreen': '~/dialogs/snapscreen/snapscreen.html'
        },
        //所有的的下拉框显示的内容
        listMap: {
            //字体
            'fontfamily': ['微软雅黑', '宋体', '楷体', '隶书', '黑体', 'andale mono', 'arial', 'comic sans ms', 'impact', 'times new roman'],
            //字号
            'fontsize': [12, 14, 16, 18, 20, 24, 36, 48, 64],
            //段落格式 值:显示的名字
            'paragraph': ['p:段落', 'h1:标题 1', 'h2:标题 2', 'h3:标题 3', 'h4:标题 4', 'h5:标题 5', 'h6:标题 6'],
            //段间距 值和显示的名字相同
            'rowspacing': ['5', '10', '15', '20', '25'],
            //行内间距 值和显示的名字相同
            'lineheight': ['1', '1.5', '1.75', '2', '3', '4', '5'],
            //block的元素是依据设置段落的逻辑设置的，inline的元素依据BIU的逻辑设置
            //尽量使用一些常用的标签
            //参数说明
            //tag 使用的标签名字
            //label 显示的名字也是用来标识不同类型的标识符，注意这个值每个要不同，
            //style 添加的样式
            //每一个对象就是一个自定义的样式
            'customstyle': [{
                tag: 'h1',
                label: '居中标题',
                style: 'border-bottom:#ccc 2px solid;padding:0 4px 0 0;text-align:center;margin:0 0 20px 0;'
            }, {
                tag: 'h1',
                label: '居左标题',
                style: 'border-bottom:#ccc 2px solid;padding:0 4px 0 0;margin:0 0 10px 0;'
            }, {
                tag: 'span',
                label: '强调',
                style: 'font-style:italic;font-weight:bold;color:#000'
            }, {
                tag: 'span',
                label: '明显强调',
                style: 'font-style:italic;font-weight:bold;color:rgb(51, 153, 204)'
            }]
        },
        //字体对应的style值
        fontMap: {
            '微软雅黑': ['微软雅黑', 'Microsoft YaHei'],
            '宋体': ['宋体', 'SimSun'],
            '楷体': ['楷体', '楷体_GB2312', 'SimKai'],
            '黑体': ['黑体', 'SimHei'],
            '隶书': ['隶书', 'SimLi'],
            'andale mono': ['andale mono'],
            'arial': ['arial', 'helvetica', 'sans-serif'],
            'comic sans ms': ['comic sans ms'],
            'impact': ['impact', 'chicago'],
            'times new roman': ['times new roman']
        },

        initialStyle: //编辑器内部样式
        //选中的td上的样式
        '.selectTdClass{background-color:#3399FF !important}' +
        //插入的表格的默认样式
        'table{clear:both;margin-bottom:10px;border-collapse:collapse;word-break:break-all;}' +
        //分页符的样式
        '.pagebreak{display:block;clear:both !important;cursor:default !important;width: 100% !important;margin:0;}' +
        //锚点的样式,注意这里背景图的路径
        '.anchorclass{background: url("' + URL + 'themes/default/images/anchor.gif") no-repeat scroll left center transparent;border: 1px dotted #0000FF;cursor: auto;display: inline-block;height: 16px;width: 15px;}' +
        //设置四周的留边
        '.view{padding:0;word-wrap:break-word;word-break:break-all;cursor:text;height:100%;}\n' + 'body{margin:8px;font-family:"微软雅黑",sans-serif;font-size:14px;}' +
        //针对li的处理
        'li{clear:both}' +
        //设置段落间距
        'p{margin:5px 0;}img{max-width:100%;}' +
        //九宫格日记
        '.diary9-td{border: 1px solid #b9da9b;} .diary9-title{background-color: #d6f1bf;text-align: center;} .diary9-tr-content{height:20px} .diary9-tr-block{height:120px}' + '.note-bold{font-weight:bold}' + '.editor-note-checkbox{position: relative;top: 6px;}',
        //初始化编辑器的内容,也可以通过textarea/script给值，看官网例子
        initialContent: '',
        autoClearinitialContent: false,
        //是否自动清除编辑器初始内容，注意：如果focus属性设置为true,这个也为真，那么编辑器一上来就会触发导致初始化的内容看不到了
        iframeCssUrl: '',
        //要引入css的url
        removeFormatTags: 'b,big,code,del,dfn,em,font,i,ins,kbd,q,samp,small,span,strike,strong,sub,sup,tt,u,var',
        //清除格式删除的标签
        removeFormatAttributes: 'class,style,lang,width,height,align,hspace,valign',
        //清除格式删除的属性
        enterTag: 'p',
        //编辑器回车标签。p或br
        maxUndoCount: 20,
        //最多可以回退的次数
        maxInputCount: 4,
        //当输入的字符数超过该值时，保存一次现场
        selectedTdClass: 'selectTdClass',
        //设定选中td的样式名称
        pasteplain: false,
        //是否纯文本粘贴。false为不使用纯文本粘贴，true为使用纯文本粘贴
        //提交表单时，服务器获取编辑器提交内容的所用的参数，多实例时可以给容器name属性，会将name给定的值最为每个实例的键值，不用每次实例化的时候都设置这个值
        textarea: 'editorValue',
        focus: false,
        //初始化时，是否让编辑器获得焦点true或false
        indentValue: '2em',
        //初始化时，首行缩进距离
        pageBreakTag: '_baidu_page_break_tag_',
        //分页符
        minFrameHeight: 320,
        //最小高度
        autoHeightEnabled: false,
        //是否自动长高
        autoFloatEnabled: true,
        //是否保持toolbar的位置不动
        elementPathEnabled: false,
        //是否启用elementPath
        wordCount: true,
        //是否开启字数统计
        maximumWords: 1000000,
        //允许的最大字符数
        tabSize: 4,
        //tab的宽度
        tabNode: '&nbsp;',
        //tab时的单一字符
        imagePopup: true,
        //图片操作的浮层开关，默认打开
        emotionLocalization: false,
        //是否开启表情本地化，默认关闭。若要开启请确保emotion文件夹下包含官网提供的images表情文件夹
        sourceEditor: "codemirror",
        //源码的查看方式，codemirror 是代码高亮，textarea是文本框
        tdHeight: '20',
        //单元格的默认高度
        highlightJsUrl: URL + "third-party/SyntaxHighlighter/shCore.js",
        highlightCssUrl: URL + "third-party/SyntaxHighlighter/shCoreDefault.css",
        codeMirrorJsUrl: URL + "third-party/codemirror2.15/codemirror.js",
        codeMirrorCssUrl: URL + "third-party/codemirror2.15/codemirror.css",
        zIndex: 999999,
        //编辑器z-index的基数
        fullscreen: false,
        //是否上来就是全屏
        snapscreenHost: '127.0.0.1',
        //屏幕截图的server端文件所在的网站地址或者ip，请不要加http://
        snapscreenServerFile: URL + "server/upload/php/snapImgUp.php",
        //屏幕截图的server端保存程序，UEditor的范例代码为“URL +"server/upload/php/snapImgUp.php"”
        snapscreenServerPort: 80,
        //屏幕截图的server端端口
        snapscreenImgAlign: 'center',
        //截图的图片默认的排版方式
        snapscreenImgIsUseImagePath: 1,
        //是否使用上面定义的imagepath，如果为否，那么server端需要直接返回图片的完整路径
        messages: {
            pasteMsg: '编辑器已过滤掉您粘贴内容中不支持的格式！',
            //粘贴提示
            wordCountMsg: '当前已输入 {#count} 个字符，您还可以输入{#leave} 个字符 ',
            //字数统计提示，{#count}代表当前字数，{#leave}代表还可以输入多少字符数。
            wordOverFlowMsg: '你输入的字符个数已经超出最大允许值，服务器可能会拒绝保存！',
            //超出字数限制
            pasteWordImgMsg: '您粘贴的内容中包含本地图片，需要转存后才能正确显示！',
            snapScreenNotIETip: '截图功能需要在ie浏览器下使用',
            snapScreenMsg: '截图上传失败，请检查你的PHP环境。 '
        },
        serialize: function() { //配置过滤标签
            //            var X = baidu.editor.utils.extend;
            //            var inline = {strong:1,em:1,b:1,i:1,u:1,span:1,a:1,img:1};
            //            var block = X(inline, {p:1,div:1,blockquote:1,$:{style:1,dir:1}});
            return {
                //编辑器中不能够插入的标签，如果想插入那些标签可以去掉相应的标签名
                blackList: {
                    style: 1,
                    link: 1,
                    object: 1,
                    applet: 1,
                    input: 1,
                    meta: 1,
                    base: 1,
                    button: 1,
                    select: 1,
                    textarea: 1,
                    '#comment': 1,
                    'map': 1,
                    'area': 1
                }
            };
        }(),
        //下来框默认显示的内容
        ComboxInitial: {
            FONT_FAMILY: '字体',
            FONT_SIZE: '字号',
            PARAGRAPH: '段落格式',
            CUSTOMSTYLE: '自定义样式'
        },
        //自动排版参数
        autotypeset: {
            mergeEmptyline: true,
            //合并空行
            removeClass: true,
            //去掉冗余的class
            removeEmptyline: false,
            //去掉空行
            textAlign: "left",
            //段落的排版方式，可以是 left,right,center,justify 去掉这个属性表示不执行排版
            imageBlockLine: 'center',
            //图片的浮动方式，独占一行剧中,左右浮动，默认: center,left,right,none 去掉这个属性表示不执行排版
            pasteFilter: false,
            //根据规则过滤没事粘贴进来的内容
            clearFontSize: false,
            //去掉所有的内嵌字号，使用编辑器默认的字号
            clearFontFamily: false,
            //去掉所有的内嵌字体，使用编辑器默认的字体
            removeEmptyNode: false,
            // 去掉空节点
            //可以去掉的标签
            removeTagNames: {
                div: 1,
                a: 1,
                abbr: 1,
                acronym: 1,
                address: 1,
                b: 1,
                bdo: 1,
                big: 1,
                cite: 1,
                code: 1,
                del: 1,
                dfn: 1,
                em: 1,
                font: 1,
                i: 1,
                ins: 1,
                label: 1,
                kbd: 1,
                q: 1,
                s: 1,
                samp: 1,
                small: 1,
                span: 1,
                strike: 1,
                strong: 1,
                sub: 1,
                sup: 1,
                tt: 1,
                u: 1,
                'var': 1
            },
            indent: false,
            // 行首缩进
            indentValue: '2em' //行首缩进的大小
        }
    };
})();