﻿var bookWidth = $bookWidth;
var bookHeight = $bookHeight;
var bookPageCount = $bookPageCount;
var pageWidth;
var pageHeight;
var modalLayer;
var messageWindow;
var audioWindow;
var videoWindow;
var imageWindow;
var closeButton;

function clickModalLayer( event )
{
	event.preventDefault();

	if( messageWindow )
		hideWindow( messageWindow );
	if( audioWindow )
		hideWindow( audioWindow );
	if( videoWindow )
		hideWindow( videoWindow );
	if( imageWindow )
		hideWindow( imageWindow );
	if( closeButton )
		hideWindow( closeButton );
		
	hideModalLayer();
}

function hideModalLayer()
{
	document.body.removeChild( modalLayer );
	modalLayer = null;
}

function showModalLayer()
{
	if( modalLayer )
		return;
	
	modalLayer = document.createElement("div");
	modalLayer.id = "modalLayer";
	modalLayer.onclick = clickModalLayer;
	modalLayer.style.opacity = 0.01;
	modalLayer.ontouchend = clickModalLayer;
	document.body.appendChild( modalLayer );
}

function updatePageImage()
{
	var page = $("#pageIndex").attr( "value");
	page = "images/page" + page + ".jpg";
	$("#bgImage").attr( "src", page );
}

function test()
{
	var link = document.createElement( "div");
	link.style.backgroundColor = "red";
	link.style.position = "absolute";
	link.style.left = "100px";
	link.style.top = "100px";
	link.style.width = "300px";
	link.style.height = "10px";
	
	document.body.appendChild( link );
}

function makeWindowSize( width, height )
{
	this.width = width;
	this.height = height;
	
	if( width >= bookWidth * 0.9 )
		this.width = Number( bookWidth * 0.9 );
	if( height >= bookHeight * 0.9 )
		this.height = Number( bookHeight * 0.9 );
}

function showAudio( source )
{
	showModalLayer();
	var url = $(source).attr( "destination" );
	url = url.replace( "content/", "" );
	
	var x = $(source).attr( "x" );
	if( x < 0 )
		x = bookWidth * 0.2;
		
	audioWindow = document.createElement( "div");
	audioWindow.className = "popupWindow"
	audioWindow.style.left = x + "px";
	audioWindow.style.top = $(source).attr( "y" ) + "px";
	audioWindow.style.width = "300px";
	audioWindow.style.height = "100px";
	
	
	document.body.appendChild( audioWindow );
	$(audioWindow).addClass( "searchViewShow");
	
	var player = document.createElement( "audio");
	player.src = url;
	player.style.width = "100%";
	player.style.height = "100%";
	player.controls = "controls";
	player.play();
	audioWindow.appendChild( player );
	
	closeButton = document.createElement( "img" );
	closeButton.src = "images/close.png";
	closeButton.id = "closeButton";
	closeButton.style.left = Number( x ) + 300 - 20 + "px";
	closeButton.style.top = Number( $(source).attr( "y" ) ) - 20 + "px";
	closeButton.style.width = "40px";
	closeButton.style.height = "40px";
	closeButton.onclick = clickModalLayer;

	document.body.appendChild( closeButton );



}

function showVideo( source )
{
	showModalLayer();
	var url = $(source).attr( "destination" );
	if( url )
		url = url.replace( "content/", "" );
	
	var width = Number( $(source).attr( "popupWidth" ) );
	var height = Number( $(source).attr( "popupHeight" ) );
	
	if( $(source).attr( "popupWidth" )  == null )
		width = bookWidth * 0.8;
	if( $(source).attr( "popupHeight" )  == null)
		height = width * 0.75;

	var size = new makeWindowSize( width, height );
	
	videoWindow = document.createElement( "div");
	videoWindow.className = "popupWindow"
	videoWindow.style.left = ( bookWidth - size.width ) / 2 + "px";
	videoWindow.style.top = ( bookHeight - size.height ) / 2 + "px";
	videoWindow.style.width = size.width + "px";
	videoWindow.style.height = size.height + "px";
	
	
	document.body.appendChild( videoWindow );
	$(videoWindow).addClass( "searchViewShow");
	
	var player = document.createElement( "video");
	player.src = url;
	player.style.width = "100%";
	player.style.height = "100%";
	player.controls = "controls";
	player.play();
	videoWindow.appendChild( player );
	
	closeButton = document.createElement( "img" );
	closeButton.src = "images/close.png";
	closeButton.id = "closeButton";

	closeButton.style.left = ( bookWidth - size.width ) / 2 + size.width - 25 + "px";
	closeButton.style.top = ( bookHeight - size.height ) / 2 - 25 + "px";

	
	closeButton.onclick = clickModalLayer;

	document.body.appendChild( closeButton );



}

function showImage( source )
{
	showModalLayer();
	var url = $(source).attr( "destination" );
	url = url.replace( "content/", "" );
	
	var player = document.createElement( "img");
	player.src = url;
	
	var img = new Image();
	img.onload = function(){
		var w = this.width;	
		var h = this.height;
		var width;
		var height;
	
		if( w > h )
		{
			var rate = h / w;
			width = bookWidth * 0.8;
			height = width * rate;
			
		}
		else 
		{
			var rate = w / h;
			height = bookHeight * 0.8;
			width = height * rate;
			
		}
		
		imageWindow = document.createElement( "div");
		imageWindow.className = "popupWindow"
		
		document.body.appendChild( imageWindow );
		$(imageWindow).addClass( "searchViewShow");
		document.body.appendChild( imageWindow );
		
		imageWindow.style.width = width + "px";
		imageWindow.style.height = height + "px";
		imageWindow.style.left = ( bookWidth - width ) / 2 + "px";
		imageWindow.style.top = ( bookHeight - height ) / 2 + "px";
		imageWindow.style.overflow = "hidden";
		
		player = document.createElement( "img");
		player.style.width = "100%";
		player.style.height = "100%";
		player.src = url;
		
		imageWindow.appendChild( player );
		
		closeButton = document.createElement( "img" );
		closeButton.src = "images/close.png";
		closeButton.id = "closeButton";
		closeButton.style.left = ( bookWidth - width ) / 2 + width - 25 + "px";
		closeButton.style.top = ( bookHeight - height ) / 2 - 25 + "px";
		closeButton.onclick = clickModalLayer;
	
		document.body.appendChild( closeButton );


	}
	img.src = url;

}

function showMessage( source )
{
	showModalLayer();
	var width = Number( $(source).attr( "popupWidth" ) );
	var height = Number( $(source).attr( "popupHeight" ) );

	if( width > bookWidth )
		width = bookWidth * 0.7;
	if( height > bookHeight )
		height = bookHeight * 0.7
		
	var size = new makeWindowSize( width, height );

	messageWindow = document.createElement( "div");
	messageWindow.id = "messageWindow";
	messageWindow.className = "popupWindow";
	messageWindow.style.left = ( bookWidth - size.width ) / 2 + "px";
	messageWindow.style.top = ( bookHeight - size.height ) / 2 + "px";
	messageWindow.style.width = size.width + "px";
	messageWindow.style.height = size.height + "px";

	
	var text = document.createElement( "textarea");
	text.readOnly = "readonly";
	text.style.fontSize = "300%";
	
	var txt = $(source).text();
	$(text).text( txt );
	messageWindow.appendChild( text );
	
	document.body.appendChild( messageWindow );

	$("#messageWindow").addClass( "searchViewShow");
	
	closeButton = document.createElement( "img" );
	closeButton.src = "images/close.png";
	closeButton.id = "closeButton";
	closeButton.style.left = ( bookWidth - size.width ) / 2 + size.width - 25 + "px";
	closeButton.style.top = ( bookHeight - size.height ) / 2 - 25 + "px";
	closeButton.onclick = clickModalLayer;

	document.body.appendChild( closeButton );
	
	$("#closeButton").addClass( "searchViewShow");

}

function hideWindow( win )
{
	if( !$(win).hasClass( "searchViewHide") )
	{

		$(win).addClass( "searchViewHide");
		
		win.addEventListener( 'webkitAnimationEnd', 
		function( event ) 
		{
	 	 	document.body.removeChild( win );
	 	 	win = null;
		 }, false );
	}

}

function clickLink( event )
{
	event.preventDefault();
	var source = $(this).data( "source");
	var action = $(source).attr( "destination" );
	var type = $(source).attr( "type" );
	//alert( $(source).attr( "destination" ) );

	if( type == "message" )
	{
		showMessage( source );
	}
	else if( type == "audio" )
	{
		showAudio( source );
	}
	else if( type == "video" )
	{
		showVideo( source );
	}
	else if( type == "image" )
	{
		showImage( source );
	}
	else if( action.indexOf( "http:" ) == 0 )
	{
		window.open( action, "_blank" );
	}
	else if( action.indexOf( "mailto:" ) == 0 )
	{
		window.open( action, "_blank" );
	}
	else if( action.indexOf( "page:" ) == 0 )
	{
		var page = Number( action.substring( 5, action.length ) );
		var url = sprintf( "page%02d.xhtml", page );
		window.open( url, "_blank" );
	}
	
}

function createLink( source )
{
	//alert( $(this).attr( "page" ) );
	var pageNo = parseInt( $(source).attr( "page" ) );
	var x = $(source).attr( "x" );
	
	var currentPageNo = parseInt( $("#pageIndex").attr( "value" ) );
	if( pageNo != currentPageNo && pageNo != currentPageNo + 1 )
		return;
		
	if( pageNo == currentPageNo + 1)
	{
		if( x > 0 )
			return;
		else
			x = pageWidth + Number( x );
	} 
	
	var y = $(source).attr( "y" );
	var w = $(source).attr( "width" );
	var h = $(source).attr( "height" );

	x = x / pageWidth * bookWidth;
	w = w / pageWidth * bookWidth;
	y = y / pageHeight * bookHeight;
	h = h / pageHeight * bookHeight;
	
	var link = document.createElement( "div");
	link.style.backgroundColor = "red";
	link.style.position = "absolute";
	link.style.left = x + "px";
	link.style.top = y + "px";
	link.style.width = w + "px";
	link.style.height = h + "px";
	link.style.backgroundColor = $(source).attr( "color" );
	link.style.opacity = $(source).attr( "opacity" );
	$(link).data( "source", source );
	link.onclick = clickLink;

	document.body.appendChild( link );
	
}

function createButton( source )
{
	var pageNo = parseInt( $(source).attr( "page" ) );
	var x = $(source).attr( "x" );
	
	var currentPageNo = parseInt( $("#pageIndex").attr( "value" ) );		
	if( pageNo != currentPageNo && pageNo != currentPageNo + 1 )
		return;
		
	if( pageNo == currentPageNo + 1)
	{
		if( x > 0 )
			return;
		else
			x = pageWidth + Number( x );
	} 

			
	
	var y = $(source).attr( "y" );
	var w = $(source).attr( "width" );
	var h = $(source).attr( "height" );
	var url = $(source).attr( "image" );
	url = url.replace( "content/", "" );
	
	x = x / pageWidth * bookWidth;
	w = w / pageWidth * bookWidth;
	y = y / pageHeight * bookHeight;
	h = h / pageHeight * bookHeight;

	var button = document.createElement( "div");
	button.style.position = "absolute";
	button.style.left = x + "px";
	button.style.top = y + "px";
	button.style.width = w + "px";
	button.style.height = h + "px";
//	button.style.backgroundColor = "black";
	$(button).data( "source", source );
	button.onclick = clickLink;
	
	var image = document.createElement( "img");
	image.src = url;
	image.style.width = "100%";
	image.style.height = "100%";
	button.appendChild( image );

	document.body.appendChild( button );
	
}

function createVideo( source )
{
	var pageNo = parseInt( $(source).attr( "page" ) );
	var currentPageNo = parseInt( $("#pageIndex").attr( "value" ) );
	if( pageNo != currentPageNo )
		return;
				
	var x = $(source).attr( "x" );
	var y = $(source).attr( "y" );
	var w = $(source).attr( "width" );
	var h = $(source).attr( "height" );
	
	var url = $(source).attr( "url" );
	var showControls = $(source).attr( "showControl" );
	var autoRepeat = $(source).attr( "autoRepeat" );
	var autoPlay = $(source).attr( "autoPlay" );
	
	url = url.replace( "content/", "" );

	var button = document.createElement( "div");
	button.style.position = "absolute";
	button.style.left = x + "px";
	button.style.top = y + "px";
	button.style.width = w + "px";
	button.style.height = h + "px";
	button.style.backgroundColor = "black";
	$(button).data( "source", source );
	button.onclick = clickLink;
	
	var video = document.createElement( "video");
	video.src = url;
	video.style.width = "100%";
	video.style.height = "100%";
	
	if( showControls == "true" )
		video.controls = "controls";
	if( autoPlay == "true" )
		video.play();
	if( autoRepeat == "true" )
		video.loop = "loop";
		
	button.appendChild( video );

	document.body.appendChild( button );
}

function createAudio( source )
{
	var pageNo = parseInt( $(source).attr( "pageNumber" ) );
	var currentPageNo = parseInt( $("#pageIndex").attr( "value" ) );
	if( pageNo != currentPageNo )
		return;
		
	var repeta = $(source).attr( "repeat" );
	var showControl = $(source).attr( "controlBar" );
	var url = $(source).attr( "url" );
	url = url.replace( "content/", "" );
	
	if( showControl == "true" )
	{
		var s = function()
		{
			this.destination = url;
			this.x = bookWidth * 0.3;
			this.y = bookHeight * 0.2;
		}
		showAudio( s );
		return;
	}
	
	var player = document.createElement( "audio");
	player.src = url;
	player.controls = "controls";
	player.play();
	if( repeta )
		player.loop = "loop";
		
	document.body.appendChild( player );
	
}

function updateHotlinks()
{
	var currentPageNo = parseInt( $("#pageIndex").attr( "value" ) );		
	var file;
	file = "data/page" + currentPageNo + "_links.xml";

	xmlhttp=new XMLHttpRequest();
	xmlhttp.open("GET",file,false);
	xmlhttp.send();
	xmlDoc=xmlhttp.responseXML;
	links = xmlDoc.getElementsByTagName( "hotlink");

	for( var i = 0; i < links.length; ++i )
	{
		createLink( links[i] );	
	}
	
	currentPageNo++;
	if( currentPageNo <= bookPageCount )
	{
		file = "data/page" + currentPageNo + "_links.xml";
		
		xmlhttp=new XMLHttpRequest();
		xmlhttp.open("GET",file,false);
		xmlhttp.send();
		xmlDoc=xmlhttp.responseXML;
		links = xmlDoc.getElementsByTagName( "hotlink");
	
		for( var i = 0; i < links.length; ++i )
		{
			createLink( links[i] );	
		}
	}
}

function updateButtons()
{
	xmlhttp=new XMLHttpRequest();
	xmlhttp.open("GET","data/buttons.xml",false);
	xmlhttp.send();
	xmlDoc=xmlhttp.responseXML;
	items = xmlDoc.getElementsByTagName( "button");

	for( var i = 0; i < items.length; ++i )
	{
		createButton( items[i] );	
	}
}

function updateVideos()
{
	xmlhttp=new XMLHttpRequest();
	xmlhttp.open("GET","data/videos.xml",false);
	xmlhttp.send();
	xmlDoc=xmlhttp.responseXML;
	items = xmlDoc.getElementsByTagName( "video");

	for( var i = 0; i < items.length; ++i )
	{
		createVideo( items[i] );	
	}
}

function updateAudios()
{
	xmlhttp=new XMLHttpRequest();
	xmlhttp.open("GET","data/sounds.xml",false);
	xmlhttp.send();
	xmlDoc=xmlhttp.responseXML;
	items = xmlDoc.getElementsByTagName( "sound");

	for( var i = 0; i < items.length; ++i )
	{
		createAudio( items[i] );
	}
}

function pageLoaded()
{
	
	var image = new Image();

	image.onload = function() {
		pageWidth = this.width;
		pageHeight = this.height;

		updateHotlinks(); 
		updateButtons();
		updateVideos();
		updateAudios();

	}
	image.src = $("#bgImage").attr( "src" );
	
}