#! /bin/sh

# CrossFTP Startup batch file. For more information, please refer to http://www.crossftp.com
# CrossFTP startup arguments
CROSSFTP_ARGS=""
JAVA_ARGS=""

# Locates the java executable.
if [ "$JAVA_HOME" != "" ] ; then
    JAVA=$JAVA_HOME/bin/java
else
    JAVACMD=`which java 2> /dev/null `
    if [ -z "$JAVACMD" ] ; then
        echo "Error: cannot find java VM."
        exit 1
    else
        JAVA=java
    fi
fi

# Resolve the path to the crossftp.jar located in the same directory as this script
if [ -h $0 ]
then
    # This script has been invoked from a symlink, resolve the link's target (i.e. the path to this script)
    CROSSFTP_SH=`ls -l "$0"`
    CROSSFTP_SH=${CROSSFTP_SH#*-> }
else
    CROSSFTP_SH=$0
fi

CURRENT_DIR=`dirname "$CROSSFTP_SH"`
CROSSFTP_JARS=$CURRENT_DIR/crossftp.jar:$CURRENT_DIR/crossftp-resources.jar:$CURRENT_DIR/commons-logging.jar:$CURRENT_DIR/jnlp.jar:$CURRENT_DIR/looks-2.2.1.jar:$CURRENT_DIR/bcprov-jdk15on-147.jar

if [ ! -f $CROSSFTP_JAR ]
then
    echo "Error: cannot find file crossftp.jar in directory $CURRENT_DIR"
    exit 1
fi

# Starts crossftp.
$JAVA $JAVA_ARGS -cp $CROSSFTP_JARS crossftp.ui.MainFrameWindow $CROSSFTP_ARGS $@