-- DROP TABLE IF EXISTS `zt_action`;
CREATE TABLE IF NOT EXISTS `zt_action` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `objectType` varchar(30) NOT NULL default '',
  `objectID` mediumint(8) unsigned NOT NULL default '0',
  `product` varchar(255) NOT NULL,
  `project` mediumint(9) NOT NULL,
  `actor` varchar(30) NOT NULL default '',
  `action` varchar(30) NOT NULL default '',
  `date` datetime NOT NULL,
  `comment` text NOT NULL,
  `extra` varchar(255) NOT NULL,
  `read` enum('0','1') NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_bug`;
CREATE TABLE IF NOT EXISTS `zt_bug` (
  `id` mediumint(8) NOT NULL auto_increment,
  `product` mediumint(8) unsigned NOT NULL default '0',
  `module` mediumint(8) unsigned NOT NULL default '0',
  `project` mediumint(8) unsigned NOT NULL default '0',
  `plan` mediumint(8) unsigned NOT NULL default '0',
  `story` mediumint(8) unsigned NOT NULL default '0',
  `storyVersion` smallint(6) NOT NULL default '1',
  `task` mediumint(8) unsigned NOT NULL default '0',
  `toTask` mediumint(8) unsigned NOT NULL default '0',
  `toStory` mediumint(8) NOT NULL default '0',
  `title` varchar(255) NOT NULL,
  `keywords` varchar(255) NOT NULL,
  `severity` tinyint(4) NOT NULL default '0',
  `pri` tinyint(3) unsigned NOT NULL,
  `type` varchar(30) NOT NULL default '',
  `os` varchar(30) NOT NULL default '',
  `browser` varchar(30) NOT NULL default '',
  `hardware` varchar(30) NOT NULL,
  `found` varchar(30) NOT NULL default '',
  `steps` text NOT NULL,
  `status` enum('active','resolved','closed') NOT NULL default 'active',
  `confirmed` tinyint(1) NOT NULL default '0',
  `activatedCount` smallint(6) NOT NULL,
  `mailto` varchar(255) NOT NULL default '',
  `openedBy` varchar(30) NOT NULL default '',
  `openedDate` datetime NOT NULL,
  `openedBuild` varchar(255) NOT NULL,
  `assignedTo` varchar(30) NOT NULL default '',
  `assignedDate` datetime NOT NULL,
  `resolvedBy` varchar(30) NOT NULL default '',
  `resolution` varchar(30) NOT NULL default '',
  `resolvedBuild` varchar(30) NOT NULL default '',
  `resolvedDate` datetime NOT NULL,
  `closedBy` varchar(30) NOT NULL default '',
  `closedDate` datetime NOT NULL,
  `duplicateBug` mediumint(8) unsigned NOT NULL,
  `linkBug` varchar(255) NOT NULL,
  `case` mediumint(8) unsigned NOT NULL,
  `caseVersion` smallint(6) NOT NULL default '1',
  `result` mediumint(8) unsigned NOT NULL,
  `testtask` mediumint(8) unsigned NOT NULL,
  `lastEditedBy` varchar(30) NOT NULL default '',
  `lastEditedDate` datetime NOT NULL,
  `deleted` enum('0','1') NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_build`;
CREATE TABLE IF NOT EXISTS `zt_build` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `product` mediumint(8) unsigned NOT NULL default '0',
  `project` mediumint(8) unsigned NOT NULL default '0',
  `name` char(150) NOT NULL,
  `scmPath` char(255) NOT NULL,
  `filePath` char(255) NOT NULL,
  `date` date NOT NULL,
  `stories` text NOT NULL,
  `bugs` text NOT NULL,
  `builder` char(30) NOT NULL default '',
  `desc` text NOT NULL,
  `deleted` enum('0','1') NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_burn`;
CREATE TABLE IF NOT EXISTS `zt_burn` (
  `project` mediumint(8) unsigned NOT NULL,
  `date` date NOT NULL,
  `left` float NOT NULL,
  `consumed` float NOT NULL,
  PRIMARY KEY  (`project`,`date`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_case`;
CREATE TABLE IF NOT EXISTS `zt_case` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `product` mediumint(8) unsigned NOT NULL default '0',
  `module` mediumint(8) unsigned NOT NULL default '0',
  `path` mediumint(8) unsigned NOT NULL default '0',
  `story` mediumint(30) unsigned NOT NULL default '0',
  `storyVersion` smallint(6) NOT NULL default '1',
  `title` varchar(255) NOT NULL,
  `precondition` text NOT NULL,
  `keywords` varchar(255) NOT NULL,
  `pri` tinyint(3) unsigned NOT NULL default '3',
  `type` char(30) NOT NULL default '1',
  `stage` varchar(255) NOT NULL,
  `howRun` varchar(30) NOT NULL,
  `scriptedBy` varchar(30) NOT NULL,
  `scriptedDate` date NOT NULL,
  `scriptStatus` varchar(30) NOT NULL,
  `scriptLocation` varchar(255) NOT NULL,
  `status` char(30) NOT NULL default '1',
  `frequency` enum('1','2','3') NOT NULL default '1',
  `order` tinyint(30) unsigned NOT NULL default '0',
  `openedBy` char(30) NOT NULL default '',
  `openedDate` datetime NOT NULL,
  `lastEditedBy` char(30) NOT NULL default '',
  `lastEditedDate` datetime NOT NULL,
  `version` tinyint(3) unsigned NOT NULL default '0',
  `linkCase` varchar(255) NOT NULL,
  `fromBug` mediumint(8) unsigned NOT NULL,
  `deleted` enum('0','1') NOT NULL default '0',
  `lastRunner` varchar(30) NOT NULL,
  `lastRunDate` datetime NOT NULL,
  `lastRunResult` char(30) NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_casestep`;
CREATE TABLE IF NOT EXISTS `zt_casestep` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `case` mediumint(8) unsigned NOT NULL default '0',
  `version` smallint(3) unsigned NOT NULL default '0',
  `desc` text NOT NULL,
  `expect` text NOT NULL,
  PRIMARY KEY  (`id`),
  KEY `case` (`case`,`version`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_company`;
CREATE TABLE IF NOT EXISTS `zt_company` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `name` char(120) default NULL,
  `phone` char(20) default NULL,
  `fax` char(20) default NULL,
  `address` char(120) default NULL,
  `zipcode` char(10) default NULL,
  `website` char(120) default NULL,
  `backyard` char(120) default NULL,
  `guest` enum('1','0') NOT NULL default '0',
  `admins` char(255) default NULL,
  `deleted` enum('0','1') NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_config`;
CREATE TABLE IF NOT EXISTS `zt_config` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `owner` char(30) NOT NULL default '',
  `module` varchar(30) NOT NULL,
  `section` char(30) NOT NULL default '',
  `key` char(30) NOT NULL default '',
  `value` text NOT NULL,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `unique` (`owner`,`module`,`section`,`key`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_cron`;
CREATE TABLE IF NOT EXISTS `zt_cron` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `m` varchar(20) NOT NULL,
  `h` varchar(20) NOT NULL,
  `dom` varchar(20) NOT NULL,
  `mon` varchar(20) NOT NULL,
  `dow` varchar(20) NOT NULL,
  `command` text NOT NULL,
  `remark` varchar(255) NOT NULL,
  `type` varchar(20) NOT NULL,
  `buildin` tinyint(1) NOT NULL DEFAULT '0',
  `status` varchar(20) NOT NULL,
  `lastTime` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_lang`;
CREATE TABLE IF NOT EXISTS `zt_lang` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `lang` varchar(30) NOT NULL,
  `module` varchar(30) NOT NULL,
  `section` varchar(30) NOT NULL,
  `key` varchar(60) NOT NULL,
  `value` text NOT NULL,
  `system` enum('0','1') NOT NULL default '1',
  PRIMARY KEY  (`id`),
  UNIQUE KEY `lang` (`lang`,`module`,`section`,`key`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_dept`;
CREATE TABLE IF NOT EXISTS `zt_dept` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `name` char(60) NOT NULL,
  `parent` mediumint(8) unsigned NOT NULL default '0',
  `path` char(255) NOT NULL default '',
  `grade` tinyint(3) unsigned NOT NULL default '0',
  `order` tinyint(3) unsigned NOT NULL default '0',
  `position` char(30) NOT NULL default '',
  `function` char(255) NOT NULL default '',
  `manager` char(30) NOT NULL default '',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_doc`;
CREATE TABLE IF NOT EXISTS `zt_doc` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `product` mediumint(8) unsigned NOT NULL,
  `project` mediumint(8) unsigned NOT NULL,
  `lib` varchar(30) NOT NULL,
  `module` varchar(30) NOT NULL,
  `title` varchar(255) NOT NULL,
  `digest` varchar(255) NOT NULL,
  `keywords` varchar(255) NOT NULL,
  `type` varchar(30) NOT NULL,
  `content` text NOT NULL,
  `url` varchar(255) NOT NULL,
  `views` smallint(5) unsigned NOT NULL,
  `addedBy` varchar(30) NOT NULL,
  `addedDate` datetime NOT NULL,
  `editedBy` varchar(30) NOT NULL,
  `editedDate` datetime NOT NULL,
  `deleted` enum('0','1') NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_doclib`;
CREATE TABLE IF NOT EXISTS `zt_doclib` (
  `id` smallint(5) unsigned NOT NULL auto_increment,
  `name` varchar(60) NOT NULL,
  `deleted` enum('0','1') NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_effort`;
CREATE TABLE IF NOT EXISTS `zt_effort` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `user` char(30) NOT NULL default '',
  `todo` enum('1','0') NOT NULL default '1',
  `date` date NOT NULL,
  `begin` datetime NOT NULL default '0000-00-00 00:00:00',
  `end` datetime NOT NULL default '0000-00-00 00:00:00',
  `type` enum('1','2','3') NOT NULL default '1',
  `idvalue` mediumint(8) unsigned NOT NULL default '0',
  `name` char(30) NOT NULL default '',
  `desc` char(255) NOT NULL default '',
  `status` enum('1','2','3') NOT NULL default '1',
  PRIMARY KEY  (`id`),
  KEY `user` (`user`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_extension`;
CREATE TABLE IF NOT EXISTS `zt_extension` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `name` varchar(150) NOT NULL,
  `code` varchar(30) NOT NULL,
  `version` varchar(50) NOT NULL,
  `author` varchar(100) NOT NULL,
  `desc` text NOT NULL,
  `license` text NOT NULL,
  `type` varchar(20) NOT NULL default 'extension',
  `site` varchar(150) NOT NULL,
  `zentaoCompatible` varchar(100) NOT NULL,
  `installedTime` datetime NOT NULL,
  `depends` varchar(100) NOT NULL,
  `dirs` text NOT NULL,
  `files` text NOT NULL,
  `status` varchar(20) NOT NULL,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `code` (`code`),
  KEY `name` (`name`),
  KEY `addedTime` (`installedTime`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_file`;
CREATE TABLE IF NOT EXISTS `zt_file` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `pathname` char(50) NOT NULL,
  `title` char(90) NOT NULL,
  `extension` char(30) NOT NULL,
  `size` mediumint(8) unsigned NOT NULL default '0',
  `objectType` char(30) NOT NULL,
  `objectID` mediumint(9) NOT NULL,
  `addedBy` char(30) NOT NULL default '',
  `addedDate` datetime NOT NULL,
  `downloads` mediumint(8) unsigned NOT NULL default '0',
  `extra` varchar(255) NOT NULL,
  `deleted` enum('0','1') NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_group`;
CREATE TABLE IF NOT EXISTS `zt_group` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `name` char(30) NOT NULL,
  `role` char(30) NOT NULL default '',
  `desc` char(255) NOT NULL default '',
  `acl` text NOT NULL default '',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_grouppriv`;
CREATE TABLE IF NOT EXISTS `zt_grouppriv` (
  `group` mediumint(8) unsigned NOT NULL default '0',
  `module` char(30) NOT NULL default '',
  `method` char(30) NOT NULL default '',
  UNIQUE KEY `group` (`group`,`module`,`method`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_history`;
CREATE TABLE IF NOT EXISTS `zt_history` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `action` mediumint(8) unsigned NOT NULL default '0',
  `field` varchar(30) NOT NULL default '',
  `old` text NOT NULL,
  `new` text NOT NULL,
  `diff` mediumtext NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_mailqueue`;
CREATE TABLE IF NOT EXISTS `zt_mailqueue` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `toList` varchar(255) NOT NULL,
  `ccList` varchar(255) NOT NULL,
  `subject` varchar(255) NOT NULL,
  `body` text NOT NULL,
  `addedBy` char(30) NOT NULL,
  `addedDate` datetime NOT NULL,
  `sendTime` datetime NOT NULL,
  `status` varchar(10) NOT NULL DEFAULT 'wait',
  `failReason` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_module`;
CREATE TABLE IF NOT EXISTS `zt_module` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `root` mediumint(8) unsigned NOT NULL default '0',
  `name` char(60) NOT NULL default '',
  `parent` mediumint(8) unsigned NOT NULL default '0',
  `path` char(255) NOT NULL default '',
  `grade` tinyint(3) unsigned NOT NULL default '0',
  `order` smallint(5) unsigned NOT NULL default '0',
  `type` char(30) NOT NULL,
  `owner` varchar(30) NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_product`;
CREATE TABLE IF NOT EXISTS `zt_product` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `name` varchar(90) NOT NULL,
  `code` varchar(45) NOT NULL,
  `status` varchar(30) NOT NULL default '',
  `desc` text NOT NULL,
  `PO` varchar(30) NOT NULL,
  `QD` varchar(30) NOT NULL,
  `RD` varchar(30) NOT NULL,
  `acl` enum('open','private','custom') NOT NULL default 'open',
  `whitelist` varchar(255) NOT NULL,
  `createdBy` varchar(30) NOT NULL,
  `createdDate` datetime NOT NULL,
  `createdVersion` varchar(20) NOT NULL,
  `order` mediumint(8) unsigned NOT NULL,
  `deleted` enum('0','1') NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_productplan`;
CREATE TABLE IF NOT EXISTS `zt_productplan` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `product` mediumint(8) unsigned NOT NULL,
  `title` varchar(90) NOT NULL,
  `desc` text NOT NULL,
  `begin` date NOT NULL,
  `end` date NOT NULL,
  `deleted` enum('0','1') NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_project`;
CREATE TABLE IF NOT EXISTS `zt_project` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `isCat` enum('1','0') NOT NULL default '0',
  `catID` mediumint(8) unsigned NOT NULL,
  `type` varchar(20) NOT NULL default 'sprint',
  `parent` mediumint(8) unsigned NOT NULL default '0',
  `name` varchar(90) NOT NULL,
  `code` varchar(45) NOT NULL,
  `begin` date NOT NULL,
  `end` date NOT NULL,
  `days` smallint(5) unsigned NOT NULL,
  `status` varchar(10) NOT NULL,
  `statge` enum('1','2','3','4','5') NOT NULL default '1',
  `pri` enum('1','2','3','4') NOT NULL default '1',
  `desc` text NOT NULL,
  `openedBy` varchar(30) NOT NULL default '',
  `openedDate` int(10) unsigned NOT NULL default '0',
  `openedVersion` varchar(20) NOT NULL,
  `closedBy` varchar(30) NOT NULL default '',
  `closedDate` int(10) unsigned NOT NULL default '0',
  `canceledBy` varchar(30) NOT NULL default '',
  `canceledDate` int(10) unsigned NOT NULL default '0',
  `PO` varchar(30) NOT NULL default '',
  `PM` varchar(30) NOT NULL default '',
  `QD` varchar(30) NOT NULL default '',
  `RD` varchar(30) NOT NULL default '',
  `team` varchar(30) NOT NULL,
  `acl` enum('open','private','custom') NOT NULL default 'open',
  `whitelist` varchar(255) NOT NULL,
  `order` mediumint(8) unsigned NOT NULL,
  `deleted` enum('0','1') NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `project` (`type`,`parent`,`begin`,`end`,`status`,`statge`,`pri`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_projectproduct`;
CREATE TABLE IF NOT EXISTS `zt_projectproduct` (
  `project` mediumint(8) unsigned NOT NULL,
  `product` mediumint(8) unsigned NOT NULL,
  PRIMARY KEY  (`project`,`product`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_projectstory`;
CREATE TABLE IF NOT EXISTS `zt_projectstory` (
  `project` mediumint(8) unsigned NOT NULL default '0',
  `product` mediumint(8) unsigned NOT NULL,
  `story` mediumint(8) unsigned NOT NULL default '0',
  `version` smallint(6) NOT NULL default '1',
  UNIQUE KEY `project` (`project`,`story`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_release`;
CREATE TABLE IF NOT EXISTS `zt_release` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `product` mediumint(8) unsigned NOT NULL default '0',
  `build` mediumint(8) unsigned NOT NULL,
  `name` char(30) NOT NULL default '',
  `date` date NOT NULL,
  `stories` text NOT NULL,
  `bugs` text NOT NULL,
  `desc` text NOT NULL,
  `deleted` enum('0','1') NOT NULL default '0',
  PRIMARY KEY  (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_story`;
CREATE TABLE IF NOT EXISTS `zt_story` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `product` mediumint(8) unsigned NOT NULL default '0',
  `module` mediumint(8) unsigned NOT NULL default '0',
  `plan` mediumint(8) unsigned NOT NULL default '0',
  `source` varchar(20) NOT NULL,
  `fromBug` mediumint(8) unsigned NOT NULL default '0',
  `title` varchar(255) NOT NULL,
  `keywords` varchar(255) NOT NULL,
  `type` varchar(30) NOT NULL default '',
  `pri` tinyint(3) unsigned NOT NULL default '3',
  `estimate` float unsigned NOT NULL,
  `status` enum('','changed','active','draft','closed') NOT NULL default '',
  `stage` enum('','wait','planned','projected','developing','developed','testing','tested','verified','released') NOT NULL DEFAULT 'wait',
  `mailto` varchar(255) NOT NULL default '',
  `openedBy` varchar(30) NOT NULL default '',
  `openedDate` datetime NOT NULL,
  `assignedTo` varchar(30) NOT NULL default '',
  `assignedDate` datetime NOT NULL,
  `lastEditedBy` varchar(30) NOT NULL default '',
  `lastEditedDate` datetime NOT NULL,
  `reviewedBy` varchar(255) NOT NULL,
  `reviewedDate` date NOT NULL,
  `closedBy` varchar(30) NOT NULL default '',
  `closedDate` datetime NOT NULL,
  `closedReason` varchar(30) NOT NULL,
  `toBug` mediumint(9) NOT NULL,
  `childStories` varchar(255) NOT NULL,
  `linkStories` varchar(255) NOT NULL,
  `duplicateStory` mediumint(8) unsigned NOT NULL,
  `version` smallint(6) NOT NULL default '1',
  `deleted` enum('0','1') NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `product` (`product`,`module`,`plan`,`type`,`pri`),
  KEY `status` (`status`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_storyspec`;
CREATE TABLE IF NOT EXISTS `zt_storyspec` (
  `story` mediumint(9) NOT NULL,
  `version` smallint(6) NOT NULL,
  `title` varchar(90) NOT NULL,
  `spec` text NOT NULL,
  `verify` text NOT NULL,
  UNIQUE KEY `story` (`story`,`version`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_task`;
CREATE TABLE IF NOT EXISTS `zt_task` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `project` mediumint(8) unsigned NOT NULL default '0',
  `module` mediumint(8) unsigned NOT NULL default '0',
  `story` mediumint(8) unsigned NOT NULL default '0',
  `storyVersion` smallint(6) NOT NULL default '1',
  `fromBug` mediumint(8) unsigned NOT NULL default '0',
  `name` varchar(255) NOT NULL,
  `type` varchar(20) NOT NULL,
  `pri` tinyint(3) unsigned NOT NULL default '0',
  `estimate` float unsigned NOT NULL,
  `consumed` float unsigned NOT NULL,
  `left` float unsigned NOT NULL,
  `deadline` date NOT NULL,
  `status` enum('wait','doing','done','pause','cancel','closed') NOT NULL default 'wait',
  `mailto` varchar(255) NOT NULL default '',
  `desc` text NOT NULL,
  `openedBy` varchar(30) NOT NULL,
  `openedDate` datetime NOT NULL,
  `assignedTo` varchar(30) NOT NULL,
  `assignedDate` datetime NOT NULL,
  `estStarted` date NOT NULL,
  `realStarted` date NOT NULL,
  `finishedBy` varchar(30) NOT NULL,
  `finishedDate` datetime NOT NULL,
  `canceledBy` varchar(30) NOT NULL,
  `canceledDate` datetime NOT NULL,
  `closedBy` varchar(30) NOT NULL,
  `closedDate` datetime NOT NULL,
  `closedReason` varchar(30) NOT NULL,
  `lastEditedBy` varchar(30) NOT NULL,
  `lastEditedDate` datetime NOT NULL,
  `deleted` enum('0','1') NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `type` (`type`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_taskestimate`;
CREATE TABLE IF NOT EXISTS `zt_taskestimate` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `task` mediumint(8) unsigned NOT NULL default '0',
  `date` date NOT NULL,
  `left` float unsigned NOT NULL default '0',
  `consumed` float unsigned NOT NULL,
  `account` char(30) NOT NULL default '',
  `work` varchar(255) NOT NULL,
  PRIMARY KEY  (`id`),
  KEY `task` (`task`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_team`;
CREATE TABLE IF NOT EXISTS `zt_team` (
  `project` mediumint(8) unsigned NOT NULL default '0',
  `account` char(30) NOT NULL default '',
  `role` char(30) NOT NULL default '',
  `join` date NOT NULL default '0000-00-00',
  `days` smallint(5) unsigned NOT NULL,
  `hours` float(2,1) unsigned NOT NULL default '0',
  PRIMARY KEY  (`project`,`account`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_testresult`;
CREATE TABLE IF NOT EXISTS `zt_testresult` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `run` mediumint(8) unsigned NOT NULL,
  `case` mediumint(8) unsigned NOT NULL,
  `version` smallint(5) unsigned NOT NULL,
  `caseResult` char(30) NOT NULL,
  `stepResults` text NOT NULL,
  `lastRunner` varchar(30) NOT NULL,
  `date` datetime NOT NULL,
  PRIMARY KEY  (`id`),
  KEY `run` (`run`),
  KEY `case` (`case`,`version`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_testrun`;
CREATE TABLE IF NOT EXISTS `zt_testrun` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `task` mediumint(8) unsigned NOT NULL default '0',
  `case` mediumint(8) unsigned NOT NULL default '0',
  `version` tinyint(3) unsigned NOT NULL default '0',
  `assignedTo` char(30) NOT NULL default '',
  `lastRunner` varchar(30) NOT NULL,
  `lastRunDate` datetime NOT NULL,
  `lastRunResult` char(30) NOT NULL,
  `status` char(30) NOT NULL,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `task` (`task`,`case`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_testtask`;
CREATE TABLE IF NOT EXISTS `zt_testtask` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `name` char(90) NOT NULL,
  `product` mediumint(8) unsigned NOT NULL,
  `project` mediumint(8) unsigned NOT NULL default '0',
  `build` char(30) NOT NULL,
  `owner` varchar(30) NOT NULL,
  `pri` tinyint(3) unsigned NOT NULL default '0',
  `begin` date NOT NULL,
  `end` date NOT NULL,
  `desc` text NOT NULL,
  `report` text NOT NULL,
  `status` enum('blocked','doing','wait','done') NOT NULL DEFAULT 'wait',
  `deleted` enum('0','1') NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_todo`;
CREATE TABLE IF NOT EXISTS `zt_todo` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `account` char(30) NOT NULL,
  `date` date NOT NULL,
  `begin` smallint(4) unsigned zerofill NOT NULL,
  `end` smallint(4) unsigned zerofill NOT NULL,
  `type` char(10) NOT NULL,
  `idvalue` mediumint(8) unsigned NOT NULL default '0',
  `pri` tinyint(3) unsigned NOT NULL,
  `name` char(150) NOT NULL,
  `desc` text NOT NULL,
  `status`  enum('wait','doing','done') NOT NULL DEFAULT 'wait',
  `private` tinyint(1) NOT NULL,
  PRIMARY KEY  (`id`),
  KEY `user` (`account`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_user`;
CREATE TABLE IF NOT EXISTS `zt_user` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `dept` mediumint(8) unsigned NOT NULL default '0',
  `account` char(30) NOT NULL default '',
  `password` char(32) NOT NULL default '',
  `role` char(10) NOT NULL default '',
  `realname` char(30) NOT NULL default '',
  `nickname` char(60) NOT NULL default '',
  `commiter` varchar(100) NOT NULL,
  `avatar` char(30) NOT NULL default '',
  `birthday` date NOT NULL default '0000-00-00',
  `gender` enum('f','m') NOT NULL default 'f',
  `email` char(90) NOT NULL default '',
  `skype` char(90) NOT NULL default '',
  `qq` char(20) NOT NULL default '',
  `yahoo` char(90) NOT NULL default '',
  `gtalk` char(90) NOT NULL default '',
  `wangwang` char(90) NOT NULL default '',
  `mobile` char(11) NOT NULL default '',
  `phone` char(20) NOT NULL default '',
  `address` char(120) NOT NULL default '',
  `zipcode` char(10) NOT NULL default '',
  `join` date NOT NULL default '0000-00-00',
  `visits` mediumint(8) unsigned NOT NULL default '0',
  `ip` char(15) NOT NULL default '',
  `last` int(10) unsigned NOT NULL default '0',
  `fails` tinyint(5) NOT NULL default '0',
  `locked` datetime NOT NULL default '0000-00-00 00:00:00',
  `deleted` enum('0','1') NOT NULL default '0',
  PRIMARY KEY  (`id`),
  UNIQUE KEY `account` (`account`),
  KEY `dept` (`dept`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_usercontact`;
CREATE TABLE IF NOT EXISTS `zt_usercontact` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `account` char(30) NOT NULL,
  `listName` varchar(60) NOT NULL,
  `userList` text NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_usergroup`;
CREATE TABLE IF NOT EXISTS `zt_usergroup` (
  `account` char(30) NOT NULL default '',
  `group` mediumint(8) unsigned NOT NULL default '0',
  UNIQUE KEY `account` (`account`,`group`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_userquery`;
CREATE TABLE IF NOT EXISTS `zt_userquery` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `account` char(30) NOT NULL,
  `module` varchar(30) NOT NULL,
  `title` varchar(90) NOT NULL,
  `form` text NOT NULL,
  `sql` text NOT NULL,
  PRIMARY KEY  (`id`),
  KEY `account` (`account`),
  KEY `module` (`module`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
-- DROP TABLE IF EXISTS `zt_usertpl`;
CREATE TABLE IF NOT EXISTS `zt_usertpl` (
  `id` mediumint(8) unsigned NOT NULL auto_increment,
  `account` char(30) NOT NULL,
  `type` char(30) NOT NULL,
  `title` varchar(150) NOT NULL,
  `content` text NOT NULL,
  PRIMARY KEY  (`id`),
  KEY `account` (`account`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `zt_cron` (`m`, `h`, `dom`, `mon`, `dow`, `command`, `remark`, `type`, `buildin`, `status`, `lastTime`) VALUES
('*',    '*',    '*',    '*',    '*',    '',     '监控定时任务', 'zentao',       1,      'normal',       '0000-00-00 00:00:00'),
('30',   '23',   '*',    '*',    '*',    'moduleName=project&methodName=computeburn',    '更新燃尽图',   'zentao',       1,      'normal', '0000-00-00 00:00:00'),
('0',    '1',    '*',    '*',    '*',    'moduleName=report&methodName=remind',  '每日任务提醒', 'zentao',       1,      'normal', '0000-00-00 00:00:00'),
('*/5',  '*',    '*',    '*',    '*',    'moduleName=svn&methodName=run',        '同步SVN',      'zentao',       1,      'stop',       '0000-00-00 00:00:00'),
('*/5',  '*',    '*',    '*',    '*',    'moduleName=git&methodName=run',        '同步GIT',      'zentao',       1,      'stop', '0000-00-00 00:00:00'),
('30',   '0',    '*',    '*',    '*',    'moduleName=backup&methodName=backup',  '备份数据和附件',       'zentao',       1,      'normal', '0000-00-00 00:00:00'),
('*/5',  '*',    '*',    '*',    '*',    'moduleName=mail&methodName=asyncSend', '异步发信',     'zentao',       1,      'normal', '0000-00-00 00:00:00');

INSERT INTO `zt_group` (`id`, `name`, `role`, `desc`) VALUES
(1, 'ADMIN', 'admin', 'for administrator'),
(2, 'DEV', 'dev', 'for developers.'),
(3, 'QA', 'qa', 'for testers.'),
(4, 'PM', 'pm', 'for project managers.'),
(5, 'PO', 'po', 'for product owners.'),
(6, 'TD', 'td', 'for technical director.'),
(7, 'PD', 'pd', 'for product director.'),
(8, 'QD', 'qd', 'for quality director.'),
(9, 'TOP', 'top', 'for top manager.'),
(10, 'OTHERS', '', 'for others.'),
(11, 'guest', 'guest', 'For guest');

INSERT INTO `zt_grouppriv` (`group`, `module`, `method`) VALUES
(1, 'action', 'editComment'),
(1, 'action', 'hideAll'),
(1, 'action', 'hideOne'),
(1, 'action', 'trash'),
(1, 'action', 'undelete'),
(1, 'admin', 'checkDB'),
(1, 'admin', 'checkWeak'),
(1, 'admin', 'index'),
(1, 'admin', 'safe'),
(1, 'api', 'debug'),
(1, 'api', 'getModel'),
(1, 'api', 'sql'),
(1, 'backup', 'backup'),
(1, 'backup', 'change'),
(1, 'backup', 'delete'),
(1, 'backup', 'index'),
(1, 'backup', 'restore'),
(1, 'bug', 'activate'),
(1, 'bug', 'assignTo'),
(1, 'bug', 'batchAssignTo'),
(1, 'bug', 'batchClose'),
(1, 'bug', 'batchConfirm'),
(1, 'bug', 'batchCreate'),
(1, 'bug', 'batchEdit'),
(1, 'bug', 'batchResolve'),
(1, 'bug', 'browse'),
(1, 'bug', 'close'),
(1, 'bug', 'confirmBug'),
(1, 'bug', 'confirmStoryChange'),
(1, 'bug', 'create'),
(1, 'bug', 'delete'),
(1, 'bug', 'deleteTemplate'),
(1, 'bug', 'edit'),
(1, 'bug', 'export'),
(1, 'bug', 'index'),
(1, 'bug', 'report'),
(1, 'bug', 'resolve'),
(1, 'bug', 'saveTemplate'),
(1, 'bug', 'view'),
(1, 'build', 'batchUnlinkBug'),
(1, 'build', 'batchUnlinkStory'),
(1, 'build', 'create'),
(1, 'build', 'delete'),
(1, 'build', 'edit'),
(1, 'build', 'linkBug'),
(1, 'build', 'linkStory'),
(1, 'build', 'unlinkBug'),
(1, 'build', 'unlinkStory'),
(1, 'build', 'view'),
(1, 'company', 'browse'),
(1, 'company', 'dynamic'),
(1, 'company', 'edit'),
(1, 'company', 'index'),
(1, 'company', 'view'),
(1, 'convert', 'checkBugFree'),
(1, 'convert', 'checkConfig'),
(1, 'convert', 'checkRedmine'),
(1, 'convert', 'convertBugFree'),
(1, 'convert', 'convertRedmine'),
(1, 'convert', 'execute'),
(1, 'convert', 'index'),
(1, 'convert', 'selectSource'),
(1, 'convert', 'setBugfree'),
(1, 'convert', 'setConfig'),
(1, 'convert', 'setRedmine'),
(1, 'cron', 'create'),
(1, 'cron', 'delete'),
(1, 'cron', 'edit'),
(1, 'cron', 'index'),
(1, 'cron', 'toggle'),
(1, 'cron', 'turnon'),
(1, 'custom', 'flow'),
(1, 'custom', 'index'),
(1, 'custom', 'restore'),
(1, 'custom', 'set'),
(1, 'dept', 'browse'),
(1, 'dept', 'delete'),
(1, 'dept', 'edit'),
(1, 'dept', 'manageChild'),
(1, 'dept', 'updateOrder'),
(1, 'dev', 'api'),
(1, 'dev', 'db'),
(1, 'doc', 'browse'),
(1, 'doc', 'create'),
(1, 'doc', 'createLib'),
(1, 'doc', 'delete'),
(1, 'doc', 'deleteLib'),
(1, 'doc', 'edit'),
(1, 'doc', 'editLib'),
(1, 'doc', 'index'),
(1, 'doc', 'view'),
(1, 'editor', 'delete'),
(1, 'editor', 'edit'),
(1, 'editor', 'extend'),
(1, 'editor', 'index'),
(1, 'editor', 'newPage'),
(1, 'editor', 'save'),
(1, 'extension', 'activate'),
(1, 'extension', 'browse'),
(1, 'extension', 'deactivate'),
(1, 'extension', 'erase'),
(1, 'extension', 'install'),
(1, 'extension', 'obtain'),
(1, 'extension', 'structure'),
(1, 'extension', 'uninstall'),
(1, 'extension', 'upgrade'),
(1, 'extension', 'upload'),
(1, 'file', 'delete'),
(1, 'file', 'download'),
(1, 'file', 'edit'),
(1, 'file', 'uploadImages'),
(1, 'git', 'apiSync'),
(1, 'git', 'cat'),
(1, 'git', 'diff'),
(1, 'group', 'browse'),
(1, 'group', 'copy'),
(1, 'group', 'create'),
(1, 'group', 'delete'),
(1, 'group', 'edit'),
(1, 'group', 'manageMember'),
(1, 'group', 'managePriv'),
(1, 'group', 'manageView'),
(1, 'index', 'index'),
(1, 'mail', 'batchDelete'),
(1, 'mail', 'browse'),
(1, 'mail', 'delete'),
(1, 'mail', 'detect'),
(1, 'mail', 'edit'),
(1, 'mail', 'index'),
(1, 'mail', 'reset'),
(1, 'mail', 'save'),
(1, 'mail', 'test'),
(1, 'misc', 'ping'),
(1, 'my', 'bug'),
(1, 'my', 'changePassword'),
(1, 'my', 'dynamic'),
(1, 'my', 'editProfile'),
(1, 'my', 'index'),
(1, 'my', 'profile'),
(1, 'my', 'project'),
(1, 'my', 'story'),
(1, 'my', 'task'),
(1, 'my', 'testCase'),
(1, 'my', 'testTask'),
(1, 'my', 'todo'),
(1, 'product', 'batchEdit'),
(1, 'product', 'browse'),
(1, 'product', 'close'),
(1, 'product', 'create'),
(1, 'product', 'delete'),
(1, 'product', 'doc'),
(1, 'product', 'dynamic'),
(1, 'product', 'edit'),
(1, 'product', 'index'),
(1, 'product', 'order'),
(1, 'product', 'project'),
(1, 'product', 'roadmap'),
(1, 'product', 'view'),
(1, 'product', 'updateOrder'),
(1, 'productplan', 'batchUnlinkBug'),
(1, 'productplan', 'batchUnlinkStory'),
(1, 'productplan', 'browse'),
(1, 'productplan', 'create'),
(1, 'productplan', 'delete'),
(1, 'productplan', 'edit'),
(1, 'productplan', 'linkBug'),
(1, 'productplan', 'linkStory'),
(1, 'productplan', 'unlinkBug'),
(1, 'productplan', 'unlinkStory'),
(1, 'productplan', 'view'),
(1, 'project', 'activate'),
(1, 'project', 'batchedit'),
(1, 'project', 'batchUnlinkStory'),
(1, 'project', 'browse'),
(1, 'project', 'bug'),
(1, 'project', 'build'),
(1, 'project', 'burn'),
(1, 'project', 'burnData'),
(1, 'project', 'close'),
(1, 'project', 'computeBurn'),
(1, 'project', 'create'),
(1, 'project', 'delete'),
(1, 'project', 'doc'),
(1, 'project', 'dynamic'),
(1, 'project', 'edit'),
(1, 'project', 'grouptask'),
(1, 'project', 'importBug'),
(1, 'project', 'importtask'),
(1, 'project', 'index'),
(1, 'project', 'linkStory'),
(1, 'project', 'manageMembers'),
(1, 'project', 'manageProducts'),
(1, 'project', 'order'),
(1, 'project', 'putoff'),
(1, 'project', 'start'),
(1, 'project', 'story'),
(1, 'project', 'suspend'),
(1, 'project', 'task'),
(1, 'project', 'team'),
(1, 'project', 'testtask'),
(1, 'project', 'unlinkMember'),
(1, 'project', 'unlinkStory'),
(1, 'project', 'view'),
(1, 'project', 'updateOrder'),
(1, 'qa', 'index'),
(1, 'release', 'batchUnlinkBug'),
(1, 'release', 'batchUnlinkStory'),
(1, 'release', 'browse'),
(1, 'release', 'create'),
(1, 'release', 'delete'),
(1, 'release', 'edit'),
(1, 'release', 'export'),
(1, 'release', 'linkBug'),
(1, 'release', 'linkStory'),
(1, 'release', 'unlinkBug'),
(1, 'release', 'unlinkStory'),
(1, 'release', 'view'),
(1, 'report', 'bugAssign'),
(1, 'report', 'bugCreate'),
(1, 'report', 'index'),
(1, 'report', 'productSummary'),
(1, 'report', 'projectDeviation'),
(1, 'report', 'workload'),
(1, 'search', 'buildForm'),
(1, 'search', 'buildQuery'),
(1, 'search', 'deleteQuery'),
(1, 'search', 'saveQuery'),
(1, 'search', 'select'),
(1, 'story', 'activate'),
(1, 'story', 'batchAssignTo'),
(1, 'story', 'batchChangePlan'),
(1, 'story', 'batchChangeStage'),
(1, 'story', 'batchClose'),
(1, 'story', 'batchCreate'),
(1, 'story', 'batchEdit'),
(1, 'story', 'batchReview'),
(1, 'story', 'change'),
(1, 'story', 'close'),
(1, 'story', 'create'),
(1, 'story', 'delete'),
(1, 'story', 'edit'),
(1, 'story', 'export'),
(1, 'story', 'report'),
(1, 'story', 'review'),
(1, 'story', 'tasks'),
(1, 'story', 'view'),
(1, 'story', 'zeroCase'),
(1, 'svn', 'apiSync'),
(1, 'svn', 'cat'),
(1, 'svn', 'diff'),
(1, 'task', 'activate'),
(1, 'task', 'assignTo'),
(1, 'task', 'batchAssignTo'),
(1, 'task', 'batchClose'),
(1, 'task', 'batchCreate'),
(1, 'task', 'batchEdit'),
(1, 'task', 'cancel'),
(1, 'task', 'close'),
(1, 'task', 'confirmStoryChange'),
(1, 'task', 'create'),
(1, 'task', 'delete'),
(1, 'task', 'deleteEstimate'),
(1, 'task', 'edit'),
(1, 'task', 'editEstimate'),
(1, 'task', 'export'),
(1, 'task', 'finish'),
(1, 'task', 'pause'),
(1, 'task', 'recordEstimate'),
(1, 'task', 'report'),
(1, 'task', 'restart'),
(1, 'task', 'start'),
(1, 'task', 'view'),
(1, 'testcase', 'batchCreate'),
(1, 'testcase', 'batchDelete'),
(1, 'testcase', 'batchEdit'),
(1, 'testcase', 'browse'),
(1, 'testcase', 'confirmChange'),
(1, 'testcase', 'confirmStoryChange'),
(1, 'testcase', 'create'),
(1, 'testcase', 'createBug'),
(1, 'testcase', 'delete'),
(1, 'testcase', 'edit'),
(1, 'testcase', 'export'),
(1, 'testcase', 'exportTemplet'),
(1, 'testcase', 'groupCase'),
(1, 'testcase', 'import'),
(1, 'testcase', 'index'),
(1, 'testcase', 'showImport'),
(1, 'testcase', 'view'),
(1, 'testtask', 'batchAssign'),
(1, 'testtask', 'batchRun'),
(1, 'testtask', 'browse'),
(1, 'testtask', 'cases'),
(1, 'testtask', 'close'),
(1, 'testtask', 'create'),
(1, 'testtask', 'delete'),
(1, 'testtask', 'edit'),
(1, 'testtask', 'groupCase'),
(1, 'testtask', 'index'),
(1, 'testtask', 'linkcase'),
(1, 'testtask', 'results'),
(1, 'testtask', 'runcase'),
(1, 'testtask', 'start'),
(1, 'testtask', 'unlinkcase'),
(1, 'testtask', 'view'),
(1, 'todo', 'batchCreate'),
(1, 'todo', 'batchEdit'),
(1, 'todo', 'batchFinish'),
(1, 'todo', 'create'),
(1, 'todo', 'delete'),
(1, 'todo', 'edit'),
(1, 'todo', 'export'),
(1, 'todo', 'finish'),
(1, 'todo', 'import2Today'),
(1, 'todo', 'view'),
(1, 'tree', 'browse'),
(1, 'tree', 'browseTask'),
(1, 'tree', 'delete'),
(1, 'tree', 'edit'),
(1, 'tree', 'fix'),
(1, 'tree', 'manageChild'),
(1, 'tree', 'updateOrder'),
(1, 'user', 'batchCreate'),
(1, 'user', 'batchEdit'),
(1, 'user', 'bug'),
(1, 'user', 'create'),
(1, 'user', 'delete'),
(1, 'user', 'deleteContacts'),
(1, 'user', 'dynamic'),
(1, 'user', 'edit'),
(1, 'user', 'manageContacts'),
(1, 'user', 'profile'),
(1, 'user', 'project'),
(1, 'user', 'story'),
(1, 'user', 'task'),
(1, 'user', 'testCase'),
(1, 'user', 'testTask'),
(1, 'user', 'todo'),
(1, 'user', 'unlock'),
(1, 'user', 'view'),
(2, 'action', 'editComment'),
(2, 'api', 'getModel'),
(2, 'bug', 'activate'),
(2, 'bug', 'assignTo'),
(2, 'bug', 'batchAssignTo'),
(2, 'bug', 'batchClose'),
(2, 'bug', 'batchConfirm'),
(2, 'bug', 'batchCreate'),
(2, 'bug', 'batchEdit'),
(2, 'bug', 'batchResolve'),
(2, 'bug', 'browse'),
(2, 'bug', 'close'),
(2, 'bug', 'confirmBug'),
(2, 'bug', 'confirmStoryChange'),
(2, 'bug', 'create'),
(2, 'bug', 'deleteTemplate'),
(2, 'bug', 'edit'),
(2, 'bug', 'export'),
(2, 'bug', 'index'),
(2, 'bug', 'report'),
(2, 'bug', 'resolve'),
(2, 'bug', 'saveTemplate'),
(2, 'bug', 'view'),
(2, 'build', 'create'),
(2, 'build', 'delete'),
(2, 'build', 'edit'),
(2, 'build', 'view'),
(2, 'company', 'browse'),
(2, 'company', 'dynamic'),
(2, 'company', 'index'),
(2, 'company', 'view'),
(2, 'doc', 'browse'),
(2, 'doc', 'create'),
(2, 'doc', 'edit'),
(2, 'doc', 'index'),
(2, 'doc', 'view'),
(2, 'file', 'download'),
(2, 'file', 'edit'),
(2, 'git', 'apiSync'),
(2, 'git', 'cat'),
(2, 'git', 'diff'),
(2, 'group', 'browse'),
(2, 'index', 'index'),
(2, 'misc', 'ping'),
(2, 'my', 'bug'),
(2, 'my', 'changePassword'),
(2, 'my', 'dynamic'),
(2, 'my', 'editProfile'),
(2, 'my', 'index'),
(2, 'my', 'profile'),
(2, 'my', 'project'),
(2, 'my', 'story'),
(2, 'my', 'task'),
(2, 'my', 'todo'),
(2, 'product', 'browse'),
(2, 'product', 'doc'),
(2, 'product', 'dynamic'),
(2, 'product', 'index'),
(2, 'product', 'project'),
(2, 'product', 'roadmap'),
(2, 'product', 'view'),
(2, 'productplan', 'browse'),
(2, 'productplan', 'view'),
(2, 'project', 'browse'),
(2, 'project', 'bug'),
(2, 'project', 'build'),
(2, 'project', 'burn'),
(2, 'project', 'burnData'),
(2, 'project', 'computeBurn'),
(2, 'project', 'doc'),
(2, 'project', 'dynamic'),
(2, 'project', 'grouptask'),
(2, 'project', 'importBug'),
(2, 'project', 'importtask'),
(2, 'project', 'index'),
(2, 'project', 'story'),
(2, 'project', 'task'),
(2, 'project', 'team'),
(2, 'project', 'testtask'),
(2, 'project', 'view'),
(2, 'qa', 'index'),
(2, 'release', 'browse'),
(2, 'release', 'export'),
(2, 'release', 'view'),
(2, 'report', 'bugAssign'),
(2, 'report', 'bugCreate'),
(2, 'report', 'index'),
(2, 'report', 'productSummary'),
(2, 'report', 'projectDeviation'),
(2, 'report', 'workload'),
(2, 'search', 'buildForm'),
(2, 'search', 'buildQuery'),
(2, 'search', 'deleteQuery'),
(2, 'search', 'saveQuery'),
(2, 'search', 'select'),
(2, 'story', 'export'),
(2, 'story', 'report'),
(2, 'story', 'tasks'),
(2, 'story', 'view'),
(2, 'svn', 'apiSync'),
(2, 'svn', 'cat'),
(2, 'svn', 'diff'),
(2, 'task', 'activate'),
(2, 'task', 'assignTo'),
(2, 'task', 'batchAssignTo'),
(2, 'task', 'batchClose'),
(2, 'task', 'batchCreate'),
(2, 'task', 'batchEdit'),
(2, 'task', 'cancel'),
(2, 'task', 'close'),
(2, 'task', 'confirmStoryChange'),
(2, 'task', 'create'),
(2, 'task', 'deleteEstimate'),
(2, 'task', 'edit'),
(2, 'task', 'editEstimate'),
(2, 'task', 'export'),
(2, 'task', 'finish'),
(2, 'task', 'pause'),
(2, 'task', 'recordEstimate'),
(2, 'task', 'report'),
(2, 'task', 'restart'),
(2, 'task', 'start'),
(2, 'task', 'view'),
(2, 'testcase', 'browse'),
(2, 'testcase', 'export'),
(2, 'testcase', 'groupCase'),
(2, 'testcase', 'index'),
(2, 'testcase', 'view'),
(2, 'testtask', 'browse'),
(2, 'testtask', 'cases'),
(2, 'testtask', 'create'),
(2, 'testtask', 'edit'),
(2, 'testtask', 'groupCase'),
(2, 'testtask', 'index'),
(2, 'testtask', 'results'),
(2, 'testtask', 'view'),
(2, 'todo', 'batchCreate'),
(2, 'todo', 'batchEdit'),
(2, 'todo', 'batchFinish'),
(2, 'todo', 'create'),
(2, 'todo', 'delete'),
(2, 'todo', 'edit'),
(2, 'todo', 'export'),
(2, 'todo', 'finish'),
(2, 'todo', 'import2Today'),
(2, 'todo', 'view'),
(2, 'user', 'bug'),
(2, 'user', 'deleteContacts'),
(2, 'user', 'dynamic'),
(2, 'user', 'manageContacts'),
(2, 'user', 'profile'),
(2, 'user', 'project'),
(2, 'user', 'story'),
(2, 'user', 'task'),
(2, 'user', 'testCase'),
(2, 'user', 'testTask'),
(2, 'user', 'todo'),
(2, 'user', 'view'),
(3, 'action', 'editComment'),
(3, 'api', 'getModel'),
(3, 'bug', 'activate'),
(3, 'bug', 'assignTo'),
(3, 'bug', 'batchClose'),
(3, 'bug', 'batchConfirm'),
(3, 'bug', 'batchCreate'),
(3, 'bug', 'batchEdit'),
(3, 'bug', 'batchResolve'),
(3, 'bug', 'browse'),
(3, 'bug', 'close'),
(3, 'bug', 'confirmBug'),
(3, 'bug', 'confirmStoryChange'),
(3, 'bug', 'create'),
(3, 'bug', 'deleteTemplate'),
(3, 'bug', 'edit'),
(3, 'bug', 'export'),
(3, 'bug', 'index'),
(3, 'bug', 'report'),
(3, 'bug', 'resolve'),
(3, 'bug', 'saveTemplate'),
(3, 'bug', 'view'),
(3, 'build', 'create'),
(3, 'build', 'edit'),
(3, 'build', 'view'),
(3, 'company', 'browse'),
(3, 'company', 'dynamic'),
(3, 'company', 'index'),
(3, 'company', 'view'),
(3, 'doc', 'browse'),
(3, 'doc', 'create'),
(3, 'doc', 'edit'),
(3, 'doc', 'index'),
(3, 'doc', 'view'),
(3, 'file', 'download'),
(3, 'file', 'edit'),
(3, 'git', 'apiSync'),
(3, 'git', 'cat'),
(3, 'git', 'diff'),
(3, 'group', 'browse'),
(3, 'index', 'index'),
(3, 'misc', 'ping'),
(3, 'my', 'bug'),
(3, 'my', 'changePassword'),
(3, 'my', 'dynamic'),
(3, 'my', 'editProfile'),
(3, 'my', 'index'),
(3, 'my', 'profile'),
(3, 'my', 'project'),
(3, 'my', 'story'),
(3, 'my', 'task'),
(3, 'my', 'testCase'),
(3, 'my', 'testTask'),
(3, 'my', 'todo'),
(3, 'product', 'browse'),
(3, 'product', 'doc'),
(3, 'product', 'dynamic'),
(3, 'product', 'index'),
(3, 'product', 'project'),
(3, 'product', 'roadmap'),
(3, 'product', 'view'),
(3, 'productplan', 'browse'),
(3, 'productplan', 'view'),
(3, 'project', 'browse'),
(3, 'project', 'bug'),
(3, 'project', 'build'),
(3, 'project', 'burn'),
(3, 'project', 'burnData'),
(3, 'project', 'computeBurn'),
(3, 'project', 'doc'),
(3, 'project', 'dynamic'),
(3, 'project', 'grouptask'),
(3, 'project', 'importBug'),
(3, 'project', 'importtask'),
(3, 'project', 'index'),
(3, 'project', 'story'),
(3, 'project', 'task'),
(3, 'project', 'team'),
(3, 'project', 'testtask'),
(3, 'project', 'view'),
(3, 'qa', 'index'),
(3, 'release', 'browse'),
(3, 'release', 'export'),
(3, 'release', 'view'),
(3, 'report', 'bugAssign'),
(3, 'report', 'bugCreate'),
(3, 'report', 'index'),
(3, 'report', 'productSummary'),
(3, 'report', 'projectDeviation'),
(3, 'report', 'workload'),
(3, 'search', 'buildForm'),
(3, 'search', 'buildQuery'),
(3, 'search', 'deleteQuery'),
(3, 'search', 'saveQuery'),
(3, 'search', 'select'),
(3, 'story', 'export'),
(3, 'story', 'report'),
(3, 'story', 'tasks'),
(3, 'story', 'view'),
(3, 'story', 'zeroCase'),
(3, 'svn', 'apiSync'),
(3, 'svn', 'cat'),
(3, 'svn', 'diff'),
(3, 'task', 'activate'),
(3, 'task', 'assignTo'),
(3, 'task', 'batchAssignTo'),
(3, 'task', 'batchClose'),
(3, 'task', 'batchCreate'),
(3, 'task', 'batchEdit'),
(3, 'task', 'cancel'),
(3, 'task', 'close'),
(3, 'task', 'confirmStoryChange'),
(3, 'task', 'create'),
(3, 'task', 'deleteEstimate'),
(3, 'task', 'edit'),
(3, 'task', 'editEstimate'),
(3, 'task', 'export'),
(3, 'task', 'finish'),
(3, 'task', 'pause'),
(3, 'task', 'recordEstimate'),
(3, 'task', 'report'),
(3, 'task', 'restart'),
(3, 'task', 'start'),
(3, 'task', 'view'),
(3, 'testcase', 'batchCreate'),
(3, 'testcase', 'batchEdit'),
(3, 'testcase', 'browse'),
(3, 'testcase', 'confirmChange'),
(3, 'testcase', 'confirmStoryChange'),
(3, 'testcase', 'create'),
(3, 'testcase', 'createBug'),
(3, 'testcase', 'edit'),
(3, 'testcase', 'export'),
(3, 'testcase', 'exportTemplet'),
(3, 'testcase', 'groupCase'),
(3, 'testcase', 'import'),
(3, 'testcase', 'index'),
(3, 'testcase', 'showImport'),
(3, 'testcase', 'view'),
(3, 'testtask', 'batchAssign'),
(3, 'testtask', 'batchRun'),
(3, 'testtask', 'browse'),
(3, 'testtask', 'cases'),
(3, 'testtask', 'close'),
(3, 'testtask', 'create'),
(3, 'testtask', 'edit'),
(3, 'testtask', 'groupCase'),
(3, 'testtask', 'index'),
(3, 'testtask', 'linkcase'),
(3, 'testtask', 'results'),
(3, 'testtask', 'runcase'),
(3, 'testtask', 'start'),
(3, 'testtask', 'unlinkcase'),
(3, 'testtask', 'view'),
(3, 'todo', 'batchCreate'),
(3, 'todo', 'batchEdit'),
(3, 'todo', 'batchFinish'),
(3, 'todo', 'create'),
(3, 'todo', 'delete'),
(3, 'todo', 'edit'),
(3, 'todo', 'export'),
(3, 'todo', 'finish'),
(3, 'todo', 'import2Today'),
(3, 'todo', 'view'),
(3, 'user', 'bug'),
(3, 'user', 'deleteContacts'),
(3, 'user', 'dynamic'),
(3, 'user', 'manageContacts'),
(3, 'user', 'profile'),
(3, 'user', 'project'),
(3, 'user', 'story'),
(3, 'user', 'task'),
(3, 'user', 'testCase'),
(3, 'user', 'testTask'),
(3, 'user', 'todo'),
(3, 'user', 'view'),
(4, 'action', 'editComment'),
(4, 'action', 'hideAll'),
(4, 'action', 'hideOne'),
(4, 'action', 'trash'),
(4, 'action', 'undelete'),
(4, 'admin', 'index'),
(4, 'api', 'getModel'),
(4, 'bug', 'activate'),
(4, 'bug', 'assignTo'),
(4, 'bug', 'batchAssignTo'),
(4, 'bug', 'batchClose'),
(4, 'bug', 'batchConfirm'),
(4, 'bug', 'batchCreate'),
(4, 'bug', 'batchEdit'),
(4, 'bug', 'batchResolve'),
(4, 'bug', 'browse'),
(4, 'bug', 'close'),
(4, 'bug', 'confirmBug'),
(4, 'bug', 'confirmStoryChange'),
(4, 'bug', 'create'),
(4, 'bug', 'delete'),
(4, 'bug', 'deleteTemplate'),
(4, 'bug', 'edit'),
(4, 'bug', 'export'),
(4, 'bug', 'index'),
(4, 'bug', 'report'),
(4, 'bug', 'resolve'),
(4, 'bug', 'saveTemplate'),
(4, 'bug', 'view'),
(4, 'build', 'batchUnlinkBug'),
(4, 'build', 'batchUnlinkStory'),
(4, 'build', 'create'),
(4, 'build', 'delete'),
(4, 'build', 'edit'),
(4, 'build', 'linkBug'),
(4, 'build', 'linkStory'),
(4, 'build', 'unlinkBug'),
(4, 'build', 'unlinkStory'),
(4, 'build', 'view'),
(4, 'company', 'browse'),
(4, 'company', 'dynamic'),
(4, 'company', 'index'),
(4, 'company', 'view'),
(4, 'doc', 'browse'),
(4, 'doc', 'create'),
(4, 'doc', 'createLib'),
(4, 'doc', 'delete'),
(4, 'doc', 'deleteLib'),
(4, 'doc', 'edit'),
(4, 'doc', 'editLib'),
(4, 'doc', 'index'),
(4, 'doc', 'view'),
(4, 'extension', 'browse'),
(4, 'extension', 'obtain'),
(4, 'extension', 'structure'),
(4, 'file', 'delete'),
(4, 'file', 'download'),
(4, 'file', 'edit'),
(4, 'file', 'uploadImages'),
(4, 'git', 'apiSync'),
(4, 'git', 'cat'),
(4, 'git', 'diff'),
(4, 'group', 'browse'),
(4, 'index', 'index'),
(4, 'misc', 'ping'),
(4, 'my', 'bug'),
(4, 'my', 'changePassword'),
(4, 'my', 'dynamic'),
(4, 'my', 'editProfile'),
(4, 'my', 'index'),
(4, 'my', 'profile'),
(4, 'my', 'project'),
(4, 'my', 'story'),
(4, 'my', 'task'),
(4, 'my', 'testCase'),
(4, 'my', 'testTask'),
(4, 'my', 'todo'),
(4, 'product', 'browse'),
(4, 'product', 'doc'),
(4, 'product', 'dynamic'),
(4, 'product', 'index'),
(4, 'product', 'project'),
(4, 'product', 'roadmap'),
(4, 'product', 'view'),
(4, 'productplan', 'browse'),
(4, 'productplan', 'view'),
(4, 'project', 'activate'),
(4, 'project', 'batchedit'),
(4, 'project', 'batchUnlinkStory'),
(4, 'project', 'browse'),
(4, 'project', 'bug'),
(4, 'project', 'build'),
(4, 'project', 'burn'),
(4, 'project', 'burnData'),
(4, 'project', 'close'),
(4, 'project', 'computeBurn'),
(4, 'project', 'create'),
(4, 'project', 'delete'),
(4, 'project', 'doc'),
(4, 'project', 'dynamic'),
(4, 'project', 'edit'),
(4, 'project', 'grouptask'),
(4, 'project', 'importBug'),
(4, 'project', 'importtask'),
(4, 'project', 'index'),
(4, 'project', 'linkStory'),
(4, 'project', 'manageMembers'),
(4, 'project', 'manageProducts'),
(4, 'project', 'order'),
(4, 'project', 'putoff'),
(4, 'project', 'start'),
(4, 'project', 'story'),
(4, 'project', 'suspend'),
(4, 'project', 'task'),
(4, 'project', 'team'),
(4, 'project', 'testtask'),
(4, 'project', 'unlinkMember'),
(4, 'project', 'unlinkStory'),
(4, 'project', 'view'),
(4, 'project', 'updateOrder'),
(4, 'qa', 'index'),
(4, 'release', 'browse'),
(4, 'release', 'export'),
(4, 'release', 'view'),
(4, 'report', 'bugAssign'),
(4, 'report', 'bugCreate'),
(4, 'report', 'index'),
(4, 'report', 'productSummary'),
(4, 'report', 'projectDeviation'),
(4, 'report', 'workload'),
(4, 'search', 'buildForm'),
(4, 'search', 'buildQuery'),
(4, 'search', 'deleteQuery'),
(4, 'search', 'saveQuery'),
(4, 'search', 'select'),
(4, 'story', 'export'),
(4, 'story', 'report'),
(4, 'story', 'tasks'),
(4, 'story', 'view'),
(4, 'story', 'zeroCase'),
(4, 'svn', 'apiSync'),
(4, 'svn', 'cat'),
(4, 'svn', 'diff'),
(4, 'task', 'activate'),
(4, 'task', 'assignTo'),
(4, 'task', 'batchAssignTo'),
(4, 'task', 'batchClose'),
(4, 'task', 'batchCreate'),
(4, 'task', 'batchEdit'),
(4, 'task', 'cancel'),
(4, 'task', 'close'),
(4, 'task', 'confirmStoryChange'),
(4, 'task', 'create'),
(4, 'task', 'delete'),
(4, 'task', 'deleteEstimate'),
(4, 'task', 'edit'),
(4, 'task', 'editEstimate'),
(4, 'task', 'export'),
(4, 'task', 'finish'),
(4, 'task', 'pause'),
(4, 'task', 'recordEstimate'),
(4, 'task', 'report'),
(4, 'task', 'restart'),
(4, 'task', 'start'),
(4, 'task', 'view'),
(4, 'testcase', 'browse'),
(4, 'testcase', 'createBug'),
(4, 'testcase', 'export'),
(4, 'testcase', 'groupCase'),
(4, 'testcase', 'index'),
(4, 'testcase', 'view'),
(4, 'testtask', 'batchAssign'),
(4, 'testtask', 'browse'),
(4, 'testtask', 'cases'),
(4, 'testtask', 'create'),
(4, 'testtask', 'edit'),
(4, 'testtask', 'groupCase'),
(4, 'testtask', 'index'),
(4, 'testtask', 'results'),
(4, 'testtask', 'view'),
(4, 'todo', 'batchCreate'),
(4, 'todo', 'batchEdit'),
(4, 'todo', 'batchFinish'),
(4, 'todo', 'create'),
(4, 'todo', 'delete'),
(4, 'todo', 'edit'),
(4, 'todo', 'export'),
(4, 'todo', 'finish'),
(4, 'todo', 'import2Today'),
(4, 'todo', 'view'),
(4, 'tree', 'browse'),
(4, 'tree', 'browseTask'),
(4, 'tree', 'delete'),
(4, 'tree', 'edit'),
(4, 'tree', 'fix'),
(4, 'tree', 'manageChild'),
(4, 'tree', 'updateOrder'),
(4, 'user', 'bug'),
(4, 'user', 'deleteContacts'),
(4, 'user', 'dynamic'),
(4, 'user', 'manageContacts'),
(4, 'user', 'profile'),
(4, 'user', 'project'),
(4, 'user', 'story'),
(4, 'user', 'task'),
(4, 'user', 'testCase'),
(4, 'user', 'testTask'),
(4, 'user', 'todo'),
(4, 'user', 'view'),
(5, 'action', 'editComment'),
(5, 'action', 'hideAll'),
(5, 'action', 'hideOne'),
(5, 'action', 'trash'),
(5, 'action', 'undelete'),
(5, 'admin', 'index'),
(5, 'api', 'getModel'),
(5, 'bug', 'activate'),
(5, 'bug', 'assignTo'),
(5, 'bug', 'batchAssignTo'),
(5, 'bug', 'batchClose'),
(5, 'bug', 'batchConfirm'),
(5, 'bug', 'batchCreate'),
(5, 'bug', 'batchEdit'),
(5, 'bug', 'batchResolve'),
(5, 'bug', 'browse'),
(5, 'bug', 'close'),
(5, 'bug', 'confirmBug'),
(5, 'bug', 'confirmStoryChange'),
(5, 'bug', 'create'),
(5, 'bug', 'deleteTemplate'),
(5, 'bug', 'edit'),
(5, 'bug', 'export'),
(5, 'bug', 'index'),
(5, 'bug', 'report'),
(5, 'bug', 'resolve'),
(5, 'bug', 'saveTemplate'),
(5, 'bug', 'view'),
(5, 'build', 'view'),
(5, 'company', 'browse'),
(5, 'company', 'dynamic'),
(5, 'company', 'index'),
(5, 'company', 'view'),
(5, 'doc', 'browse'),
(5, 'doc', 'create'),
(5, 'doc', 'createLib'),
(5, 'doc', 'delete'),
(5, 'doc', 'deleteLib'),
(5, 'doc', 'edit'),
(5, 'doc', 'editLib'),
(5, 'doc', 'index'),
(5, 'doc', 'view'),
(5, 'extension', 'browse'),
(5, 'extension', 'obtain'),
(5, 'extension', 'structure'),
(5, 'file', 'delete'),
(5, 'file', 'download'),
(5, 'file', 'edit'),
(5, 'file', 'uploadImages'),
(5, 'git', 'apiSync'),
(5, 'git', 'cat'),
(5, 'git', 'diff'),
(5, 'group', 'browse'),
(5, 'index', 'index'),
(5, 'misc', 'ping'),
(5, 'my', 'bug'),
(5, 'my', 'changePassword'),
(5, 'my', 'dynamic'),
(5, 'my', 'editProfile'),
(5, 'my', 'index'),
(5, 'my', 'profile'),
(5, 'my', 'project'),
(5, 'my', 'story'),
(5, 'my', 'task'),
(5, 'my', 'testCase'),
(5, 'my', 'testTask'),
(5, 'my', 'todo'),
(5, 'product', 'batchEdit'),
(5, 'product', 'browse'),
(5, 'product', 'close'),
(5, 'product', 'create'),
(5, 'product', 'delete'),
(5, 'product', 'doc'),
(5, 'product', 'dynamic'),
(5, 'product', 'edit'),
(5, 'product', 'index'),
(5, 'product', 'order'),
(5, 'product', 'project'),
(5, 'product', 'roadmap'),
(5, 'product', 'view'),
(5, 'product', 'updateOrder'),
(5, 'productplan', 'batchUnlinkBug'),
(5, 'productplan', 'batchUnlinkStory'),
(5, 'productplan', 'browse'),
(5, 'productplan', 'create'),
(5, 'productplan', 'delete'),
(5, 'productplan', 'edit'),
(5, 'productplan', 'linkBug'),
(5, 'productplan', 'linkStory'),
(5, 'productplan', 'unlinkBug'),
(5, 'productplan', 'unlinkStory'),
(5, 'productplan', 'view'),
(5, 'project', 'activate'),
(5, 'project', 'batchedit'),
(5, 'project', 'batchUnlinkStory'),
(5, 'project', 'browse'),
(5, 'project', 'bug'),
(5, 'project', 'build'),
(5, 'project', 'burn'),
(5, 'project', 'burnData'),
(5, 'project', 'close'),
(5, 'project', 'computeBurn'),
(5, 'project', 'create'),
(5, 'project', 'delete'),
(5, 'project', 'doc'),
(5, 'project', 'dynamic'),
(5, 'project', 'edit'),
(5, 'project', 'grouptask'),
(5, 'project', 'importBug'),
(5, 'project', 'importtask'),
(5, 'project', 'index'),
(5, 'project', 'linkStory'),
(5, 'project', 'manageMembers'),
(5, 'project', 'manageProducts'),
(5, 'project', 'order'),
(5, 'project', 'putoff'),
(5, 'project', 'start'),
(5, 'project', 'story'),
(5, 'project', 'suspend'),
(5, 'project', 'task'),
(5, 'project', 'team'),
(5, 'project', 'testtask'),
(5, 'project', 'unlinkMember'),
(5, 'project', 'unlinkStory'),
(5, 'project', 'view'),
(5, 'project', 'updateOrder'),
(5, 'qa', 'index'),
(5, 'release', 'batchUnlinkBug'),
(5, 'release', 'batchUnlinkStory'),
(5, 'release', 'browse'),
(5, 'release', 'create'),
(5, 'release', 'delete'),
(5, 'release', 'edit'),
(5, 'release', 'export'),
(5, 'release', 'linkBug'),
(5, 'release', 'linkStory'),
(5, 'release', 'unlinkBug'),
(5, 'release', 'unlinkStory'),
(5, 'release', 'view'),
(5, 'report', 'bugAssign'),
(5, 'report', 'bugCreate'),
(5, 'report', 'index'),
(5, 'report', 'productSummary'),
(5, 'report', 'projectDeviation'),
(5, 'report', 'workload'),
(5, 'search', 'buildForm'),
(5, 'search', 'buildQuery'),
(5, 'search', 'deleteQuery'),
(5, 'search', 'saveQuery'),
(5, 'search', 'select'),
(5, 'story', 'activate'),
(5, 'story', 'batchChangePlan'),
(5, 'story', 'batchChangeStage'),
(5, 'story', 'batchClose'),
(5, 'story', 'batchCreate'),
(5, 'story', 'batchEdit'),
(5, 'story', 'batchReview'),
(5, 'story', 'change'),
(5, 'story', 'close'),
(5, 'story', 'create'),
(5, 'story', 'delete'),
(5, 'story', 'edit'),
(5, 'story', 'export'),
(5, 'story', 'report'),
(5, 'story', 'review'),
(5, 'story', 'tasks'),
(5, 'story', 'view'),
(5, 'story', 'zeroCase'),
(5, 'svn', 'apiSync'),
(5, 'svn', 'cat'),
(5, 'svn', 'diff'),
(5, 'task', 'confirmStoryChange'),
(5, 'task', 'deleteEstimate'),
(5, 'task', 'editEstimate'),
(5, 'task', 'export'),
(5, 'task', 'recordEstimate'),
(5, 'task', 'report'),
(5, 'task', 'view'),
(5, 'testcase', 'browse'),
(5, 'testcase', 'createBug'),
(5, 'testcase', 'export'),
(5, 'testcase', 'groupCase'),
(5, 'testcase', 'index'),
(5, 'testcase', 'view'),
(5, 'testtask', 'browse'),
(5, 'testtask', 'cases'),
(5, 'testtask', 'groupCase'),
(5, 'testtask', 'index'),
(5, 'testtask', 'results'),
(5, 'testtask', 'view'),
(5, 'todo', 'batchCreate'),
(5, 'todo', 'batchEdit'),
(5, 'todo', 'batchFinish'),
(5, 'todo', 'create'),
(5, 'todo', 'delete'),
(5, 'todo', 'edit'),
(5, 'todo', 'export'),
(5, 'todo', 'finish'),
(5, 'todo', 'import2Today'),
(5, 'todo', 'view'),
(5, 'tree', 'browse'),
(5, 'tree', 'browseTask'),
(5, 'tree', 'delete'),
(5, 'tree', 'edit'),
(5, 'tree', 'fix'),
(5, 'tree', 'manageChild'),
(5, 'tree', 'updateOrder'),
(5, 'user', 'bug'),
(5, 'user', 'deleteContacts'),
(5, 'user', 'dynamic'),
(5, 'user', 'manageContacts'),
(5, 'user', 'profile'),
(5, 'user', 'project'),
(5, 'user', 'story'),
(5, 'user', 'task'),
(5, 'user', 'testCase'),
(5, 'user', 'testTask'),
(5, 'user', 'todo'),
(5, 'user', 'view'),
(6, 'action', 'editComment'),
(6, 'action', 'hideAll'),
(6, 'action', 'hideOne'),
(6, 'action', 'trash'),
(6, 'action', 'undelete'),
(6, 'admin', 'index'),
(6, 'api', 'getModel'),
(6, 'bug', 'activate'),
(6, 'bug', 'assignTo'),
(6, 'bug', 'batchAssignTo'),
(6, 'bug', 'batchClose'),
(6, 'bug', 'batchConfirm'),
(6, 'bug', 'batchCreate'),
(6, 'bug', 'batchEdit'),
(6, 'bug', 'batchResolve'),
(6, 'bug', 'browse'),
(6, 'bug', 'close'),
(6, 'bug', 'confirmBug'),
(6, 'bug', 'confirmStoryChange'),
(6, 'bug', 'create'),
(6, 'bug', 'delete'),
(6, 'bug', 'deleteTemplate'),
(6, 'bug', 'edit'),
(6, 'bug', 'export'),
(6, 'bug', 'index'),
(6, 'bug', 'report'),
(6, 'bug', 'resolve'),
(6, 'bug', 'saveTemplate'),
(6, 'bug', 'view'),
(6, 'build', 'batchUnlinkBug'),
(6, 'build', 'batchUnlinkStory'),
(6, 'build', 'create'),
(6, 'build', 'delete'),
(6, 'build', 'edit'),
(6, 'build', 'linkBug'),
(6, 'build', 'linkStory'),
(6, 'build', 'unlinkBug'),
(6, 'build', 'unlinkStory'),
(6, 'build', 'view'),
(6, 'company', 'browse'),
(6, 'company', 'dynamic'),
(6, 'company', 'index'),
(6, 'company', 'view'),
(6, 'doc', 'browse'),
(6, 'doc', 'create'),
(6, 'doc', 'createLib'),
(6, 'doc', 'delete'),
(6, 'doc', 'deleteLib'),
(6, 'doc', 'edit'),
(6, 'doc', 'editLib'),
(6, 'doc', 'index'),
(6, 'doc', 'view'),
(6, 'extension', 'browse'),
(6, 'extension', 'obtain'),
(6, 'extension', 'structure'),
(6, 'file', 'delete'),
(6, 'file', 'download'),
(6, 'file', 'edit'),
(6, 'file', 'uploadImages'),
(6, 'git', 'apiSync'),
(6, 'git', 'cat'),
(6, 'git', 'diff'),
(6, 'group', 'browse'),
(6, 'index', 'index'),
(6, 'misc', 'ping'),
(6, 'my', 'bug'),
(6, 'my', 'changePassword'),
(6, 'my', 'dynamic'),
(6, 'my', 'editProfile'),
(6, 'my', 'index'),
(6, 'my', 'profile'),
(6, 'my', 'project'),
(6, 'my', 'story'),
(6, 'my', 'task'),
(6, 'my', 'testCase'),
(6, 'my', 'testTask'),
(6, 'my', 'todo'),
(6, 'product', 'browse'),
(6, 'product', 'doc'),
(6, 'product', 'dynamic'),
(6, 'product', 'index'),
(6, 'product', 'project'),
(6, 'product', 'roadmap'),
(6, 'product', 'view'),
(6, 'productplan', 'browse'),
(6, 'productplan', 'view'),
(6, 'project', 'activate'),
(6, 'project', 'batchedit'),
(6, 'project', 'batchUnlinkStory'),
(6, 'project', 'browse'),
(6, 'project', 'bug'),
(6, 'project', 'build'),
(6, 'project', 'burn'),
(6, 'project', 'burnData'),
(6, 'project', 'close'),
(6, 'project', 'computeBurn'),
(6, 'project', 'create'),
(6, 'project', 'delete'),
(6, 'project', 'doc'),
(6, 'project', 'dynamic'),
(6, 'project', 'edit'),
(6, 'project', 'grouptask'),
(6, 'project', 'importBug'),
(6, 'project', 'importtask'),
(6, 'project', 'index'),
(6, 'project', 'linkStory'),
(6, 'project', 'manageMembers'),
(6, 'project', 'manageProducts'),
(6, 'project', 'order'),
(6, 'project', 'putoff'),
(6, 'project', 'start'),
(6, 'project', 'story'),
(6, 'project', 'suspend'),
(6, 'project', 'task'),
(6, 'project', 'team'),
(6, 'project', 'testtask'),
(6, 'project', 'unlinkMember'),
(6, 'project', 'unlinkStory'),
(6, 'project', 'view'),
(6, 'project', 'updateOrder'),
(6, 'qa', 'index'),
(6, 'release', 'browse'),
(6, 'release', 'export'),
(6, 'release', 'view'),
(6, 'report', 'bugAssign'),
(6, 'report', 'bugCreate'),
(6, 'report', 'index'),
(6, 'report', 'productSummary'),
(6, 'report', 'projectDeviation'),
(6, 'report', 'workload'),
(6, 'search', 'buildForm'),
(6, 'search', 'buildQuery'),
(6, 'search', 'deleteQuery'),
(6, 'search', 'saveQuery'),
(6, 'search', 'select'),
(6, 'story', 'export'),
(6, 'story', 'report'),
(6, 'story', 'tasks'),
(6, 'story', 'view'),
(6, 'story', 'zeroCase'),
(6, 'svn', 'apiSync'),
(6, 'svn', 'cat'),
(6, 'svn', 'diff'),
(6, 'task', 'activate'),
(6, 'task', 'assignTo'),
(6, 'task', 'batchAssignTo'),
(6, 'task', 'batchClose'),
(6, 'task', 'batchCreate'),
(6, 'task', 'batchEdit'),
(6, 'task', 'cancel'),
(6, 'task', 'close'),
(6, 'task', 'confirmStoryChange'),
(6, 'task', 'create'),
(6, 'task', 'delete'),
(6, 'task', 'deleteEstimate'),
(6, 'task', 'edit'),
(6, 'task', 'editEstimate'),
(6, 'task', 'export'),
(6, 'task', 'finish'),
(6, 'task', 'pause'),
(6, 'task', 'recordEstimate'),
(6, 'task', 'report'),
(6, 'task', 'restart'),
(6, 'task', 'start'),
(6, 'task', 'view'),
(6, 'testcase', 'browse'),
(6, 'testcase', 'export'),
(6, 'testcase', 'groupCase'),
(6, 'testcase', 'index'),
(6, 'testcase', 'view'),
(6, 'testtask', 'browse'),
(6, 'testtask', 'cases'),
(6, 'testtask', 'create'),
(6, 'testtask', 'edit'),
(6, 'testtask', 'groupCase'),
(6, 'testtask', 'index'),
(6, 'testtask', 'results'),
(6, 'testtask', 'view'),
(6, 'todo', 'batchCreate'),
(6, 'todo', 'batchEdit'),
(6, 'todo', 'batchFinish'),
(6, 'todo', 'create'),
(6, 'todo', 'delete'),
(6, 'todo', 'edit'),
(6, 'todo', 'export'),
(6, 'todo', 'finish'),
(6, 'todo', 'import2Today'),
(6, 'todo', 'view'),
(6, 'tree', 'browse'),
(6, 'tree', 'browseTask'),
(6, 'tree', 'delete'),
(6, 'tree', 'edit'),
(6, 'tree', 'fix'),
(6, 'tree', 'manageChild'),
(6, 'tree', 'updateOrder'),
(6, 'user', 'bug'),
(6, 'user', 'deleteContacts'),
(6, 'user', 'dynamic'),
(6, 'user', 'manageContacts'),
(6, 'user', 'profile'),
(6, 'user', 'project'),
(6, 'user', 'story'),
(6, 'user', 'task'),
(6, 'user', 'testCase'),
(6, 'user', 'testTask'),
(6, 'user', 'todo'),
(6, 'user', 'view'),
(7, 'action', 'editComment'),
(7, 'action', 'hideAll'),
(7, 'action', 'hideOne'),
(7, 'action', 'trash'),
(7, 'action', 'undelete'),
(7, 'admin', 'index'),
(7, 'api', 'getModel'),
(7, 'bug', 'activate'),
(7, 'bug', 'assignTo'),
(7, 'bug', 'batchClose'),
(7, 'bug', 'batchConfirm'),
(7, 'bug', 'batchCreate'),
(7, 'bug', 'batchEdit'),
(7, 'bug', 'batchResolve'),
(7, 'bug', 'browse'),
(7, 'bug', 'close'),
(7, 'bug', 'confirmBug'),
(7, 'bug', 'confirmStoryChange'),
(7, 'bug', 'create'),
(7, 'bug', 'delete'),
(7, 'bug', 'deleteTemplate'),
(7, 'bug', 'edit'),
(7, 'bug', 'export'),
(7, 'bug', 'index'),
(7, 'bug', 'report'),
(7, 'bug', 'resolve'),
(7, 'bug', 'saveTemplate'),
(7, 'bug', 'view'),
(7, 'build', 'view'),
(7, 'company', 'browse'),
(7, 'company', 'dynamic'),
(7, 'company', 'index'),
(7, 'company', 'view'),
(7, 'doc', 'browse'),
(7, 'doc', 'create'),
(7, 'doc', 'createLib'),
(7, 'doc', 'delete'),
(7, 'doc', 'deleteLib'),
(7, 'doc', 'edit'),
(7, 'doc', 'editLib'),
(7, 'doc', 'index'),
(7, 'doc', 'view'),
(7, 'extension', 'browse'),
(7, 'extension', 'obtain'),
(7, 'extension', 'structure'),
(7, 'file', 'delete'),
(7, 'file', 'download'),
(7, 'file', 'edit'),
(7, 'file', 'uploadImages'),
(7, 'git', 'apiSync'),
(7, 'git', 'cat'),
(7, 'git', 'diff'),
(7, 'group', 'browse'),
(7, 'index', 'index'),
(7, 'misc', 'ping'),
(7, 'my', 'bug'),
(7, 'my', 'changePassword'),
(7, 'my', 'dynamic'),
(7, 'my', 'editProfile'),
(7, 'my', 'index'),
(7, 'my', 'profile'),
(7, 'my', 'project'),
(7, 'my', 'story'),
(7, 'my', 'task'),
(7, 'my', 'testCase'),
(7, 'my', 'testTask'),
(7, 'my', 'todo'),
(7, 'product', 'batchEdit'),
(7, 'product', 'browse'),
(7, 'product', 'close'),
(7, 'product', 'create'),
(7, 'product', 'delete'),
(7, 'product', 'doc'),
(7, 'product', 'dynamic'),
(7, 'product', 'edit'),
(7, 'product', 'index'),
(7, 'product', 'order'),
(7, 'product', 'project'),
(7, 'product', 'roadmap'),
(7, 'product', 'view'),
(7, 'product', 'updateOrder'),
(7, 'productplan', 'batchUnlinkBug'),
(7, 'productplan', 'batchUnlinkStory'),
(7, 'productplan', 'browse'),
(7, 'productplan', 'create'),
(7, 'productplan', 'delete'),
(7, 'productplan', 'edit'),
(7, 'productplan', 'linkBug'),
(7, 'productplan', 'linkStory'),
(7, 'productplan', 'unlinkBug'),
(7, 'productplan', 'unlinkStory'),
(7, 'productplan', 'view'),
(7, 'project', 'browse'),
(7, 'project', 'bug'),
(7, 'project', 'build'),
(7, 'project', 'burn'),
(7, 'project', 'burnData'),
(7, 'project', 'doc'),
(7, 'project', 'dynamic'),
(7, 'project', 'grouptask'),
(7, 'project', 'index'),
(7, 'project', 'linkStory'),
(7, 'project', 'manageProducts'),
(7, 'project', 'story'),
(7, 'project', 'task'),
(7, 'project', 'team'),
(7, 'project', 'testtask'),
(7, 'project', 'unlinkStory'),
(7, 'project', 'view'),
(7, 'qa', 'index'),
(7, 'release', 'batchUnlinkBug'),
(7, 'release', 'batchUnlinkStory'),
(7, 'release', 'browse'),
(7, 'release', 'create'),
(7, 'release', 'delete'),
(7, 'release', 'edit'),
(7, 'release', 'export'),
(7, 'release', 'linkBug'),
(7, 'release', 'linkStory'),
(7, 'release', 'unlinkBug'),
(7, 'release', 'unlinkStory'),
(7, 'release', 'view'),
(7, 'report', 'bugAssign'),
(7, 'report', 'bugCreate'),
(7, 'report', 'index'),
(7, 'report', 'productSummary'),
(7, 'report', 'projectDeviation'),
(7, 'report', 'workload'),
(7, 'search', 'buildForm'),
(7, 'search', 'buildQuery'),
(7, 'search', 'deleteQuery'),
(7, 'search', 'saveQuery'),
(7, 'search', 'select'),
(7, 'story', 'activate'),
(7, 'story', 'batchAssignTo'),
(7, 'story', 'batchChangePlan'),
(7, 'story', 'batchChangeStage'),
(7, 'story', 'batchClose'),
(7, 'story', 'batchCreate'),
(7, 'story', 'batchEdit'),
(7, 'story', 'batchReview'),
(7, 'story', 'change'),
(7, 'story', 'close'),
(7, 'story', 'create'),
(7, 'story', 'delete'),
(7, 'story', 'edit'),
(7, 'story', 'export'),
(7, 'story', 'report'),
(7, 'story', 'review'),
(7, 'story', 'tasks'),
(7, 'story', 'view'),
(7, 'story', 'zeroCase'),
(7, 'svn', 'apiSync'),
(7, 'svn', 'cat'),
(7, 'svn', 'diff'),
(7, 'task', 'confirmStoryChange'),
(7, 'task', 'deleteEstimate'),
(7, 'task', 'editEstimate'),
(7, 'task', 'export'),
(7, 'task', 'recordEstimate'),
(7, 'task', 'report'),
(7, 'task', 'view'),
(7, 'testcase', 'browse'),
(7, 'testcase', 'createBug'),
(7, 'testcase', 'export'),
(7, 'testcase', 'groupCase'),
(7, 'testcase', 'index'),
(7, 'testcase', 'view'),
(7, 'testtask', 'browse'),
(7, 'testtask', 'cases'),
(7, 'testtask', 'groupCase'),
(7, 'testtask', 'index'),
(7, 'testtask', 'results'),
(7, 'testtask', 'view'),
(7, 'todo', 'batchCreate'),
(7, 'todo', 'batchEdit'),
(7, 'todo', 'batchFinish'),
(7, 'todo', 'create'),
(7, 'todo', 'delete'),
(7, 'todo', 'edit'),
(7, 'todo', 'export'),
(7, 'todo', 'finish'),
(7, 'todo', 'import2Today'),
(7, 'todo', 'view'),
(7, 'tree', 'browse'),
(7, 'tree', 'browseTask'),
(7, 'tree', 'delete'),
(7, 'tree', 'edit'),
(7, 'tree', 'fix'),
(7, 'tree', 'manageChild'),
(7, 'tree', 'updateOrder'),
(7, 'user', 'bug'),
(7, 'user', 'deleteContacts'),
(7, 'user', 'dynamic'),
(7, 'user', 'manageContacts'),
(7, 'user', 'profile'),
(7, 'user', 'project'),
(7, 'user', 'story'),
(7, 'user', 'task'),
(7, 'user', 'testCase'),
(7, 'user', 'testTask'),
(7, 'user', 'todo'),
(7, 'user', 'view'),
(8, 'action', 'editComment'),
(8, 'action', 'hideAll'),
(8, 'action', 'hideOne'),
(8, 'action', 'trash'),
(8, 'action', 'undelete'),
(8, 'admin', 'index'),
(8, 'api', 'getModel'),
(8, 'bug', 'activate'),
(8, 'bug', 'assignTo'),
(8, 'bug', 'batchAssignTo'),
(8, 'bug', 'batchClose'),
(8, 'bug', 'batchConfirm'),
(8, 'bug', 'batchCreate'),
(8, 'bug', 'batchEdit'),
(8, 'bug', 'batchResolve'),
(8, 'bug', 'browse'),
(8, 'bug', 'close'),
(8, 'bug', 'confirmBug'),
(8, 'bug', 'confirmStoryChange'),
(8, 'bug', 'create'),
(8, 'bug', 'delete'),
(8, 'bug', 'deleteTemplate'),
(8, 'bug', 'edit'),
(8, 'bug', 'export'),
(8, 'bug', 'index'),
(8, 'bug', 'report'),
(8, 'bug', 'resolve'),
(8, 'bug', 'saveTemplate'),
(8, 'bug', 'view'),
(8, 'build', 'create'),
(8, 'build', 'delete'),
(8, 'build', 'edit'),
(8, 'build', 'view'),
(8, 'company', 'browse'),
(8, 'company', 'dynamic'),
(8, 'company', 'index'),
(8, 'company', 'view'),
(8, 'doc', 'browse'),
(8, 'doc', 'create'),
(8, 'doc', 'createLib'),
(8, 'doc', 'delete'),
(8, 'doc', 'deleteLib'),
(8, 'doc', 'edit'),
(8, 'doc', 'editLib'),
(8, 'doc', 'index'),
(8, 'doc', 'view'),
(8, 'extension', 'browse'),
(8, 'extension', 'obtain'),
(8, 'extension', 'structure'),
(8, 'file', 'delete'),
(8, 'file', 'download'),
(8, 'file', 'edit'),
(8, 'file', 'uploadImages'),
(8, 'git', 'apiSync'),
(8, 'git', 'cat'),
(8, 'git', 'diff'),
(8, 'group', 'browse'),
(8, 'index', 'index'),
(8, 'misc', 'ping'),
(8, 'my', 'bug'),
(8, 'my', 'changePassword'),
(8, 'my', 'dynamic'),
(8, 'my', 'editProfile'),
(8, 'my', 'index'),
(8, 'my', 'profile'),
(8, 'my', 'project'),
(8, 'my', 'story'),
(8, 'my', 'task'),
(8, 'my', 'testCase'),
(8, 'my', 'testTask'),
(8, 'my', 'todo'),
(8, 'product', 'browse'),
(8, 'product', 'doc'),
(8, 'product', 'dynamic'),
(8, 'product', 'index'),
(8, 'product', 'project'),
(8, 'product', 'roadmap'),
(8, 'product', 'view'),
(8, 'productplan', 'browse'),
(8, 'productplan', 'view'),
(8, 'project', 'bug'),
(8, 'project', 'build'),
(8, 'project', 'burn'),
(8, 'project', 'burnData'),
(8, 'project', 'doc'),
(8, 'project', 'dynamic'),
(8, 'project', 'grouptask'),
(8, 'project', 'importBug'),
(8, 'project', 'importtask'),
(8, 'project', 'index'),
(8, 'project', 'story'),
(8, 'project', 'task'),
(8, 'project', 'team'),
(8, 'project', 'testtask'),
(8, 'project', 'view'),
(8, 'qa', 'index'),
(8, 'release', 'browse'),
(8, 'release', 'export'),
(8, 'release', 'view'),
(8, 'report', 'bugAssign'),
(8, 'report', 'bugCreate'),
(8, 'report', 'index'),
(8, 'report', 'productSummary'),
(8, 'report', 'projectDeviation'),
(8, 'report', 'workload'),
(8, 'search', 'buildForm'),
(8, 'search', 'buildQuery'),
(8, 'search', 'deleteQuery'),
(8, 'search', 'saveQuery'),
(8, 'search', 'select'),
(8, 'story', 'export'),
(8, 'story', 'report'),
(8, 'story', 'tasks'),
(8, 'story', 'view'),
(8, 'story', 'zeroCase'),
(8, 'svn', 'apiSync'),
(8, 'svn', 'cat'),
(8, 'svn', 'diff'),
(8, 'task', 'activate'),
(8, 'task', 'assignTo'),
(8, 'task', 'batchAssignTo'),
(8, 'task', 'batchClose'),
(8, 'task', 'batchCreate'),
(8, 'task', 'batchEdit'),
(8, 'task', 'cancel'),
(8, 'task', 'close'),
(8, 'task', 'confirmStoryChange'),
(8, 'task', 'create'),
(8, 'task', 'delete'),
(8, 'task', 'deleteEstimate'),
(8, 'task', 'edit'),
(8, 'task', 'editEstimate'),
(8, 'task', 'export'),
(8, 'task', 'finish'),
(8, 'task', 'pause'),
(8, 'task', 'recordEstimate'),
(8, 'task', 'report'),
(8, 'task', 'restart'),
(8, 'task', 'start'),
(8, 'task', 'view'),
(8, 'testcase', 'batchCreate'),
(8, 'testcase', 'batchDelete'),
(8, 'testcase', 'batchEdit'),
(8, 'testcase', 'browse'),
(8, 'testcase', 'confirmChange'),
(8, 'testcase', 'confirmStoryChange'),
(8, 'testcase', 'create'),
(8, 'testcase', 'createBug'),
(8, 'testcase', 'delete'),
(8, 'testcase', 'edit'),
(8, 'testcase', 'export'),
(8, 'testcase', 'exportTemplet'),
(8, 'testcase', 'groupCase'),
(8, 'testcase', 'import'),
(8, 'testcase', 'index'),
(8, 'testcase', 'showImport'),
(8, 'testcase', 'view'),
(8, 'testtask', 'batchAssign'),
(8, 'testtask', 'batchRun'),
(8, 'testtask', 'browse'),
(8, 'testtask', 'cases'),
(8, 'testtask', 'close'),
(8, 'testtask', 'create'),
(8, 'testtask', 'delete'),
(8, 'testtask', 'edit'),
(8, 'testtask', 'groupCase'),
(8, 'testtask', 'index'),
(8, 'testtask', 'linkcase'),
(8, 'testtask', 'results'),
(8, 'testtask', 'runcase'),
(8, 'testtask', 'start'),
(8, 'testtask', 'unlinkcase'),
(8, 'testtask', 'view'),
(8, 'todo', 'batchCreate'),
(8, 'todo', 'batchEdit'),
(8, 'todo', 'batchFinish'),
(8, 'todo', 'create'),
(8, 'todo', 'delete'),
(8, 'todo', 'edit'),
(8, 'todo', 'export'),
(8, 'todo', 'finish'),
(8, 'todo', 'import2Today'),
(8, 'todo', 'view'),
(8, 'tree', 'browse'),
(8, 'tree', 'browseTask'),
(8, 'tree', 'delete'),
(8, 'tree', 'edit'),
(8, 'tree', 'fix'),
(8, 'tree', 'manageChild'),
(8, 'tree', 'updateOrder'),
(8, 'user', 'bug'),
(8, 'user', 'deleteContacts'),
(8, 'user', 'dynamic'),
(8, 'user', 'manageContacts'),
(8, 'user', 'profile'),
(8, 'user', 'project'),
(8, 'user', 'story'),
(8, 'user', 'task'),
(8, 'user', 'testCase'),
(8, 'user', 'testTask'),
(8, 'user', 'todo'),
(8, 'user', 'view'),
(9, 'action', 'editComment'),
(9, 'action', 'hideAll'),
(9, 'action', 'hideOne'),
(9, 'action', 'trash'),
(9, 'action', 'undelete'),
(9, 'admin', 'index'),
(9, 'api', 'getModel'),
(9, 'bug', 'browse'),
(9, 'bug', 'export'),
(9, 'bug', 'index'),
(9, 'bug', 'report'),
(9, 'bug', 'view'),
(9, 'build', 'view'),
(9, 'company', 'browse'),
(9, 'company', 'dynamic'),
(9, 'company', 'edit'),
(9, 'company', 'index'),
(9, 'company', 'view'),
(9, 'dept', 'browse'),
(9, 'dept', 'delete'),
(9, 'dept', 'manageChild'),
(9, 'dept', 'updateOrder'),
(9, 'doc', 'browse'),
(9, 'doc', 'create'),
(9, 'doc', 'createLib'),
(9, 'doc', 'delete'),
(9, 'doc', 'deleteLib'),
(9, 'doc', 'edit'),
(9, 'doc', 'editLib'),
(9, 'doc', 'index'),
(9, 'doc', 'view'),
(9, 'extension', 'browse'),
(9, 'extension', 'obtain'),
(9, 'extension', 'structure'),
(9, 'file', 'delete'),
(9, 'file', 'download'),
(9, 'file', 'edit'),
(9, 'file', 'uploadImages'),
(9, 'git', 'apiSync'),
(9, 'git', 'cat'),
(9, 'git', 'diff'),
(9, 'group', 'browse'),
(9, 'index', 'index'),
(9, 'misc', 'ping'),
(9, 'my', 'bug'),
(9, 'my', 'changePassword'),
(9, 'my', 'dynamic'),
(9, 'my', 'editProfile'),
(9, 'my', 'index'),
(9, 'my', 'profile'),
(9, 'my', 'project'),
(9, 'my', 'story'),
(9, 'my', 'task'),
(9, 'my', 'testCase'),
(9, 'my', 'testTask'),
(9, 'my', 'todo'),
(9, 'product', 'browse'),
(9, 'product', 'doc'),
(9, 'product', 'dynamic'),
(9, 'product', 'index'),
(9, 'product', 'project'),
(9, 'product', 'roadmap'),
(9, 'product', 'view'),
(9, 'productplan', 'browse'),
(9, 'productplan', 'view'),
(9, 'project', 'browse'),
(9, 'project', 'bug'),
(9, 'project', 'build'),
(9, 'project', 'burn'),
(9, 'project', 'burnData'),
(9, 'project', 'computeBurn'),
(9, 'project', 'doc'),
(9, 'project', 'dynamic'),
(9, 'project', 'grouptask'),
(9, 'project', 'index'),
(9, 'project', 'story'),
(9, 'project', 'task'),
(9, 'project', 'team'),
(9, 'project', 'view'),
(9, 'qa', 'index'),
(9, 'release', 'browse'),
(9, 'release', 'export'),
(9, 'release', 'view'),
(9, 'report', 'bugAssign'),
(9, 'report', 'bugCreate'),
(9, 'report', 'index'),
(9, 'report', 'productSummary'),
(9, 'report', 'projectDeviation'),
(9, 'report', 'workload'),
(9, 'search', 'buildForm'),
(9, 'search', 'buildQuery'),
(9, 'search', 'deleteQuery'),
(9, 'search', 'saveQuery'),
(9, 'search', 'select'),
(9, 'story', 'export'),
(9, 'story', 'report'),
(9, 'story', 'review'),
(9, 'story', 'tasks'),
(9, 'story', 'view'),
(9, 'story', 'zeroCase'),
(9, 'svn', 'apiSync'),
(9, 'svn', 'cat'),
(9, 'svn', 'diff'),
(9, 'task', 'deleteEstimate'),
(9, 'task', 'editEstimate'),
(9, 'task', 'export'),
(9, 'task', 'recordEstimate'),
(9, 'task', 'report'),
(9, 'task', 'view'),
(9, 'testcase', 'browse'),
(9, 'testcase', 'export'),
(9, 'testcase', 'groupCase'),
(9, 'testcase', 'index'),
(9, 'testcase', 'view'),
(9, 'testtask', 'browse'),
(9, 'testtask', 'cases'),
(9, 'testtask', 'groupCase'),
(9, 'testtask', 'index'),
(9, 'testtask', 'results'),
(9, 'testtask', 'view'),
(9, 'todo', 'batchCreate'),
(9, 'todo', 'batchEdit'),
(9, 'todo', 'batchFinish'),
(9, 'todo', 'create'),
(9, 'todo', 'delete'),
(9, 'todo', 'edit'),
(9, 'todo', 'export'),
(9, 'todo', 'finish'),
(9, 'todo', 'import2Today'),
(9, 'todo', 'view'),
(9, 'user', 'batchCreate'),
(9, 'user', 'batchEdit'),
(9, 'user', 'bug'),
(9, 'user', 'create'),
(9, 'user', 'delete'),
(9, 'user', 'deleteContacts'),
(9, 'user', 'dynamic'),
(9, 'user', 'edit'),
(9, 'user', 'manageContacts'),
(9, 'user', 'profile'),
(9, 'user', 'project'),
(9, 'user', 'story'),
(9, 'user', 'task'),
(9, 'user', 'testCase'),
(9, 'user', 'testTask'),
(9, 'user', 'todo'),
(9, 'user', 'unlock'),
(9, 'user', 'view'),
(10, 'action', 'editComment'),
(10, 'api', 'getModel'),
(10, 'bug', 'activate'),
(10, 'bug', 'browse'),
(10, 'bug', 'close'),
(10, 'bug', 'create'),
(10, 'bug', 'edit'),
(10, 'bug', 'index'),
(10, 'bug', 'report'),
(10, 'bug', 'view'),
(10, 'build', 'view'),
(10, 'company', 'browse'),
(10, 'company', 'dynamic'),
(10, 'company', 'index'),
(10, 'company', 'view'),
(10, 'doc', 'browse'),
(10, 'doc', 'index'),
(10, 'doc', 'view'),
(10, 'file', 'download'),
(10, 'index', 'index'),
(10, 'misc', 'ping'),
(10, 'my', 'changePassword'),
(10, 'my', 'dynamic'),
(10, 'my', 'editProfile'),
(10, 'my', 'index'),
(10, 'my', 'profile'),
(10, 'my', 'task'),
(10, 'my', 'todo'),
(10, 'product', 'browse'),
(10, 'product', 'doc'),
(10, 'product', 'dynamic'),
(10, 'product', 'index'),
(10, 'product', 'roadmap'),
(10, 'product', 'view'),
(10, 'productplan', 'browse'),
(10, 'productplan', 'view'),
(10, 'project', 'browse'),
(10, 'project', 'bug'),
(10, 'project', 'build'),
(10, 'project', 'burn'),
(10, 'project', 'doc'),
(10, 'project', 'dynamic'),
(10, 'project', 'grouptask'),
(10, 'project', 'index'),
(10, 'project', 'story'),
(10, 'project', 'task'),
(10, 'project', 'team'),
(10, 'project', 'testtask'),
(10, 'project', 'view'),
(10, 'qa', 'index'),
(10, 'release', 'browse'),
(10, 'release', 'view'),
(10, 'report', 'bugAssign'),
(10, 'report', 'bugCreate'),
(10, 'report', 'index'),
(10, 'report', 'productSummary'),
(10, 'report', 'projectDeviation'),
(10, 'report', 'workload'),
(10, 'search', 'buildForm'),
(10, 'search', 'buildQuery'),
(10, 'search', 'deleteQuery'),
(10, 'search', 'saveQuery'),
(10, 'story', 'tasks'),
(10, 'story', 'view'),
(10, 'task', 'deleteEstimate'),
(10, 'task', 'editEstimate'),
(10, 'task', 'recordEstimate'),
(10, 'task', 'view'),
(10, 'todo', 'batchCreate'),
(10, 'todo', 'batchEdit'),
(10, 'todo', 'batchFinish'),
(10, 'todo', 'create'),
(10, 'todo', 'delete'),
(10, 'todo', 'edit'),
(10, 'todo', 'export'),
(10, 'todo', 'finish'),
(10, 'todo', 'import2Today'),
(10, 'todo', 'view'),
(10, 'user', 'bug'),
(10, 'user', 'dynamic'),
(10, 'user', 'profile'),
(10, 'user', 'project'),
(10, 'user', 'story'),
(10, 'user', 'task'),
(10, 'user', 'testCase'),
(10, 'user', 'testTask'),
(10, 'user', 'todo'),
(10, 'user', 'view'),
(11, 'bug', 'browse'),
(11, 'bug', 'index'),
(11, 'bug', 'report'),
(11, 'bug', 'view'),
(11, 'build', 'view'),
(11, 'company', 'browse'),
(11, 'company', 'dynamic'),
(11, 'company', 'index'),
(11, 'company', 'view'),
(11, 'doc', 'browse'),
(11, 'doc', 'index'),
(11, 'doc', 'view'),
(11, 'file', 'download'),
(11, 'git', 'cat'),
(11, 'git', 'diff'),
(11, 'group', 'browse'),
(11, 'index', 'index'),
(11, 'misc', 'ping'),
(11, 'my', 'index'),
(11, 'product', 'browse'),
(11, 'product', 'doc'),
(11, 'product', 'dynamic'),
(11, 'product', 'index'),
(11, 'product', 'roadmap'),
(11, 'product', 'view'),
(11, 'productplan', 'browse'),
(11, 'productplan', 'view'),
(11, 'project', 'browse'),
(11, 'project', 'bug'),
(11, 'project', 'build'),
(11, 'project', 'burn'),
(11, 'project', 'doc'),
(11, 'project', 'dynamic'),
(11, 'project', 'grouptask'),
(11, 'project', 'index'),
(11, 'project', 'story'),
(11, 'project', 'task'),
(11, 'project', 'team'),
(11, 'project', 'testtask'),
(11, 'project', 'view'),
(11, 'qa', 'index'),
(11, 'release', 'browse'),
(11, 'release', 'view'),
(11, 'report', 'bugAssign'),
(11, 'report', 'bugCreate'),
(11, 'report', 'index'),
(11, 'report', 'productSummary'),
(11, 'report', 'projectDeviation'),
(11, 'report', 'workload'),
(11, 'search', 'buildForm'),
(11, 'search', 'buildQuery'),
(11, 'story', 'tasks'),
(11, 'story', 'view'),
(11, 'svn', 'cat'),
(11, 'svn', 'diff'),
(11, 'task', 'recordEstimate'),
(11, 'task', 'view'),
(11, 'testcase', 'browse'),
(11, 'testcase', 'groupCase'),
(11, 'testcase', 'index'),
(11, 'testcase', 'view'),
(11, 'testtask', 'browse'),
(11, 'testtask', 'cases'),
(11, 'testtask', 'groupCase'),
(11, 'testtask', 'index'),
(11, 'testtask', 'results'),
(11, 'testtask', 'view'),
(11, 'user', 'bug'),
(11, 'user', 'dynamic'),
(11, 'user', 'profile'),
(11, 'user', 'project'),
(11, 'user', 'story'),
(11, 'user', 'task'),
(11, 'user', 'testCase'),
(11, 'user', 'testTask'),
(11, 'user', 'todo'),
(11, 'user', 'view');

DROP TABLE IF EXISTS `zt_effort`;
CREATE TABLE IF NOT EXISTS `zt_effort` (
  `id` MEDIUMINT( 8 ) UNSIGNED NOT NULL AUTO_INCREMENT PRIMARY KEY ,
  `objectType` VARCHAR( 30 ) NOT NULL ,
  `objectID` SMALLINT( 8 ) UNSIGNED NOT NULL ,
  `product` VARCHAR( 255 ) NOT NULL ,
  `project` MEDIUMINT( 9 ) UNSIGNED NOT NULL ,
  `account` VARCHAR( 30 ) NOT NULL ,
  `work` VARCHAR( 255 ) NOT NULL ,
  `date` DATE NOT NULL ,
  `left` float NOT NULL,
  `consumed` float NOT NULL,
  `begin` SMALLINT( 4 ) UNSIGNED ZEROFILL NOT NULL ,
  `end` SMALLINT( 4 ) UNSIGNED ZEROFILL NOT NULL
) ENGINE = MYISAM CHARACTER SET utf8 COLLATE utf8_general_ci ;
ALTER TABLE  `zt_action` ADD  `efforted` BOOL NOT NULL DEFAULT  '0';
INSERT INTO `zt_grouppriv` (`group`, `module`, `method`) VALUES
(1, 'company', 'effort'),
(2, 'company', 'effort'),
(3, 'company', 'effort'),
(4, 'company', 'effort'),
(5, 'company', 'effort'),
(6, 'company', 'effort'),
(7, 'company', 'effort'),
(8, 'company', 'effort'),
(9, 'company', 'effort'),
(10, 'company', 'effort'),
(1, 'effort', 'export'),
(2, 'effort', 'export'),
(3, 'effort', 'export'),
(4, 'effort', 'export'),
(5, 'effort', 'export'),
(6, 'effort', 'export'),
(7, 'effort', 'export'),
(8, 'effort', 'export'),
(9, 'effort', 'export'),
(10, 'effort', 'export'),
(1, 'effort', 'view'),
(2, 'effort', 'view'),
(3, 'effort', 'view'),
(4, 'effort', 'view'),
(5, 'effort', 'view'),
(6, 'effort', 'view'),
(7, 'effort', 'view'),
(8, 'effort', 'view'),
(9, 'effort', 'view'),
(10, 'effort', 'view'),
(1, 'effort', 'edit'),
(2, 'effort', 'edit'),
(3, 'effort', 'edit'),
(4, 'effort', 'edit'),
(5, 'effort', 'edit'),
(6, 'effort', 'edit'),
(7, 'effort', 'edit'),
(8, 'effort', 'edit'),
(9, 'effort', 'edit'),
(10, 'effort', 'edit'),
(1, 'effort', 'batchCreate'),
(2, 'effort', 'batchCreate'),
(3, 'effort', 'batchCreate'),
(4, 'effort', 'batchCreate'),
(5, 'effort', 'batchCreate'),
(6, 'effort', 'batchCreate'),
(7, 'effort', 'batchCreate'),
(8, 'effort', 'batchCreate'),
(9, 'effort', 'batchCreate'),
(10, 'effort', 'batchCreate'),
(1, 'effort', 'delete'),
(2, 'effort', 'delete'),
(3, 'effort', 'delete'),
(4, 'effort', 'delete'),
(5, 'effort', 'delete'),
(6, 'effort', 'delete'),
(7, 'effort', 'delete'),
(8, 'effort', 'delete'),
(9, 'effort', 'delete'),
(10, 'effort', 'delete'),
(1, 'effort', 'createForObject'),
(2, 'effort', 'createForObject'),
(3, 'effort', 'createForObject'),
(4, 'effort', 'createForObject'),
(5, 'effort', 'createForObject'),
(6, 'effort', 'createForObject'),
(7, 'effort', 'createForObject'),
(8, 'effort', 'createForObject'),
(9, 'effort', 'createForObject'),
(10, 'effort', 'createForObject'),
(1, 'my', 'effort'),
(2, 'my', 'effort'),
(3, 'my', 'effort'),
(4, 'my', 'effort'),
(5, 'my', 'effort'),
(6, 'my', 'effort'),
(7, 'my', 'effort'),
(8, 'my', 'effort'),
(9, 'my', 'effort'),
(10, 'my', 'effort'),
(1, 'project', 'effort'),
(2, 'project', 'effort'),
(3, 'project', 'effort'),
(4, 'project', 'effort'),
(5, 'project', 'effort'),
(6, 'project', 'effort'),
(7, 'project', 'effort'),
(8, 'project', 'effort'),
(9, 'project', 'effort'),
(10, 'project', 'effort'),
(1, 'user', 'effort');
INSERT INTO `zt_grouppriv` (`group`, `module`, `method`) VALUES
(1, 'bug', 'exportTemplet'),
(4, 'bug', 'exportTemplet'),
(1, 'bug', 'import'),
(4, 'bug', 'import'),
(1, 'bug', 'showImport'),
(4, 'bug', 'showImport'),
(1, 'story', 'exportTemplet'),
(4, 'story', 'exportTemplet'),
(1, 'story', 'import'),
(4, 'story', 'import'),
(1, 'story', 'showImport'),
(4, 'story', 'showImport'),
(1, 'task', 'exportTemplet'),
(4, 'task', 'exportTemplet'),
(1, 'task', 'import'),
(4, 'task', 'import'),
(1, 'task', 'showImport'),
(4, 'task', 'showImport');
INSERT INTO `zt_grouppriv` (`group`, `module`, `method`) VALUES
(1, 'todo', 'calendar'),
(2, 'todo', 'calendar'),
(3, 'todo', 'calendar'),
(4, 'todo', 'calendar'),
(5, 'todo', 'calendar'),
(6, 'todo', 'calendar'),
(7, 'todo', 'calendar'),
(8, 'todo', 'calendar'),
(9, 'todo', 'calendar'),
(10, 'todo', 'calendar'),
(1, 'effort', 'calendar'),
(2, 'effort', 'calendar'),
(3, 'effort', 'calendar'),
(4, 'effort', 'calendar'),
(5, 'effort', 'calendar'),
(6, 'effort', 'calendar'),
(7, 'effort', 'calendar'),
(8, 'effort', 'calendar'),
(9, 'effort', 'calendar'),
(10, 'effort', 'calendar'),
(1, 'project', 'calendar'),
(2, 'project', 'calendar'),
(3, 'project', 'calendar'),
(4, 'project', 'calendar'),
(5, 'project', 'calendar'),
(6, 'project', 'calendar'),
(7, 'project', 'calendar'),
(8, 'project', 'calendar'),
(9, 'project', 'calendar'),
(10, 'project', 'calendar'),
(1, 'user', 'effortcalendar'),
(2, 'user', 'effortcalendar'),
(3, 'user', 'effortcalendar'),
(4, 'user', 'effortcalendar'),
(5, 'user', 'effortcalendar'),
(6, 'user', 'effortcalendar'),
(7, 'user', 'effortcalendar'),
(8, 'user', 'effortcalendar'),
(9, 'user', 'effortcalendar'),
(10, 'user', 'effortcalendar'),
(1, 'user', 'todocalendar'),
(2, 'user', 'todocalendar'),
(3, 'user', 'todocalendar'),
(4, 'user', 'todocalendar'),
(5, 'user', 'todocalendar'),
(6, 'user', 'todocalendar'),
(7, 'user', 'todocalendar'),
(8, 'user', 'todocalendar'),
(9, 'user', 'todocalendar'),
(10, 'user', 'todocalendar');
 -- DROP TABLE IF EXISTS `zt_relationoftasks`;
CREATE TABLE IF NOT EXISTS `zt_relationoftasks` (
  `id` MEDIUMINT( 8 ) UNSIGNED NOT NULL AUTO_INCREMENT ,
  `project` MEDIUMINT( 8 ) UNSIGNED NOT NULL ,
  `pretask` MEDIUMINT( 8 ) UNSIGNED NOT NULL ,
  `condition` ENUM( 'begin', 'end' ) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL ,
  `task` MEDIUMINT( 8 ) UNSIGNED NOT NULL ,
  `action` ENUM( 'begin', 'end' ) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL ,
  PRIMARY KEY ( `id` )
) ENGINE = MYISAM CHARACTER SET utf8 COLLATE utf8_general_ci;
INSERT INTO `zt_grouppriv` (`group`, `module`, `method`) VALUES
(1, 'project', 'deleterelation'),
(1, 'project', 'gantt'),
(2, 'project', 'gantt'),
(3, 'project', 'gantt'),
(4, 'project', 'gantt'),
(5, 'project', 'gantt'),
(6, 'project', 'gantt'),
(7, 'project', 'gantt'),
(8, 'project', 'gantt'),
(9, 'project', 'gantt'),
(10, 'project', 'gantt'),
(1, 'project', 'relation'),
(2, 'project', 'relation'),
(3, 'project', 'relation'),
(4, 'project', 'relation'),
(5, 'project', 'relation'),
(6, 'project', 'relation'),
(7, 'project', 'relation'),
(8, 'project', 'relation'),
(9, 'project', 'relation'),
(10, 'project', 'relation');
INSERT INTO `zt_grouppriv` (`group`, `module`, `method`) VALUES
(1, 'project', 'kanban'),
(2, 'project', 'kanban'),
(3, 'project', 'kanban'),
(4, 'project', 'kanban'),
(5, 'project', 'kanban'),
(6, 'project', 'kanban'),
(7, 'project', 'kanban'),
(8, 'project', 'kanban'),
(9, 'project', 'kanban'),
(10, 'project', 'kanban');
-- DROP TABLE IF EXISTS `zt_repo`;
CREATE TABLE IF NOT EXISTS `zt_repo` (
  `id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `path` varchar(255) NOT NULL,
  `prefix` varchar(100) NOT NULL,
  `encoding` varchar(20) NOT NULL,
  `SCM` varchar(10) NOT NULL,
  `client` varchar(100) NOT NULL,
  `commits` mediumint(8) unsigned NOT NULL,
  `account` varchar(30) NOT NULL,
  `password` varchar(30) NOT NULL,
  `acl` text NOT NULL,
  `synced` tinyint(1) NOT NULL DEFAULT '0',
  `lastSync` datetime NOT NULL,
  `deleted` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_repohistory`;
CREATE TABLE IF NOT EXISTS `zt_repohistory` (
      `id` mediumint(9) NOT NULL AUTO_INCREMENT,
      `repo` mediumint(9) NOT NULL,
      `revision` varchar(40) NOT NULL,
      `commit` mediumint(8) unsigned NOT NULL,
      `comment` text NOT NULL,
      `committer` varchar(100) NOT NULL,
      `time` datetime NOT NULL,
      PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- DROP TABLE IF EXISTS `zt_repofiles`;
CREATE TABLE `zt_repofiles` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `repo` mediumint(8) unsigned NOT NULL,
  `revision` mediumint(8) unsigned NOT NULL,
  `path` varchar(255) NOT NULL,
  `parent` varchar(255) NOT NULL,
  `type` varchar(20) NOT NULL,
  `action` char(1) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

ALTER TABLE `zt_bug`
CHANGE `caseVersion` `caseVersion` smallint(6) NOT NULL AFTER `case`,
ADD `repo` mediumint(8) unsigned NOT NULL AFTER `result`,
ADD `lines` varchar(10) COLLATE 'utf8_general_ci' NOT NULL AFTER `repo`,
ADD `v1` varchar(40) COLLATE 'utf8_general_ci' NOT NULL AFTER `lines`,
ADD `v2` varchar(40) COLLATE 'utf8_general_ci' NOT NULL AFTER `v1`,
ADD `repoType` varchar(30) COLLATE 'utf8_general_ci' NOT NULL DEFAULT '' AFTER `v2`;
ALTER TABLE `zt_bug` ADD `entry` varchar(255) COLLATE 'utf8_general_ci' NOT NULL AFTER `repo`;
INSERT INTO `zt_grouppriv` (`group`, `module`, `method`) VALUES
(1, 'repo', 'view'),
(2, 'repo', 'view'),
(3, 'repo', 'view'),
(4, 'repo', 'view'),
(5, 'repo', 'view'),
(6, 'repo', 'view'),
(7, 'repo', 'view'),
(8, 'repo', 'view'),
(9, 'repo', 'view'),
(10, 'repo', 'view'),
(1, 'repo', 'revision'),
(2, 'repo', 'revision'),
(3, 'repo', 'revision'),
(4, 'repo', 'revision'),
(5, 'repo', 'revision'),
(6, 'repo', 'revision'),
(7, 'repo', 'revision'),
(8, 'repo', 'revision'),
(9, 'repo', 'revision'),
(10, 'repo', 'revision'),
(1, 'repo', 'showSyncComment'),
(2, 'repo', 'showSyncComment'),
(3, 'repo', 'showSyncComment'),
(4, 'repo', 'showSyncComment'),
(5, 'repo', 'showSyncComment'),
(6, 'repo', 'showSyncComment'),
(7, 'repo', 'showSyncComment'),
(8, 'repo', 'showSyncComment'),
(9, 'repo', 'showSyncComment'),
(10, 'repo', 'showSyncComment'),
(1, 'repo', 'download'),
(2, 'repo', 'download'),
(3, 'repo', 'download'),
(4, 'repo', 'download'),
(5, 'repo', 'download'),
(6, 'repo', 'download'),
(7, 'repo', 'download'),
(8, 'repo', 'download'),
(9, 'repo', 'download'),
(10, 'repo', 'download'),
(1, 'repo', 'browse'),
(2, 'repo', 'browse'),
(3, 'repo', 'browse'),
(4, 'repo', 'browse'),
(5, 'repo', 'browse'),
(6, 'repo', 'browse'),
(7, 'repo', 'browse'),
(8, 'repo', 'browse'),
(9, 'repo', 'browse'),
(10, 'repo', 'browse'),
(1, 'repo', 'diff'),
(2, 'repo', 'diff'),
(3, 'repo', 'diff'),
(4, 'repo', 'diff'),
(5, 'repo', 'diff'),
(6, 'repo', 'diff'),
(7, 'repo', 'diff'),
(8, 'repo', 'diff'),
(9, 'repo', 'diff'),
(10, 'repo', 'diff'),
(1, 'repo', 'log'),
(2, 'repo', 'log'),
(3, 'repo', 'log'),
(4, 'repo', 'log'),
(5, 'repo', 'log'),
(6, 'repo', 'log'),
(7, 'repo', 'log'),
(8, 'repo', 'log'),
(9, 'repo', 'log'),
(10, 'repo', 'log'),
(1, 'repo', 'create'),
(4, 'repo', 'create'),
(5, 'repo', 'create'),
(1, 'repo', 'settings'),
(4, 'repo', 'settings'),
(5, 'repo', 'settings'),
(1, 'repo', 'delete'),
(4, 'repo', 'delete'),
(5, 'repo', 'delete');
INSERT INTO `zt_grouppriv` (`group`, `module`, `method`) VALUES
(1, 'report', 'build'),
(2, 'report', 'build'),
(3, 'report', 'build'),
(4, 'report', 'build'),
(5, 'report', 'build'),
(6, 'report', 'build'),
(7, 'report', 'build'),
(8, 'report', 'build'),
(9, 'report', 'build'),
(10, 'report', 'build'),
(1, 'report', 'testcase'),
(2, 'report', 'testcase'),
(3, 'report', 'testcase'),
(4, 'report', 'testcase'),
(5, 'report', 'testcase'),
(6, 'report', 'testcase'),
(7, 'report', 'testcase'),
(8, 'report', 'testcase'),
(9, 'report', 'testcase'),
(10, 'report', 'testcase'),
(1, 'report', 'workSummary'),
(2, 'report', 'workSummary'),
(3, 'report', 'workSummary'),
(4, 'report', 'workSummary'),
(5, 'report', 'workSummary'),
(6, 'report', 'workSummary'),
(7, 'report', 'workSummary'),
(8, 'report', 'workSummary'),
(9, 'report', 'workSummary'),
(10, 'report', 'workSummary');
-- DROP TABLE IF EXISTS `zt_report`;
CREATE TABLE `zt_report` (
  `id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `code` varchar(100) NOT NULL,
  `name` text NOT NULL,
  `module` varchar(100) NOT NULL,
  `sql` text NOT NULL,
  `vars` text NOT NULL,
  `langs` text NOT NULL,
  `params` text NOT NULL,
  `step` tinyint(1) NOT NULL DEFAULT '2',
  `desc` text NOT NULL,
  `addedBy` char(30) NOT NULL,
  `addedDate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `code` (`code`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `zt_report` (`code`, `name`, `module`, `sql`, `vars`, `langs`, `params`, `step`, `desc`, `addedBy`, `addedDate`) VALUES
('project-taskstatus',   '{\"zh-cn\":\"\\u9879\\u76ee\\u4efb\\u52a1\\u72b6\\u6001\\u7edf\\u8ba1\",\"zh-tw\":\"\",\"en\":\"\"}',  'project',      'select t1.*, (case when t1.deadline < CURDATE() and t1.deadline != \'0000-00-00\' and t1.status != \'closed\' and t1.status != \'done\' and t1.status != \'cancel\' then 1 else 0 end) as timeout,t2.name as project from zt_task as t1 left join zt_project as t2 on (t1.project=t2.id) where t1.openedDate >= $startDate and t1.openedDate <= $endDate',     '{\"varName\":[\"startDate\",\"endDate\"],\"showName\":[\"\\u5f00\\u59cb\\u65f6\\u95f4\",\"\\u7ed3\\u675f\\u65f6\\u95f4\"],\"requestType\":[\"date\",\"date\"]}',       '',     '{\"group1\":\"project\",\"group2\":\"\",\"reportField\":[\"status\",\"timeout\"],\"reportType\":[\"count\",\"sum\"],\"sumAppend\":[\"\",\"timeout\"],\"reportTotal\":[\"1\"]}',        2,      '{\"zh-cn\":\"\\u9879\\u76ee\\u4efb\\u52a1\\u72b6\\u6001\\u7edf\\u8ba1\",\"zh-tw\":\"\",\"en\":\"\"}',  'admin',        '2014-09-11 10:08:08');

CREATE OR REPLACE VIEW `ztv_projectsummary` AS select `zt_task`.`project` AS `project`,sum(`zt_task`.`estimate`) AS `estimate`,sum(`zt_task`.`consumed`) AS `consumed`,sum(`zt_task`.`left`) AS `left`,count(0) AS `number`,sum(if(((`zt_task`.`status` = 'wait') or (`zt_task`.`status` = 'doing')),1,0)) AS `undone`,sum((`zt_task`.`consumed` + `zt_task`.`left`)) AS `totalReal` from `zt_task` where ((`zt_task`.`deleted` = '0') and (`zt_task`.`status` <> 'cancel') and (`zt_task`.`status` <> 'closed')) group by `zt_task`.`project`;
CREATE OR REPLACE VIEW `ztv_projectstories` AS select `t1`.`project` AS `project`,count('*') AS `stories`,sum(if((`t2`.`status` = 'closed'),0,1)) AS `undone` from (`zt_projectstory` `t1` left join `zt_story` `t2` on((`t1`.`story` = `t2`.`id`))) group by `t1`.`project`;
CREATE OR REPLACE VIEW `ztv_projectteams` AS select `zt_team`.`project` AS `project`,count('*') AS `teams` from `zt_team` group by `zt_team`.`project`;
CREATE OR REPLACE VIEW `ztv_projectbugs` AS select `zt_bug`.`project` AS `project`,count(0) AS `bugs`,sum(if((`zt_bug`.`resolution` = ''),0,1)) AS `resolutions`,sum(if((`zt_bug`.`severity` <= 2),1,0)) AS `seriousBugs` from `zt_bug` where (`zt_bug`.`deleted` = '0') group by `zt_bug`.`project`;
CREATE OR REPLACE VIEW `ztv_productbugs` AS select `zt_bug`.`product` AS `product`,count(0) AS `bugs`,sum(if((`zt_bug`.`resolution` = ''),0,1)) AS `resolutions`,sum(if((`zt_bug`.`severity` <= 2),1,0)) AS `seriousBugs` from `zt_bug` where (`zt_bug`.`deleted` = '0') group by `zt_bug`.`product`;
CREATE OR REPLACE VIEW `ztv_productstories` AS select `zt_story`.`product` AS `product`,count('*') AS `stories`,sum(if((`zt_story`.`status` = 'closed'),0,1)) AS `undone` from `zt_story` where (`zt_story`.`deleted` = '0') group by `zt_story`.`product`;
CREATE OR REPLACE VIEW `ztv_dayuserlogin` AS select count(*) AS `userlogin`,left(`zt_action`.`date`,10) AS `day` from `zt_action` where ((`zt_action`.`objectType` = 'user') and (`zt_action`.`action` = 'login')) group by left(`zt_action`.`date`,10);
CREATE OR REPLACE VIEW `ztv_dayeffort` AS select round(sum(`zt_effort`.`consumed`),1) AS `consumed`,`zt_effort`.`date` AS `date` from `zt_effort` group by `zt_effort`.`date`;
CREATE OR REPLACE VIEW `ztv_daystoryopen` AS select count(*) AS `storyopen`,left(`zt_action`.`date`,10) AS `day` from `zt_action` where ((`zt_action`.`objectType` = 'story') and (`zt_action`.`action` = 'opened')) group by left(`zt_action`.`date`,10);
CREATE OR REPLACE VIEW `ztv_daystoryclose` AS select count(*) AS `storyclose`,left(`zt_action`.`date`,10) AS `day` from `zt_action` where ((`zt_action`.`objectType` = 'story') and (`zt_action`.`action` = 'closed')) group by left(`zt_action`.`date`,10);
CREATE OR REPLACE VIEW `ztv_daytaskopen` AS select count(*) AS `taskopen`,left(`zt_action`.`date`,10) AS `day` from `zt_action` where ((`zt_action`.`objectType` = 'task') and (`zt_action`.`action` = 'opened')) group by left(`zt_action`.`date`,10);
CREATE OR REPLACE VIEW `ztv_daytaskfinish` AS select count(*) AS `taskfinish`,left(`zt_action`.`date`,10) AS `day` from `zt_action` where ((`zt_action`.`objectType` = 'task') and (`zt_action`.`action` = 'finished')) group by left(`zt_action`.`date`,10);
CREATE OR REPLACE VIEW `ztv_daybugopen` AS select count(*) AS `bugopen`,left(`zt_action`.`date`,10) AS `day` from `zt_action` where ((`zt_action`.`objectType` = 'bug') and (`zt_action`.`action` = 'opened')) group by left(`zt_action`.`date`,10);
CREATE OR REPLACE VIEW `ztv_daybugresolve` AS select count(*) AS `bugresolve`,left(`zt_action`.`date`,10) AS `day` from `zt_action` where ((`zt_action`.`objectType` = 'bug') and (`zt_action`.`action` = 'resolved')) group by left(`zt_action`.`date`,10);
CREATE OR REPLACE VIEW `ztv_dayactions` AS select count(*) AS `actions`,left(`zt_action`.`date`,10) AS `day` from `zt_action` group by left(`zt_action`.`date`,10);

REPLACE INTO `zt_report` (`code`, `name`, `module`, `sql`, `vars`, `langs`, `params`, `step`, `desc`, `addedBy`, `addedDate`) VALUES
('product-invest',       '{\"zh-cn\":\"\\u4ea7\\u54c1\\u6295\\u5165\\u8868\",\"zh-tw\":\"\\u7522\\u54c1\\u6295\\u5165\\u8868\",\"en\":\"Product invest\"}',      ',product',     'select t1.id,t1.name,1 as projects, round(t3.consumed,2) as consumed from TABLE_PRODUCT as t1 left join TABLE_PROJECTPRODUCT as t2 on t1.id=t2.product left join ztv_projectsummary as t3 on t2.project=t3.project where t1.deleted=\'0\'',    '',     '{\"projects\":{\"zh-cn\":\"\\u9879\\u76ee\\u6570\",\"zh-tw\":\"\\u9879\\u76ee\\u6570\",\"en\":\"Projects\"},\"consumed\":{\"zh-cn\":\"\\u5df2\\u6d88\\u8017\\u5de5\\u65f6\",\"zh-tw\":\"\\u5df2\\u6d88\\u8017\\u5de5\\u65f6\",\"en\":\"Consumed\"}}',  '{\"group1\":\"name\",\"group2\":\"\",\"reportField\":[\"projects\",\"consumed\"],\"reportType\":[\"sum\",\"sum\"],\"sumAppend\":[\"projects\",\"consumed\"],\"contrast\":[\"\",\"\"]}',        2,      '{\"zh-cn\":\"\\u5217\\u51fa\\u6bcf\\u4e2a\\u4ea7\\u54c1\\u7684\\u9879\\u76ee\\u603b\\u6570\\uff0c\\u5df2\\u7ecf\\u6d88\\u8017\\u7684\\u5de5\\u65f6\\u3002\",\"zh-tw\":\"\",\"en\":\"\"}',      'admin',        '2015-07-20 14:21:30'),
('product-progress',     '{\"zh-cn\":\"\\u4ea7\\u54c1\\u5b8c\\u6210\\u5ea6\\u7edf\\u8ba1\\u62a5\\u8868\",\"zh-tw\":\"\\u7522\\u54c1\\u5b8c\\u6210\\u5ea6\\u7d71\\u8a08\\u5831\\u8868\",\"en\":\"Product progress\"}',    ',product',     'select t1.*,t2.name, (case when t1.status = \'status\' or t1.stage = \'released\' then 1 else 0 end) as done, 1 as count from TABLE_STORY as t1 left join TABLE_PRODUCT as t2 on t1.product=t2.id where t1.deleted=\'0\' and t2.deleted=\'0\'',        '',     '{\"count\":{\"zh-cn\":\"\\u9700\\u6c42\\u6570\",\"zh-tw\":\"\\u9700\\u6c42\\u6570\",\"en\":\"Stories\"},\"done\":{\"zh-cn\":\"\\u5b8c\\u6210\\u6570\",\"zh-tw\":\"\\u5b8c\\u6210\\u6570\",\"en\":\"Done\"}}',  '{\"group1\":\"name\",\"group2\":\"\",\"reportField\":[\"count\",\"done\"],\"reportType\":[\"sum\",\"sum\"],\"sumAppend\":[\"count\",\"done\"],\"contrast\":[\"\",\"count\"],\"percent\":{\"1\":\"1\"},\"showAlone\":{\"1\":\"1\"}}',   2,      '{\"zh-cn\":\"\\u6309\\u7167\\u4ea7\\u54c1\\u5217\\u51fa\\u9700\\u6c42\\u603b\\u6570\\uff0c\\u5b8c\\u6210\\u7684\\u603b\\u6570(\\u72b6\\u6001\\u662f\\u5173\\u95ed\\u7684\\u6216\\u8005\\uff0c\\u6216\\u8005\\u7814\\u53d1\\u9636\\u6bb5\\u662f\\u53d1\\u5e03\\u7684)\\uff0c\\u5b8c\\u6210\\u7684\\u767e\\u5206\\u6bd4\\u3002\",\"zh-tw\":\"\",\"en\":\"\"}',   'admin',        '2015-07-21 15:07:48'),
('story-status',         '{\"zh-cn\":\"\\u4ea7\\u54c1\\u9700\\u6c42\\u72b6\\u6001\\u5206\\u5e03\",\"zh-tw\":\"\\u7522\\u54c1\\u9700\\u6c42\\u72c0\\u614b\\u5206\\u4f48\",\"en\":\"The report for story status\"}',       ',product',     'select t1.*,t2.name from TABLE_STORY as t1 left join TABLE_PRODUCT as t2 on t1.product=t2.id where t1.deleted=\'0\' and t2.deleted=\'0\'',     '',     '',     '{\"group1\":\"name\",\"group2\":\"\",\"reportField\":[\"status\"],\"reportType\":[\"count\"],\"sumAppend\":[\"\"],\"reportTotal\":[\"1\"],\"contrast\":[\"\"]}',       2,      '{\"zh-cn\":\"\\u6309\\u7167\\u4ea7\\u54c1\\u5217\\u51fa\\u9700\\u6c42\\u603b\\u6570\\uff0c\\u72b6\\u6001\\u7684\\u5206\\u5e03\\u60c5\\u51b5\\u3002\",\"zh-tw\":\"\",\"en\":\"\"}',     'admin',        '2015-07-21 15:35:38'),
('story-stage',          '{\"zh-cn\":\"\\u4ea7\\u54c1\\u9700\\u6c42\\u9636\\u6bb5\\u5206\\u5e03\",\"zh-tw\":\"\\u7522\\u54c1\\u9700\\u6c42\\u968e\\u6bb5\\u5206\\u4f48\",\"en\":\"The report for story stage\"}',        ',product',     'select t1.*,t2.name from TABLE_STORY as t1 left join TABLE_PRODUCT as t2 on t1.product=t2.id where t1.deleted=\'0\' and t2.deleted=\'0\'',     '',     '',     '{\"group1\":\"name\",\"group2\":\"\",\"reportField\":[\"stage\"],\"reportType\":[\"count\"],\"sumAppend\":[\"\"],\"reportTotal\":[\"1\"],\"contrast\":[\"\"]}',        2,      '{\"zh-cn\":\"\\u6309\\u7167\\u4ea7\\u54c1\\u5217\\u51fa\\u9700\\u6c42\\u603b\\u6570\\uff0c\\u7814\\u53d1\\u9636\\u6bb5\\u7684\\u5206\\u5e03\\u60c5\\u51b5\\u3002\",\"zh-tw\":\"\",\"en\":\"\"}',       'admin',        '2015-07-21 15:38:34'),
('product-release',      '{\"zh-cn\":\"\\u4ea7\\u54c1\\u53d1\\u5e03\\u6570\\u91cf\\u7edf\\u8ba1\",\"zh-tw\":\"\\u7522\\u54c1\\u767c\\u4f48\\u6578\\u91cf\\u7d71\\u8a08\",\"en\":\"The number for product release\"}',    ',product',     'select t2.name, 1 as releases from TABLE_RELEASE as t1 left join TABLE_PRODUCT as t2 on t1.product=t2.id where t1.deleted=\'0\' and t2.deleted=\'0\'', '',     '',     '{\"group1\":\"name\",\"group2\":\"\",\"reportField\":[\"releases\"],\"reportType\":[\"sum\"],\"sumAppend\":[\"releases\"],\"contrast\":[\"\"]}',       2,      '{\"zh-cn\":\"\\u6309\\u7167\\u4ea7\\u54c1\\u5217\\u51fa\\u53d1\\u5e03\\u7684\\u6570\\u91cf\\u3002\",\"zh-tw\":\"\",\"en\":\"\"}',      'admin',        '2015-07-21 16:00:52'),
('task-status',          '{\"zh-cn\":\"\\u4efb\\u52a1\\u72b6\\u6001\\u7edf\\u8ba1\\u62a5\\u8868\",\"zh-tw\":\"\\u4efb\\u52d9\\u72c0\\u614b\\u7d71\\u8a08\\u5831\\u8868\",\"en\":\"The report for task status\"}',        ',project',     'select t1.id,t1.name,t2.status,t2.project,t2.id as taskID, if($status=\'\',\'\', t1.status) as projectstatus from TABLE_PROJECT as t1 left join TABLE_TASK as t2 on t1.id=t2.project where t1.deleted=\'0\' and t2.deleted=\'0\' and t1.begin>=$beginDate and end<=$endDate having projectstatus=$status',     '{\"varName\":[\"status\",\"beginDate\",\"endDate\"],\"showName\":[\"\\u9879\\u76ee\\u72b6\\u6001\",\"\\u9879\\u76ee\\u8d77\\u59cb\\u65f6\\u95f4\",\"\\u9879\\u76ee\\u7ed3\\u675f\\u65f6\\u95f4\"],\"requestType\":[\"select\",\"date\",\"date\"],\"selectList\":[\"project.status\",\"user\",\"user\"],\"default\":[\"\",\"$MONTHBEGIN\",\"$MONTHEND\"]}',     '',     '{\"group1\":\"name\",\"group2\":\"\",\"reportField\":[\"status\"],\"reportType\":[\"count\"],\"sumAppend\":[\"\"],\"reportTotal\":[\"1\"]}',   2,      '{\"zh-cn\":\"\\u6bcf\\u4e2a\\u9879\\u76ee\\u7684\\u4efb\\u52a1\\u603b\\u6570\\uff0c\\u6309\\u7167\\u72b6\\u6001\\u7684\\u5206\\u5e03\\u3002\",\"zh-tw\":\"\",\"en\":\"\"}',    'admin',        '2015-07-22 11:28:33'),
('task-type',            '{\"zh-cn\":\"\\u4efb\\u52a1\\u7c7b\\u578b\\u7edf\\u8ba1\\u62a5\\u8868\",\"zh-tw\":\"\\u4efb\\u52d9\\u985e\\u578b\\u7d71\\u8a08\\u5831\\u8868\",\"en\":\"The report for task type\"}',  ',project',     'select t1.id,t1.name,t2.type,t2.project,t2.id as taskID, if($status=\'\',\'\', t1.status) as projectstatus from TABLE_PROJECT as t1 left join TABLE_TASK as t2 on t1.id=t2.project where t1.deleted=\'0\' and t2.deleted=\'0\' and t1.begin>=$beginDate and end<=$endDate having projectstatus=$status',       '{\"varName\":[\"status\",\"beginDate\",\"endDate\"],\"showName\":[\"\\u9879\\u76ee\\u72b6\\u6001\",\"\\u9879\\u76ee\\u8d77\\u59cb\\u65f6\\u95f4\",\"\\u9879\\u76ee\\u7ed3\\u675f\\u65f6\\u95f4\"],\"requestType\":[\"select\",\"date\",\"date\"],\"selectList\":[\"project.status\",\"user\",\"user\"],\"default\":[\"\",\"$MONTHBEGIN\",\"$MONTHEND\"]}',     '',     '{\"group1\":\"name\",\"group2\":\"\",\"reportField\":[\"type\"],\"reportType\":[\"count\"],\"sumAppend\":[\"\"],\"reportTotal\":[\"1\"]}',     2,      '{\"zh-cn\":\"\\u6bcf\\u4e2a\\u9879\\u76ee\\u7684\\u4efb\\u52a1\\u603b\\u6570\\uff0c\\u6309\\u7167\\u7c7b\\u578b\\u7684\\u5206\\u5e03\\u3002\",\"zh-tw\":\"\",\"en\":\"\"}',    'admin',        '2015-07-22 13:06:46'),
('task-assign',          '{\"zh-cn\":\"\\u4efb\\u52a1\\u6307\\u6d3e\\u8868\",\"zh-tw\":\"\\u4efb\\u52d9\\u6307\\u6d3e\\u8868\",\"en\":\"The report for task assign\"}',  ',project',     'select t1.id,t1.name,t2.assignedTo,t2.project,t2.id as taskID, if($status=\'\',\'\', t1.status) as projectstatus from TABLE_PROJECT as t1 left join TABLE_TASK as t2 on t1.id=t2.project where t1.deleted=\'0\' and t2.deleted=\'0\' and t1.begin>=$beginDate and end<=$endDate having projectstatus=$status', '{\"varName\":[\"status\",\"beginDate\",\"endDate\"],\"showName\":[\"\\u9879\\u76ee\\u72b6\\u6001\",\"\\u9879\\u76ee\\u8d77\\u59cb\\u65f6\\u95f4\",\"\\u9879\\u76ee\\u7ed3\\u675f\\u65f6\\u95f4\"],\"requestType\":[\"select\",\"date\",\"date\"],\"selectList\":[\"project.status\",\"user\",\"user\"],\"default\":[\"\",\"$MONTHBEGIN\",\"$MONTHEND\"]}',     '',     '{\"group1\":\"name\",\"group2\":\"\",\"reportField\":[\"assignedTo\"],\"isUser\":{\"reportField\":[[\"1\"]]},\"reportType\":[\"count\"],\"sumAppend\":[\"\"],\"reportTotal\":[\"1\"]}',        2,      '{\"zh-cn\":\"\\u6bcf\\u4e2a\\u9879\\u76ee\\u7684\\u4efb\\u52a1\\u603b\\u6570\\uff0c\\u6309\\u7167\\u6307\\u6d3e\\u7ed9\\u7684\\u5206\\u5e03\\u3002\",\"zh-tw\":\"\",\"en\":\"\"}',     'admin',        '2015-07-22 13:13:28'),
('task-finish',          '{\"zh-cn\":\"\\u4efb\\u52a1\\u5b8c\\u6210\\u8868\",\"zh-tw\":\"\\u4efb\\u52d9\\u5b8c\\u6210\\u8868\",\"en\":\"The report for task finished\"}',        ',project',     'select t1.id,t1.name,t2.finishedBy,t2.project,t2.id as taskID, if($status=\'\',\'\', t1.status) as projectstatus from TABLE_PROJECT as t1 left join TABLE_TASK as t2 on t1.id=t2.project where t1.deleted=\'0\' and t2.deleted=\'0\' and t2.finishedBy!=\'\' and t1.begin>=$beginDate and end<=$endDate having projectstatus=$status', '{\"varName\":[\"status\",\"beginDate\",\"endDate\"],\"showName\":[\"\\u9879\\u76ee\\u72b6\\u6001\",\"\\u9879\\u76ee\\u8d77\\u59cb\\u65f6\\u95f4\",\"\\u9879\\u76ee\\u7ed3\\u675f\\u65f6\\u95f4\"],\"requestType\":[\"select\",\"date\",\"date\"],\"selectList\":[\"project.status\",\"user\",\"user\"],\"default\":[\"\",\"$MONTHBEGIN\",\"$MONTHEND\"]}',     '',     '{\"group1\":\"name\",\"group2\":\"\",\"reportField\":[\"finishedBy\"],\"isUser\":{\"reportField\":[[\"1\"]]},\"reportType\":[\"count\"],\"sumAppend\":[\"\"],\"reportTotal\":[\"1\"]}',        2,      '{\"zh-cn\":\"\\u6bcf\\u4e2a\\u9879\\u76ee\\u7684\\u4efb\\u52a1\\u5b8c\\u6210\\u603b\\u6570\\uff0c\\u6309\\u7167\\u5b8c\\u6210\\u8005\\u7684\\u5206\\u5e03\\u3002\",\"zh-tw\":\"\",\"en\":\"\"}',       'admin',        '2015-07-22 13:16:21'),
('project-invest',       '{\"zh-cn\":\"\\u9879\\u76ee\\u6295\\u5165\\u7edf\\u8ba1\\u8868\",\"zh-tw\":\"\\u9805\\u76ee\\u6295\\u5165\\u7d71\\u8a08\\u8868\",\"en\":\"Project invest\"}',  ',project',     'select t1.id,t1.name,CONCAT(t1.begin,\' ~ \',t1.end) as timeLimit,t2.teams,t3.stories,round(t4.consumed,1) as consumed,t4.number,if($status=\'\',\'\',t1.status) as projectstatus from zt_project as t1 left join ztv_projectteams as t2 on t1.id=t2.project left join ztv_projectstories as t3 on t1.id=t3.project left join ztv_projectsummary as t4 on t1.id=t4.project where t1.deleted=\'0\' and begin>=$beginDate and end<=$endDate having projectstatus=$status',       '{\"varName\":[\"status\",\"beginDate\",\"endDate\"],\"showName\":[\"\\u9879\\u76ee\\u72b6\\u6001\",\"\\u9879\\u76ee\\u8d77\\u59cb\\u65f6\\u95f4\",\"\\u9879\\u76ee\\u7ed3\\u675f\\u65f6\\u95f4\"],\"requestType\":[\"select\",\"date\",\"date\"],\"selectList\":[\"project.status\",\"user\",\"user\"],\"default\":[\"\",\"$MONTHBEGIN\",\"$MONTHEND\"]}',     '{\"timeLimit\":{\"zh-cn\":\"\\u5de5\\u671f\",\"zh-tw\":\"\\u5de5\\u671f\",\"en\":\"Time limit\"},\"teams\":{\"zh-cn\":\"\\u4eba\\u6570\",\"zh-tw\":\"\\u4eba\\u6570\",\"en\":\"Number\"},\"stories\":{\"zh-cn\":\"\\u9700\\u6c42\\u6570\",\"zh-tw\":\"\\u9700\\u6c42\\u6570\",\"en\":\"Stories\"},\"consumed\":{\"zh-cn\":\"\\u603b\\u6d88\\u8017\",\"zh-tw\":\"\\u603b\\u6d88\\u8017\",\"en\":\"Consumed\"},\"number\":{\"zh-cn\":\"\\u4efb\\u52a1\\u6570\",\"zh-tw\":\"\\u4efb\\u52a1\\u6570\",\"en\":\"Tasks\"}}',  '{\"group1\":\"name\",\"group2\":\"timeLimit\",\"reportField\":[\"number\",\"stories\",\"teams\",\"consumed\"],\"reportType\":[\"sum\",\"sum\",\"sum\",\"sum\"],\"sumAppend\":[\"number\",\"stories\",\"teams\",\"consumed\"]}',        2,      '{\"zh-cn\":\"\\u6309\\u7167\\u9879\\u76ee\\u5217\\u51fa\\uff1a\\u4efb\\u52a1\\u6570\\uff0c\\u9700\\u6c42\\u6570\\uff0c\\u4eba\\u6570\\uff0c\\u5de5\\u671f\\uff0c\\u603b\\u6d88\\u8017\\u5de5\\u65f6\\u3002\",\"zh-tw\":\"\",\"en\":\"\"}',     'admin',        '2015-07-22 16:37:38'),
('projectstory-status',  '{\"zh-cn\":\"\\u9879\\u76ee\\u9700\\u6c42\\u72b6\\u6001\\u5206\\u5e03\\u8868\",\"zh-tw\":\"\\u9805\\u76ee\\u9700\\u6c42\\u72c0\\u614b\\u5206\\u4f48\\u8868\",\"en\":\"The status of project story\"}', ',project',     'select t2.id,t2.name,t3.status from TABLE_PROJECTSTORY as t1 left join TABLE_PROJECT as t2 on t1.project=t2.id left join TABLE_STORY as t3 on t1.story=t3.id where t2.deleted=\'0\' and t2.status!=\'done\'',  '',     '',     '{\"group1\":\"name\",\"group2\":\"\",\"reportField\":[\"status\"],\"reportType\":[\"count\"],\"sumAppend\":[\"\"],\"reportTotal\":[\"1\"]}',   2,      '{\"zh-cn\":\"\\u6309\\u7167\\u9879\\u76ee\\u7edf\\u8ba1\\u9700\\u6c42\\u7684\\u72b6\\u6001\\u5206\\u5e03\\u8868\\u3002\",\"zh-tw\":\"\",\"en\":\"\"}', 'admin',        '2015-07-23 15:35:08'),
('projectstory-stage',   '{\"zh-cn\":\"\\u9879\\u76ee\\u9700\\u6c42\\u9636\\u6bb5\\u5206\\u5e03\\u8868\",\"zh-tw\":\"\\u9805\\u76ee\\u9700\\u6c42\\u968e\\u6bb5\\u5206\\u4f48\\u8868\",\"en\":\"The stage of project story\"}',  ',project',     'select t2.id,t2.name,t3.stage from TABLE_PROJECTSTORY as t1 left join TABLE_PROJECT as t2 on t1.project=t2.id left join TABLE_STORY as t3 on t1.story=t3.id where t2.deleted=\'0\' and t2.status!=\'done\'',   '',     '',     '{\"group1\":\"name\",\"group2\":\"\",\"reportField\":[\"stage\"],\"reportType\":[\"count\"],\"sumAppend\":[\"\"],\"reportTotal\":[\"1\"]}',    2,      '{\"zh-cn\":\"\\u5b9e\\u73b0\\u9879\\u76ee\\u9700\\u6c42\\u9636\\u6bb5\\u5206\\u5e03\\u8868\",\"zh-tw\":\"\",\"en\":\"\"}',     'admin',        '2015-07-23 15:38:18'),
('projectbug-status',    '{\"zh-cn\":\"\\u9879\\u76eeBug\\u72b6\\u6001\\u5206\\u5e03\\u8868\",\"zh-tw\":\"\\u9805\\u76eeBug\\u72c0\\u614b\\u5206\\u4f48\\u8868\",\"en\":\"The status of project bug\"}', ',project,test',        'select t1.id,t1.name,t1.id as bugID,t2.status from TABLE_PROJECT as t1 left join TABLE_BUG as t2 on t1.id=t2.project where t1.deleted=\'0\' and t2.deleted=\'0\' having bugID!=\'\'',  '',     '',     '{\"group1\":\"name\",\"group2\":\"\",\"reportField\":[\"status\"],\"reportType\":[\"count\"],\"sumAppend\":[\"\"],\"reportTotal\":[\"1\"],\"contrast\":[\"\"]}',       2,      '{\"zh-cn\":\"\\u6309\\u7167\\u9879\\u76ee\\u7edf\\u8ba1bug\\u7684\\u72b6\\u6001\\u5206\\u5e03\\u8868\",\"zh-tw\":\"\",\"en\":\"\"}',   'admin',        '2015-07-23 15:48:03'),
('projectbug-resolution','{\"zh-cn\":\"\\u9879\\u76eeBug\\u89e3\\u51b3\\u65b9\\u6848\\u5206\\u5e03\\u8868\",\"zh-tw\":\"\\u9805\\u76eeBug\\u89e3\\u6c7a\\u65b9\\u5206\\u4f48\\u8868\",\"en\":\"The resolution of project bug\"}',        ',project,test',        'select t1.id,t1.name,t1.id as bugID,t2.resolution from TABLE_PROJECT as t1 left join TABLE_BUG as t2 on t1.id=t2.project where t1.deleted=\'0\' and t2.deleted=\'0\' and t2.resolution!=\'\' having bugID!=\'\'',      '',     '',     '{\"group1\":\"name\",\"group2\":\"\",\"reportField\":[\"resolution\"],\"reportType\":[\"count\"],\"sumAppend\":[\"\"],\"reportTotal\":[\"1\"]}',       2,      '{\"zh-cn\":\"\\u6309\\u7167\\u7edf\\u8ba1bug\\u7684\\u89e3\\u51b3\\u65b9\\u6848\\u5206\\u5e03\",\"zh-tw\":\"\",\"en\":\"\"}',  'admin',        '2015-07-23 16:04:46'),
('projectbug-opened',    '{\"zh-cn\":\"\\u9879\\u76eeBug\\u521b\\u5efa\\u8005\\u5206\\u5e03\\u8868\",\"zh-tw\":\"\\u9805\\u76eeBug\\u5275\\u5efa\\u8005\\u5206\\u4f48\\u8868\",\"en\":\"The create of project bug\"}',   ',project,test',        'select t1.id,t1.name,t1.id as bugID,t2.openedBy from TABLE_PROJECT as t1 left join TABLE_BUG as t2 on t1.id=t2.project where t1.deleted=\'0\' and t2.deleted=\'0\' having bugID!=\'\'',        '',     '',     '{\"group1\":\"name\",\"group2\":\"\",\"reportField\":[\"openedBy\"],\"isUser\":{\"reportField\":[[\"1\"]]},\"reportType\":[\"count\"],\"sumAppend\":[\"\"],\"reportTotal\":[\"1\"],\"contrast\":[\"\"]}',      2,      '{\"zh-cn\":\"\\u5b9e\\u73b0\\u9879\\u76eebug\\u521b\\u5efa\\u8005\\u5206\\u5e03\\u8868\\u3002\",\"zh-tw\":\"\",\"en\":\"\"}',  'admin',        '2015-07-23 16:08:10'),
('projectbug-resolve',   '{\"zh-cn\":\"\\u9879\\u76eeBug\\u89e3\\u51b3\\u8005\\u5206\\u5e03\\u8868\",\"zh-tw\":\"\\u9805\\u76eeBug\\u89e3\\u6c7a\\u8005\\u5206\\u4f48\\u8868\",\"en\":\"The resolve of project bug\"}',  ',project,test',        'select t1.id,t1.name,t1.id as bugID,t2.resolvedBy from TABLE_PROJECT as t1 left join TABLE_BUG as t2 on t1.id=t2.project where t1.deleted=\'0\' and t2.deleted=\'0\' and t2.status!=\'active\' and t2.resolvedBy!=\'\' having bugID!=\'\'',    '',     '',     '{\"group1\":\"name\",\"group2\":\"\",\"reportField\":[\"resolvedBy\"],\"isUser\":{\"reportField\":[[\"1\"]]},\"reportType\":[\"count\"],\"sumAppend\":[\"\"],\"reportTotal\":[\"1\"]}',        2,      '{\"zh-cn\":\"\\u5b9e\\u73b0\\u9879\\u76eebug\\u89e3\\u51b3\\u8005\\u5206\\u5e03\\u8868\",\"zh-tw\":\"\",\"en\":\"\"}', 'admin',        '2015-07-23 16:13:16'),
('projectbug-assign',    '{\"zh-cn\":\"\\u9879\\u76eeBug\\u6307\\u6d3e\\u7ed9\\u5206\\u5e03\\u8868\",\"zh-tw\":\"\\u9805\\u76eeBug\\u6307\\u6d3e\\u5206\\u4f48\\u8868\",\"en\":\"The report for assign of project bug\"}',       ',project,test',        'select t1.id,t1.name,t1.id as bugID,t2.assignedTo from TABLE_PROJECT as t1 left join TABLE_BUG as t2 on t1.id=t2.project where t1.deleted=\'0\' and t2.deleted=\'0\' having bugID!=\'\'',      '',     '',     '{\"group1\":\"name\",\"group2\":\"\",\"reportField\":[\"assignedTo\"],\"isUser\":{\"reportField\":[[\"1\"]]},\"reportType\":[\"count\"],\"sumAppend\":[\"\"],\"reportTotal\":[\"1\"],\"contrast\":[\"\"]}',    2,      '{\"zh-cn\":\"\\u5b9e\\u73b0\\u9879\\u76eebug\\u6307\\u6d3e\\u7ed9\\u5206\\u5e03\\u8868\",\"zh-tw\":\"\",\"en\":\"\"}', 'admin',        '2015-07-23 16:29:10'),
('project-quality',      '{\"zh-cn\":\"\\u9879\\u76ee\\u8d28\\u91cf\\u62a5\\u8868\",\"zh-tw\":\"\\u9805\\u76ee\\u8cea\\u91cf\\u5831\\u8868\",\"en\":\"Project quality\"}',       ',project',     'select t1.id,t1.name,t2.stories,(t2.stories-t2.undone) as doneStory,t3.number,(t3.number-t3.undone) as doneTask,t4.bugs,t4.resolutions, round(t4.bugs/(t2.stories-t2.undone),2) as bugthanstory,round(t4.bugs/(t3.number-t3.undone),2) as bugthantask,t4.seriousBugs from TABLE_PROJECT as t1 left join ztv_projectstories as t2 on t1.id=t2.project left join ztv_projectsummary as t3 on t1.id=t3.project left join ztv_projectbugs as t4 on t1.id=t4.project where t1.deleted=\'0\'',       '',     '{\"stories\":{\"zh-cn\":\"\\u9700\\u6c42\\u603b\\u6570\",\"zh-tw\":\"\\u9700\\u6c42\\u603b\\u6570\",\"en\":\"Stories\"},\"doneStory\":{\"zh-cn\":\"\\u5b8c\\u6210\\u9700\\u6c42\\u6570\",\"zh-tw\":\"\\u5b8c\\u6210\\u9700\\u6c42\\u6570\",\"en\":\"Done story\"},\"number\":{\"zh-cn\":\"\\u4efb\\u52a1\\u603b\\u6570\",\"zh-tw\":\"\\u4efb\\u52a1\\u603b\\u6570\",\"en\":\"Tasks\"},\"doneTask\":{\"zh-cn\":\"\\u5b8c\\u6210\\u4efb\\u52a1\\u6570\",\"zh-tw\":\"\\u5b8c\\u6210\\u4efb\\u52a1\\u6570\",\"en\":\"Done task\"},\"bugs\":{\"zh-cn\":\"Bug\\u6570\",\"zh-tw\":\"Bug\\u6570\",\"en\":\"Bugs\"},\"resolutions\":{\"zh-cn\":\"\\u89e3\\u51b3Bug\\u6570\",\"zh-tw\":\"\\u89e3\\u51b3Bug\\u6570\",\"en\":\"Resolutions\"},\"bugthanstory\":{\"zh-cn\":\"Bug\\/\\u5b8c\\u6210\\u9700\\u6c42\",\"zh-tw\":\"Bug\\/\\u5b8c\\u6210\\u9700\\u6c42\",\"en\":\"Bug\\/Done story\"},\"bugthantask\":{\"zh-cn\":\"Bug\\/\\u5b8c\\u6210\\u4efb\\u52a1\",\"zh-tw\":\"Bug\\/\\u5b8c\\u6210\\u4efb\\u52a1\",\"en\":\"Bug\\/Done task\"},\"seriousBugs\":{\"zh-cn\":\"\\u91cd\\u8981Bug\\u6570\",\"zh-tw\":\"\\u91cd\\u8981Bug\\u6570\",\"en\":\"Serious Bugs\"},\"seriousBugsPercent\":{\"zh-cn\":\"\\u4e25\\u91cdBug\\u6bd4\\u7387\",\"zh-tw\":\"\\u4e25\\u91cdBug\\u6bd4\\u7387\",\"en\":\"Severe bug ratio\"}}',  '{\"group1\":\"name\",\"group2\":\"\",\"reportField\":[\"stories\",\"doneStory\",\"number\",\"doneTask\",\"bugs\",\"resolutions\",\"bugthanstory\",\"bugthantask\",\"seriousBugs\"],\"reportType\":[\"sum\",\"sum\",\"sum\",\"sum\",\"sum\",\"sum\",\"sum\",\"sum\",\"sum\"],\"sumAppend\":[\"stories\",\"doneStory\",\"number\",\"doneTask\",\"bugs\",\"resolutions\",\"bugthanstory\",\"bugthantask\",\"seriousBugs\"],\"percent\":{\"8\":\"1\"},\"contrast\":{\"8\":\"bugs\"},\"showAlone\":{\"8\":\"1\"}}', 2,      '{\"zh-cn\":\"\\u5217\\u51fa\\u9879\\u76ee\\u7684\\u9700\\u6c42\\u603b\\u6570\\uff0c\\u5b8c\\u6210\\u9700\\u6c42\\u6570\\uff0c\\u4efb\\u52a1\\u603b\\u6570\\uff0c\\u5b8c\\u6210\\u7684\\u4efb\\u52a1\\u6570\\uff0cbug\\u6570\\uff0c\\u89e3\\u51b3\\u7684bug\\u6570\\uff0cbug\\/\\u9700\\u6c42 bug\\/\\u4efb\\u52a1 \\u91cd\\u8981bug\\u6570\\u91cf(\\u4e25\\u91cd\\u7a0b\\u5ea6\",\"zh-tw\":\"\",\"en\":\"\"}', 'admin',        '2015-07-23 17:03:10'),
('product-quality',      '{\"zh-cn\":\"\\u4ea7\\u54c1\\u8d28\\u91cf\\u62a5\\u8868\",\"zh-tw\":\"\\u7522\\u54c1\\u8cea\\u91cf\\u5831\\u8868\",\"en\":\"Product quality\"}',       ',product',     'select t1.id,t1.name,t2.stories,(t2.stories-t2.undone) as doneStory,t3.bugs,t3.resolutions,round(t3.bugs/(t2.stories-t2.undone),2) as bugthanstory,t3.seriousBugs from TABLE_PRODUCT as t1 left join ztv_productstories as t2 on t1.id=t2.product left join ztv_productbugs as t3 on t1.id=t3.product where t1.deleted=\'0\'', '',     '{\"stories\":{\"zh-cn\":\"\\u9700\\u6c42\\u603b\\u6570\",\"zh-tw\":\"\\u9700\\u6c42\\u603b\\u6570\",\"en\":\"Stories\"},\"doneStory\":{\"zh-cn\":\"\\u5b8c\\u6210\\u9700\\u6c42\\u6570\",\"zh-tw\":\"\\u5b8c\\u6210\\u9700\\u6c42\\u6570\",\"en\":\"Done story\"},\"bugs\":{\"zh-cn\":\"Bug\\u6570\",\"zh-tw\":\"Bug\\u6570\",\"en\":\"Bugs\"},\"resolutions\":{\"zh-cn\":\"\\u89e3\\u51b3Bug\\u6570\",\"zh-tw\":\"\\u89e3\\u51b3Bug\\u6570\",\"en\":\"Resolutions\"},\"bugthanstory\":{\"zh-cn\":\"Bug\\/\\u5b8c\\u6210\\u9700\\u6c42\",\"zh-tw\":\"Bug\\/\\u5b8c\\u6210\\u9700\\u6c42\",\"en\":\"Bug\\/Done story\"},\"seriousBugs\":{\"zh-cn\":\"\\u91cd\\u8981Bug\\u6570\",\"zh-tw\":\"\\u91cd\\u8981Bug\\u6570\",\"en\":\"Serious Bugs\"},\"seriousBugsPercent\":{\"zh-cn\":\"\\u4e25\\u91cdbug\\u6bd4\\u7387\",\"zh-tw\":\"\\u4e25\\u91cdbug\\u6bd4\\u7387\",\"en\":\"Serious Bugs Percent\"}}', '{\"group1\":\"name\",\"group2\":\"\",\"reportField\":[\"stories\",\"doneStory\",\"bugs\",\"resolutions\",\"bugthanstory\",\"seriousBugs\"],\"reportType\":[\"sum\",\"sum\",\"sum\",\"sum\",\"sum\",\"sum\"],\"sumAppend\":[\"stories\",\"doneStory\",\"bugs\",\"resolutions\",\"bugthanstory\",\"seriousBugs\"],\"percent\":{\"5\":\"1\"},\"contrast\":{\"5\":\"bugs\"},\"showAlone\":{\"5\":\"1\"}}', 2,      '{\"zh-cn\":\"\\u5217\\u51fa\\u4ea7\\u54c1\\u7684\\u9700\\u6c42\\u6570\\uff0c\\u5b8c\\u6210\\u7684\\u9700\\u6c42\\u603b\\u6570\\uff0cbug\\u6570\\uff0c\\u89e3\\u51b3\\u7684bug\\u603b\\u6570\\uff0cbug\\/\\u9700\\u6c42 \\u91cd\\u8981bug\\u6570\\u91cf(\\u4e25\\u91cd\\u7a0b\\u5ea6\",\"zh-tw\":\"\",\"en\":\"\"}',    'admin',        '2015-07-23 17:17:40'),
('productbug-type',      '{\"zh-cn\":\"\\u4ea7\\u54c1Bug\\u7c7b\\u578b\\u7edf\\u8ba1\\u62a5\\u8868\",\"zh-tw\":\"\\u7522\\u54c1Bug\\u985e\\u578b\\u7d71\\u8a08\\u5831\\u8868\",\"en\":\"The report for type of product bug\"}',  ',product,test',        'select t1.id,t1.name,t2.id as bugID,t2.type from TABLE_PRODUCT as t1 left join TABLE_BUG as t2 on t1.id=t2.product where t1.deleted=\'0\' and t2.deleted=\'0\'',       '',     '{\"count\":{\"zh-cn\":\"\\u9700\\u6c42\\u6570\",\"zh-tw\":\"\\u9700\\u6c42\\u6570\",\"en\":\"Stories\"},\"done\":{\"zh-cn\":\"\\u5b8c\\u6210\\u6570\",\"zh-tw\":\"\\u5b8c\\u6210\\u6570\",\"en\":\"Done\"}}',  '{\"group1\":\"name\",\"group2\":\"\",\"reportField\":[\"type\"],\"reportType\":[\"count\"],\"sumAppend\":[\"\"],\"reportTotal\":[\"1\"],\"contrast\":[\"\"]}', 2,      '{\"zh-cn\":\"\\u5b9e\\u73b0\\u4ea7\\u54c1bug\\u7c7b\\u578b\\u7edf\\u8ba1\\u62a5\\u8868\\uff0c\\u6309\\u7167\\u4ea7\\u54c1\\u7edf\\u8ba1bug\\u7684\\u7c7b\\u578b\\u5206\\u5e03\\u3002\",\"zh-tw\":\"\",\"en\":\"\"}',   'admin',        '2015-07-24 13:48:22'),
('productbug-resolve',   '{\"zh-cn\":\"\\u4ea7\\u54c1Bug\\u89e3\\u51b3\\u65b9\\u6848\\u7edf\\u8ba1\",\"zh-tw\":\"\\u7522\\u54c1Bug\\u89e3\\u6c7a\\u65b9\\u6848\\u7d71\\u8a08\",\"en\":\"The report for resolve of product bug\"}',       ',product,test',        'select t1.id,t1.name,t2.id as bugID,t2.resolution from TABLE_PRODUCT as t1 left join TABLE_BUG as t2 on t1.id=t2.product where t1.deleted=\'0\' and t2.deleted=\'0\' and t2.resolution!=\'\'', '',     '{\"count\":{\"zh-cn\":\"\\u9700\\u6c42\\u6570\",\"zh-tw\":\"\\u9700\\u6c42\\u6570\",\"en\":\"Stories\"},\"done\":{\"zh-cn\":\"\\u5b8c\\u6210\\u6570\",\"zh-tw\":\"\\u5b8c\\u6210\\u6570\",\"en\":\"Done\"}}',  '{\"group1\":\"name\",\"group2\":\"\",\"reportField\":[\"resolution\"],\"reportType\":[\"count\"],\"sumAppend\":[\"\"],\"reportTotal\":[\"1\"],\"contrast\":[\"\"]}',   2,      '{\"zh-cn\":\"\\u6309\\u7167\\u4ea7\\u54c1\\u7edf\\u8ba1bug\\u7684\\u89e3\\u51b3\\u65b9\\u6848\\u5206\\u5e03\\u3002\",\"zh-tw\":\"\",\"en\":\"\"}',     'admin',        '2015-07-24 13:55:46'),
('user-login',           '{\"zh-cn\":\"\\u5458\\u5de5\\u767b\\u5f55\\u6b21\\u6570\\u7edf\\u8ba1\\u62a5\\u8868\",\"zh-tw\":\"\\u54e1\\u5de5\\u767b\\u9304\\u6b21\\u6578\\u7d71\\u8a08\\u8868\",\"en\":\"The number of user login\"}',     ',staff',       'select actor,LEFT(`date`,10) as `day` from TABLE_ACTION where `action`=\'login\' and `date`>=$startDate and `date`<=$endDate order by `date` asc, actor asc',  '{\"varName\":[\"startDate\",\"endDate\"],\"showName\":[\"\\u8d77\\u59cb\\u65f6\\u95f4\",\"\\u7ed3\\u675f\\u65f6\\u95f4\"],\"requestType\":[\"date\",\"date\"],\"selectList\":[\"user\",\"user\"],\"default\":[\"$MONTHBEGIN\",\"$MONTHEND\"]}',        '{\"count\":{\"zh-cn\":\"\\u9700\\u6c42\\u6570\",\"zh-tw\":\"\\u9700\\u6c42\\u6570\",\"en\":\"Stories\"},\"done\":{\"zh-cn\":\"\\u5b8c\\u6210\\u6570\",\"zh-tw\":\"\\u5b8c\\u6210\\u6570\",\"en\":\"Done\"}}',  '{\"group1\":\"actor\",\"isUser\":{\"group1\":[\"1\"]},\"group2\":\"\",\"reportField\":[\"day\"],\"reportType\":[\"count\"],\"sumAppend\":[\"\"],\"reportTotal\":[\"1\"]}',     2,      '{\"zh-cn\":\"\\u5b9e\\u73b0\\u5458\\u5de5\\u767b\\u5f55\\u6b21\\u6570\\u7edf\\u8ba1\\u62a5\\u8868\\uff0c\\u6309\\u7167\\u5929\\u7edf\\u8ba1\\u6bcf\\u5929\\u6bcf\\u4e2a\\u4eba\\u7684\\u767b\\u5f55\\u6b21\\u6570\\uff0c\\u4ee5\\u53ca\\u603b\\u6570\\u3002\",\"zh-tw\":\"\",\"en\":\"\"}',    'admin',        '2015-07-24 14:28:11'),
('effort',               '{\"zh-cn\":\"\\u65e5\\u5fd7\\u6c47\\u603b\\u8868\",\"zh-tw\":\"\\u65e5\\u8a8c\\u5f59\\u7e3d\\u8868\",\"en\":\"Effort summary\"}',      ',staff',       'select t1.account,t1.consumed,t1.`date`,if($dept=\'0\',0,t2.dept) as dept from TABLE_EFFORT as t1 left join TABLE_USER as t2 on t1.account=t2.account where t1.`date`>=$startDate and t1.`date`<=$endDate having dept=$dept order by `date` asc',      '{\"varName\":[\"dept\",\"startDate\",\"endDate\"],\"showName\":[\"\\u90e8\\u95e8\",\"\\u8d77\\u59cb\\u65f6\\u95f4\",\"\\u7ed3\\u675f\\u65f6\\u95f4\"],\"requestType\":[\"select\",\"date\",\"date\"],\"selectList\":[\"dept\",\"user\",\"user\"],\"default\":[\"\",\"$MONTHBEGIN\",\"$MONTHEND\"]}',   '{\"date\":{\"zh-cn\":\"\\u65e5\\u671f\",\"zh-tw\":\"\\u65e5\\u671f\",\"en\":\"Date\"},\"consumed\":{\"zh-cn\":\"\\u6d88\\u8017\\u5de5\\u65f6\",\"zh-tw\":\"\\u6d88\\u8017\\u5de5\\u65f6\",\"en\":\"Customed\"}}',      '{\"group1\":\"account\",\"group2\":\"\",\"reportField\":[\"date\"],\"reportType\":[\"sum\"],\"sumAppend\":[\"consumed\"]}',    2,      '{\"zh-cn\":\"\\u67e5\\u770b\\u67d0\\u4e2a\\u65f6\\u95f4\\u6bb5\\u5185\\u7684\\u65e5\\u5fd7\\u60c5\\u51b5\\u3002\\u53ef\\u4ee5\\u6309\\u7167\\u90e8\\u95e8\\u9009\\u62e9\\u3002\",\"zh-tw\":\"\",\"en\":\"\"}', 'admin',        '2015-07-27 13:53:32'),
('company-dynamic',      '{\"zh-cn\":\"\\u516c\\u53f8\\u52a8\\u6001\\u6c47\\u603b\\u8868\",\"zh-tw\":\"\\u516c\\u53f8\\u52d5\\u614b\\u5f59\\u7e3d\\u8868\",\"en\":\"Company dynamic\"}', ',staff',       'select t1.day,t2.userlogin,t3.consumed,t4.storyopen,t5.storyclose,t6.taskopen,t7.taskfinish,t8.bugopen,t9.bugresolve,t1.actions from ztv_dayactions as t1 left join ztv_dayuserlogin as t2 on t1.day=t2.day left join ztv_dayeffort as t3 on t1.day=t3.date left join ztv_daystoryopen as t4 on t1.day=t4.day left join ztv_daystoryclose as t5 on t1.day=t5.day left join ztv_daytaskopen as t6 on t1.day=t6.day left join ztv_daytaskfinish as t7 on t1.day=t7.day left join ztv_daybugopen as t8 on t1.day=t8.day left join ztv_daybugresolve as t9 on t1.day=t9.day where t1.day>=$startDate and t1.day<=$endDate',        '{\"varName\":[\"startDate\",\"endDate\"],\"showName\":[\"\\u8d77\\u59cb\\u65f6\\u95f4\",\"\\u7ed3\\u675f\\u65f6\\u95f4\"],\"requestType\":[\"date\",\"date\"],\"selectList\":[\"user\",\"user\"],\"default\":[\"$MONTHBEGIN\",\"$MONTHEND\"]}',        '{\"day\":{\"zh-cn\":\"\\u65e5\\u671f\",\"zh-tw\":\"\\u65e5\\u671f\",\"en\":\"Date\"},\"userlogin\":{\"zh-cn\":\"\\u6bcf\\u5929\\u767b\\u5f55\\u6b21\\u6570\",\"zh-tw\":\"\\u6bcf\\u5929\\u767b\\u5f55\\u6b21\\u6570\",\"en\":\"Logins per day\"},\"consumed\":{\"zh-cn\":\"\\u6bcf\\u5929\\u65e5\\u5fd7\\u5de5\\u65f6\",\"zh-tw\":\"\\u6bcf\\u5929\\u65e5\\u5fd7\\u5de5\\u65f6\",\"en\":\"Consumed per day\"},\"storyopen\":{\"zh-cn\":\"\\u6bcf\\u5929\\u65b0\\u589e\\u9700\\u6c42\\u6570\",\"zh-tw\":\"\\u6bcf\\u5929\\u65b0\\u589e\\u9700\\u6c42\\u6570\",\"en\":\"Opened stories per day\"},\"storyclose\":{\"zh-cn\":\"\\u6bcf\\u5929\\u5173\\u95ed\\u9700\\u6c42\\u6570\",\"zh-tw\":\"\\u6bcf\\u5929\\u5173\\u95ed\\u9700\\u6c42\\u6570\",\"en\":\"Closed stories per day\"},\"taskopen\":{\"zh-cn\":\"\\u6bcf\\u5929\\u65b0\\u589e\\u4efb\\u52a1\\u6570\",\"zh-tw\":\"\\u6bcf\\u5929\\u65b0\\u589e\\u4efb\\u52a1\\u6570\",\"en\":\"Opened tasks per day\"},\"taskfinish\":{\"zh-cn\":\"\\u6bcf\\u5929\\u5b8c\\u6210\\u4efb\\u52a1\\u6570\",\"zh-tw\":\"\\u6bcf\\u5929\\u5b8c\\u6210\\u4efb\\u52a1\\u6570\",\"en\":\"Finished tasks per day\"},\"bugopen\":{\"zh-cn\":\"\\u6bcf\\u5929\\u65b0\\u589eBug\\u6570\",\"zh-tw\":\"\\u6bcf\\u5929\\u65b0\\u589eBug\\u6570\",\"en\":\"Opened bugs per day\"},\"bugresolve\":{\"zh-cn\":\"\\u6bcf\\u5929\\u89e3\\u51b3Bug\\u6570\",\"zh-tw\":\"\\u6bcf\\u5929\\u89e3\\u51b3Bug\\u6570\",\"en\":\"Resolved bug per day\"},\"actions\":{\"zh-cn\":\"\\u6bcf\\u5929\\u52a8\\u6001\\u6570\",\"zh-tw\":\"\\u6bcf\\u5929\\u52a8\\u6001\\u6570\",\"en\":\"Actions per day\"}}', '{\"group1\":\"day\",\"isUser\":{\"group1\":[\"1\"]},\"group2\":\"\",\"reportField\":[\"userlogin\",\"consumed\",\"storyopen\",\"storyclose\",\"taskopen\",\"taskfinish\",\"bugopen\",\"bugresolve\",\"actions\"],\"reportType\":[\"sum\",\"sum\",\"sum\",\"sum\",\"sum\",\"sum\",\"sum\",\"sum\",\"sum\"],\"sumAppend\":[\"userlogin\",\"consumed\",\"storyopen\",\"storyclose\",\"taskopen\",\"taskfinish\",\"bugopen\",\"bugresolve\",\"actions\"],\"contrast\":[\"\",\"\",\"\",\"\",\"\",\"\",\"\",\"\",\"\"]}',    1,      '{\"zh-cn\":\"\\u53ef\\u4ee5\\u6307\\u5b9a\\u4e00\\u4e2a\\u65f6\\u671f\\uff0c\\u5217\\u51fa\\u76f8\\u5e94\\u7684\\u6570\\u636e\\uff1a1. \\u6bcf\\u5929\\u7684\\u767b\\u5f55\\u6b21\\u6570\\u30022. \\u6bcf\\u5929\\u7684\\u65e5\\u5fd7\\u5de5\\u65f6\\u91cf\\u30023. \\u6bcf\\u5929\\u65b0\\u589e\\u7684\\u9700\\u6c42\\u6570\\u30024. \\u6bcf\\u5929\\u5173\\u95ed\\u7684\\u9700\\u6c42\\u6570\\u30025. \\u6bcf\\u5929\\u65b0\\u589e\\u7684\\u4efb\\u52a1\\u65706. \\u6bcf\\u5929\\u5b8c\\u6210\\u7684\\u4efb\\u52a1\\u6570\\u30027. \\u6bcf\\u5929\\u65b0\\u589e\\u7684bug\\u6570\\u30028. \\u6bcf\\u5929\\u89e3\\u51b3\\u7684bug\\u6570\\u30029. \\u6bcf\\u5929\\u7684\\u52a8\\u6001\\u6570\\u3002\",\"zh-tw\":\"\",\"en\":\"\"}',   'admin',        '2015-07-27 15:09:42'),
('bug-resolve',          '{\"zh-cn\":\"Bug\\u89e3\\u51b3\\u8868\",\"zh-tw\":\"Bug\\u89e3\\u6c7a\\u8868\",\"en\":\"The report of bug resolve\"}', ',test',        'select *,if($product=\'\',0,product) as customproduct from TABLE_BUG where deleted=\'0\' and resolution!=\'\' and resolvedDate>=$startDate and resolvedDate<=$endDate having customproduct=$product',  '{\"varName\":[\"product\",\"startDate\",\"endDate\"],\"showName\":[\"\\u4ea7\\u54c1\",\"\\u89e3\\u51b3\\u65e5\\u671f\\u5f00\\u59cb\",\"\\u89e3\\u51b3\\u65e5\\u671f\\u7ed3\\u675f\"],\"requestType\":[\"select\",\"date\",\"date\"],\"selectList\":[\"product\",\"user\",\"user\"],\"default\":[\"\",\"$MONTHBEGIN\",\"$MONTHEND\"]}', '{\"count\":{\"zh-cn\":\"\\u9700\\u6c42\\u6570\",\"zh-tw\":\"\\u9700\\u6c42\\u6570\",\"en\":\"Stories\"},\"done\":{\"zh-cn\":\"\\u5b8c\\u6210\\u6570\",\"zh-tw\":\"\\u5b8c\\u6210\\u6570\",\"en\":\"Done\"}}',  '{\"group1\":\"resolvedBy\",\"isUser\":{\"group1\":[\"1\"]},\"group2\":\"\",\"reportField\":[\"resolution\"],\"reportType\":[\"count\"],\"sumAppend\":[\"\"],\"reportTotal\":[\"1\"],\"percent\":[\"1\"],\"contrast\":[\"crystalTotal\"],\"showAlone\":[\"1\"]}',       2,      '{\"zh-cn\":\"\\u5217\\u51fa\\u89e3\\u51b3\\u7684bug\\u603b\\u6570\\uff0c\\u89e3\\u51b3\\u65b9\\u6848\\u7684\\u5206\\u5e03\\uff0c\\u5360\\u7684\\u6bd4\\u4f8b\\uff08\\u8be5\\u7528\\u6237\\u89e3\\u51b3\\u7684bug\\u7684\\u6570\\u91cf\\u5360\\u6240\\u6709\\u7684\\u89e3\\u51b3\\u7684bug\\u7684\\u6570\\u91cf)\",\"zh-tw\":\"\",\"en\":\"\"}',        'admin',        '2015-07-24 13:44:25'),
('project-progress',     '{\"zh-cn\":\"\\u9879\\u76ee\\u8fdb\\u5c55\\u8868\",\"zh-tw\":\"\\u9805\\u76ee\\u9032\\u5c55\\u8868\",\"en\":\"Project progress\"}',    ',project',     'select t1.id,t1.name,t2.number as tasks,round(t2.consumed,2) as consumed,round(t2.`left`,2) as `left`,t3.stories,t2.undone as undoneTask,t3.undone as undoneStory,if($status=\'\',\'\',t1.status) as projectStatus,t2.totalReal from TABLE_PROJECT as t1 left join ztv_projectsummary as t2 on t1.id=t2.project left join ztv_projectstories as t3 on t1.id=t3.project where t1.deleted=\'0\' having projectStatus=$status',   '{\"varName\":[\"status\"],\"showName\":[\"\\u9879\\u76ee\\u72b6\\u6001\"],\"requestType\":[\"select\"],\"selectList\":[\"project.status\"],\"default\":[\"\"]}',       '{\"stories\":{\"zh-cn\":\"\\u9700\\u6c42\\u6570\",\"zh-tw\":\"\\u9700\\u6c42\\u6570\",\"en\":\"Stories\"},\"tasks\":{\"zh-cn\":\"\\u4efb\\u52a1\\u6570\",\"zh-tw\":\"\\u4efb\\u52a1\\u6570\",\"en\":\"Tasks\"},\"undoneStory\":{\"zh-cn\":\"\\u5269\\u4f59\\u9700\\u6c42\\u6570\",\"zh-tw\":\"\\u5269\\u4f59\\u9700\\u6c42\\u6570\",\"en\":\"Undone stories\"},\"undoneTask\":{\"zh-cn\":\"\\u5269\\u4f59\\u4efb\\u52a1\\u6570\",\"zh-tw\":\"\\u5269\\u4f59\\u4efb\\u52a1\\u6570\",\"en\":\"Undone tasks\"},\"consumed\":{\"zh-cn\":\"\\u5df2\\u6d88\\u8017\\u5de5\\u65f6\",\"zh-tw\":\"\\u5df2\\u6d88\\u8017\\u5de5\\u65f6\",\"en\":\"Consumed\"},\"left\":{\"zh-cn\":\"\\u5269\\u4f59\\u5de5\\u65f6\",\"zh-tw\":\"\\u5269\\u4f59\\u5de5\\u65f6\",\"en\":\"Left\"},\"consumedPercent\":{\"zh-cn\":\"\\u8fdb\\u5ea6\",\"zh-tw\":\"\\u8fdb\\u5ea6\",\"en\":\"Process\"}}',      '{\"group1\":\"name\",\"group2\":\"\",\"reportField\":[\"stories\",\"undoneStory\",\"tasks\",\"undoneTask\",\"left\",\"consumed\"],\"reportType\":[\"sum\",\"sum\",\"sum\",\"sum\",\"sum\",\"sum\"],\"sumAppend\":[\"stories\",\"undoneStory\",\"tasks\",\"undoneTask\",\"left\",\"consumed\"],\"percent\":{\"5\":\"1\"},\"contrast\":{\"5\":\"totalReal\"},\"showAlone\":{\"5\":\"1\"}}',      2,      '{\"zh-cn\":\"\\u9879\\u76ee\\u7684\\u9700\\u6c42\\u6570\\uff0c\\u4efb\\u52a1\\u6570\\uff0c\\u5df2\\u6d88\\u8017\\u5de5\\u65f6\\uff0c\\u5269\\u4f59\\u5de5\\u65f6\\uff0c\\u5269\\u4f59\\u9700\\u6c42\\u6570\\uff0c\\u5269\\u4f59\\u4efb\\u52a1\\u6570\\uff0c\\u8fdb\\u5ea6\",\"zh-tw\":\"\",\"en\":\"\"}',      'admin',        '2015-07-23 14:03:06'),
('projectbug-type',      '{\"zh-cn\":\"\\u9879\\u76eeBug\\u7c7b\\u578b\\u7edf\\u8ba1\\u62a5\\u8868\",\"zh-tw\":\"\\u9805\\u76eeBug\\u985e\\u578b\\u7d71\\u8a08\\u5831\\u8868\",\"en\":\"The report for type of project bug\"}',  ',project,test',        'select t1.id,t1.name,t2.id as bugID,t2.type from TABLE_PROJECT as t1 left join TABLE_BUG as t2 on t1.id=t2.project where t1.deleted=\'0\' and t2.deleted=\'0\'',       '',     '{\"count\":{\"zh-cn\":\"\\u9700\\u6c42\\u6570\",\"zh-tw\":\"\\u9700\\u6c42\\u6570\",\"en\":\"Stories\"},\"done\":{\"zh-cn\":\"\\u5b8c\\u6210\\u6570\",\"zh-tw\":\"\\u5b8c\\u6210\\u6570\",\"en\":\"Done\"}}',  '{\"group1\":\"name\",\"group2\":\"\",\"reportField\":[\"type\"],\"reportType\":[\"count\"],\"sumAppend\":[\"\"],\"reportTotal\":[\"1\"]}',     2,      '{\"zh-cn\":\"\\u5b9e\\u73b0\\u9879\\u76ee\\u7684bug\\u7c7b\\u578b\\u7edf\\u8ba1\\u62a5\\u8868\\uff1a\\u6309\\u7167\\u9879\\u76ee\\u7edf\\u8ba1bug\\u7684\\u7c7b\\u578b\\u5206\\u5e03\",\"zh-tw\":\"\",\"en\":\"\"}',   'admin',        '2015-08-04 13:54:22');
INSERT INTO `zt_grouppriv` (`group`, `module`, `method`) VALUES
(1, 'datatable', 'custom'),
(2, 'datatable', 'custom'),
(3, 'datatable', 'custom'),
(4, 'datatable', 'custom'),
(5, 'datatable', 'custom'),
(6, 'datatable', 'custom'),
(7, 'datatable', 'custom'),
(8, 'datatable', 'custom'),
(9, 'datatable', 'custom'),
(10, 'datatable', 'custom');
CREATE TABLE IF NOT EXISTS `zt_searchindex` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `objectType` char(20) NOT NULL,
  `objectID` mediumint(9) NOT NULL,
  `title` text NOT NULL,
  `content` text NOT NULL,
  `addedDate` datetime NOT NULL,
  `editedDate` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `object` (`objectType`,`objectID`),
  KEY `addedDate` (`addedDate`),
  FULLTEXT KEY `content` (`title`,`content`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `zt_searchdict` (
  `key` smallint(5) unsigned NOT NULL,
  `value` char(3) NOT NULL,
  PRIMARY KEY (`key`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
INSERT INTO `zt_grouppriv` (`group`, `module`, `method`) VALUES
(1, 'search', 'index'),
(2, 'search', 'index'),
(3, 'search', 'index'),
(4, 'search', 'index'),
(5, 'search', 'index'),
(6, 'search', 'index'),
(7, 'search', 'index'),
(8, 'search', 'index'),
(9, 'search', 'index'),
(10, 'search', 'index'),
(1, 'search', 'buildIndex');
INSERT INTO `zt_grouppriv` (`group`, `module`, `method`) VALUES
(1, 'report', 'export'),
(4, 'report', 'export'),
(5, 'report', 'export'),
(6, 'report', 'export'),
(7, 'report', 'export'),
(8, 'report', 'export'),
(9, 'report', 'export');
