/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import org.opensourcephysics.controls.ConsoleLevel;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.controls.XMLLoader;
import org.opensourcephysics.display.OSPLayout;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.tools.LaunchClassChooser;
import org.opensourcephysics.tools.LaunchPanel;
import org.opensourcephysics.tools.LaunchRes;
import org.opensourcephysics.tools.Launcher;
import org.opensourcephysics.tools.Resource;
import org.opensourcephysics.tools.ResourceLoader;

public class LaunchNode
extends DefaultMutableTreeNode {
    static final Level DEFAULT_LOG_LEVEL = ConsoleLevel.OUT_CONSOLE;
    Object launchObj;
    String classPath;
    String launchClassName;
    Class<?> launchClass;
    String[] args = new String[]{""};
    boolean showLog = false;
    boolean clearLog = false;
    Level logLevel = DEFAULT_LOG_LEVEL;
    boolean singleVM = false;
    boolean singleVMOff = false;
    boolean hiddenWhenRoot = false;
    boolean buttonView = false;
    boolean singleton = false;
    boolean singleApp = false;
    boolean singleAppOff = false;
    boolean hiddenInLauncher = false;
    String name = "";
    String description = "";
    String tooltip = "";
    String xsetName = "";
    String author = "";
    String keywords = "";
    String level = "";
    String languages = "";
    String comment = "";
    String appletWidth = "";
    String appletHeight = "";
    ArrayList<DisplayTab> tabData = new ArrayList();
    private String fileName;
    Collection<Process> processes = new HashSet<Process>();
    Collection<Frame> frames = new HashSet<Frame>();
    Collection<Action> actions = new HashSet<Action>();
    Map<Runnable, Thread> threads = new HashMap<Runnable, Thread>();
    int launchCount = 0;
    LaunchPanel launchPanel;
    boolean selfContained;
    boolean parentSelfContained;
    boolean previewing;
    boolean saveHiddenNodes;
    boolean enabled = true;
    List<String> jars = new ArrayList<String>();
    List<String> pdf = new ArrayList<String>();
    int tabNumber = -1;
    int prevTabNumber = -1;
    URL htmlURL;
    URL prevURL;
    JScrollPane launchModelScroller;

    public LaunchNode(String string) {
        this.setUserObject(this);
        if (string != null) {
            this.name = string;
        }
    }

    public void threadRunning(boolean bl) {
        this.launchCount += bl ? 1 : -1;
        this.launchCount = Math.max(0, this.launchCount);
        if (this.launchPanel != null) {
            this.launchPanel.repaint();
        }
    }

    public void launch() {
        this.launch(null);
    }

    public void launch(LaunchPanel launchPanel) {
        Object object;
        if (!this.isLeaf()) {
            return;
        }
        this.launchPanel = launchPanel;
        OSPRuntime.launchingInSingleVM = this.isSingleVM();
        Launcher.singleAppMode = this.isSingleApp();
        Launcher.classPath = this.getClassPath();
        if (this.isShowLog() && this.isSingleVM()) {
            OSPLog.setLevel(this.getLogLevel());
            object = OSPLog.getOSPLog();
            if (this.isClearLog()) {
                ((OSPLog)object).clear();
            }
            ((OSPLog)object).setVisible(true);
        }
        this.setMinimumArgLength(1);
        object = this.args[0];
        if (this.getLaunchClass() != null) {
            if (((String)object).equals("this")) {
                Object object2 = this.getLaunchObject();
                if (object2 != null) {
                    XMLControlElement xMLControlElement = new XMLControlElement(object2);
                    this.args[0] = xMLControlElement.toXML();
                } else {
                    this.args[0] = "";
                }
            }
            if (this.args[0].equals("") && this.args.length == 1) {
                Launcher.launch(this.getLaunchClass(), null, this);
            } else {
                Launcher.launch(this.getLaunchClass(), this.args, this);
            }
        }
        this.args[0] = object;
    }

    public LaunchNode getOwner() {
        if (this.fileName != null) {
            return this;
        }
        if (this.getParent() != null) {
            return ((LaunchNode)this.getParent()).getOwner();
        }
        return null;
    }

    public LaunchNode[] getAllOwnedNodes() {
        ArrayList<LaunchNode> arrayList = new ArrayList<LaunchNode>();
        Enumeration<TreeNode> enumeration = this.breadthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            LaunchNode launchNode = (LaunchNode)enumeration.nextElement();
            if (launchNode.fileName == null || launchNode == this) continue;
            arrayList.add(launchNode);
        }
        return arrayList.toArray(new LaunchNode[0]);
    }

    public LaunchNode[] getChildOwnedNodes() {
        ArrayList<LaunchNode> arrayList = new ArrayList<LaunchNode>();
        LaunchNode[] launchNodeArray = this.getAllOwnedNodes();
        LaunchNode launchNode = this.getOwner();
        int n = 0;
        while (n < launchNodeArray.length) {
            LaunchNode launchNode2 = ((LaunchNode)launchNodeArray[n].getParent()).getOwner();
            if (launchNode2 == launchNode) {
                arrayList.add(launchNodeArray[n]);
            }
            ++n;
        }
        return arrayList.toArray(new LaunchNode[0]);
    }

    @Override
    public String toString() {
        if (this.name != null && !this.name.equals("")) {
            return this.name;
        }
        if (this.launchClassName != null) {
            return XML.getExtension(this.launchClassName);
        }
        if (!this.args[0].equals("")) {
            String string = this.args[0];
            string = XML.getName(string);
            return XML.stripExtension(string);
        }
        return "";
    }

    public String getID() {
        return String.valueOf(this.hashCode());
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public String getDescription() {
        return this.description;
    }

    public void setArgs(String[] stringArray) {
        if (stringArray != null && stringArray.length > 0 && stringArray[0] != null) {
            this.args = stringArray;
        }
    }

    public String[] getArgs() {
        return this.args;
    }

    public void setTooltip(String string) {
        this.tooltip = string;
    }

    public String getTooltip() {
        return this.tooltip;
    }

    public void setAuthor(String string) {
        this.author = string;
    }

    public String getAuthor() {
        if (!this.author.equals("")) {
            return this.author;
        }
        if (this.isRoot()) {
            return "";
        }
        LaunchNode launchNode = (LaunchNode)this.getParent();
        return launchNode.getAuthor();
    }

    public void setKeyword(String string) {
        this.keywords = string;
    }

    public String getKeywords() {
        if (!this.keywords.equals("")) {
            return this.keywords;
        }
        if (this.isRoot()) {
            return "";
        }
        LaunchNode launchNode = (LaunchNode)this.getParent();
        return launchNode.getKeywords();
    }

    public void setComment(String string) {
        this.comment = string;
    }

    public String getComment() {
        return this.comment;
    }

    public void setPreferredAppletWidth(String string) {
        this.appletWidth = string;
    }

    public String getPreferredAppletWidth() {
        return this.appletWidth;
    }

    public void setPreferredAppletHeight(String string) {
        this.appletHeight = string;
    }

    public String getPreferredAppletHeight() {
        return this.appletHeight;
    }

    public void setCourseLevel(String string) {
        this.level = string;
    }

    public String getCourseLevel() {
        if (!this.level.equals("")) {
            return this.level;
        }
        if (this.isRoot()) {
            return "";
        }
        LaunchNode launchNode = (LaunchNode)this.getParent();
        return launchNode.getCourseLevel();
    }

    public void setLanguages(String string) {
        this.languages = string;
    }

    public String getLanguages() {
        if (!this.languages.equals("")) {
            return this.languages;
        }
        if (this.isRoot()) {
            return "";
        }
        LaunchNode launchNode = (LaunchNode)this.getParent();
        return launchNode.getLanguages();
    }

    public String getClassPath() {
        String string = "";
        if (this.classPath != null) {
            string = String.valueOf(string) + this.classPath;
        }
        LaunchNode launchNode = this;
        while (!launchNode.isRoot()) {
            launchNode = (LaunchNode)launchNode.getParent();
            if (launchNode.classPath == null) continue;
            if (!string.equals("")) {
                string = String.valueOf(string) + ";";
            }
            string = String.valueOf(string) + launchNode.classPath;
        }
        if (!string.equals("")) {
            this.jars.clear();
            String string2 = string;
            int n = string.indexOf(";");
            if (n == -1) {
                n = string.indexOf(":");
            }
            if (n != -1) {
                string2 = string.substring(0, n);
                string = string.substring(n + 1);
            } else {
                string = "";
            }
            while (string2.length() > 0) {
                if (!this.jars.contains(string2)) {
                    this.jars.add(string2);
                }
                if ((n = string.indexOf(";")) == -1) {
                    n = string.indexOf(":");
                }
                if (n == -1) {
                    string2 = string.trim();
                    string = "";
                    continue;
                }
                string2 = string.substring(0, n).trim();
                string = string.substring(n + 1).trim();
            }
            Iterator<String> iterator = this.jars.iterator();
            while (iterator.hasNext()) {
                if (!string.equals("")) {
                    string = String.valueOf(string) + ";";
                }
                string = String.valueOf(string) + iterator.next();
            }
        }
        if (OSPRuntime.getLaunchJarName() != null && string.indexOf(OSPRuntime.getLaunchJarName()) == -1 && LaunchClassChooser.baseDirectoryPath == null) {
            if (!string.equals("")) {
                string = String.valueOf(string) + ";";
            }
            string = String.valueOf(string) + OSPRuntime.getLaunchJarName();
        }
        return string;
    }

    /*
     * Unable to fully structure code
     */
    public void setClassPath(String var1_1) {
        if (var1_1 != null && !var1_1.equals("")) ** GOTO lbl5
        this.classPath = null;
        return;
lbl-1000:
        // 1 sources

        {
            var1_1 = var1_1.substring(1);
lbl5:
            // 2 sources

            ** while (var1_1.startsWith((String)":") || var1_1.startsWith((String)";"))
        }
lbl6:
        // 2 sources

        while (var1_1.endsWith(":") || var1_1.endsWith(";")) {
            var1_1 = var1_1.substring(0, var1_1.length() - 1);
        }
        var2_2 = var1_1;
        var3_3 = var1_1.indexOf(";;");
        if (var3_3 == -1) {
            var3_3 = var1_1.indexOf("::");
        }
        if (var3_3 == -1) {
            var3_3 = var1_1.indexOf(":;");
        }
        if (var3_3 == -1) {
            var3_3 = var1_1.indexOf(";:");
        }
        while (var3_3 > -1) {
            var2_2 = var1_1 = String.valueOf(var1_1.substring(0, var3_3 + 1)) + var2_2.substring(var3_3 + 2);
            var3_3 = var1_1.indexOf(";;");
            if (var3_3 == -1) {
                var3_3 = var1_1.indexOf("::");
            }
            if (var3_3 == -1) {
                var3_3 = var1_1.indexOf(":;");
            }
            if (var3_3 != -1) continue;
            var3_3 = var1_1.indexOf(";:");
        }
        this.classPath = var1_1;
    }

    public String getLaunchClassName() {
        return this.launchClassName;
    }

    public boolean setLaunchClass(String string) {
        if (string == null) {
            return false;
        }
        if (this.launchClassName == string && this.launchClass != null) {
            return false;
        }
        this.launchModelScroller = null;
        this.launchClassName = string;
        this.launchClass = LaunchClassChooser.getClass(this.getClassPath(), string);
        OSPLog.finest("node " + this.getName() + ": " + LaunchRes.getString("Log.Message.SetLaunchClass") + " " + string + (this.launchClass == null ? " (not found!)" : ""));
        return this.launchClass != null;
    }

    public Class<?> getLaunchClass() {
        if (this.launchClass == null && this.launchClassName != null && !this.launchClassName.equals("")) {
            this.setLaunchClass(this.launchClassName);
        }
        return this.launchClass;
    }

    public Object getLaunchObject() {
        if (this.launchObj != null) {
            return this.launchObj;
        }
        if (this.isRoot()) {
            return null;
        }
        LaunchNode launchNode = (LaunchNode)this.getParent();
        return launchNode.getLaunchObject();
    }

    public void setLaunchObject(Object object) {
        this.launchObj = object;
    }

    public DisplayTab setDisplayTab(int n, String string, String string2, String[] stringArray) {
        if (n >= this.tabData.size()) {
            return this.addDisplayTab(string, string2, stringArray);
        }
        if (string2 == null || string2.equals("")) {
            return this.removeDisplayTab(n);
        }
        DisplayTab displayTab = this.tabData.get(n);
        displayTab.title = string;
        displayTab.setPath(string2);
        displayTab.setModelArgs(stringArray);
        OSPLog.finest("tab " + n + " changed: [\"" + string + "\", \"" + string2 + "\"]");
        return displayTab;
    }

    public DisplayTab addDisplayTab(String string, String string2, String[] stringArray) {
        if (string2 == null || string2.equals("")) {
            return null;
        }
        DisplayTab displayTab = new DisplayTab(string, string2);
        displayTab.setModelArgs(stringArray);
        this.tabData.add(displayTab);
        OSPLog.finest("tab added: [\"" + string + "\", \"" + string2 + "\"]");
        return displayTab;
    }

    public DisplayTab insertDisplayTab(int n, String string, String string2, String[] stringArray) {
        if (string2 == null || string2.equals("") || n >= this.tabData.size()) {
            return null;
        }
        DisplayTab displayTab = new DisplayTab(string, string2);
        displayTab.setModelArgs(stringArray);
        this.tabData.add(n, displayTab);
        OSPLog.finest("tab inserted: [\"" + string + "\", \"" + string2 + "\"]");
        return displayTab;
    }

    public DisplayTab removeDisplayTab(int n) {
        DisplayTab displayTab = this.getDisplayTab(n);
        if (displayTab != null) {
            this.tabData.remove(displayTab);
            OSPLog.finest("tab " + n + " removed: [\"" + displayTab.title + "\", \"" + displayTab.path + "\"]");
        }
        return displayTab;
    }

    public DisplayTab getDisplayTab(int n) {
        if (n < 0 || n >= this.tabData.size()) {
            return null;
        }
        return this.tabData.get(n);
    }

    public int getDisplayTabCount() {
        return this.tabData.size();
    }

    public List<String> getPDFPaths() {
        int n = this.getDisplayTabCount();
        this.pdf.clear();
        int n2 = 0;
        while (n2 < n) {
            String string = this.getDisplayTab(n2).getPath();
            if (string.toLowerCase().endsWith(".pdf")) {
                this.pdf.add(string);
            }
            ++n2;
        }
        return this.pdf;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getPathString() {
        TreeNode[] treeNodeArray = this.getPath();
        LaunchNode launchNode = (LaunchNode)treeNodeArray[0];
        StringBuffer stringBuffer = new StringBuffer(launchNode.name);
        int n = 1;
        while (n < treeNodeArray.length) {
            launchNode = (LaunchNode)treeNodeArray[n];
            stringBuffer.append("/" + launchNode.name);
            ++n;
        }
        return stringBuffer.toString();
    }

    public String setFileName(String string) {
        this.fileName = string == null ? null : XML.getPathRelativeTo(string, Launcher.tabSetBasePath);
        return this.fileName;
    }

    public boolean isParentSelfContained() {
        if (this.parentSelfContained) {
            return true;
        }
        if (this.isRoot()) {
            return false;
        }
        LaunchNode launchNode = (LaunchNode)this.getParent();
        return launchNode.isSelfContained();
    }

    public boolean isSelfContained() {
        return this.selfContained || this.isParentSelfContained();
    }

    public boolean isPreviewing() {
        if (this.previewing) {
            return true;
        }
        if (this.isRoot()) {
            return false;
        }
        LaunchNode launchNode = (LaunchNode)this.getParent();
        return launchNode.isPreviewing();
    }

    public boolean isSavingHiddenNodes() {
        if (this.saveHiddenNodes) {
            return true;
        }
        if (this.isRoot()) {
            return false;
        }
        LaunchNode launchNode = (LaunchNode)this.getParent();
        return launchNode.isSavingHiddenNodes();
    }

    public void setSelfContained(boolean bl) {
        this.selfContained = bl;
    }

    public boolean isSingleVM() {
        if (this.singleVM || OSPRuntime.isWebStart()) {
            return true;
        }
        if (this.isRoot()) {
            return false;
        }
        LaunchNode launchNode = (LaunchNode)this.getParent();
        return this.singleVMOff ? false : launchNode.isSingleVM();
    }

    public void setSingleVM(boolean bl) {
        this.singleVM = bl;
    }

    public boolean isShowLog() {
        if (this.showLog) {
            return true;
        }
        if (this.isRoot()) {
            return false;
        }
        LaunchNode launchNode = (LaunchNode)this.getParent();
        return launchNode.isShowLog();
    }

    public void setShowLog(boolean bl) {
        this.showLog = bl;
    }

    public boolean isClearLog() {
        if (this.clearLog) {
            return true;
        }
        if (this.isRoot()) {
            return false;
        }
        LaunchNode launchNode = (LaunchNode)this.getParent();
        return launchNode.isClearLog();
    }

    public void setClearLog(boolean bl) {
        this.clearLog = bl;
    }

    public Level getLogLevel() {
        Level level;
        if (this.isRoot()) {
            return this.logLevel;
        }
        LaunchNode launchNode = (LaunchNode)this.getParent();
        if (launchNode.isShowLog() && (level = launchNode.getLogLevel()).intValue() < this.logLevel.intValue()) {
            return level;
        }
        return this.logLevel;
    }

    public void setLogLevel(Level level) {
        if (level != null) {
            this.logLevel = level;
        }
    }

    public boolean isSingleApp() {
        if (this.singleApp) {
            return true;
        }
        if (this.isRoot()) {
            return false;
        }
        LaunchNode launchNode = (LaunchNode)this.getParent();
        return this.singleAppOff ? false : launchNode.isSingleApp();
    }

    public void setSingleApp(boolean bl) {
        this.singleApp = bl;
    }

    public void setHiddenWhenRoot(boolean bl) {
        this.hiddenWhenRoot = bl;
    }

    public boolean isButtonView() {
        if (this.buttonView) {
            return true;
        }
        if (this.isRoot()) {
            return false;
        }
        LaunchNode launchNode = (LaunchNode)this.getParent();
        return launchNode.isButtonView();
    }

    public void setButtonView(boolean bl) {
        LaunchNode launchNode = (LaunchNode)this.getRoot();
        launchNode.buttonView = bl;
    }

    public boolean isSingleton() {
        if (this.singleton) {
            return true;
        }
        if (this.isRoot()) {
            return false;
        }
        LaunchNode launchNode = (LaunchNode)this.getParent();
        return launchNode.isSingleton();
    }

    public void setSingleton(boolean bl) {
        this.singleton = bl;
    }

    public boolean isHiddenInLauncher() {
        if (this.hiddenInLauncher) {
            return true;
        }
        if (this.isRoot()) {
            return false;
        }
        LaunchNode launchNode = (LaunchNode)this.getParent();
        return launchNode.isHiddenInLauncher();
    }

    public void setHiddenInLauncher(boolean bl) {
        this.hiddenInLauncher = bl;
    }

    public Resource getResource() {
        if (this.fileName == null) {
            return null;
        }
        String string = XML.getResolvedPath(this.fileName, Launcher.tabSetBasePath);
        return ResourceLoader.getResource(string);
    }

    public boolean exists() {
        return this.getResource() != null;
    }

    public File getFile() {
        if (this.exists()) {
            return this.getResource().getFile();
        }
        return null;
    }

    public boolean matches(LaunchNode launchNode) {
        if (launchNode == null) {
            return false;
        }
        boolean bl = this.showLog == launchNode.showLog && this.clearLog == launchNode.clearLog && this.singleton == launchNode.singleton && this.singleVM == launchNode.singleVM && this.hiddenWhenRoot == launchNode.hiddenWhenRoot && this.name.equals(launchNode.name) && this.description.equals(launchNode.description) && this.args[0].equals(launchNode.args[0]) && (this.fileName == null && launchNode.fileName == null || this.fileName != null && this.fileName.equals(launchNode.fileName)) && (this.getLaunchClass() == null && launchNode.getLaunchClass() == null || this.getLaunchClass() != null && this.getLaunchClass().equals(launchNode.getLaunchClass())) && (this.classPath == null && launchNode.classPath == null || this.classPath != null && this.classPath.equals(launchNode.classPath));
        return bl;
    }

    public LaunchNode getChildNode(String string) {
        Enumeration<TreeNode> enumeration = this.breadthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            LaunchNode launchNode = (LaunchNode)enumeration.nextElement();
            if (!string.equals(launchNode.fileName)) continue;
            return launchNode;
        }
        return null;
    }

    public void addMenuItemsTo(JComponent jComponent) {
        Enumeration<TreeNode> enumeration = this.children();
        while (enumeration.hasMoreElements()) {
            JMenuItem jMenuItem;
            LaunchNode launchNode = (LaunchNode)enumeration.nextElement();
            if (launchNode.isLeaf()) {
                jMenuItem = new JMenuItem(launchNode.toString());
                jComponent.add(jMenuItem);
                jMenuItem.setToolTipText(launchNode.tooltip);
                jMenuItem.setActionCommand(launchNode.getID());
                jMenuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        String string = actionEvent.getActionCommand();
                        LaunchNode launchNode = (LaunchNode)LaunchNode.this.getRoot();
                        Enumeration<TreeNode> enumeration = launchNode.postorderEnumeration();
                        while (enumeration.hasMoreElements()) {
                            LaunchNode launchNode2 = (LaunchNode)enumeration.nextElement();
                            if (!launchNode2.getID().equals(string)) continue;
                            launchNode2.launch();
                            break;
                        }
                    }
                });
                continue;
            }
            jMenuItem = new JMenu(launchNode.toString());
            jComponent.add(jMenuItem);
            launchNode.addMenuItemsTo(jMenuItem);
        }
    }

    public void addTerminateAction(Action action) {
        this.actions.add(action);
        ++this.launchCount;
    }

    public void removeTerminateAction(Action action) {
        this.actions.remove(action);
        this.launchCount = Math.max(0, --this.launchCount);
    }

    public void terminate(Action action) {
        if (this.actions.contains(action)) {
            this.removeTerminateAction(action);
            if (this.launchPanel != null) {
                this.launchPanel.repaint();
            }
        }
    }

    public void terminateAll() {
        Object object;
        for (Process object22 : this.processes) {
            object22.destroy();
        }
        for (Frame frame : this.frames) {
            object = frame.getWindowListeners();
            int n = 0;
            while (n < ((WindowListener[])object).length) {
                if (object[n] instanceof Launcher.FrameCloser) {
                    frame.removeWindowListener(object[n]);
                }
                ++n;
            }
            frame.dispose();
        }
        for (Thread thread : this.threads.values()) {
            if (thread == null) continue;
            thread.interrupt();
        }
        HashSet<Action> hashSet = new HashSet<Action>(this.actions);
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            object = (Action)iterator.next();
            if (object == null) continue;
            object.actionPerformed(null);
        }
        this.processes.clear();
        this.frames.clear();
        this.threads.clear();
        this.actions.clear();
        this.launchCount = 0;
    }

    protected JScrollPane getLaunchModelScroller() {
        if (this.launchModelScroller == null) {
            final JComponent jComponent = Launcher.getModelPane(this.getLaunchClass(), this.getArgs());
            if (jComponent == null) {
                return null;
            }
            JPanel jPanel = new JPanel(new OSPLayout()){

                @Override
                public Dimension getPreferredSize() {
                    Dimension dimension = jComponent.getPreferredSize();
                    dimension.width += 8;
                    dimension.height += 8;
                    return dimension;
                }
            };
            jPanel.setBackground(Color.white);
            jPanel.add((Component)jComponent, "Centered");
            this.launchModelScroller = new JScrollPane(jPanel);
        }
        return this.launchModelScroller;
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    private String[][] getDisplayData() {
        if (this.tabData.isEmpty()) {
            return null;
        }
        String[][] stringArray = new String[this.tabData.size()][2];
        int n = 0;
        while (n < this.tabData.size()) {
            DisplayTab displayTab = this.tabData.get(n);
            stringArray[n] = new String[]{displayTab.title, displayTab.path};
            ++n;
        }
        return stringArray;
    }

    private void setDisplayData(String[][] stringArray) {
        if (stringArray == null) {
            return;
        }
        this.tabData.clear();
        int n = 0;
        while (n < stringArray.length) {
            DisplayTab displayTab = new DisplayTab(stringArray[n][0], stringArray[n][1]);
            this.tabData.add(displayTab);
            ++n;
        }
    }

    private String[][] getDisplayArgs() {
        if (this.tabData.isEmpty()) {
            return null;
        }
        String[][] stringArray = new String[this.tabData.size()][];
        int n = 0;
        while (n < this.tabData.size()) {
            DisplayTab displayTab = this.tabData.get(n);
            String[] stringArray2 = displayTab.getModelArgs();
            stringArray[n] = stringArray2.length == 0 ? null : stringArray2;
            ++n;
        }
        return stringArray;
    }

    private void setDisplayArgs(String[][] stringArray) {
        if (stringArray == null) {
            return;
        }
        int n = Math.min(stringArray.length, this.tabData.size());
        int n2 = 0;
        while (n2 < n) {
            DisplayTab displayTab = this.tabData.get(n2);
            displayTab.setModelArgs(stringArray[n2]);
            ++n2;
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void setMinimumArgLength(int var1_1) {
        block4: {
            if ((var1_1 = Math.max(var1_1, 1)) == this.args.length) {
                return;
            }
            if (var1_1 <= this.args.length) ** GOTO lbl19
            var2_2 = new String[var1_1];
            var3_4 = 0;
            while (var3_4 < var1_1) {
                var2_2[var3_4] = var3_4 < this.args.length ? this.args[var3_4] : "";
                ++var3_4;
            }
            this.setArgs(var2_2);
            break block4;
lbl-1000:
            // 1 sources

            {
                var2_3 = new String[this.args.length - 1];
                var3_5 = 0;
                while (var3_5 < var2_3.length) {
                    var2_3[var3_5] = this.args[var3_5];
                    ++var3_5;
                }
                this.setArgs(var2_3);
lbl19:
                // 2 sources

                ** while (this.args.length > var1_1 && this.args[this.args.length - 1].equals((Object)""))
            }
        }
    }

    protected void removeThread(Runnable runnable) {
        this.threads.remove(runnable);
    }

    public DisplayTab addHTML(String string, String string2) {
        return this.addDisplayTab(string, string2, null);
    }

    public DisplayTab insertHTML(int n, String string, String string2) {
        return this.insertDisplayTab(n, string, string2, null);
    }

    public DisplayTab removeHTML(int n) {
        return this.removeDisplayTab(n);
    }

    public DisplayTab getHTML(int n) {
        return this.getDisplayTab(n);
    }

    public int getHTMLCount() {
        return this.getDisplayTabCount();
    }

    public DisplayTab setHTML(int n, String string, String string2) {
        return this.setDisplayTab(n, string, string2, null);
    }

    public class DisplayTab {
        String title;
        boolean hyperlinksEnabled = true;
        String path;
        URL url;
        Class<?> modelClass;
        JComponent modelPane;
        JScrollPane modelScroller;
        String[] modelArgs = new String[0];

        DisplayTab(String string, String string2) {
            this.setTitle(string);
            this.setPath(string2);
        }

        public String getPath() {
            return this.path;
        }

        public void setPath(String string) {
            this.path = string;
            if (!this.setURL(string)) {
                this.setModelClass(string);
            }
        }

        public String getTitle() {
            return this.title;
        }

        public void setTitle(String string) {
            this.title = string;
        }

        public URL getURL() {
            if (this.url == null && this.modelClass == null && this.path != null && !"".equals(this.path)) {
                this.setURL(this.path);
            }
            return this.url;
        }

        public Class<?> getModelClass() {
            if (this.url == null && this.modelClass == null && this.path != null && !this.path.equals("")) {
                this.setModelClass(this.path);
            }
            return this.modelClass;
        }

        public JComponent getModelPane() {
            if (this.modelPane == null && this.getModelClass() != null) {
                if (JComponent.class.isAssignableFrom(this.modelClass)) {
                    try {
                        this.modelPane = (JComponent)this.modelClass.newInstance();
                    }
                    catch (Exception exception) {}
                } else {
                    this.modelPane = Launcher.getModelPane(this.modelClass, this.getModelArgs());
                }
            }
            return this.modelPane;
        }

        public String[] getModelArgs() {
            return this.modelArgs;
        }

        public void setModelArgs(String[] stringArray) {
            if (stringArray != null) {
                this.modelArgs = stringArray;
                this.modelPane = null;
                this.modelScroller = null;
            }
        }

        protected JScrollPane getModelScroller() {
            final JComponent jComponent = this.getModelPane();
            if (this.modelScroller == null && jComponent != null) {
                JPanel jPanel = new JPanel(new OSPLayout()){

                    @Override
                    public Dimension getPreferredSize() {
                        Dimension dimension = jComponent.getPreferredSize();
                        dimension.width += 8;
                        dimension.height += 8;
                        return dimension;
                    }
                };
                jPanel.setBackground(Color.white);
                jPanel.add((Component)jComponent, "Centered");
                this.modelScroller = new JScrollPane(jPanel);
            }
            return this.modelScroller;
        }

        /*
         * Unable to fully structure code
         */
        protected void setMinimumModelArgLength(int var1_1) {
            block4: {
                if ((var1_1 = Math.max(var1_1, 0)) == this.modelArgs.length) {
                    return;
                }
                if (var1_1 <= this.modelArgs.length) ** GOTO lbl19
                var2_2 = new String[var1_1];
                var3_4 = 0;
                while (var3_4 < var1_1) {
                    var2_2[var3_4] = var3_4 < this.modelArgs.length ? this.modelArgs[var3_4] : null;
                    ++var3_4;
                }
                this.setModelArgs(var2_2);
                break block4;
lbl-1000:
                // 1 sources

                {
                    var2_3 = new String[this.modelArgs.length - 1];
                    var3_5 = 0;
                    while (var3_5 < var2_3.length) {
                        var2_3[var3_5] = this.modelArgs[var3_5];
                        ++var3_5;
                    }
                    this.setModelArgs(var2_3);
lbl19:
                    // 2 sources

                    ** while (this.modelArgs.length > var1_1 && this.modelArgs[this.modelArgs.length - 1] == null)
                }
            }
        }

        private boolean setURL(String string) {
            this.url = null;
            Resource resource = ResourceLoader.getResource(string);
            if (resource != null && resource.getURL() != null) {
                this.url = resource.getURL();
                try {
                    InputStream inputStream = this.url.openStream();
                    inputStream.close();
                    OSPLog.finer(String.valueOf(LaunchRes.getString("Log.Message.URL")) + " " + this.url);
                }
                catch (Exception exception) {
                    this.url = null;
                }
            }
            return this.url != null;
        }

        private boolean setModelClass(String string) {
            this.path = string;
            if (string == null) {
                return false;
            }
            if (this.modelClass != null && string.equals(this.modelClass.getName())) {
                return false;
            }
            this.modelPane = null;
            this.modelScroller = null;
            this.modelClass = LaunchClassChooser.getModelClass(LaunchNode.this.getClassPath(), string);
            return this.modelClass != null;
        }
    }

    private static class Loader
    extends XMLLoader {
        private Loader() {
        }

        @Override
        public void saveObject(XMLControl xMLControl, Object object) {
            LaunchNode launchNode = (LaunchNode)object;
            launchNode.setMinimumArgLength(1);
            if (!launchNode.name.equals("")) {
                xMLControl.setValue("name", launchNode.name);
            }
            if (!launchNode.description.equals("")) {
                xMLControl.setValue("description", launchNode.description);
            }
            if (!launchNode.tooltip.equals("")) {
                xMLControl.setValue("tooltip", launchNode.tooltip);
            }
            if (!launchNode.xsetName.equals("")) {
                xMLControl.setValue("launchset", launchNode.xsetName);
            }
            xMLControl.setValue("display_tabs", launchNode.getDisplayData());
            xMLControl.setValue("display_args", launchNode.getDisplayArgs());
            if (launchNode.getLaunchClass() != null) {
                xMLControl.setValue("launch_class", launchNode.getLaunchClass().getName());
            } else if (launchNode.launchClassName != null) {
                xMLControl.setValue("launch_class", launchNode.launchClassName);
            }
            if (!launchNode.args[0].equals("") || launchNode.args.length > 1) {
                xMLControl.setValue("launch_args", launchNode.args);
            }
            if (launchNode.classPath != null && !launchNode.classPath.equals("")) {
                xMLControl.setValue("classpath", launchNode.classPath);
            }
            if (launchNode.hiddenWhenRoot) {
                xMLControl.setValue("root_hidden", true);
            }
            if (launchNode.buttonView) {
                xMLControl.setValue("button_view", true);
            }
            if (launchNode.singleton) {
                xMLControl.setValue("singleton", true);
            }
            if (launchNode.singleVM) {
                xMLControl.setValue("single_vm", true);
            }
            if (launchNode.singleVMOff) {
                xMLControl.setValue("single_vm_off", true);
            }
            if (launchNode.showLog) {
                xMLControl.setValue("show_log", true);
            }
            if (launchNode.logLevel != DEFAULT_LOG_LEVEL) {
                xMLControl.setValue("log_level", launchNode.logLevel.getName());
            }
            if (launchNode.clearLog) {
                xMLControl.setValue("clear_log", true);
            }
            if (launchNode.singleApp) {
                xMLControl.setValue("single_app", true);
            }
            if (launchNode.singleAppOff) {
                xMLControl.setValue("single_app_off", true);
            }
            if (launchNode.hiddenInLauncher) {
                xMLControl.setValue("hidden_in_launcher", true);
            }
            if (!launchNode.author.equals("")) {
                xMLControl.setValue("author", launchNode.author);
            }
            if (!launchNode.keywords.equals("")) {
                xMLControl.setValue("keywords", launchNode.keywords);
            }
            if (!launchNode.level.equals("")) {
                xMLControl.setValue("level", launchNode.level);
            }
            if (!launchNode.languages.equals("")) {
                xMLControl.setValue("languages", launchNode.languages);
            }
            if (!launchNode.comment.equals("")) {
                xMLControl.setValue("comment", launchNode.comment);
            }
            if (!launchNode.appletWidth.equals("")) {
                xMLControl.setValue("applet_width", launchNode.appletWidth);
            }
            if (!launchNode.appletHeight.equals("")) {
                xMLControl.setValue("applet_height", launchNode.appletHeight);
            }
            if (launchNode.children != null) {
                ArrayList<Object> arrayList = new ArrayList<Object>();
                Enumeration<TreeNode> enumeration = launchNode.children();
                boolean bl = launchNode.isSavingHiddenNodes();
                while (enumeration.hasMoreElements()) {
                    LaunchNode launchNode2 = (LaunchNode)enumeration.nextElement();
                    if (!bl && launchNode2.isHiddenInLauncher()) continue;
                    if (launchNode.isPreviewing()) {
                        arrayList.add(launchNode2);
                        continue;
                    }
                    if (launchNode2.fileName != null && !launchNode.isSelfContained()) {
                        arrayList.add(launchNode2.fileName);
                        continue;
                    }
                    launchNode2.fileName = null;
                    launchNode2.setSelfContained(false);
                    arrayList.add(launchNode2);
                }
                if (arrayList.size() > 0) {
                    xMLControl.setValue("child_nodes", arrayList);
                }
            }
        }

        @Override
        public Object createObject(XMLControl xMLControl) {
            String string = xMLControl.getString("name");
            if (string == null) {
                string = LaunchRes.getString("NewNode.Name");
            }
            return new LaunchNode(string);
        }

        @Override
        public Object loadObject(XMLControl xMLControl, Object object) {
            ArrayList arrayList;
            String string;
            String string2;
            String string3;
            String string4;
            String string5;
            String string6;
            String string7;
            String[] stringArray;
            String string8;
            String string9;
            String string10;
            String string11;
            LaunchNode launchNode = (LaunchNode)object;
            String string12 = xMLControl.getString("name");
            if (string12 != null) {
                launchNode.name = string12;
            }
            if ((string11 = xMLControl.getString("description")) != null) {
                launchNode.description = string11;
            }
            if ((string10 = xMLControl.getString("tooltip")) != null) {
                launchNode.tooltip = string10;
            }
            if ((string9 = xMLControl.getString("launchset")) != null) {
                launchNode.xsetName = string9;
            }
            if ((string8 = xMLControl.getString("url")) != null) {
                String[][] stringArray2 = new String[1][];
                String[] stringArray3 = new String[2];
                stringArray3[1] = string8;
                stringArray2[0] = stringArray3;
                launchNode.setDisplayData(stringArray2);
            } else {
                if (xMLControl.getPropertyNames().contains("html")) {
                    launchNode.setDisplayData((String[][])xMLControl.getObject("html"));
                } else {
                    launchNode.setDisplayData((String[][])xMLControl.getObject("display_tabs"));
                }
                launchNode.setDisplayArgs((String[][])xMLControl.getObject("display_args"));
            }
            launchNode.setClassPath(xMLControl.getString("classpath"));
            String string13 = xMLControl.getString("launch_class");
            if (string13 != null) {
                launchNode.launchClassName = string13;
                launchNode.launchModelScroller = null;
            }
            if ((stringArray = (String[])xMLControl.getObject("launch_args")) != null) {
                launchNode.setArgs(stringArray);
            }
            launchNode.hiddenWhenRoot = xMLControl.getBoolean("root_hidden");
            launchNode.buttonView = xMLControl.getBoolean("button_view");
            launchNode.singleton = xMLControl.getBoolean("singleton");
            launchNode.singleVM = xMLControl.getBoolean("single_vm");
            launchNode.singleVMOff = xMLControl.getBoolean("single_vm_off");
            launchNode.showLog = xMLControl.getBoolean("show_log");
            launchNode.clearLog = xMLControl.getBoolean("clear_log");
            launchNode.singleApp = xMLControl.getBoolean("single_app");
            launchNode.singleAppOff = xMLControl.getBoolean("single_app_off");
            launchNode.hiddenInLauncher = xMLControl.getBoolean("hidden_in_launcher");
            Level level = OSPLog.parseLevel(xMLControl.getString("log_level"));
            if (level != null) {
                launchNode.logLevel = level;
            }
            if ((string7 = xMLControl.getString("author")) != null) {
                launchNode.author = string7;
            }
            if ((string6 = xMLControl.getString("keywords")) != null) {
                launchNode.keywords = string6;
            }
            if ((string5 = xMLControl.getString("level")) != null) {
                launchNode.level = string5;
            }
            if ((string4 = xMLControl.getString("languages")) != null) {
                launchNode.languages = string4;
            }
            if ((string3 = xMLControl.getString("comment")) != null) {
                launchNode.comment = string3;
            }
            if ((string2 = xMLControl.getString("applet_width")) != null) {
                launchNode.appletWidth = string2;
            }
            if ((string = xMLControl.getString("applet_height")) != null) {
                launchNode.appletHeight = string;
            }
            if ((string12 = xMLControl.getString("filename")) != null) {
                launchNode.setFileName(string12);
            }
            if ((arrayList = (ArrayList)xMLControl.getObject("child_nodes")) != null) {
                launchNode.removeAllChildren();
                for (Object e : arrayList) {
                    Class<?> clazz;
                    LaunchNode launchNode2;
                    Object object2;
                    if (e instanceof LaunchNode) {
                        object2 = (LaunchNode)e;
                        launchNode.add((MutableTreeNode)object2);
                        ((LaunchNode)object2).setLaunchClass(((LaunchNode)object2).launchClassName);
                        continue;
                    }
                    if (!(e instanceof String)) continue;
                    object2 = (String)e;
                    String string14 = XML.getResolvedPath((String)object2, Launcher.tabSetBasePath);
                    ResourceLoader.addSearchPath(Launcher.resourcesPath);
                    ResourceLoader.addSearchPath(Launcher.tabSetBasePath);
                    XMLControlElement xMLControlElement = new XMLControlElement();
                    String string15 = xMLControlElement.read(string14);
                    if (xMLControlElement.failedToRead()) {
                        JOptionPane.showMessageDialog(null, String.valueOf(LaunchRes.getString("Dialog.InvalidXML.Message")) + " \"" + (String)object2 + "\"", LaunchRes.getString("Dialog.InvalidXML.Title"), 2);
                    }
                    if ((launchNode2 = (LaunchNode)launchNode.getRoot()).getChildNode((String)object2) != null || ((String)object2).equals(launchNode2.fileName) || !LaunchNode.class.isAssignableFrom(clazz = xMLControlElement.getObjectClass())) continue;
                    LaunchNode launchNode3 = new LaunchNode(LaunchRes.getString("NewNode.Name"));
                    launchNode3.setFileName((String)object2);
                    OSPLog.finest(String.valueOf(LaunchRes.getString("Log.Message.Loading")) + ": " + string15);
                    launchNode.add(launchNode3);
                    xMLControlElement.loadObject(launchNode3);
                }
            }
            return launchNode;
        }
    }
}

