/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.tools.Job;
import org.opensourcephysics.tools.Tool;

public class JobManager {
    Tool localTool;
    Map<Job, Collection<Tool>> replies = new HashMap<Job, Collection<Tool>>();
    Map<Job, Collection<Object>> objects = new HashMap<Job, Collection<Object>>();

    public JobManager(Tool tool) {
        this.localTool = tool;
    }

    public void log(Job job, Tool tool) {
        if (tool == null) {
            return;
        }
        Collection<Tool> collection = this.replies.get(job);
        if (collection == null) {
            collection = new HashSet<Tool>();
            this.replies.put(job, collection);
        }
        collection.add(tool);
    }

    public void associate(Job job, Object object) {
        if (object == null) {
            return;
        }
        Collection<Object> collection = this.objects.get(job);
        if (collection == null) {
            collection = new HashSet<Object>();
            this.objects.put(job, collection);
        }
        collection.add(object);
    }

    public Job[] getJobs(Object object) {
        ArrayList<Job> arrayList = new ArrayList<Job>();
        for (Job job : this.objects.keySet()) {
            Collection<Object> collection = this.objects.get(job);
            if (collection == null) {
                return null;
            }
            if (!collection.contains(object)) continue;
            arrayList.add(job);
        }
        return arrayList.toArray(new Job[0]);
    }

    public Object[] getObjects(Job job) {
        Collection<Object> collection = this.objects.get(job);
        if (collection == null) {
            return new Object[0];
        }
        return collection.toArray(new Object[0]);
    }

    public Collection<Tool> getTools(Object object) {
        HashSet<Tool> hashSet = new HashSet<Tool>();
        Job[] jobArray = this.getJobs(object);
        int n = 0;
        while (n < jobArray.length) {
            Collection<Tool> collection = this.replies.get(jobArray[n]);
            if (collection != null) {
                hashSet.addAll(collection);
            }
            ++n;
        }
        return hashSet;
    }

    public void sendReplies(Object object) {
        Job[] jobArray = this.getJobs(object);
        XMLControlElement xMLControlElement = new XMLControlElement(object);
        String string = xMLControlElement.toXML();
        int n = 0;
        while (n < jobArray.length) {
            try {
                jobArray[n].setXML(string);
            }
            catch (RemoteException remoteException) {
                remoteException.printStackTrace();
            }
            this.sendReplies(jobArray[n]);
            ++n;
        }
    }

    public void sendReplies(Job job) {
        Collection<Tool> collection = this.replies.get(job);
        if (collection == null) {
            return;
        }
        Iterator<Tool> iterator = collection.iterator();
        try {
            while (iterator.hasNext()) {
                Tool tool = iterator.next();
                tool.send(job, this.localTool);
            }
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
        }
    }
}

