/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.awt.Component;
import java.awt.Dimension;
import java.io.Serializable;
import java.util.List;
import org.opensourcephysics.tools.ParamEditor;
import org.opensourcephysics.tools.Parameter;
import org.opensourcephysics.tools.ToolsRes;

public class InitialValueEditor
extends ParamEditor {
    public InitialValueEditor(ParamEditor paramEditor) {
        this.paramEditor = paramEditor;
        this.functionPanel = paramEditor.functionPanel;
    }

    @Override
    public boolean isNameEditable(Object object) {
        return false;
    }

    @Override
    public Dimension getPreferredSize() {
        Serializable serializable;
        boolean bl = false;
        Component[] componentArray = this.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            serializable = componentArray[n2];
            if (serializable == this.buttonPanel) {
                bl = true;
            }
            ++n2;
        }
        if (bl) {
            return super.getPreferredSize();
        }
        serializable = this.table.getPreferredSize();
        ((Dimension)serializable).height += this.table.getTableHeader().getHeight();
        ((Dimension)serializable).height = (int)((double)((Dimension)serializable).height + (1.25 * (double)this.table.getRowHeight() + 14.0));
        return serializable;
    }

    @Override
    public Dimension getMaximumSize() {
        Dimension dimension = super.getMaximumSize();
        dimension.height = this.getPreferredSize().height;
        return dimension;
    }

    @Override
    public void evaluateAll() {
        Parameter parameter;
        super.evaluateAll();
        if (this.paramValues.length != this.objects.size()) {
            this.paramValues = new double[this.objects.size()];
        }
        List<Object> list = this.paramEditor.getObjects();
        int n = 0;
        while (n < this.evaluate.size()) {
            parameter = (Parameter)this.evaluate.get(n);
            parameter.evaluate(list);
            ++n;
        }
        n = 0;
        while (n < this.objects.size()) {
            parameter = (Parameter)this.objects.get(n);
            this.paramValues[n] = parameter.getValue();
            ++n;
        }
    }

    @Override
    protected void createGUI() {
        super.createGUI();
        this.remove(this.buttonPanel);
    }

    @Override
    public void refreshGUI() {
        super.refreshGUI();
        this.titledBorder.setTitle(ToolsRes.getString("InitialValueEditor.Border.Title"));
    }

    @Override
    protected String getVariablesString(String string) {
        StringBuffer stringBuffer = new StringBuffer("");
        int n = stringBuffer.length();
        int n2 = this.table.getSelectedRow();
        if (!"t".equals(this.table.getValueAt(n2, 0))) {
            boolean bl = true;
            String[] stringArray = this.paramEditor.getNames();
            int n3 = 0;
            while (n3 < stringArray.length) {
                if (!bl) {
                    stringBuffer.append(" ");
                }
                stringBuffer.append(stringArray[n3]);
                bl = false;
                ++n3;
            }
        }
        if (stringBuffer.length() == n) {
            return ToolsRes.getString("FunctionPanel.Instructions.Help");
        }
        return String.valueOf(ToolsRes.getString("FunctionPanel.Instructions.ValueCell")) + string + stringBuffer.toString();
    }
}

