/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Box;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLProperty;
import org.opensourcephysics.display.ArrayTable;

public class ArrayInspector
extends JDialog
implements PropertyChangeListener {
    JTabbedPane tabbedPane = new JTabbedPane();
    ArrayTable[] tables;
    JSpinner spinner;
    JScrollPane scrollpane;
    Object array;
    boolean changed;

    public static ArrayInspector getInspector(XMLProperty xMLProperty) {
        if (!xMLProperty.getPropertyType().equals("array")) {
            return null;
        }
        Class<?> clazz = xMLProperty.getPropertyClass();
        while (clazz.getComponentType() != null) {
            clazz = clazz.getComponentType();
        }
        if (clazz.getName().equals("double") || clazz.getName().equals("int") || clazz.getName().equals("boolean") || clazz.equals(String.class)) {
            String string = xMLProperty.getPropertyName();
            XMLProperty xMLProperty2 = xMLProperty.getParentProperty();
            while (!(xMLProperty2 instanceof XMLControl)) {
                string = xMLProperty2.getPropertyName();
                xMLProperty = xMLProperty2;
                xMLProperty2 = xMLProperty2.getParentProperty();
            }
            XMLControl xMLControl = (XMLControl)xMLProperty2;
            Object object = xMLControl.getObject(string);
            if (object == null) {
                return null;
            }
            return ArrayInspector.getInspector(object, string);
        }
        return null;
    }

    public static ArrayInspector getInspector(Object object, String string) {
        ArrayInspector arrayInspector = null;
        if (object instanceof double[]) {
            double[] dArray = (double[])object;
            arrayInspector = new ArrayInspector(dArray, string);
        } else if (object instanceof double[][]) {
            double[][] dArray = (double[][])object;
            arrayInspector = new ArrayInspector(dArray, string);
        } else if (object instanceof double[][][]) {
            double[][][] dArray = (double[][][])object;
            arrayInspector = new ArrayInspector(dArray, string);
        } else if (object instanceof int[]) {
            int[] nArray = (int[])object;
            arrayInspector = new ArrayInspector(nArray, string);
        } else if (object instanceof int[][]) {
            int[][] nArray = (int[][])object;
            arrayInspector = new ArrayInspector(nArray, string);
        } else if (object instanceof int[][][]) {
            int[][][] nArray = (int[][][])object;
            arrayInspector = new ArrayInspector(nArray, string);
        } else if (object instanceof String[]) {
            String[] stringArray = (String[])object;
            arrayInspector = new ArrayInspector(stringArray, string);
        } else if (object instanceof String[][]) {
            String[][] stringArray = (String[][])object;
            arrayInspector = new ArrayInspector(stringArray, string);
        } else if (object instanceof String[][][]) {
            String[][][] stringArray = (String[][][])object;
            arrayInspector = new ArrayInspector(stringArray, string);
        } else if (object instanceof boolean[]) {
            boolean[] blArray = (boolean[])object;
            arrayInspector = new ArrayInspector(blArray, string);
        } else if (object instanceof boolean[][]) {
            boolean[][] blArray = (boolean[][])object;
            arrayInspector = new ArrayInspector(blArray, string);
        } else if (object instanceof boolean[][][]) {
            boolean[][][] blArray = (boolean[][][])object;
            arrayInspector = new ArrayInspector(blArray, string);
        }
        if (arrayInspector != null) {
            arrayInspector.array = object;
        }
        return arrayInspector;
    }

    public static boolean canInspect(XMLProperty xMLProperty) {
        if (!xMLProperty.getPropertyType().equals("array")) {
            return false;
        }
        String string = xMLProperty.getPropertyName();
        XMLProperty xMLProperty2 = xMLProperty.getParentProperty();
        while (!(xMLProperty2 instanceof XMLControl)) {
            string = xMLProperty2.getPropertyName();
            xMLProperty = xMLProperty2;
            xMLProperty2 = xMLProperty2.getParentProperty();
        }
        XMLControl xMLControl = (XMLControl)xMLProperty2;
        Object object = xMLControl.getObject(string);
        return ArrayInspector.canInspect(object);
    }

    public static boolean canInspect(Object object) {
        if (object == null) {
            return false;
        }
        return object instanceof double[] || object instanceof double[][] || object instanceof double[][][] || object instanceof int[] || object instanceof int[][] || object instanceof int[][][] || object instanceof boolean[] || object instanceof boolean[][] || object instanceof boolean[][][] || object instanceof String[] || object instanceof String[][] || object instanceof String[][][];
    }

    public Object getArray() {
        return this.array;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.changed = true;
        this.firePropertyChange(propertyChangeEvent.getPropertyName(), propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
    }

    public void setEditable(boolean bl) {
        int n = 0;
        while (n < this.tables.length) {
            this.tables[n].setEditable(bl);
            ++n;
        }
    }

    public void refreshTable() {
        int n = 0;
        while (n < this.tables.length) {
            this.tables[n].refreshTable();
            ++n;
        }
    }

    protected void createGUI() {
        this.setSize(400, 300);
        this.setContentPane(new JPanel(new BorderLayout()));
        this.scrollpane = new JScrollPane(this.tables[0]);
        if (this.tables.length > 1) {
            SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(0, 0, this.tables.length - 1, 1);
            this.spinner = new JSpinner(spinnerNumberModel);
            JSpinner.NumberEditor numberEditor = new JSpinner.NumberEditor(this.spinner);
            numberEditor.getTextField().setFont(this.tables[0].getFont());
            this.spinner.setEditor(numberEditor);
            this.spinner.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    int n = (Integer)ArrayInspector.this.spinner.getValue();
                    ArrayInspector.this.scrollpane.setViewportView(ArrayInspector.this.tables[n]);
                }
            });
            Dimension dimension = this.spinner.getMinimumSize();
            this.spinner.setMaximumSize(dimension);
            this.getContentPane().add((Component)this.scrollpane, "Center");
            JToolBar jToolBar = new JToolBar();
            jToolBar.setFloatable(false);
            jToolBar.add(new JLabel(" index "));
            jToolBar.add(this.spinner);
            jToolBar.add(Box.createHorizontalGlue());
            this.getContentPane().add((Component)jToolBar, "North");
        } else {
            this.scrollpane.createHorizontalScrollBar();
            this.getContentPane().add((Component)this.scrollpane, "Center");
        }
    }

    private ArrayInspector() {
        super((Frame)null, true);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                if (ArrayInspector.this.changed) {
                    ArrayInspector.this.firePropertyChange("arrayData", null, null);
                }
            }
        });
    }

    private ArrayInspector(int[] nArray) {
        this();
        this.tables = new ArrayTable[1];
        this.tables[0] = new ArrayTable(nArray);
        this.tables[0].addPropertyChangeListener("cell", this);
        this.createGUI();
        this.setTitle("Array: int[row]");
    }

    private ArrayInspector(int[] nArray, String string) {
        this(nArray);
        this.setTitle("Array \"" + string + "\": int[row]");
    }

    private ArrayInspector(int[][] nArray) {
        this();
        this.tables = new ArrayTable[1];
        this.tables[0] = new ArrayTable(nArray);
        this.tables[0].addPropertyChangeListener("cell", this);
        this.createGUI();
        this.setTitle("Array: int[row][column]");
    }

    private ArrayInspector(int[][] nArray, String string) {
        this(nArray);
        this.setTitle("Array \"" + string + "\": int[row][column]");
    }

    private ArrayInspector(int[][][] nArray) {
        this();
        this.tables = new ArrayTable[nArray.length];
        int n = 0;
        while (n < this.tables.length) {
            this.tables[n] = new ArrayTable(nArray[n]);
            this.tables[n].addPropertyChangeListener("cell", this);
            ++n;
        }
        this.createGUI();
        this.setTitle("Array: int[index][row][column]");
    }

    private ArrayInspector(int[][][] nArray, String string) {
        this(nArray);
        this.setTitle("Array \"" + string + "\": int[index][row][column]");
    }

    private ArrayInspector(double[] dArray) {
        this();
        this.tables = new ArrayTable[1];
        this.tables[0] = new ArrayTable(dArray);
        this.tables[0].addPropertyChangeListener("cell", this);
        this.createGUI();
        this.setTitle("Array: double[row]");
    }

    private ArrayInspector(double[] dArray, String string) {
        this(dArray);
        this.setTitle("Array \"" + string + "\": double[row]");
    }

    private ArrayInspector(double[][] dArray) {
        this();
        this.tables = new ArrayTable[1];
        this.tables[0] = new ArrayTable(dArray);
        this.tables[0].addPropertyChangeListener("cell", this);
        this.createGUI();
        this.setTitle("Array: double[row][column]");
    }

    private ArrayInspector(double[][] dArray, String string) {
        this(dArray);
        this.setTitle("Array \"" + string + "\": double[row][column]");
    }

    private ArrayInspector(double[][][] dArray) {
        this();
        this.tables = new ArrayTable[dArray.length];
        int n = 0;
        while (n < this.tables.length) {
            this.tables[n] = new ArrayTable(dArray[n]);
            this.tables[n].addPropertyChangeListener("cell", this);
            ++n;
        }
        this.createGUI();
        this.setTitle("Array: double[index][row][column]");
    }

    private ArrayInspector(double[][][] dArray, String string) {
        this(dArray);
        this.setTitle("Array \"" + string + "\": double[index][row][column]");
    }

    private ArrayInspector(String[] stringArray) {
        this();
        this.tables = new ArrayTable[1];
        this.tables[0] = new ArrayTable(stringArray);
        this.tables[0].addPropertyChangeListener("cell", this);
        this.createGUI();
        this.setTitle("Array: String[row]");
    }

    private ArrayInspector(String[] stringArray, String string) {
        this(stringArray);
        this.setTitle("Array \"" + string + "\": String[row]");
    }

    private ArrayInspector(String[][] stringArray) {
        this();
        this.tables = new ArrayTable[1];
        this.tables[0] = new ArrayTable(stringArray);
        this.tables[0].addPropertyChangeListener("cell", this);
        this.createGUI();
        this.setTitle("Array: String[row][column]");
    }

    private ArrayInspector(String[][] stringArray, String string) {
        this(stringArray);
        this.setTitle("Array \"" + string + "\": String[row][column]");
    }

    private ArrayInspector(String[][][] stringArray) {
        this();
        this.tables = new ArrayTable[stringArray.length];
        int n = 0;
        while (n < this.tables.length) {
            this.tables[n] = new ArrayTable(stringArray[n]);
            this.tables[n].addPropertyChangeListener("cell", this);
            ++n;
        }
        this.createGUI();
        this.setTitle("Array: String[index][row][column]");
    }

    private ArrayInspector(String[][][] stringArray, String string) {
        this(stringArray);
        this.setTitle("Array \"" + string + "\": String[index][row][column]");
    }

    private ArrayInspector(boolean[] blArray) {
        this();
        this.tables = new ArrayTable[1];
        this.tables[0] = new ArrayTable(blArray);
        this.tables[0].addPropertyChangeListener("cell", this);
        this.createGUI();
        this.setTitle("Array: boolean[row]");
    }

    private ArrayInspector(boolean[] blArray, String string) {
        this(blArray);
        this.setTitle("Array \"" + string + "\": boolean[row]");
    }

    private ArrayInspector(boolean[][] blArray) {
        this();
        this.tables = new ArrayTable[1];
        this.tables[0] = new ArrayTable(blArray);
        this.tables[0].addPropertyChangeListener("cell", this);
        this.createGUI();
        this.setTitle("Array: boolean[row][column]");
    }

    private ArrayInspector(boolean[][] blArray, String string) {
        this(blArray);
        this.setTitle("Array \"" + string + "\": boolean[row][column]");
    }

    private ArrayInspector(boolean[][][] blArray) {
        this();
        this.tables = new ArrayTable[blArray.length];
        int n = 0;
        while (n < this.tables.length) {
            this.tables[n] = new ArrayTable(blArray[n]);
            this.tables[n].addPropertyChangeListener("cell", this);
            ++n;
        }
        this.createGUI();
        this.setTitle("Array: boolean[index][row][column]");
    }

    private ArrayInspector(boolean[][][] blArray, String string) {
        this(blArray);
        this.setTitle("Array \"" + string + "\": boolean[index][row][column]");
    }
}

