/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.numerics;

import org.opensourcephysics.numerics.ODE;
import org.opensourcephysics.numerics.ODESolver;

public abstract class AbstractODESolver
implements ODESolver {
    protected double stepSize = 0.1;
    protected int numEqn = 0;
    protected ODE ode;

    public AbstractODESolver(ODE oDE) {
        this.ode = oDE;
        this.initialize(0.1);
    }

    @Override
    public abstract double step();

    @Override
    public void setStepSize(double d) {
        this.stepSize = d;
    }

    @Override
    public void initialize(double d) {
        this.stepSize = d;
        double[] dArray = this.ode.getState();
        this.numEqn = dArray == null ? 0 : dArray.length;
    }

    @Override
    public double getStepSize() {
        return this.stepSize;
    }
}

