/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.media.gif;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import javax.swing.Timer;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.media.core.DoubleArray;
import org.opensourcephysics.media.core.Filter;
import org.opensourcephysics.media.core.ImageCoordSystem;
import org.opensourcephysics.media.core.VideoAdapter;
import org.opensourcephysics.media.core.VideoIO;
import org.opensourcephysics.media.core.VideoType;
import org.opensourcephysics.media.gif.GifDecoder;
import org.opensourcephysics.tools.Resource;
import org.opensourcephysics.tools.ResourceLoader;

public class GifVideo
extends VideoAdapter {
    protected GifDecoder decoder;
    protected int[] startTimes;
    private Timer timer;
    private HashSet<DrawingPanel> panels = new HashSet();

    public GifVideo(String string) throws IOException {
        this.load(string);
        this.createTimer();
    }

    @Override
    public void draw(DrawingPanel drawingPanel, Graphics graphics) {
        this.panels.add(drawingPanel);
        super.draw(drawingPanel, graphics);
    }

    @Override
    protected void finalize() {
    }

    @Override
    public void play() {
        if (this.getFrameCount() == 1) {
            return;
        }
        if (!this.timer.isRunning()) {
            if (this.getFrameNumber() >= this.getEndFrameNumber()) {
                this.setFrameNumber(this.getStartFrameNumber());
            }
            this.timer.restart();
            this.support.firePropertyChange("playing", null, new Boolean(true));
        }
    }

    @Override
    public void stop() {
        if (this.timer.isRunning()) {
            this.timer.stop();
            this.support.firePropertyChange("playing", null, new Boolean(false));
        }
    }

    @Override
    public void setFrameNumber(int n) {
        super.setFrameNumber(n);
        n = this.getFrameNumber();
        int n2 = Math.min(n, this.decoder.getFrameCount() - 1);
        this.rawImage = this.decoder.getFrame(n2);
        this.isValidImage = false;
        this.isValidFilteredImage = false;
        this.support.firePropertyChange("framenumber", null, new Integer(n));
        for (DrawingPanel drawingPanel : this.panels) {
            drawingPanel.repaint();
        }
    }

    @Override
    public double getFrameTime(int n) {
        if (n >= this.startTimes.length || n < 0) {
            return -1.0;
        }
        return this.startTimes[n];
    }

    @Override
    public double getTime() {
        return this.getFrameTime(this.getFrameNumber());
    }

    @Override
    public void setTime(double d) {
        d = Math.abs(d);
        int n = 0;
        while (n < this.startTimes.length) {
            int n2 = this.startTimes[n];
            if (d < (double)n2) {
                this.setFrameNumber(n - 1);
                break;
            }
            ++n;
        }
    }

    @Override
    public double getStartTime() {
        return this.getFrameTime(this.getStartFrameNumber());
    }

    @Override
    public void setStartTime(double d) {
        d = Math.abs(d);
        int n = 0;
        while (n < this.startTimes.length) {
            int n2 = this.startTimes[n];
            if (d < (double)n2) {
                this.setStartFrameNumber(n - 1);
                break;
            }
            ++n;
        }
    }

    @Override
    public double getEndTime() {
        int n = this.getEndFrameNumber();
        return this.getFrameTime(n) + (double)this.decoder.getDelay(n);
    }

    @Override
    public void setEndTime(double d) {
        d = Math.abs(d);
        d = Math.min(this.getDuration(), d);
        int n = 0;
        while (n < this.startTimes.length) {
            int n2 = this.startTimes[n];
            if (d < (double)n2) {
                this.setEndFrameNumber(n - 1);
                break;
            }
            ++n;
        }
    }

    @Override
    public double getDuration() {
        int n = this.getFrameCount() - 1;
        return this.getFrameTime(n) + (double)this.decoder.getDelay(n);
    }

    protected void load(String string) throws IOException {
        this.decoder = new GifDecoder();
        int n = this.decoder.read(string);
        if (n == 2) {
            throw new IOException("Gif " + string + " not found");
        }
        if (n == 1) {
            throw new IOException("File format error");
        }
        this.setProperty("name", string);
        if (string.indexOf(":") == -1) {
            this.setProperty("path", XML.forwardSlash(string));
            Resource resource = ResourceLoader.getResource(string);
            if (resource != null) {
                this.setProperty("absolutePath", resource.getAbsolutePath());
            }
        } else {
            this.setProperty("path", XML.getRelativePath(string));
            this.setProperty("absolutePath", string);
        }
        this.frameCount = this.decoder.getFrameCount();
        this.startFrameNumber = 0;
        this.endFrameNumber = this.frameCount - 1;
        this.startTimes = new int[this.frameCount];
        this.startTimes[0] = 0;
        int n2 = 1;
        while (n2 < this.startTimes.length) {
            this.startTimes[n2] = this.startTimes[n2 - 1] + this.decoder.getDelay(n2 - 1);
            ++n2;
        }
        this.setImage(this.decoder.getFrame(0));
    }

    private void setImage(BufferedImage bufferedImage) {
        this.rawImage = bufferedImage;
        this.size = new Dimension(bufferedImage.getWidth(), bufferedImage.getHeight());
        this.refreshBufferedImage();
        this.coords = new ImageCoordSystem(this.frameCount);
        this.coords.addPropertyChangeListener(this);
        this.aspects = new DoubleArray(this.frameCount, 1.0);
    }

    private void createTimer() {
        int n = this.decoder.getDelay(0);
        this.timer = new Timer(n, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (GifVideo.this.getFrameNumber() < GifVideo.this.getEndFrameNumber()) {
                    int n = GifVideo.this.decoder.getDelay(GifVideo.this.getFrameNumber() + 1);
                    GifVideo.this.timer.setDelay((int)((double)n / GifVideo.this.getRate()));
                    GifVideo.this.setFrameNumber(GifVideo.this.getFrameNumber() + 1);
                } else if (GifVideo.this.looping) {
                    int n = GifVideo.this.decoder.getDelay(GifVideo.this.getStartFrameNumber());
                    GifVideo.this.timer.setDelay((int)((double)n / GifVideo.this.getRate()));
                    GifVideo.this.setFrameNumber(GifVideo.this.getStartFrameNumber());
                } else {
                    GifVideo.this.stop();
                }
            }
        });
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    static class Loader
    implements XML.ObjectLoader {
        Loader() {
        }

        @Override
        public void saveObject(XMLControl xMLControl, Object object) {
            GifVideo gifVideo = (GifVideo)object;
            String string = (String)gifVideo.getProperty("base");
            String string2 = (String)gifVideo.getProperty("absolutePath");
            if (string != null && string2 != null) {
                xMLControl.setValue("path", XML.getPathRelativeTo(string2, string));
            } else {
                String string3 = (String)gifVideo.getProperty("path");
                xMLControl.setValue("path", string3);
            }
            if (!gifVideo.getFilterStack().isEmpty()) {
                xMLControl.setValue("filters", gifVideo.getFilterStack().getFilters());
            }
        }

        @Override
        public Object createObject(XMLControl xMLControl) {
            try {
                String string = xMLControl.getString("path");
                GifVideo gifVideo = new GifVideo(string);
                VideoType videoType = VideoIO.getVideoType("gif", null);
                if (videoType != null) {
                    gifVideo.setProperty("video_type", videoType);
                }
                return gifVideo;
            }
            catch (IOException iOException) {
                OSPLog.fine(iOException.getMessage());
                return null;
            }
        }

        @Override
        public Object loadObject(XMLControl xMLControl, Object object) {
            GifVideo gifVideo = (GifVideo)object;
            Collection collection = (Collection)xMLControl.getObject("filters");
            if (collection != null) {
                gifVideo.getFilterStack().clear();
                for (Filter filter : collection) {
                    gifVideo.getFilterStack().addFilter(filter);
                }
            }
            return object;
        }
    }
}

