/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.media.core;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.TreeSet;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileFilter;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.media.core.Filter;
import org.opensourcephysics.media.core.ImageVideo;
import org.opensourcephysics.media.core.ImageVideoType;
import org.opensourcephysics.media.core.MediaRes;
import org.opensourcephysics.media.core.Video;
import org.opensourcephysics.media.core.VideoFileFilter;
import org.opensourcephysics.media.core.VideoPanel;
import org.opensourcephysics.media.core.VideoType;
import org.opensourcephysics.tools.ExtensionsManager;
import org.opensourcephysics.tools.FontSizer;
import org.opensourcephysics.tools.ResourceLoader;

public class VideoIO {
    public static final String[] VIDEO_EXTENSIONS;
    public static final String ENGINE_QUICKTIME = "QT";
    public static final String ENGINE_XUGGLE = "Xuggle";
    public static final String ENGINE_NONE = "none";
    public static final String DEFAULT_PREFERRED_EXPORT_EXTENSION = "mp4";
    public static final long XUGGLE_54_FILE_LENGTH = 1000000L;
    protected static JFileChooser chooser;
    protected static VideoFileFilter videoFileFilter;
    protected static Collection<VideoFileFilter> singleVideoTypeFilters;
    protected static FileFilter imageFileFilter;
    protected static ArrayList<VideoType> videoTypes;
    protected static ArrayList<VideoType> videoEngines;
    protected static String defaultXMLExt;
    protected static String videoEngine;
    protected static VideoEnginePanel videoEnginePanel;
    protected static boolean canceled;
    protected static String preferredExportExtension;

    static {
        Object object;
        VIDEO_EXTENSIONS = new String[]{"mov", "avi", DEFAULT_PREFERRED_EXPORT_EXTENSION};
        videoFileFilter = new VideoFileFilter();
        singleVideoTypeFilters = new TreeSet<VideoFileFilter>();
        videoTypes = new ArrayList();
        videoEngines = new ArrayList();
        defaultXMLExt = "xml";
        preferredExportExtension = DEFAULT_PREFERRED_EXPORT_EXTENSION;
        try {
            object = "org.opensourcephysics.media.gif.GifVideoType";
            Class<?> clazz = Class.forName((String)object);
            VideoIO.addVideoType((VideoType)clazz.newInstance());
        }
        catch (Exception exception) {
        }
        catch (Error error) {}
        object = new VideoFileFilter("jpg", new String[]{"jpg", "jpeg"});
        VideoIO.addVideoType(new ImageVideoType((VideoFileFilter)object));
        object = new VideoFileFilter("png", new String[]{"png"});
        VideoIO.addVideoType(new ImageVideoType((VideoFileFilter)object));
        imageFileFilter = new FileFilter(){

            @Override
            public boolean accept(File file) {
                if (file == null) {
                    return false;
                }
                if (file.isDirectory()) {
                    return true;
                }
                String string = VideoIO.getExtension(file);
                return string != null && (string.equals("gif") || string.equals("jpg"));
            }

            @Override
            public String getDescription() {
                return MediaRes.getString("VideoIO.ImageFileFilter.Description");
            }
        };
        videoEnginePanel = new VideoEnginePanel();
    }

    protected VideoIO() {
    }

    public static String getExtension(File file) {
        return XML.getExtension(file.getName());
    }

    public static JFileChooser getChooser() {
        if (chooser == null) {
            File file = OSPRuntime.chooserDir == null ? new File(System.getProperty("user.home")) : new File(OSPRuntime.chooserDir);
            chooser = new JFileChooser(file);
            chooser.addPropertyChangeListener(videoEnginePanel);
        }
        FontSizer.setFonts(chooser, FontSizer.getLevel());
        return chooser;
    }

    public static void setDefaultXMLExtension(String string) {
        defaultXMLExt = string;
    }

    public static String getRelativePath(String string) {
        if (string.indexOf("/") == -1 && string.indexOf("\\") == -1) {
            return string;
        }
        if (string.startsWith("http:")) {
            return string;
        }
        String string2 = string;
        String string3 = "";
        boolean bl = false;
        String string4 = System.getProperty("user.dir");
        if (string4 == null) {
            return string2;
        }
        int n = 0;
        while (n < 3) {
            int n2;
            if (n > 0) {
                n2 = string4.lastIndexOf("\\");
                if (n2 == -1) {
                    n2 = string4.lastIndexOf("/");
                }
                if (n2 == -1) break;
                string4 = string4.substring(0, n2);
                string3 = String.valueOf(string3) + "../";
            }
            if (string2.startsWith(string4)) {
                string2 = string2.substring(string4.length() + 1);
                n2 = string2.indexOf("\\");
                while (n2 != -1) {
                    string2 = String.valueOf(string2.substring(0, n2)) + "/" + string2.substring(n2 + 1);
                    n2 = string2.indexOf("\\");
                }
                string3 = String.valueOf(string3) + string2;
                bl = true;
                break;
            }
            ++n;
        }
        if (bl) {
            return string3;
        }
        return string2;
    }

    public static boolean isEngineInstalled(String string) {
        if (string.equals(ENGINE_XUGGLE)) {
            return ExtensionsManager.getManager().getXuggleJar() != null;
        }
        if (string.equals(ENGINE_QUICKTIME)) {
            if (OSPRuntime.isMac()) {
                return true;
            }
            if (OSPRuntime.isLinux()) {
                return false;
            }
            return ExtensionsManager.getManager().getQTJavaZip() != null;
        }
        return false;
    }

    public static String getEngine() {
        if (videoEngine == null) {
            videoEngine = VideoIO.getDefaultEngine();
        }
        return videoEngine;
    }

    public static void setEngine(String string) {
        if (string == null || !string.equals(ENGINE_QUICKTIME) && !string.equals(ENGINE_XUGGLE) && !string.equals(ENGINE_NONE)) {
            return;
        }
        videoEngine = string;
    }

    public static String getDefaultEngine() {
        String string = ENGINE_NONE;
        double d = 0.0;
        boolean bl = false;
        for (VideoType videoType : videoEngines) {
            if (videoType.getClass().getSimpleName().contains(ENGINE_XUGGLE)) {
                d = VideoIO.guessXuggleVersion();
                continue;
            }
            if (!videoType.getClass().getSimpleName().contains(ENGINE_QUICKTIME)) continue;
            bl = true;
        }
        if (d == 3.4) {
            string = ENGINE_XUGGLE;
        } else if (bl) {
            string = ENGINE_QUICKTIME;
        } else if (d == 5.4) {
            string = ENGINE_XUGGLE;
        }
        return string;
    }

    public static boolean updateEngine(String string) {
        String string2 = XML.forwardSlash(System.getProperty("java.ext.dirs"));
        ArrayList<File> arrayList = new ArrayList<File>();
        String string3 = System.getProperty("path.separator");
        int n = string2.indexOf(string3);
        while (n > -1) {
            arrayList.add(new File(string2.substring(0, n)));
            string2 = string2.substring(n + 1);
            n = string2.indexOf(string3);
        }
        if (!"".equals(string2)) {
            arrayList.add(new File(string2));
        }
        ExtensionsManager extensionsManager = ExtensionsManager.getManager();
        if (string.equals(ENGINE_XUGGLE)) {
            boolean bl = false;
            for (File file : arrayList) {
                if (!file.exists()) continue;
                boolean bl2 = bl = extensionsManager.copyXuggleJarsTo(file) || bl;
            }
            return bl;
        }
        if (string.equals(ENGINE_QUICKTIME)) {
            if (OSPRuntime.isLinux()) {
                return false;
            }
            boolean bl = false;
            for (File file : arrayList) {
                if (!file.exists()) continue;
                boolean bl3 = bl = extensionsManager.copyQTJavaTo(file) || bl;
            }
            return bl;
        }
        return false;
    }

    public static void testExec() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static boolean copyFile(File file, File file2) {
        byte[] byArray = new byte[100000];
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            while (true) {
                byte[] byArray2 = byArray;
                // MONITORENTER : byArray
                int n = ((InputStream)fileInputStream).read(byArray);
                if (n == -1) {
                    // MONITOREXIT : byArray2
                    break;
                }
                ((OutputStream)fileOutputStream).write(byArray, 0, n);
                // MONITOREXIT : byArray2
            }
            ((InputStream)fileInputStream).close();
            ((OutputStream)fileOutputStream).close();
            file2.setLastModified(file.lastModified());
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public static String[] getVideoExtensions() {
        return videoFileFilter.getExtensions();
    }

    public static String getPreferredExportExtension() {
        return preferredExportExtension;
    }

    public static void setPreferredExportExtension(String string) {
        if (string != null && string.length() > 1) {
            preferredExportExtension = string;
        }
    }

    public static void addVideoType(VideoType videoType) {
        if (videoType != null) {
            boolean bl = false;
            for (VideoType object : videoTypes) {
                if (!object.getDescription().equals(videoType.getDescription()) || object.getClass() != videoType.getClass()) continue;
                bl = true;
            }
            if (!bl) {
                videoTypes.add(videoType);
                VideoFileFilter videoFileFilter = videoType.getDefaultFileFilter();
                if (videoFileFilter != null && videoFileFilter.extensions != null) {
                    singleVideoTypeFilters.add(videoFileFilter);
                }
            }
        }
    }

    public static void addVideoEngine(VideoType videoType) {
        if (videoType != null) {
            OSPLog.finest(String.valueOf(videoType.getClass().getSimpleName()) + " " + videoType.getDefaultExtension());
            boolean bl = false;
            for (VideoType videoType2 : videoEngines) {
                if (videoType2.getClass() != videoType.getClass()) continue;
                bl = true;
            }
            if (!bl) {
                videoEngines.add(videoType);
                videoEnginePanel.addVideoEngine(videoType);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static VideoType getVideoType(String string, String string2) {
        if (string == null && string2 == null) {
            return null;
        }
        ArrayList<VideoType> arrayList = new ArrayList<VideoType>();
        ArrayList<VideoType> arrayList2 = videoTypes;
        synchronized (arrayList2) {
            if (string == null) {
                arrayList.addAll(videoTypes);
            } else {
                string = string.toLowerCase();
                for (VideoType videoType : videoTypes) {
                    String string3 = videoType.getClass().getSimpleName().toLowerCase();
                    if (string3.indexOf(string) <= -1) continue;
                    arrayList.add(videoType);
                }
            }
            if (string2 == null) {
                if (!arrayList.isEmpty()) return (VideoType)arrayList.get(0);
                return null;
            }
            string2 = string2.toLowerCase();
            for (VideoType videoType : arrayList) {
                String string4 = videoType.getDefaultExtension();
                if (string4 == null || string4.indexOf(string2) <= -1) continue;
                return videoType;
            }
            for (VideoType videoType : arrayList) {
                VideoFileFilter[] videoFileFilterArray;
                VideoFileFilter[] videoFileFilterArray2 = videoFileFilterArray = videoType.getFileFilters();
                int n = videoFileFilterArray.length;
                int n2 = 0;
                while (n2 < n) {
                    VideoFileFilter videoFileFilter = videoFileFilterArray2[n2];
                    if (videoFileFilter.extensions != null) {
                        String[] stringArray = videoFileFilter.extensions;
                        int n3 = videoFileFilter.extensions.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            String string5 = stringArray[n4];
                            if (string5.indexOf(string2) > -1) {
                                return videoType;
                            }
                            ++n4;
                        }
                    }
                    ++n2;
                }
            }
            return null;
        }
    }

    public static VideoType[] getVideoTypesForExtension(String string) {
        VideoFileFilter[] videoFileFilterArray;
        VideoType videoType;
        VideoType[] videoTypeArray;
        string = string.toLowerCase();
        ArrayList<VideoType> arrayList = new ArrayList<VideoType>();
        VideoType[] videoTypeArray2 = videoTypeArray = VideoIO.getVideoTypes();
        int n = videoTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            videoType = videoTypeArray2[n2];
            videoFileFilterArray = videoType.getDefaultExtension();
            if (videoFileFilterArray != null && videoFileFilterArray.indexOf(string) > -1) {
                arrayList.add(videoType);
            }
            ++n2;
        }
        videoTypeArray2 = videoTypeArray;
        n = videoTypeArray.length;
        n2 = 0;
        while (n2 < n) {
            videoType = videoTypeArray2[n2];
            VideoFileFilter[] videoFileFilterArray2 = videoFileFilterArray = videoType.getFileFilters();
            int n3 = videoFileFilterArray.length;
            int n4 = 0;
            while (n4 < n3) {
                VideoFileFilter videoFileFilter = videoFileFilterArray2[n4];
                if (videoFileFilter.extensions != null) {
                    String[] stringArray = videoFileFilter.extensions;
                    int n5 = videoFileFilter.extensions.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        String string2 = stringArray[n6];
                        if (string2.indexOf(string) > -1 && !arrayList.contains(videoType)) {
                            arrayList.add(videoType);
                        }
                        ++n6;
                    }
                }
                ++n4;
            }
            ++n2;
        }
        return arrayList.toArray(new VideoType[0]);
    }

    public static VideoType[] getVideoTypes() {
        return VideoIO.getVideoTypesForEngine(VideoIO.getEngine());
    }

    public static VideoType[] getVideoTypesForEngine(String string) {
        ArrayList<VideoType> arrayList = new ArrayList<VideoType>();
        boolean bl = VideoIO.getEngine().equals(ENGINE_XUGGLE) || VideoIO.getEngine().equals(ENGINE_NONE);
        boolean bl2 = VideoIO.getEngine().equals(ENGINE_QUICKTIME) || VideoIO.getEngine().equals(ENGINE_NONE);
        for (VideoType videoType : videoTypes) {
            String string2 = videoType.getClass().getSimpleName();
            if (bl && string2.contains(ENGINE_QUICKTIME) || bl2 && string2.contains(ENGINE_XUGGLE)) continue;
            arrayList.add(videoType);
        }
        return arrayList.toArray(new VideoType[0]);
    }

    public static void setCanceled(boolean bl) {
        canceled = bl;
    }

    public static boolean isCanceled() {
        return canceled;
    }

    public static Video getVideo(String string, VideoType videoType) {
        OSPLog.fine("path: " + string + " type: " + videoType);
        Video video = null;
        VideoIO.setCanceled(false);
        if (videoType != null) {
            OSPLog.finest("requested type " + videoType.getClass().getSimpleName() + " " + videoType.getDescription());
            video = videoType.getVideo(string);
            if (video != null) {
                return video;
            }
        }
        if (VideoIO.isCanceled()) {
            return null;
        }
        String string2 = XML.getExtension(string);
        VideoType[] videoTypeArray = VideoIO.getVideoTypesForExtension(string2);
        ArrayList<VideoType> arrayList = new ArrayList<VideoType>();
        boolean bl = VideoIO.getEngine().equals(ENGINE_XUGGLE) || VideoIO.getEngine().equals(ENGINE_NONE);
        boolean bl2 = VideoIO.getEngine().equals(ENGINE_QUICKTIME) || VideoIO.getEngine().equals(ENGINE_NONE);
        int n = 0;
        while (n < videoTypeArray.length) {
            String string3 = videoTypeArray[n].getClass().getSimpleName();
            if (!(bl && string3.contains(ENGINE_QUICKTIME) || bl2 && string3.contains(ENGINE_XUGGLE))) {
                arrayList.add(videoTypeArray[n]);
            }
            ++n;
        }
        for (VideoType videoType2 : arrayList) {
            OSPLog.finest("preferred type " + videoType2.getClass().getSimpleName() + " " + videoType2.getDescription());
            video = videoType2.getVideo(string);
            if (VideoIO.isCanceled()) {
                return null;
            }
            if (video == null) continue;
            return video;
        }
        return null;
    }

    public static Video getVideo(String string, ArrayList<VideoType> arrayList, JComponent jComponent, JFrame jFrame) {
        int n;
        String string2 = VideoIO.getEngine();
        string2 = ENGINE_NONE.equals(string2) ? MediaRes.getString("VideoIO.Engine.None") : (ENGINE_XUGGLE.equals(string2) ? MediaRes.getString("XuggleVideoType.Description") : MediaRes.getString("QTVideoType.Description"));
        String string3 = String.valueOf(MediaRes.getString("VideoIO.Dialog.TryDifferentEngine.Message1")) + " (" + string2 + ").";
        string3 = String.valueOf(string3) + "\n" + MediaRes.getString("VideoIO.Dialog.TryDifferentEngine.Message2");
        string3 = String.valueOf(string3) + "\n\n" + MediaRes.getString("VideoIO.Dialog.Label.Path") + ": " + string;
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (VideoType objectArray2 : arrayList) {
            if (objectArray2.getClass().getSimpleName().equals("XuggleVideoType")) {
                arrayList2.add(MediaRes.getString("XuggleVideoType.Description"));
                continue;
            }
            if (!objectArray2.getClass().getSimpleName().equals("QTVideoType")) continue;
            arrayList2.add(MediaRes.getString("QTVideoType.Description"));
        }
        arrayList2.add(MediaRes.getString("Dialog.Button.Cancel"));
        Object[] objectArray = arrayList2.toArray(new String[arrayList2.size()]);
        JPanel jPanel = new JPanel(new BorderLayout());
        JTextArea jTextArea = new JTextArea();
        jTextArea.setText(string3);
        jTextArea.setOpaque(false);
        jTextArea.setBorder(BorderFactory.createEmptyBorder(4, 0, 4, 4));
        jPanel.add((Component)jTextArea, "North");
        if (jComponent != null) {
            jComponent.setBorder(BorderFactory.createEmptyBorder(12, 0, 12, 0));
            jPanel.add((Component)jComponent, "South");
        }
        if ((n = JOptionPane.showOptionDialog(jFrame, jPanel, MediaRes.getString("VideoClip.Dialog.BadVideo.Title"), 1, 2, null, objectArray, objectArray[0])) >= 0 && n < objectArray.length - 1) {
            VideoType videoType = arrayList.get(n);
            Video video = VideoIO.getVideo(string, videoType);
            if (video == null && !VideoIO.isCanceled()) {
                JOptionPane.showMessageDialog(jFrame, String.valueOf(MediaRes.getString("VideoIO.Dialog.BadVideo.Message")) + "\n\n" + string, MediaRes.getString("VideoClip.Dialog.BadVideo.Title"), 2);
            }
            return video;
        }
        return null;
    }

    public static Video clone(Video video) {
        if (video == null) {
            return null;
        }
        if (video instanceof ImageVideo) {
            ImageVideo imageVideo = (ImageVideo)video;
            ImageVideo imageVideo2 = new ImageVideo(imageVideo.getImages());
            imageVideo2.rawImage = imageVideo2.images[0];
            ArrayList<Filter> arrayList = video.getFilterStack().getFilters();
            if (arrayList != null) {
                for (Filter filter : arrayList) {
                    imageVideo2.getFilterStack().addFilter(filter);
                }
            }
            return imageVideo2;
        }
        XMLControlElement xMLControlElement = new XMLControlElement(video);
        return (Video)new XMLControlElement(xMLControlElement).loadObject(null);
    }

    public static File open(VideoPanel videoPanel) {
        return VideoIO.open(null, videoPanel);
    }

    public static File[] getChooserFiles(String string) {
        File[] fileArray;
        JFileChooser jFileChooser = VideoIO.getChooser();
        jFileChooser.setMultiSelectionEnabled(false);
        jFileChooser.setAcceptAllFileFilterUsed(true);
        int n = 1;
        if (string.toLowerCase().equals("open")) {
            jFileChooser.addChoosableFileFilter(videoFileFilter);
            jFileChooser.setFileFilter(jFileChooser.getAcceptAllFileFilter());
            n = jFileChooser.showOpenDialog(null);
        } else if (string.toLowerCase().equals("open video")) {
            jFileChooser.addChoosableFileFilter(videoFileFilter);
            n = jFileChooser.showOpenDialog(null);
        } else if (string.toLowerCase().equals("save")) {
            fileArray = MediaRes.getString("VideoIO.FileName.Untitled");
            jFileChooser.setSelectedFile(new File(String.valueOf(fileArray) + "." + defaultXMLExt));
            n = jFileChooser.showSaveDialog(null);
        } else if (string.toLowerCase().equals("insert image")) {
            jFileChooser.setMultiSelectionEnabled(true);
            jFileChooser.setAcceptAllFileFilterUsed(false);
            jFileChooser.addChoosableFileFilter(imageFileFilter);
            jFileChooser.setSelectedFile(new File(""));
            n = jFileChooser.showOpenDialog(null);
            fileArray = jFileChooser.getSelectedFiles();
            jFileChooser.removeChoosableFileFilter(imageFileFilter);
            jFileChooser.setSelectedFile(new File(""));
            if (n == 0) {
                return fileArray;
            }
        }
        if (n == 0) {
            fileArray = jFileChooser.getSelectedFile();
            jFileChooser.removeChoosableFileFilter(videoFileFilter);
            jFileChooser.setSelectedFile(new File(""));
            return new File[]{fileArray};
        }
        return null;
    }

    public static File open(File file, VideoPanel videoPanel) {
        Object object;
        if (file == null && (object = VideoIO.getChooserFiles("open")) != null) {
            file = object[0];
        }
        if (file == null) {
            return null;
        }
        if (videoFileFilter.accept(file)) {
            object = VideoIO.getVideoTypes();
            Video video = null;
            int n = 0;
            while (n < ((Object)object).length) {
                video = object[n].getVideo(file.getAbsolutePath());
                if (video != null) {
                    OSPLog.info(String.valueOf(file.getName()) + " opened as type " + object[n].getDescription());
                    break;
                }
                OSPLog.info(String.valueOf(file.getName()) + " failed as type " + object[n].getDescription());
                ++n;
            }
            if (video != null) {
                videoPanel.setVideo(video);
                videoPanel.repaint();
            } else {
                JOptionPane.showMessageDialog(videoPanel, String.valueOf(MediaRes.getString("VideoIO.Dialog.BadVideo.Message")) + ResourceLoader.getNonURIPath(XML.getAbsolutePath(file)));
            }
        } else {
            object = new XMLControlElement();
            ((XMLControlElement)object).read(file.getAbsolutePath());
            Class<?> clazz = ((XMLControlElement)object).getObjectClass();
            if (VideoPanel.class.isAssignableFrom(clazz)) {
                videoPanel.setDataFile(file);
                ((XMLControlElement)object).loadObject(videoPanel);
            } else {
                if (!((XMLControlElement)object).failedToRead()) {
                    JOptionPane.showMessageDialog(videoPanel, "\"" + file.getName() + "\" " + MediaRes.getString("VideoIO.Dialog.XMLMismatch.Message"), MediaRes.getString("VideoIO.Dialog.XMLMismatch.Title"), 2);
                    return null;
                }
                JOptionPane.showMessageDialog(videoPanel, String.valueOf(MediaRes.getString("VideoIO.Dialog.BadFile.Message")) + ResourceLoader.getNonURIPath(XML.getAbsolutePath(file)));
            }
            videoPanel.changed = false;
        }
        return file;
    }

    public static File save(File file, VideoPanel videoPanel) {
        return VideoIO.save(file, videoPanel, MediaRes.getString("VideoIO.Dialog.SaveAs.Title"));
    }

    public static File save(File file, VideoPanel videoPanel, String string) {
        Object object;
        Video video;
        if (file == null) {
            int n;
            video = videoPanel.getVideo();
            object = VideoIO.getChooser();
            ((JFileChooser)object).removeChoosableFileFilter(videoFileFilter);
            ((JFileChooser)object).removeChoosableFileFilter(imageFileFilter);
            ((JFileChooser)object).setDialogTitle(string);
            String string2 = MediaRes.getString("VideoIO.FileName.Untitled");
            if (videoPanel.getFilePath() != null) {
                string2 = XML.stripExtension(videoPanel.getFilePath());
            } else if (video != null && video.getProperty("name") != null && (n = (string2 = (String)video.getProperty("name")).lastIndexOf(".")) > 0) {
                string2 = string2.substring(0, n);
            }
            file = new File(String.valueOf(string2) + "." + defaultXMLExt);
            String string3 = XML.getDirectoryPath(string2);
            if (!string3.equals("")) {
                XML.createFolders(string3);
                ((JFileChooser)object).setCurrentDirectory(new File(string3));
            }
            ((JFileChooser)object).setSelectedFile(file);
            int n2 = ((JFileChooser)object).showSaveDialog(videoPanel);
            if (n2 == 0) {
                int n3;
                file = ((JFileChooser)object).getSelectedFile();
                if (!defaultXMLExt.equals(VideoIO.getExtension(file))) {
                    string2 = XML.stripExtension(file.getPath());
                    file = new File(String.valueOf(string2) + "." + defaultXMLExt);
                }
                if (file.exists() && (n3 = JOptionPane.showConfirmDialog(videoPanel, " \"" + file.getName() + "\" " + MediaRes.getString("VideoIO.Dialog.FileExists.Message"), MediaRes.getString("VideoIO.Dialog.FileExists.Title"), 2)) != 0) {
                    return null;
                }
                videoPanel.setDataFile(file);
            } else {
                return null;
            }
        }
        if ((video = videoPanel.getVideo()) != null) {
            video.setProperty("base", XML.getDirectoryPath(XML.getAbsolutePath(file)));
            if (video instanceof ImageVideo) {
                ((ImageVideo)video).saveInvalidImages();
            }
        }
        object = new XMLControlElement(videoPanel);
        object.write(file.getAbsolutePath());
        videoPanel.changed = false;
        return file;
    }

    public static File writeImageFile(BufferedImage bufferedImage, String string) {
        if (bufferedImage == null) {
            return null;
        }
        File file = new File(string);
        File file2 = file.getParentFile();
        if (!file2.exists()) {
            file2.mkdirs();
        }
        String string2 = XML.getExtension(string);
        try {
            if (ImageIO.write((RenderedImage)bufferedImage, string2, file)) {
                return file;
            }
        }
        catch (IOException iOException) {
            OSPLog.finer(iOException.toString());
        }
        return null;
    }

    public static double guessXuggleVersion() {
        File file = ExtensionsManager.getManager().getXuggleJar();
        if (file != null) {
            return file.length() < 1000000L ? 3.4 : 5.4;
        }
        return 0.0;
    }

    public static class StreamPiper
    implements Runnable {
        private final InputStream input;
        private final OutputStream output;

        public StreamPiper(InputStream inputStream, OutputStream outputStream) {
            this.input = inputStream;
            this.output = outputStream;
        }

        @Override
        public void run() {
            try {
                byte[] byArray = new byte[1024];
                int n = 0;
                while ((n = this.input.read(byArray)) >= 0) {
                    this.output.write(byArray, 0, n);
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    protected static class VideoEnginePanel
    extends JPanel
    implements PropertyChangeListener {
        JPanel emptyPanel;
        File selectedFile;
        ButtonGroup videoEngineButtonGroup = new ButtonGroup();
        HashMap<JRadioButton, VideoType> buttonMap = new HashMap();
        TitledBorder title;
        boolean isClosing = false;

        VideoEnginePanel() {
            this.setLayout(new BoxLayout(this, 1));
            this.title = BorderFactory.createTitledBorder(MediaRes.getString("VideoEnginePanel.TitledBorder.Title"));
            this.setBorder(this.title);
            this.emptyPanel = new JPanel(){

                @Override
                public Dimension getPreferredSize() {
                    return videoEnginePanel.getPreferredSize();
                }
            };
        }

        public void addVideoEngine(VideoType videoType) {
            JRadioButton jRadioButton = new JRadioButton(videoType.getDescription());
            jRadioButton.setActionCommand(videoType.getClass().getSimpleName());
            this.videoEngineButtonGroup.add(jRadioButton);
            this.buttonMap.put(jRadioButton, videoType);
            this.add(jRadioButton);
        }

        public VideoType getSelectedVideoType() {
            if (chooser.getAccessory() == null || chooser.getAccessory() == this.emptyPanel) {
                return null;
            }
            for (JRadioButton jRadioButton : this.buttonMap.keySet()) {
                if (!jRadioButton.isSelected()) continue;
                VideoType videoType = this.buttonMap.get(jRadioButton);
                OSPLog.finest("selected video type: " + videoType);
                String string = videoType.getClass().getSimpleName();
                String string2 = XML.getExtension(this.selectedFile.getName());
                VideoType videoType2 = VideoIO.getVideoType(string, string2);
                return videoType2 == null ? videoType : videoType2;
            }
            return null;
        }

        public void reset() {
            this.isClosing = false;
            this.refresh();
        }

        public void refresh() {
            if (this.isClosing) {
                return;
            }
            this.selectedFile = chooser.getSelectedFile();
            if (this.buttonMap.size() < 2) {
                chooser.setAccessory(null);
                chooser.validate();
                return;
            }
            int n = 0;
            boolean bl = false;
            for (JRadioButton jRadioButton : this.buttonMap.keySet()) {
                if (jRadioButton.isSelected()) {
                    bl = true;
                }
                VideoType videoType = this.buttonMap.get(jRadioButton);
                VideoFileFilter[] videoFileFilterArray = videoType.getFileFilters();
                int n2 = videoFileFilterArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    VideoFileFilter videoFileFilter = videoFileFilterArray[n3];
                    if (this.selectedFile != null && ((FileFilter)videoFileFilter).accept(this.selectedFile)) {
                        ++n;
                    }
                    ++n3;
                }
            }
            if (n < 2) {
                chooser.setAccessory(this.emptyPanel);
            } else {
                chooser.setAccessory(videoEnginePanel);
                if (!bl) {
                    for (JRadioButton jRadioButton : this.buttonMap.keySet()) {
                        jRadioButton.setSelected(jRadioButton.getActionCommand().contains(VideoIO.getEngine()));
                    }
                }
            }
            chooser.validate();
            chooser.repaint();
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string.toLowerCase().indexOf("closing") > -1) {
                this.isClosing = true;
            } else {
                if (chooser.getAccessory() == null) {
                    return;
                }
                if (string.equals("SelectedFileChangedProperty")) {
                    this.refresh();
                }
            }
        }
    }
}

