/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.media.core;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.media.core.ClipControl;
import org.opensourcephysics.media.core.ImageVideo;
import org.opensourcephysics.media.core.VideoClip;

public class StepperClipControl
extends ClipControl {
    private Timer timer;
    private double frameDuration = 100.0;
    private boolean playing = false;
    private boolean readyToStep = true;
    private boolean stepDisplayed = true;
    private int minDelay = 10;
    private int maxDelay = 5000;

    protected StepperClipControl(VideoClip videoClip) {
        super(videoClip);
        videoClip.addPropertyChangeListener(this);
        if (this.video != null) {
            this.video.addPropertyChangeListener(this);
            if (this.video.getFrameCount() > 1 && this.video.getDuration() > 0.0) {
                double d = this.video.getFrameTime(this.video.getStartFrameNumber());
                double d2 = this.video.getFrameTime(this.video.getEndFrameNumber());
                int n = this.video.getEndFrameNumber() - this.video.getStartFrameNumber();
                if (n != 0 && d2 - d > 0.0) {
                    this.frameDuration = (int)(d2 - d) / n;
                }
            }
        }
        this.timer = new Timer(this.getTimerDelay(), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StepperClipControl.this.readyToStep = true;
                StepperClipControl.this.step();
            }
        });
        this.timer.setRepeats(false);
        this.timer.setCoalesce(false);
    }

    @Override
    public void play() {
        if (this.clip.getStepCount() == 1) {
            return;
        }
        this.playing = true;
        this.readyToStep = true;
        if (this.stepNumber == this.clip.getStepCount() - 1) {
            this.setStepNumber(0);
        } else {
            this.step();
        }
        this.support.firePropertyChange("playing", null, new Boolean(true));
    }

    @Override
    public void stop() {
        this.timer.stop();
        this.readyToStep = true;
        this.stepDisplayed = true;
        this.playing = false;
        this.support.firePropertyChange("playing", null, new Boolean(false));
    }

    @Override
    public void step() {
        if (this.stepNumber >= this.clip.getStepCount() - 1 && !this.looping) {
            this.stop();
        } else if (this.stepDisplayed && (!this.playing || this.readyToStep)) {
            this.stepDisplayed = false;
            if (this.playing) {
                this.readyToStep = false;
                this.timer.restart();
            }
            if (this.stepNumber < this.clip.getStepCount() - 1) {
                this.setStepNumber(this.stepNumber + 1);
            } else if (this.looping) {
                this.setStepNumber(0);
            }
        }
    }

    @Override
    public void back() {
        if (this.stepDisplayed && this.stepNumber > 0) {
            this.stepDisplayed = false;
            this.setStepNumber(this.stepNumber - 1);
        }
    }

    @Override
    public void setStepNumber(int n) {
        n = Math.max(0, n);
        n = Math.min(this.clip.getStepCount() - 1, n);
        if (n == this.stepNumber && this.clip.stepToFrame(n) == this.getFrameNumber()) {
            return;
        }
        if (this.video == null) {
            super.setStepNumber(n);
            this.stepDisplayed = true;
            this.support.firePropertyChange("stepnumber", null, new Integer(n));
        } else {
            int n2 = this.video.getEndFrameNumber();
            final int n3 = this.clip.stepToFrame(n) + this.clip.getFrameShift();
            final int n4 = n;
            if (n3 > n2) {
                super.setStepNumber(n);
                this.video.setVisible(false);
                this.stepDisplayed = true;
                this.support.firePropertyChange("stepnumber", null, new Integer(n));
            } else {
                this.video.setVisible(true);
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        if (StepperClipControl.this.videoFrameNumber == n3) {
                            StepperClipControl.this.stepDisplayed = true;
                        } else if (StepperClipControl.this.video.getFrameNumber() == n3) {
                            StepperClipControl.super.setStepNumber(n4);
                            StepperClipControl.this.stepDisplayed = true;
                            StepperClipControl.this.support.firePropertyChange("stepnumber", null, new Integer(n4));
                        } else {
                            StepperClipControl.this.video.setFrameNumber(n3);
                        }
                    }
                };
                SwingUtilities.invokeLater(runnable);
            }
        }
    }

    @Override
    public void setRate(double d) {
        if (d == 0.0 || d == this.rate) {
            return;
        }
        this.rate = Math.abs(d);
        this.timer.setInitialDelay(this.getTimerDelay());
        this.support.firePropertyChange("rate", null, new Double(this.rate));
    }

    @Override
    public double getMeanFrameDuration() {
        if (this.video != null && this.video.getDuration() > 0.0) {
            int n = this.video.getEndFrameNumber() - this.video.getStartFrameNumber();
            if (n != 0) {
                double d = this.video.getFrameTime(this.video.getStartFrameNumber());
                double d2 = this.video.getFrameTime(this.video.getEndFrameNumber());
                return this.timeStretch * (d2 - d) / (double)n;
            }
            return this.timeStretch * this.video.getDuration() / (double)this.video.getFrameCount();
        }
        return this.frameDuration;
    }

    @Override
    public void setFrameDuration(double d) {
        if ((d = Math.abs(d)) == 0.0 || d == this.getMeanFrameDuration()) {
            return;
        }
        if (this.video != null && this.video instanceof ImageVideo) {
            ImageVideo imageVideo = (ImageVideo)this.video;
            imageVideo.setFrameDuration(d);
            this.frameDuration = d;
            this.timer.setInitialDelay(this.getTimerDelay());
        } else if (this.video != null && this.video.getDuration() > 0.0) {
            double d2 = this.video.getFrameTime(this.video.getStartFrameNumber());
            double d3 = this.video.getFrameTime(this.video.getEndFrameNumber());
            int n = this.video.getEndFrameNumber() - this.video.getStartFrameNumber();
            if (n != 0) {
                this.timeStretch = d * (double)n / (d3 - d2);
            }
        } else {
            this.frameDuration = d;
            this.timer.setInitialDelay(this.getTimerDelay());
        }
        this.support.firePropertyChange("frameduration", null, new Double(d));
    }

    @Override
    public void setLooping(boolean bl) {
        if (bl == this.looping) {
            return;
        }
        this.looping = bl;
        this.support.firePropertyChange("looping", null, new Boolean(bl));
    }

    @Override
    public boolean isPlaying() {
        return this.playing;
    }

    @Override
    public double getTime() {
        if (this.video != null && this.video.getDuration() > 0.0) {
            int n = this.video.getFrameNumber();
            double d = this.video.getFrameTime(n);
            int n2 = this.clip.stepToFrame(this.getStepNumber()) + this.clip.getFrameShift();
            if (n2 > this.video.getFrameCount() - 1) {
                int n3 = n2 - this.video.getFrameCount() + 1;
                d = this.video.getFrameTime(this.video.getFrameCount() - 1) + (double)n3 * this.frameDuration;
            }
            return (d - this.video.getStartTime()) * this.timeStretch;
        }
        return (double)this.stepNumber * this.frameDuration * (double)this.clip.getStepSize();
    }

    @Override
    public double getStepTime(int n) {
        if (this.video != null && this.video.getDuration() > 0.0) {
            int n2 = this.clip.stepToFrame(n) + this.clip.getFrameShift();
            double d = this.video.getFrameTime(n2);
            if (n2 > this.video.getFrameCount() - 1) {
                int n3 = n2 - this.video.getFrameCount() + 1;
                d = this.video.getFrameTime(this.video.getFrameCount() - 1) + (double)n3 * this.frameDuration;
            }
            return (d - this.video.getStartTime()) * this.timeStretch;
        }
        return (double)n * this.frameDuration * (double)this.clip.getStepSize();
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("stepsize")) {
            this.timer.setInitialDelay(this.getTimerDelay());
        } else if (string.equals("framenumber")) {
            int n = (Integer)propertyChangeEvent.getNewValue();
            this.stepDisplayed = true;
            if (n != this.videoFrameNumber) {
                super.setFrameNumber(n - this.clip.getFrameShift());
                this.support.firePropertyChange("stepnumber", null, new Integer(this.stepNumber));
            }
            if (this.playing) {
                this.step();
            }
        } else {
            super.propertyChange(propertyChangeEvent);
        }
    }

    private int getTimerDelay() {
        int n;
        double d = this.frameDuration;
        if (this.video != null && this.video.getDuration() > 0.0) {
            n = this.video.getEndFrameNumber() - this.video.getStartFrameNumber();
            if (n != 0) {
                double d2 = this.video.getFrameTime(this.video.getStartFrameNumber());
                double d3 = this.video.getFrameTime(this.video.getEndFrameNumber());
                d = (d3 - d2) / (double)n;
            } else {
                d = this.video.getDuration() / (double)this.video.getFrameCount();
            }
        }
        n = (int)(d * (double)this.clip.getStepSize() / this.rate);
        n = Math.min(n, this.maxDelay);
        n = Math.max(n, this.minDelay);
        return n;
    }

    public static XML.ObjectLoader getLoader() {
        return new ClipControl.Loader();
    }
}

