/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.event.SwingPropertyChangeSupport;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;

public class DataClip {
    private int dataLength = 2;
    private int startIndex = 0;
    private int clipLength = 0;
    private int stride = 1;
    private PropertyChangeSupport support = new SwingPropertyChangeSupport(this);
    private boolean isAdjusting = false;

    public void setDataLength(int n) {
        this.dataLength = n = Math.max(n, 1);
    }

    public int getDataLength() {
        return this.dataLength;
    }

    public int setClipLength(int n) {
        int n2 = this.getClipLength();
        if ((n = Math.min(n, this.dataLength)) == this.dataLength) {
            n = 0;
        }
        this.clipLength = n;
        this.support.firePropertyChange("clip_length", n2, this.getClipLength());
        return this.getClipLength();
    }

    public int getClipLength() {
        if (this.clipLength <= 0) {
            return this.dataLength;
        }
        return this.clipLength;
    }

    public int setStartIndex(int n) {
        int n2 = this.getStartIndex();
        n = Math.max(n, 0);
        this.startIndex = n = Math.min(n, this.dataLength - 1);
        this.support.firePropertyChange("start_index", n2, n);
        return this.getStartIndex();
    }

    public int getStartIndex() {
        return this.startIndex;
    }

    public int setStride(int n) {
        int n2 = this.getStride();
        n = Math.min(n, this.dataLength - 1);
        this.stride = n = Math.max(n, 1);
        this.support.firePropertyChange("stride", n2, n);
        return this.getStride();
    }

    public int getStride() {
        return this.stride;
    }

    public int getAvailableClipLength() {
        int n = this.getClipLength();
        int n2 = n - 1;
        while (n2 > 0) {
            if (this.stepToIndex(n2) < this.dataLength) {
                return n2 + 1;
            }
            --n2;
        }
        return 1;
    }

    public int stepToIndex(int n) {
        return this.startIndex + n * this.stride;
    }

    public int indexToStep(int n) {
        return (n - this.startIndex) / this.stride;
    }

    public boolean includesIndex(int n) {
        int n2 = this.getClipLength();
        int n3 = 0;
        while (n3 < n2) {
            if (this.stepToIndex(n3) == n) {
                return true;
            }
            ++n3;
        }
        return false;
    }

    public void setAdjusting(boolean bl) {
        if (this.isAdjusting == bl) {
            return;
        }
        this.isAdjusting = bl;
        this.support.firePropertyChange("adjusting", null, (Object)bl);
    }

    public boolean isAdjusting() {
        return this.isAdjusting;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(string, propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(string, propertyChangeListener);
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    static class Loader
    implements XML.ObjectLoader {
        Loader() {
        }

        @Override
        public void saveObject(XMLControl xMLControl, Object object) {
            DataClip dataClip = (DataClip)object;
            xMLControl.setValue("start", dataClip.getStartIndex());
            xMLControl.setValue("clip_length", dataClip.getClipLength());
            xMLControl.setValue("stride", dataClip.getStride());
            xMLControl.setValue("data_length", dataClip.getDataLength());
        }

        @Override
        public Object createObject(XMLControl xMLControl) {
            return new DataClip();
        }

        @Override
        public Object loadObject(XMLControl xMLControl, Object object) {
            DataClip dataClip = (DataClip)object;
            dataClip.setDataLength(xMLControl.getInt("data_length"));
            dataClip.setStartIndex(xMLControl.getInt("start"));
            dataClip.setClipLength(xMLControl.getInt("clip_length"));
            dataClip.setStride(xMLControl.getInt("stride"));
            return object;
        }
    }
}

