/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display;

import java.util.Dictionary;
import java.util.Hashtable;
import javax.swing.table.AbstractTableModel;
import org.opensourcephysics.display.TeXParser;

public class ArrayTableModel
extends AbstractTableModel {
    double[] doubleArray1;
    double[][] doubleArray2;
    int[] intArray1;
    int[][] intArray2;
    String[] stringArray1;
    String[][] stringArray2;
    boolean[] booleanArray1;
    boolean[][] booleanArray2;
    boolean editable = false;
    String[] columnNames;
    boolean showRowNumber = true;
    int firstRow = 0;
    int firstCol = 0;
    boolean transposed = false;
    Dictionary<Integer, Boolean> lockedColumns = new Hashtable<Integer, Boolean>();

    public ArrayTableModel(int[] nArray) {
        this.intArray1 = nArray;
    }

    public ArrayTableModel(int[][] nArray) {
        this.intArray2 = nArray;
    }

    public ArrayTableModel(double[] dArray) {
        this.doubleArray1 = dArray;
    }

    public ArrayTableModel(double[][] dArray) {
        this.doubleArray2 = dArray;
    }

    public ArrayTableModel(String[] stringArray) {
        this.stringArray1 = stringArray;
    }

    public ArrayTableModel(String[][] stringArray) {
        this.stringArray2 = stringArray;
    }

    public ArrayTableModel(boolean[] blArray) {
        this.booleanArray1 = blArray;
    }

    public ArrayTableModel(boolean[][] blArray) {
        this.booleanArray2 = blArray;
    }

    public void setArray(Object object) {
        if (object instanceof double[]) {
            this.doubleArray1 = (double[])object;
        } else if (object instanceof double[][]) {
            this.doubleArray2 = (double[][])object;
        } else if (object instanceof int[]) {
            this.intArray1 = (int[])object;
        } else if (object instanceof int[][]) {
            this.intArray2 = (int[][])object;
        } else if (object instanceof String[]) {
            this.stringArray1 = (String[])object;
        } else if (object instanceof String[][]) {
            this.stringArray2 = (String[][])object;
        } else if (object instanceof boolean[]) {
            this.booleanArray1 = (boolean[])object;
        } else if (object instanceof boolean[][]) {
            this.booleanArray2 = (boolean[][])object;
        }
    }

    public boolean setColumnLock(int n, boolean bl) {
        Boolean bl2 = this.lockedColumns.get(n);
        if (bl2 != null && bl == bl2) {
            return false;
        }
        this.lockedColumns.put(n, bl);
        return true;
    }

    public boolean setColumnLocks(boolean[] blArray) {
        int n;
        int n2;
        boolean bl = false;
        if (this.lockedColumns.size() != blArray.length) {
            bl = true;
        } else {
            n2 = 0;
            n = blArray.length;
            while (n2 < n) {
                Boolean bl2 = this.lockedColumns.get(n2);
                if (!Boolean.valueOf(blArray[n2]).equals(bl2)) {
                    bl = true;
                    break;
                }
                ++n2;
            }
        }
        if (!bl) {
            return false;
        }
        ((Hashtable)this.lockedColumns).clear();
        n2 = 0;
        n = blArray.length;
        while (n2 < n) {
            this.lockedColumns.put(n2, blArray[n2]);
            ++n2;
        }
        return true;
    }

    public void setFirstRowIndex(int n) {
        this.firstRow = n;
    }

    public void setFirstColIndex(int n) {
        this.firstRow = n;
    }

    public void setRowNumberVisible(boolean bl) {
        this.showRowNumber = bl;
    }

    public void setTransposed(boolean bl) {
        this.transposed = bl;
    }

    public boolean isTransposed() {
        return this.transposed;
    }

    public void setEditable(boolean bl) {
        this.editable = bl;
    }

    @Override
    public int getColumnCount() {
        int n;
        if (this.getArrayRowCount() == 0) {
            return 0;
        }
        int n2 = n = this.showRowNumber ? 1 : 0;
        if (this.transposed) {
            return this.getArrayRowCount() + n;
        }
        return this.getArrayColumnCount() + n;
    }

    int getArrayColumnCount() {
        if (this.intArray1 != null || this.doubleArray1 != null || this.stringArray1 != null || this.booleanArray1 != null) {
            return 1;
        }
        if (this.intArray2 != null) {
            return this.intArray2[0].length;
        }
        if (this.doubleArray2 != null) {
            return this.doubleArray2[0].length;
        }
        if (this.stringArray2 != null) {
            return this.stringArray2[0].length;
        }
        if (this.booleanArray2 != null) {
            return this.booleanArray2[0].length;
        }
        return 0;
    }

    public boolean setColumnNames(String[] stringArray) {
        if (stringArray == null && this.columnNames == null) {
            return false;
        }
        if (stringArray != null) {
            stringArray = (String[])stringArray.clone();
        }
        boolean bl = false;
        if (stringArray != null && this.columnNames != null && this.columnNames.length == stringArray.length) {
            int n = 0;
            int n2 = stringArray.length;
            while (n < n2) {
                stringArray[n] = TeXParser.parseTeX(stringArray[n]);
                if (!stringArray[n].equals(this.columnNames[n])) {
                    bl = true;
                }
                ++n;
            }
        } else {
            bl = true;
            if (stringArray != null) {
                int n = 0;
                int n3 = stringArray.length;
                while (n < n3) {
                    stringArray[n] = TeXParser.parseTeX(stringArray[n]);
                    ++n;
                }
            }
        }
        this.columnNames = stringArray;
        return bl;
    }

    @Override
    public String getColumnName(int n) {
        if (!this.showRowNumber) {
            ++n;
        }
        if (this.columnNames != null && n < this.columnNames.length) {
            return this.columnNames[n];
        }
        if (n == 0) {
            return "";
        }
        if (this.intArray1 != null || this.doubleArray1 != null || this.stringArray1 != null || this.booleanArray1 != null) {
            return "value";
        }
        return "" + (n - 1 + this.firstCol);
    }

    @Override
    public int getRowCount() {
        if (this.transposed) {
            return this.getArrayColumnCount();
        }
        return this.getArrayRowCount();
    }

    int getArrayRowCount() {
        if (this.intArray1 != null) {
            return this.intArray1.length;
        }
        if (this.intArray2 != null) {
            return this.intArray2.length;
        }
        if (this.doubleArray1 != null) {
            return this.doubleArray1.length;
        }
        if (this.doubleArray2 != null) {
            return this.doubleArray2.length;
        }
        if (this.stringArray1 != null) {
            return this.stringArray1.length;
        }
        if (this.stringArray2 != null) {
            return this.stringArray2.length;
        }
        if (this.booleanArray1 != null) {
            return this.booleanArray1.length;
        }
        if (this.booleanArray2 != null) {
            return this.booleanArray2.length;
        }
        return 0;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        int n3;
        int n4;
        if (this.showRowNumber && n2 == 0) {
            return new Integer(n + this.firstRow);
        }
        int n5 = n4 = this.showRowNumber ? 1 : 0;
        if (this.transposed) {
            n3 = n;
            n = n2 - n4;
            n2 = n3;
        }
        if (this.intArray1 != null) {
            return new Integer(this.intArray1[n]);
        }
        if (this.intArray2 != null) {
            int n6 = n3 = this.transposed ? n2 : n2 - n4;
            if (n > this.intArray2.length - 1 || n3 > this.intArray2[n].length - 1 || n3 < 0) {
                return null;
            }
            return new Integer(this.intArray2[n][n3]);
        }
        if (this.doubleArray1 != null) {
            return new Double(this.doubleArray1[n]);
        }
        if (this.doubleArray2 != null) {
            int n7 = n3 = this.transposed ? n2 : n2 - n4;
            if (n > this.doubleArray2.length - 1 || n3 > this.doubleArray2[n].length - 1 || n3 < 0) {
                return null;
            }
            return new Double(this.doubleArray2[n][n3]);
        }
        if (this.stringArray1 != null) {
            return this.stringArray1[n];
        }
        if (this.stringArray2 != null) {
            int n8 = n3 = this.transposed ? n2 : n2 - n4;
            if (n > this.stringArray2.length - 1 || n3 > this.stringArray2[n].length - 1 || n3 < 0) {
                return null;
            }
            return this.stringArray2[n][n3];
        }
        if (this.booleanArray1 != null) {
            return new Boolean(this.booleanArray1[n]);
        }
        if (this.booleanArray2 != null) {
            int n9 = n3 = this.transposed ? n2 : n2 - n4;
            if (n > this.booleanArray2.length - 1 || n3 > this.booleanArray2[n].length - 1 || n3 < 0) {
                return null;
            }
            return new Boolean(this.booleanArray2[n][n3]);
        }
        return null;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        int n3;
        int n4 = n3 = this.showRowNumber ? 1 : 0;
        if (this.transposed) {
            int n5 = n;
            n = n2 - n3;
            n2 = n5;
        }
        try {
            if (object instanceof String) {
                String string = (String)object;
                int n6 = n2 = this.transposed ? n2 : n2 - n3;
                if (this.intArray1 != null) {
                    this.intArray1[n] = Integer.parseInt(string);
                } else if (this.intArray2 != null) {
                    this.intArray2[n][n2] = Integer.parseInt(string);
                } else if (this.doubleArray1 != null) {
                    this.doubleArray1[n] = Double.parseDouble(string);
                } else if (this.doubleArray2 != null) {
                    this.doubleArray2[n][n2] = Double.parseDouble(string);
                } else if (this.stringArray1 != null) {
                    this.stringArray1[n] = string;
                } else if (this.stringArray2 != null) {
                    this.stringArray2[n][n2] = string;
                } else if (this.booleanArray1 != null) {
                    this.booleanArray1[n] = string.toLowerCase().startsWith("t");
                } else if (this.booleanArray2 != null) {
                    this.booleanArray2[n][n2] = string.toLowerCase().startsWith("t");
                }
                if (this.transposed) {
                    this.fireTableCellUpdated(n2, n);
                } else {
                    this.fireTableCellUpdated(n, n2);
                }
            }
        }
        catch (Exception exception) {}
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        if (this.showRowNumber && n2 == 0) {
            return false;
        }
        n2 = this.showRowNumber ? n2 - 1 : n2;
        Boolean bl = this.lockedColumns.get(n2);
        if (bl == null) {
            return this.editable;
        }
        return bl == false && this.editable;
    }
}

