/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.controls;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.opensourcephysics.controls.ControlsRes;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLProperty;
import org.opensourcephysics.controls.XMLTree;

public class XMLTreeChooser
extends JDialog {
    private JPanel scrollPane;
    private XMLTree tree;
    private JLabel textLabel;
    private boolean applyChanges = false;

    public XMLTreeChooser(String string, String string2) {
        this(string, string2, null);
    }

    public XMLTreeChooser(String string, String string2, Component component) {
        super(JOptionPane.getFrameForComponent(component), true);
        this.setTitle(string);
        this.textLabel = new JLabel(" " + string2);
        this.textLabel.setHorizontalTextPosition(2);
        JButton jButton = new JButton(ControlsRes.getString("Chooser.Button.Cancel"));
        JButton jButton2 = new JButton(ControlsRes.getString("Chooser.Button.OK"));
        JButton jButton3 = new JButton(ControlsRes.getString("Chooser.Button.SelectAll"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                XMLTreeChooser.this.setVisible(false);
            }
        });
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                XMLTreeChooser.this.applyChanges = true;
                XMLTreeChooser.this.setVisible(false);
            }
        });
        jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                XMLTreeChooser.this.tree.selectHighlightedProperties();
            }
        });
        this.getRootPane().setDefaultButton(jButton2);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.add(this.textLabel);
        jPanel.add(Box.createHorizontalGlue());
        jPanel.add(jButton3);
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 0, 10));
        this.scrollPane = new JPanel(new BorderLayout());
        this.scrollPane.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
        jPanel2.add(Box.createHorizontalGlue());
        jPanel2.add(jButton2);
        jPanel2.add(Box.createRigidArea(new Dimension(10, 0)));
        jPanel2.add(jButton);
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.setPreferredSize(new Dimension(340, 340));
        this.setContentPane(jPanel3);
        jPanel3.add((Component)jPanel, "North");
        jPanel3.add((Component)this.scrollPane, "Center");
        jPanel3.add((Component)jPanel2, "South");
        this.pack();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int n = (dimension.width - this.getBounds().width) / 2;
        int n2 = (dimension.height - this.getBounds().height) / 2;
        this.setLocation(n, n2);
    }

    public List<XMLProperty> choose(XMLControl xMLControl, Class<?> clazz) {
        ArrayList<XMLProperty> arrayList = new ArrayList<XMLProperty>();
        this.tree = new XMLTree(xMLControl);
        this.tree.setHighlightedClass(clazz);
        this.tree.selectHighlightedProperties();
        this.textLabel.setIcon(XMLTree.hiliteIcon);
        this.scrollPane.removeAll();
        this.scrollPane.add((Component)this.tree.getScrollPane(), "Center");
        this.validate();
        this.applyChanges = false;
        this.setVisible(true);
        if (this.applyChanges) {
            List<XMLProperty> list = this.tree.getSelectedProperties();
            for (XMLProperty xMLProperty : list) {
                Class<?> clazz2 = xMLProperty.getPropertyClass();
                if (clazz2 == null || !clazz.isAssignableFrom(clazz2)) continue;
                arrayList.add(xMLProperty);
            }
        }
        return arrayList;
    }
}

