/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.rmi.RemoteException;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import org.opensourcephysics.cabrillo.tracker.CoordAxes;
import org.opensourcephysics.cabrillo.tracker.TButton;
import org.opensourcephysics.cabrillo.tracker.TFrame;
import org.opensourcephysics.cabrillo.tracker.TMat;
import org.opensourcephysics.cabrillo.tracker.TTrack;
import org.opensourcephysics.cabrillo.tracker.TView;
import org.opensourcephysics.cabrillo.tracker.TViewChooser;
import org.opensourcephysics.cabrillo.tracker.Tracker;
import org.opensourcephysics.cabrillo.tracker.TrackerIO;
import org.opensourcephysics.cabrillo.tracker.TrackerPanel;
import org.opensourcephysics.cabrillo.tracker.TrackerRes;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.display.Drawable;
import org.opensourcephysics.display.Interactive;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.media.core.ImageCoordSystem;
import org.opensourcephysics.media.core.TPoint;
import org.opensourcephysics.media.core.Video;
import org.opensourcephysics.media.core.VideoPlayer;
import org.opensourcephysics.tools.FontSizer;
import org.opensourcephysics.tools.Job;
import org.opensourcephysics.tools.JobManager;
import org.opensourcephysics.tools.Tool;

public class WorldTView
extends TrackerPanel
implements TView {
    protected TrackerPanel trackerPanel;
    protected Icon icon;
    protected JMenuItem copyImageItem;
    protected JMenuItem printItem;
    protected JMenuItem helpItem;
    protected JButton worldViewButton;
    protected ArrayList<Component> components = new ArrayList();
    protected OverlayTool overlayTool = new OverlayTool();

    public WorldTView(TrackerPanel trackerPanel) {
        super((Video)null);
        this.trackerPanel = trackerPanel;
        this.init();
        this.setPlayerVisible(false);
        this.setDrawingInImageSpace(false);
        this.setPreferredSize(new Dimension(240, 180));
        this.setShowCoordinates(false);
        this.icon = new ImageIcon(Tracker.class.getResource("resources/images/axes.gif"));
        this.worldViewButton = new TButton();
        this.components.add(this.worldViewButton);
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                new TrackerIO.ComponentImage(WorldTView.this).copyToClipboard();
            }
        };
        this.copyImageItem = new JMenuItem(abstractAction);
        AbstractAction abstractAction2 = new AbstractAction(TrackerRes.getString("TActions.Action.Print"), null){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                new TrackerIO.ComponentImage(WorldTView.this).print();
            }
        };
        this.printItem = new JMenuItem(abstractAction2);
        this.helpItem = new JMenuItem();
        this.helpItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TFrame tFrame = WorldTView.this.trackerPanel.getTFrame();
                if (tFrame != null) {
                    tFrame.showHelp("world", 0);
                }
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (OSPRuntime.isPopupTrigger(mouseEvent)) {
                    WorldTView.this.popup.removeAll();
                    if (WorldTView.this.trackerPanel.isEnabled("edit.copyImage")) {
                        WorldTView.this.copyImageItem.setText(TrackerRes.getString("TMenuBar.Menu.CopyImage"));
                        WorldTView.this.popup.add(WorldTView.this.copyImageItem);
                        WorldTView.this.popup.add(WorldTView.this.snapshotItem);
                    }
                    if (WorldTView.this.trackerPanel.isEnabled("file.print")) {
                        if (WorldTView.this.popup.getComponentCount() > 0) {
                            WorldTView.this.popup.addSeparator();
                        }
                        WorldTView.this.printItem.setText(TrackerRes.getString("TActions.Action.Print"));
                        WorldTView.this.popup.add(WorldTView.this.printItem);
                    }
                    if (WorldTView.this.popup.getComponentCount() > 0) {
                        WorldTView.this.popup.addSeparator();
                    }
                    WorldTView.this.helpItem.setText(TrackerRes.getString("Tracker.Popup.MenuItem.Help"));
                    WorldTView.this.popup.add(WorldTView.this.helpItem);
                    FontSizer.setFonts(WorldTView.this.popup, FontSizer.getLevel());
                    WorldTView.this.popup.show(WorldTView.this, mouseEvent.getX(), mouseEvent.getY());
                }
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                WorldTView.this.refresh();
            }
        });
    }

    @Override
    public void refresh() {
        CoordAxes coordAxes = this.trackerPanel.getAxes();
        if (coordAxes != null) {
            coordAxes.removePropertyChangeListener("visible", this);
            coordAxes.addPropertyChangeListener("visible", this);
        }
        if (!this.trackerPanel.calibrationTools.isEmpty()) {
            for (TTrack tTrack : this.trackerPanel.getTracks()) {
                if (!this.trackerPanel.calibrationTools.contains(tTrack)) continue;
                tTrack.removePropertyChangeListener("visible", this);
                tTrack.addPropertyChangeListener("visible", this);
            }
        }
        for (Drawable drawable : this.getDrawables()) {
            if (!(drawable instanceof TTrack)) continue;
            TTrack tTrack = (TTrack)drawable;
            tTrack.erase(this);
        }
        this.repaint();
    }

    @Override
    public void init() {
        this.cleanup();
        this.trackerPanel.addPropertyChangeListener("track", this);
        this.trackerPanel.addPropertyChangeListener("size", this);
        this.trackerPanel.addPropertyChangeListener("transform", this);
        this.trackerPanel.addPropertyChangeListener("stepnumber", this);
        this.trackerPanel.addPropertyChangeListener("video", this);
        this.trackerPanel.addPropertyChangeListener("image", this);
        this.trackerPanel.addPropertyChangeListener("videoVisible", this);
        this.trackerPanel.addPropertyChangeListener("data", this);
        for (TTrack tTrack : this.trackerPanel.getTracks()) {
            tTrack.addPropertyChangeListener("color", this);
        }
    }

    @Override
    public void cleanup() {
        this.trackerPanel.removePropertyChangeListener("track", this);
        this.trackerPanel.removePropertyChangeListener("transform", this);
        this.trackerPanel.removePropertyChangeListener("stepnumber", this);
        this.trackerPanel.removePropertyChangeListener("image", this);
        this.trackerPanel.removePropertyChangeListener("videoVisible", this);
        this.trackerPanel.removePropertyChangeListener("data", this);
        for (TTrack tTrack : this.trackerPanel.getTracks()) {
            tTrack.removePropertyChangeListener("color", this);
        }
    }

    @Override
    public TrackerPanel getTrackerPanel() {
        return this.trackerPanel;
    }

    @Override
    public TPoint getSnapPoint() {
        return this.trackerPanel.getSnapPoint();
    }

    @Override
    public TTrack getSelectedTrack() {
        return this.trackerPanel.getSelectedTrack();
    }

    @Override
    public void setSelectedTrack(TTrack tTrack) {
        this.trackerPanel.setSelectedTrack(tTrack);
    }

    @Override
    public String getViewName() {
        return TrackerRes.getString("TFrame.View.World");
    }

    @Override
    public Icon getViewIcon() {
        return this.icon;
    }

    @Override
    public ArrayList<Component> getToolBarComponents() {
        this.worldViewButton.setText(TrackerRes.getString("WorldTView.Button.World"));
        return this.components;
    }

    @Override
    public boolean isCustomState() {
        return false;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("track")) {
            this.refresh();
        } else if (string.equals("stepnumber") || string.equals("color") || string.equals("visible") || string.equals("image") || string.equals("video") || string.equals("videoVisible")) {
            this.repaint();
        } else if (string.equals("transform")) {
            this.refresh();
        } else if (string.equals("size")) {
            this.refresh();
        } else if (string.equals("data")) {
            this.refresh();
        }
    }

    @Override
    public ArrayList<Drawable> getDrawables() {
        ArrayList<Drawable> arrayList = this.trackerPanel.getDrawables();
        arrayList.addAll(super.getDrawables());
        TMat tMat = this.trackerPanel.getMat();
        if (tMat != null && arrayList.get(0) != tMat) {
            arrayList.remove(tMat);
            arrayList.add(0, tMat);
        }
        if (!this.trackerPanel.isEmpty) {
            this.remove(this.noData);
        }
        return arrayList;
    }

    @Override
    public VideoPlayer getPlayer() {
        if (this.trackerPanel == null) {
            return super.getPlayer();
        }
        return this.trackerPanel.getPlayer();
    }

    @Override
    public ImageCoordSystem getCoords() {
        if (this.trackerPanel == null) {
            return super.getCoords();
        }
        return this.trackerPanel.getCoords();
    }

    @Override
    public void repaintDirtyRegion() {
        if (this.dirty != null) {
            this.repaint();
            this.dirty = null;
        }
    }

    @Override
    public Interactive getInteractive() {
        return null;
    }

    @Override
    protected void configure() {
        this.setPreferredSize(new Dimension(1, 1));
        this.coords.addPropertyChangeListener(this);
        this.removeOptionController();
    }

    protected boolean isSelectedView() {
        Container container = this.getParent();
        while (container != null) {
            TViewChooser tViewChooser;
            if (container instanceof TViewChooser && (tViewChooser = (TViewChooser)container).getSelectedView() == this) {
                return true;
            }
            container = container.getParent();
        }
        return false;
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    static class Loader
    implements XML.ObjectLoader {
        Loader() {
        }

        @Override
        public void saveObject(XMLControl xMLControl, Object object) {
        }

        @Override
        public Object createObject(XMLControl xMLControl) {
            return null;
        }

        @Override
        public Object loadObject(XMLControl xMLControl, Object object) {
            return object;
        }
    }

    class OverlayTool
    implements Tool {
        JobManager jobManager = new JobManager(this);
        XMLControlElement control = new XMLControlElement();

        OverlayTool() {
        }

        @Override
        public void send(Job job, Tool tool) throws RemoteException {
            Drawable drawable = null;
            Object[] objectArray = this.jobManager.getObjects(job);
            if (objectArray != null && objectArray.length > 0) {
                drawable = (Drawable)objectArray[0];
            }
            this.control.readXML(job.getXML());
            if (this.control.failedToRead() || this.control.getObjectClass() == Object.class) {
                return;
            }
            boolean bl = drawable == null;
            drawable = (Drawable)this.control.loadObject(drawable);
            if (bl && drawable != null) {
                WorldTView.this.addDrawable(drawable);
                this.jobManager.log(job, tool);
                this.jobManager.associate(job, drawable);
            }
            WorldTView.this.repaint();
        }
    }
}

