/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import org.opensourcephysics.cabrillo.tracker.TFrame;
import org.opensourcephysics.cabrillo.tracker.TrackerPanel;
import org.opensourcephysics.cabrillo.tracker.TrackerRes;
import org.opensourcephysics.cabrillo.tracker.Vector;
import org.opensourcephysics.cabrillo.tracker.VectorSum;
import org.opensourcephysics.tools.FontSizer;

public class VectorSumInspector
extends JDialog
implements PropertyChangeListener {
    protected VectorSum sum;
    protected TrackerPanel trackerPanel;
    protected JButton okButton;
    protected JPanel mainPanel;
    protected JPanel checkboxPanel;
    protected JPanel sumPanel;
    protected ActionListener listener;
    protected boolean isVisible;

    public VectorSumInspector(VectorSum vectorSum) {
        super(JOptionPane.getFrameForComponent(vectorSum.trackerPanel), false);
        this.sum = vectorSum;
        this.trackerPanel = vectorSum.trackerPanel;
        if (this.trackerPanel != null) {
            this.trackerPanel.addPropertyChangeListener("track", this);
            TFrame tFrame = this.trackerPanel.getTFrame();
            if (tFrame != null) {
                tFrame.addPropertyChangeListener("tab", this);
            }
        }
        this.listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                VectorSumInspector.this.updateSum();
            }
        };
        this.setTitle(String.valueOf(TrackerRes.getString("VectorSumInspector.Title")) + " \"" + vectorSum.getName() + "\"");
        this.setResizable(false);
        this.createGUI();
        this.initialize();
        this.pack();
    }

    @Override
    public void setVisible(boolean bl) {
        if (bl) {
            FontSizer.setFonts(this, FontSizer.getLevel());
            this.pack();
        }
        super.setVisible(bl);
        this.isVisible = bl;
    }

    public void initialize() {
        this.updateDisplay();
    }

    @Override
    public void dispose() {
        this.checkboxPanel.removeAll();
        if (this.trackerPanel != null) {
            this.trackerPanel.removePropertyChangeListener("track", this);
            for (Vector propertyChangeListener2 : this.trackerPanel.getDrawables(Vector.class)) {
                propertyChangeListener2.removePropertyChangeListener("name", this);
                propertyChangeListener2.removePropertyChangeListener("color", this);
                propertyChangeListener2.removePropertyChangeListener("footprint", this);
            }
            TFrame tFrame = this.trackerPanel.getTFrame();
            if (tFrame != null) {
                tFrame.removePropertyChangeListener("tab", this);
            }
        }
        super.dispose();
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("tab")) {
            if (this.trackerPanel != null && propertyChangeEvent.getNewValue() == this.trackerPanel) {
                this.setVisible(this.isVisible);
            } else {
                boolean bl = this.isVisible;
                this.setVisible(false);
                this.isVisible = bl;
            }
        } else {
            this.updateDisplay();
        }
    }

    protected void updateDisplay() {
        this.setTitle(String.valueOf(TrackerRes.getString("VectorSumInspector.Title")) + " \"" + this.sum.getName() + "\"");
        this.checkboxPanel.removeAll();
        for (Vector vector : this.trackerPanel.getDrawables(Vector.class)) {
            vector.removePropertyChangeListener("name", this);
            vector.removePropertyChangeListener("color", this);
            vector.removePropertyChangeListener("footprint", this);
            vector.addPropertyChangeListener("name", this);
            vector.addPropertyChangeListener("color", this);
            vector.addPropertyChangeListener("footprint", this);
            if (vector instanceof VectorSum) continue;
            JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(vector.getName(), vector.getFootprint().getIcon(21, 16));
            if (this.sum.contains(vector)) {
                jCheckBoxMenuItem.setSelected(true);
            }
            jCheckBoxMenuItem.addActionListener(this.listener);
            this.checkboxPanel.add(jCheckBoxMenuItem);
        }
        FontSizer.setFonts(this.checkboxPanel, FontSizer.getLevel());
        this.pack();
        this.repaint();
    }

    private void createGUI() {
        JPanel jPanel = new JPanel(new BorderLayout());
        this.setContentPane(jPanel);
        this.mainPanel = new JPanel(new GridLayout(1, 0));
        Border border = BorderFactory.createEtchedBorder();
        TitledBorder titledBorder = BorderFactory.createTitledBorder(border, TrackerRes.getString("VectorSumInspector.Border.Title"));
        this.mainPanel.setBorder(titledBorder);
        jPanel.add((Component)this.mainPanel, "Center");
        this.checkboxPanel = new JPanel(new GridLayout(0, 1));
        this.mainPanel.add(this.checkboxPanel);
        this.sumPanel = new JPanel(new GridLayout(0, 2));
        this.okButton = new JButton(TrackerRes.getString("Dialog.Button.OK"));
        this.okButton.setForeground(new Color(0, 0, 102));
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                VectorSumInspector.this.setVisible(false);
            }
        });
        JPanel jPanel2 = new JPanel(new GridLayout(1, 3));
        jPanel2.setBorder(BorderFactory.createEmptyBorder(1, 0, 3, 0));
        jPanel.add((Component)jPanel2, "South");
        Box box = Box.createHorizontalBox();
        jPanel2.add(box);
        jPanel2.add(this.okButton);
        box = Box.createHorizontalBox();
        jPanel2.add(box);
    }

    private void updateSum() {
        Component[] componentArray = this.checkboxPanel.getComponents();
        int n = 0;
        while (n < componentArray.length) {
            JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)componentArray[n];
            Vector vector = this.getVector(jCheckBoxMenuItem.getActionCommand());
            if (jCheckBoxMenuItem.isSelected() && !this.sum.contains(vector)) {
                this.sum.addVector(vector);
                vector.setVisible(true);
            }
            if (!jCheckBoxMenuItem.isSelected() && this.sum.contains(vector)) {
                this.sum.removeVector(vector);
            }
            ++n;
        }
        if (this.trackerPanel != null) {
            if (this.trackerPanel.getSelectedTrack() == this.sum && this.trackerPanel.getSelectedPoint() != null) {
                this.trackerPanel.getSelectedPoint().showCoordinates(this.trackerPanel);
            }
            this.trackerPanel.repaint();
        }
    }

    private Vector getVector(String string) {
        if (this.trackerPanel != null) {
            ArrayList<Vector> arrayList = this.trackerPanel.getDrawables(Vector.class);
            for (Vector vector : arrayList) {
                if (vector.getName() != string) continue;
                return vector;
            }
        }
        return null;
    }
}

