/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.opensourcephysics.cabrillo.tracker.Footprint;
import org.opensourcephysics.cabrillo.tracker.LineFootprint;
import org.opensourcephysics.cabrillo.tracker.Step;
import org.opensourcephysics.cabrillo.tracker.TTrack;
import org.opensourcephysics.cabrillo.tracker.TrackerPanel;
import org.opensourcephysics.cabrillo.tracker.TrackerRes;
import org.opensourcephysics.cabrillo.tracker.Undo;
import org.opensourcephysics.cabrillo.tracker.VectorStep;
import org.opensourcephysics.cabrillo.tracker.WorldTView;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.display.Dataset;
import org.opensourcephysics.display.DatasetManager;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Interactive;
import org.opensourcephysics.media.core.ImageCoordSystem;
import org.opensourcephysics.media.core.NumberField;
import org.opensourcephysics.media.core.TPoint;
import org.opensourcephysics.media.core.VideoClip;
import org.opensourcephysics.media.core.VideoPlayer;

public class Vector
extends TTrack {
    protected JMenuItem tailsToOriginItem = new JMenuItem();
    protected JCheckBoxMenuItem labelsVisibleItem;
    protected Map<TrackerPanel, Boolean> visMap = new HashMap<TrackerPanel, Boolean>();

    public Vector() {
        this.defaultColors = new Color[]{Color.magenta, Color.cyan, Color.blue, Color.red};
        this.setFootprints(new Footprint[]{LineFootprint.getFootprint("Footprint.BoldArrow"), LineFootprint.getFootprint("Footprint.Arrow"), LineFootprint.getFootprint("Footprint.BigArrow")});
        this.defaultFootprint = this.getFootprint();
        this.setColor(this.defaultColors[0]);
        this.setTrailVisible(true);
        this.setAutoAdvance(true);
        this.setName(TrackerRes.getString("Vector.New.Name"));
        this.setProperty("xVarPlot0", "t");
        this.setProperty("yVarPlot0", "x");
        this.setProperty("xVarPlot1", "t");
        this.setProperty("yVarPlot1", "y");
        this.partName = TrackerRes.getString("TTrack.Selected.Hint");
        this.hint = TrackerRes.getString("Vector.Unmarked.Hint");
        this.magLabel.setText("mag");
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Vector.this.setXYComponents();
                ((NumberField)actionEvent.getSource()).requestFocusInWindow();
            }
        };
        FocusAdapter focusAdapter = new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                Vector.this.setXYComponents();
            }
        };
        AbstractAction abstractAction2 = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Vector.this.setMagnitudeAngle();
                ((NumberField)actionEvent.getSource()).requestFocusInWindow();
            }
        };
        FocusAdapter focusAdapter2 = new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                Vector.this.setMagnitudeAngle();
            }
        };
        this.xField.addActionListener(abstractAction);
        this.yField.addActionListener(abstractAction);
        this.xField.addFocusListener(focusAdapter);
        this.yField.addFocusListener(focusAdapter);
        this.magField.addActionListener(abstractAction2);
        this.angleField.addActionListener(abstractAction2);
        this.magField.addFocusListener(focusAdapter2);
        this.angleField.addFocusListener(focusAdapter2);
        this.tailsToOriginItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                for (TrackerPanel trackerPanel : Vector.this.panels) {
                    TPoint tPoint = trackerPanel.getSnapPoint();
                    Step[] stepArray = Vector.this.getSteps();
                    int n = 0;
                    while (n < stepArray.length) {
                        if (stepArray[n] != null) {
                            VectorStep vectorStep = (VectorStep)stepArray[n];
                            if (vectorStep.chain != null) {
                                vectorStep.chain.clear();
                            }
                            vectorStep.attach(null);
                            vectorStep.attach(tPoint);
                        }
                        ++n;
                    }
                    trackerPanel.repaint();
                }
            }
        });
        this.labelsVisibleItem = new JCheckBoxMenuItem(TrackerRes.getString("Vector.MenuItem.Label"));
        this.labelsVisibleItem.setSelected(true);
        this.labelsVisibleItem.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                Step[] stepArray = Vector.this.getSteps();
                int n = 0;
                while (n < stepArray.length) {
                    if (stepArray[n] != null) {
                        VectorStep vectorStep = (VectorStep)stepArray[n];
                        vectorStep.setLabelVisible(Vector.this.labelsVisibleItem.isSelected());
                        vectorStep.erase();
                    }
                    ++n;
                }
                Vector.this.repaint();
            }
        });
    }

    @Override
    public Step createStep(int n, double d, double d2) {
        VectorStep vectorStep = (VectorStep)this.getStep(n);
        if (vectorStep == null) {
            return this.createStep(n, d, d2, 0.0, 0.0);
        }
        XMLControlElement xMLControlElement = new XMLControlElement(vectorStep);
        vectorStep.tip.setXY(d, d2);
        Undo.postStepEdit(vectorStep, xMLControlElement);
        return vectorStep;
    }

    public Step createStep(int n, double d, double d2, double d3, double d4) {
        if (this.locked) {
            return null;
        }
        VectorStep vectorStep = (VectorStep)this.getStep(n);
        vectorStep = new VectorStep(this, n, d, d2, d3, d4);
        vectorStep.setFirePropertyChangeEvents(true);
        this.steps.setStep(n, vectorStep);
        vectorStep.setFootprint(this.getFootprint());
        this.support.firePropertyChange("step", null, new Integer(n));
        return vectorStep;
    }

    @Override
    public int getStepLength() {
        return VectorStep.getLength();
    }

    @Override
    public int getFootprintLength() {
        return 2;
    }

    @Override
    public void draw(DrawingPanel drawingPanel, Graphics graphics) {
        if (drawingPanel instanceof TrackerPanel) {
            TrackerPanel trackerPanel = (TrackerPanel)drawingPanel;
            if (!this.isVectorsVisible(trackerPanel)) {
                return;
            }
            super.draw(drawingPanel, graphics);
        }
    }

    @Override
    public void setLocked(boolean bl) {
        super.setLocked(bl);
        Step[] stepArray = this.getSteps();
        int n = 0;
        while (n < stepArray.length) {
            VectorStep vectorStep = (VectorStep)stepArray[n];
            if (vectorStep != null) {
                vectorStep.setTipEnabled(!this.isLocked());
            }
            ++n;
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string;
        if (propertyChangeEvent.getSource() instanceof TrackerPanel && (string = propertyChangeEvent.getPropertyName()).equals("adjusting")) {
            this.refreshDataLater = (Boolean)propertyChangeEvent.getNewValue();
            if (!this.refreshDataLater) {
                this.support.firePropertyChange("data", null, null);
            }
        }
        super.propertyChange(propertyChangeEvent);
    }

    @Override
    protected void refreshData(DatasetManager datasetManager, TrackerPanel trackerPanel) {
        int n;
        if (this.refreshDataLater) {
            return;
        }
        this.dataFrames.clear();
        VideoPlayer videoPlayer = trackerPanel.getPlayer();
        VideoClip videoClip = videoPlayer.getVideoClip();
        ImageCoordSystem imageCoordSystem = trackerPanel.getCoords();
        int n2 = 0;
        Dataset dataset = datasetManager.getDataset(n2++);
        Dataset dataset2 = datasetManager.getDataset(n2++);
        Dataset dataset3 = datasetManager.getDataset(n2++);
        Dataset dataset4 = datasetManager.getDataset(n2++);
        Dataset dataset5 = datasetManager.getDataset(n2++);
        Dataset dataset6 = datasetManager.getDataset(n2++);
        Dataset dataset7 = datasetManager.getDataset(n2++);
        Dataset dataset8 = datasetManager.getDataset(n2++);
        if (dataset.getColumnName(0).equals("x")) {
            dataset.setXYColumnNames("t", "x");
            dataset2.setXYColumnNames("t", "y");
            dataset3.setXYColumnNames("t", "mag");
            dataset4.setXYColumnNames("t", "$\\theta$");
            dataset5.setXYColumnNames("t", "x_{tail}");
            dataset6.setXYColumnNames("t", "y_{tail}");
            dataset7.setXYColumnNames("t", "step");
            dataset8.setXYColumnNames("t", "frame");
        } else {
            n = 0;
            while (n < n2) {
                datasetManager.getDataset(n).clear();
                ++n;
            }
        }
        this.dataDescriptions = new String[n2 + 1];
        n = 0;
        while (n < this.dataDescriptions.length) {
            this.dataDescriptions[n] = TrackerRes.getString("Vector.Data.Description." + n);
            ++n;
        }
        Step[] stepArray = this.getSteps();
        int n3 = 0;
        while (n3 < stepArray.length) {
            int n4;
            double d;
            VectorStep vectorStep;
            int n5;
            if (stepArray[n3] != null && videoClip.includesFrame(n5 = (vectorStep = (VectorStep)stepArray[n3]).getFrameNumber()) && !((d = videoPlayer.getStepTime(n4 = videoClip.frameToStep(n5)) / 1000.0) < 0.0)) {
                double d2 = vectorStep.getXComponent();
                double d3 = vectorStep.getYComponent();
                double d4 = imageCoordSystem.imageToWorldXComponent(n5, d2, d3);
                double d5 = imageCoordSystem.imageToWorldYComponent(n5, d2, d3);
                dataset.append(d, d4);
                dataset2.append(d, d5);
                dataset3.append(d, Math.sqrt(d4 * d4 + d5 * d5));
                dataset4.append(d, Math.atan2(d5, d4));
                Point2D point2D = vectorStep.getTail().getWorldPosition(trackerPanel);
                dataset5.append(d, point2D.getX());
                dataset6.append(d, point2D.getY());
                dataset7.append(d, n4);
                dataset8.append(d, n5);
                this.dataFrames.add(new Integer(n5));
            }
            ++n3;
        }
    }

    @Override
    public Interactive findInteractive(DrawingPanel drawingPanel, int n, int n2) {
        Interactive interactive = super.findInteractive(drawingPanel, n, n2);
        if (interactive == null) {
            TPoint tPoint = this.trackerPanel.getSelectedPoint();
            if (tPoint != null) {
                if (tPoint instanceof VectorStep.Handle) {
                    this.partName = TrackerRes.getString("Vector.Handle.Name");
                    this.partName = String.valueOf(this.partName) + " " + TrackerRes.getString("TTrack.Selected.Hint");
                    this.hint = TrackerRes.getString("Vector.HandleSelected.Hint");
                } else {
                    this.partName = TrackerRes.getString("Vector.Tip.Name");
                    this.partName = String.valueOf(this.partName) + " " + TrackerRes.getString("TTrack.Selected.Hint");
                    this.hint = TrackerRes.getString("Vector.TipSelected.Hint");
                }
            } else {
                this.partName = TrackerRes.getString("TTrack.Selected.Hint");
                this.hint = this.getStep(this.trackerPanel.getFrameNumber()) == null ? TrackerRes.getString("Vector.Unmarked.Hint") : TrackerRes.getString("Vector.Remark.Hint");
            }
            return null;
        }
        if (interactive instanceof VectorStep.Handle) {
            VectorStep.Handle handle = (VectorStep.Handle)interactive;
            this.partName = TrackerRes.getString("Vector.Handle.Name");
            this.hint = handle.isShort() ? TrackerRes.getString("Vector.ShortHandle.Hint") : TrackerRes.getString("Vector.Handle.Hint");
        } else {
            this.partName = TrackerRes.getString("Vector.Tip.Name");
            this.hint = TrackerRes.getString("Vector.Tip.Hint");
        }
        return interactive;
    }

    public void setLabelsVisible(boolean bl) {
        Step[] stepArray = this.getSteps();
        int n = 0;
        while (n < stepArray.length) {
            VectorStep vectorStep = (VectorStep)stepArray[n];
            if (vectorStep != null) {
                vectorStep.setLabelVisible(bl);
                vectorStep.setRolloverVisible(!bl);
            }
            ++n;
        }
    }

    public boolean isLabelsVisible() {
        Step[] stepArray = this.getSteps();
        int n = 0;
        while (n < stepArray.length) {
            VectorStep vectorStep = (VectorStep)stepArray[n];
            if (vectorStep != null) {
                return vectorStep.isLabelVisible();
            }
            ++n;
        }
        return false;
    }

    public void setVectorsVisible(TrackerPanel trackerPanel, boolean bl) {
        Step step;
        if (bl == this.isVectorsVisible(trackerPanel)) {
            return;
        }
        this.visMap.put(trackerPanel, new Boolean(bl));
        if (!bl && (step = trackerPanel.getSelectedStep()) != null && step == this.getStep(step.getFrameNumber())) {
            trackerPanel.setSelectedPoint(null);
        }
    }

    public boolean isVectorsVisible(TrackerPanel trackerPanel) {
        Boolean bl;
        if (trackerPanel instanceof WorldTView) {
            trackerPanel = ((WorldTView)trackerPanel).getTrackerPanel();
        }
        if ((bl = this.visMap.get(trackerPanel)) == null) {
            bl = new Boolean(true);
            this.visMap.put(trackerPanel, bl);
        }
        return bl;
    }

    @Override
    public JMenu getMenu(TrackerPanel trackerPanel) {
        JMenu jMenu = super.getMenu(trackerPanel);
        if (trackerPanel.isEnabled("track.delete")) {
            jMenu.remove(this.deleteTrackItem);
            if (jMenu.getItemCount() > 0) {
                jMenu.remove(jMenu.getItemCount() - 1);
            }
        }
        if (trackerPanel.isEnabled("track.autoAdvance") || trackerPanel.isEnabled("track.markByDefault")) {
            if (jMenu.getItemCount() > 0) {
                jMenu.addSeparator();
            }
            if (trackerPanel.isEnabled("track.autoAdvance")) {
                jMenu.add(this.autoAdvanceItem);
            }
            if (trackerPanel.isEnabled("track.markByDefault")) {
                jMenu.add(this.markByDefaultItem);
            }
        }
        if (jMenu.getItemCount() > 0) {
            jMenu.addSeparator();
        }
        this.tailsToOriginItem.setText(TrackerRes.getString("Vector.MenuItem.ToOrigin"));
        jMenu.add(this.tailsToOriginItem);
        if (trackerPanel.isEnabled("track.delete")) {
            TPoint tPoint;
            Step step;
            if (jMenu.getItemCount() > 0) {
                jMenu.addSeparator();
            }
            this.deleteStepItem.setEnabled((step = this.getStep(tPoint = trackerPanel.getSelectedPoint(), trackerPanel)) != null);
            jMenu.add(this.deleteStepItem);
            jMenu.add(this.clearStepsItem);
            jMenu.add(this.deleteTrackItem);
        }
        return jMenu;
    }

    @Override
    public ArrayList<Component> getToolbarTrackComponents(TrackerPanel trackerPanel) {
        ArrayList<Component> arrayList = super.getToolbarTrackComponents(trackerPanel);
        return arrayList;
    }

    @Override
    public ArrayList<Component> getToolbarPointComponents(TrackerPanel trackerPanel, TPoint tPoint) {
        ArrayList<Component> arrayList = super.getToolbarPointComponents(trackerPanel, tPoint);
        arrayList.add(this.stepSeparator);
        arrayList.add(this.stepLabel);
        arrayList.add(this.stepValueLabel);
        arrayList.add(this.tSeparator);
        arrayList.add(this.xLabel);
        arrayList.add(this.xField);
        arrayList.add(this.xSeparator);
        arrayList.add(this.yLabel);
        arrayList.add(this.yField);
        arrayList.add(this.ySeparator);
        arrayList.add(this.magLabel);
        arrayList.add(this.magField);
        arrayList.add(this.magSeparator);
        arrayList.add(this.angleLabel);
        arrayList.add(this.angleField);
        arrayList.add(this.angleSeparator);
        this.xField.setEnabled(!this.isLocked());
        this.yField.setEnabled(!this.isLocked());
        this.magField.setEnabled(!this.isLocked());
        this.angleField.setEnabled(!this.isLocked());
        return arrayList;
    }

    @Override
    public String toString() {
        return String.valueOf(TrackerRes.getString("Vector.Name")) + " \"" + this.name + "\"";
    }

    public static XML.ObjectLoader getLoader() {
        XML.setLoader(FrameData.class, new FrameDataLoader());
        return new Loader();
    }

    private void setXYComponents() {
        for (TrackerPanel trackerPanel : this.panels) {
            TPoint tPoint = trackerPanel.getSelectedPoint();
            VectorStep vectorStep = (VectorStep)this.getStep(tPoint, trackerPanel);
            if (vectorStep == null) continue;
            ImageCoordSystem imageCoordSystem = trackerPanel.getCoords();
            int n = trackerPanel.getFrameNumber();
            double d = imageCoordSystem.worldToImageXComponent(n, this.xField.getValue(), this.yField.getValue());
            double d2 = imageCoordSystem.worldToImageYComponent(n, this.xField.getValue(), this.yField.getValue());
            vectorStep.setXYComponents(d, d2);
            d = imageCoordSystem.imageToWorldXComponent(n, vectorStep.getXComponent(), vectorStep.getYComponent());
            d2 = imageCoordSystem.imageToWorldYComponent(n, vectorStep.getXComponent(), vectorStep.getYComponent());
            this.xField.setValue(d);
            this.yField.setValue(d2);
            this.magField.setValue(Math.sqrt(d * d + d2 * d2));
            double d3 = Math.atan2(d2, d);
            this.angleField.setValue(d3);
            tPoint.showCoordinates(trackerPanel);
        }
    }

    private void setMagnitudeAngle() {
        double d = this.angleField.getValue();
        double d2 = this.magField.getValue() * Math.cos(d);
        double d3 = this.magField.getValue() * Math.sin(d);
        for (TrackerPanel trackerPanel : this.panels) {
            TPoint tPoint = trackerPanel.getSelectedPoint();
            VectorStep vectorStep = (VectorStep)this.getStep(tPoint, trackerPanel);
            if (vectorStep == null) continue;
            ImageCoordSystem imageCoordSystem = trackerPanel.getCoords();
            int n = trackerPanel.getFrameNumber();
            double d4 = imageCoordSystem.worldToImageXComponent(n, d2, d3);
            double d5 = imageCoordSystem.worldToImageYComponent(n, d2, d3);
            vectorStep.setXYComponents(d4, d5);
            d4 = imageCoordSystem.imageToWorldXComponent(n, vectorStep.getXComponent(), vectorStep.getYComponent());
            d5 = imageCoordSystem.imageToWorldYComponent(n, vectorStep.getXComponent(), vectorStep.getYComponent());
            this.xField.setValue(d4);
            this.yField.setValue(d5);
            this.magField.setValue(Math.sqrt(d4 * d4 + d5 * d5));
            d = Math.atan2(d5, d4);
            this.angleField.setValue(d);
            tPoint.showCoordinates(trackerPanel);
        }
    }

    public static class FrameData {
        double x;
        double y;
        double xc;
        double yc;
        boolean independent;

        FrameData() {
        }

        FrameData(VectorStep vectorStep, boolean bl) {
            this.x = vectorStep.getTail().getX();
            this.y = vectorStep.getTail().getY();
            this.xc = vectorStep.getXComponent();
            this.yc = vectorStep.getYComponent();
            this.independent = !bl;
        }
    }

    private static class FrameDataLoader
    implements XML.ObjectLoader {
        private FrameDataLoader() {
        }

        @Override
        public void saveObject(XMLControl xMLControl, Object object) {
            FrameData frameData = (FrameData)object;
            xMLControl.setValue("xtail", frameData.x);
            xMLControl.setValue("ytail", frameData.y);
            if (frameData.independent) {
                xMLControl.setValue("xcomponent", frameData.xc);
                xMLControl.setValue("ycomponent", frameData.yc);
            }
        }

        @Override
        public Object createObject(XMLControl xMLControl) {
            return new FrameData();
        }

        @Override
        public Object loadObject(XMLControl xMLControl, Object object) {
            FrameData frameData = (FrameData)object;
            double d = xMLControl.getDouble("xcomponent");
            if (!Double.isNaN(d)) {
                frameData.xc = d;
                frameData.yc = xMLControl.getDouble("ycomponent");
            }
            frameData.x = xMLControl.getDouble("xtail");
            frameData.y = xMLControl.getDouble("ytail");
            return object;
        }
    }

    static class Loader
    implements XML.ObjectLoader {
        Loader() {
        }

        @Override
        public void saveObject(XMLControl xMLControl, Object object) {
            Vector vector = (Vector)object;
            XML.getLoader(TTrack.class).saveObject(xMLControl, object);
            Step[] stepArray = vector.getSteps();
            FrameData[] frameDataArray = new FrameData[stepArray.length];
            int n = 0;
            while (n < stepArray.length) {
                if (stepArray[n] != null) {
                    VectorStep vectorStep = (VectorStep)stepArray[n];
                    frameDataArray[n] = new FrameData(vectorStep, vector.isDependent());
                }
                ++n;
            }
            xMLControl.setValue("framedata", frameDataArray);
        }

        @Override
        public Object createObject(XMLControl xMLControl) {
            return new Vector();
        }

        @Override
        public Object loadObject(XMLControl xMLControl, Object object) {
            Vector vector = (Vector)object;
            XML.getLoader(TTrack.class).loadObject(xMLControl, object);
            FrameData[] frameDataArray = (FrameData[])xMLControl.getObject("framedata");
            if (frameDataArray != null) {
                boolean bl = vector.isLocked();
                vector.setLocked(false);
                int n = 0;
                while (n < frameDataArray.length) {
                    if (frameDataArray[n] == null) {
                        vector.steps.setStep(n, null);
                    } else {
                        vector.createStep(n, frameDataArray[n].x, frameDataArray[n].y, frameDataArray[n].xc, frameDataArray[n].yc);
                    }
                    ++n;
                }
                vector.setLocked(bl);
            }
            return object;
        }
    }
}

